/*
Copyright (C) 1986,1987 by FTP Software, Inc.

This software is furnished under a license and may be used and copied
only in accordance with the terms of such license and with the
inclusion of the above copyright notice. This software or any other
copies thereof may not be provided or otherwise made available to any
other person. No title to and ownership of the software is hereby
transferred.

The information in this software is subject to change without notice
and should not be construed as a commitment by FTP Software, Inc.
*/
/*
 *	Kwok Kong	2.8.91
 *	replaced all unsigned, word, unsword with ushort for i960
 *	Add port in the arp table
 *
 *	$Log:   /usr/shasta/pvcs/i960/include/arp.h_v  $
 * 
 *    Rev 1.2   15 Sep 1992 09:03:30   holeman
 * 
 *    Rev 1.1   28 Aug 1992 16:11:20   holeman
 * remove media dependencies
 * 
 *    Rev 1.0   01 Jul 1992 14:26:46   holeman
 * Initial revision.
 */

#ifndef	__ARP_H
#define	__ARP_H
/* ARP hardware types
*/
#define	ARP_BLUEBOOK	1	/* Blue Book ethernet */
#define	ARP_IEEE8022	6	/* IEEE 802.2 header formats */

/* define the table format of internet -> ethernet address mappings */
/* #define	ARP_CACHE_SIZE	4 */
/* #define ARP_CACHE_SIZE  8 */
#define ARP_CACHE_SIZE  20 

typedef struct tabent
	{
	in_name	ip_addr;	/* the ip address*/
	ushort	et_addr[3];	/* ethernet address */
	uint	etip_id;	/* 0 = unused, or = etipid to find out which
				 * entry is the least recently used.
				 */
	uint	et_ttl;		 /*	time to live in minutes */
	uint	et_ieee;	 /*	Is this ieee or blue book ethernet */
	uint	PortNo;	 /*	which port it is on	*/
	uint	routing_length;
	byte	routing_info[36];
	}
	tabent;

extern tabent table[];
/*
 *	ARP counters
 */
struct	arp_stat
	{
	ulong	sent_pkts;
	ulong	sent_reqs;
	ulong	sent_reps;
	ulong	rcvd_pkts;
	ulong	rcvd_reqs;
	ulong	rcvd_reps;
	ulong	not_for_me;
	ulong	bad_hardware;
	ulong	bad_protocol;
	ulong	bad_opcode;
	};

typedef	struct arp_stat	ARP_STAT;
int	ip_send(PACKET p, int len, in_name host, NID *np, in_name srcip);
void	etarrcv(PACKET p, uint len);
int	ip2et(NID **ether, uint *flagp, in_name ip, in_name srcip, int *PortList, byte **routing_info, int *routing_length);
#endif

