/*
@(#) smterror.h V6.2.3:cs.910920.2:6:6 Mon Nov 11 16:39:36 1991 Copyright 1990,1991 XLNT Designs, Inc.
*/
/*********************************************************************
	SMT Header File
	
	SMT Error File
		
	File:		smterror.h
	Created:	12/01/89

	Version:	V6.2.3	Mon Nov 11 16:39:36 1991
	Last Modified:	cs.910920.2	09/20/91
	
	Copyright 1990,1991 XLNT Designs, Inc.
	
	This header file is used by all SMT modules. This file contains
	error code definitions for used by all SMT modules.

	Modification History:

	*** UPDATED TO SMT 6.2 ***

*********************************************************************/

/*********************************************************************
	System Error Definitions
*********************************************************************/

/*
*	Error codes are divided into sections based upon the process which
*	encounters the error. There are five sections: general errors, FSP
*	errors, CSP errors, MSP errors and interface errors.
*/
#define	GENERAL_ERROR		0x100
#define	FBM_ERROR		0x200
#define	CSP_ERROR		0x300
#define	MIB_ERROR		0x400
#define	IF_ERROR		0x500


/*
*	General error definitions
*/

/*
*	Frame service process error definitions
*/
	/* no frame buffers available */
#define	EFBM_NO_FRAME_BUF_MEM	(FBM_ERROR | 0x01)
	/* bad frame class requested in send frame message */
#define	EFBM_BAD_FRAME_CLASS	(FBM_ERROR | 0x03)
	/* bad frame type requested in send frame message */
#define	EFBM_BAD_FRAME_TYPE	(FBM_ERROR | 0x04)
	/* bad frame requested in send frame message */
#define	EFBM_BAD_FRAME_REQUESTED (FBM_ERROR | 0x05)
	/* no messages available for FBM */
#define	EFBM_NO_MESSAGE		(FBM_ERROR | 0x06)
	/* message send failed from FBM */
#define	EFBM_MSG_FAILED		(FBM_ERROR | 0x07)
	/* no frames available for FBM */
#define	EFBM_NO_FRAMES		(FBM_ERROR | 0x08)
	/* FSP action queue empty */
#define	EFBM_Q_MT		(FBM_ERROR | 0x09)
	/* FSP action queue full */
#define	EFBM_Q_FULL		(FBM_ERROR | 0x0A)

/*
*	Connection service process error definitions
*/
	/* signal queue is empty */
#define	ECSP_SIG_Q_MT		(CSP_ERROR | 0x01)
	/* signal queue filled */
#define	ECSP_SIG_Q_FULL		(CSP_ERROR | 0x02)
	/* no timer available */
#define	ECSP_SIG_TIMER_FULL	(CSP_ERROR | 0x03)
	/* no messages availabe for CSP */
#define	ECSP_NO_MESSAGE		(CSP_ERROR | 0x06)
	/* message send failed from CSP */
#define	ECSP_MSG_FAILED		(CSP_ERROR | 0x07)


/*
*	MIB service process error definitions
*/
	/* MIB memory could not be allocated */
#define	EMIB_INIT_MIB		(MIB_ERROR | 0x01)
	/* no messages availabe for MIB */
#define	EMIB_NO_MESSAGE		(MIB_ERROR | 0x02)
	/* message send failed from MIB */
#define	EMIB_MSG_FAILED		(MIB_ERROR | 0x03)


/*
*	Interface error definitions
*/
