/*
@(#) mibdefs.h V6.2.3:cs.910920.2:6:6 Mon Nov 11 16:39:36 1991 Copyright 1990,1991 XLNT Designs, Inc.
*/
/*********************************************************************
	Management Information Base Header File

	MIB attribute and structure definition.

	File:		mibdefs.h
	Created:	12/01/89

	Version:	V6.2.3	Mon Nov 11 16:39:36 1991
	Last Modified:	cs.910920.2	09/20/91

	Copyright 1990,1991 XLNT Designs, Inc.

	This file contains types and constants required for accessing
	the Management Information Base (MIB).  The MIB is accessed thru
	get, set, add and change routines.  It contains or has access to all
	SMT attributes within a particular station.  

	Modification History:

	*** CREATED FOR SMT 6.2 ***
	910122-005	LJP
		Removed unused XDI attributes xdiSMTStationType,
		xdiSMTPathLatency1/2, and xdiSMTOutIndex1/2.
*********************************************************************/

/*********************************************************************
*
*	The following constants are used to access particular station 
*	attributes.  The attributes maintained on a station are defined 
*	in section 3.4 of the X3T9.5 FDDI Station Management 
*	Specification.  When reading or updating an attribute the 
*	particular attribute being read/updated must be identified.  
*	The following constants perform this role.
*
*********************************************************************/

/*
*	The SMT version that is currently running on the machine.  All
*	versions up to this point are known as version 1.  This parameter
*	should not be arbitrarily changed.  SMTs running on other vendors
*	equipment expect certain characteristics depending on the version
*	of SMT which is being run.  The current implementation only knows
*	characteristics about SMT 6.2.
*/
#define SMTOPVERSION 0001
#define SMTHIVERSION 0001
#define SMTLOVERSION 0001


/*********************************************************************
	The attribute ID values correspond to the parameter type
	values listed in the SMT documentation. The high byte contains
	the object and sub-object ID, and the lower byte is the
	attribute registration ID.

	The naming conviention used here is based on the attribute
	names used in the SMT standard. In most cases, the constant
	exactly matches the name used in the standard. In a few cases,
	minor alterations were made for readability and syntax. The
	dash (-) used by the standard is converted to an underscore
	(_) for C.
*********************************************************************/

/*
*	Object ID constants.
*/
#define	fddiSMT			0x1000
#define	fddiMAC			0x2000
#define	fddiPATHClass		0x3000
#define	fddiPATHClassPATH	0x3200
#define	fddiPORT		0x4000
#define	fddiATTACHMENT		0x6000

/*
*	ID Masks.
*/
#define	MIB_OBJECT_MASK		0xF000
#define	MIB_SUBOBJECT_MASK	0x0F00
#define	MIB_ID_MASK		0x00FF

/*
*	SMT Attribute Constants
*/
#define	fddiSMTStationIdGrp			(fddiSMT | 10)
#define	fddiSMTStationId			(fddiSMT | 11)
#define	fddiSMTOpVersionId			(fddiSMT | 13)
#define	fddiSMTHiVersionId			(fddiSMT | 14)
#define	fddiSMTLoVersionId			(fddiSMT | 15)
#define	fddiSMTManufacturerData			(fddiSMT | 16)
#define	fddiSMTUserData				(fddiSMT | 17)

#define	fddiSMTStationConfigGrp			(fddiSMT | 20)
#define	fddiSMTMAC_Ct				(fddiSMT | 21)
#define	fddiSMTNonMaster_Ct			(fddiSMT | 22)
#define	fddiSMTMaster_Ct			(fddiSMT | 23)
#define	fddiSMTPathsAvailable			(fddiSMT | 24)
#define	fddiSMTConfigCapabilities		(fddiSMT | 25)
#define	fddiSMTConfigPolicy			(fddiSMT | 26)
#define	fddiSMTConnectionPolicy			(fddiSMT | 27)
#define	fddiSMTReportLimit			(fddiSMT | 28)
#define	fddiSMTT_Notify				(fddiSMT | 29)
#define	fddiSMTStatusReporting			(fddiSMT | 30)

#define	fddiSMTStatusGrp			(fddiSMT | 40)
#define	fddiSMTECMState				(fddiSMT | 41)
#define	fddiSMTCF_State				(fddiSMT | 42)
#define	fddiSMTHoldState			(fddiSMT | 43)
#define	fddiSMTRemoteDisconnectFlag		(fddiSMT | 44)

#define	fddiSMTMIBOperationGrp			(fddiSMT | 50)
#define	fddiSMTMsgTimeStamp			(fddiSMT | 51)
#define	fddiSMTTransitionTimeStamp		(fddiSMT | 52)
#define	fddiSMTSetCount				(fddiSMT | 53)
#define	fddiSMTLastSetStationId			(fddiSMT | 54)

/* XDI added attributes */
#define	xdiSMTBothWrapCapability		(fddiSMT | 201)
#define	xdiSMTBothWrapPolicy			(fddiSMT | 202)
#define	xdiSMTTopology				(fddiSMT | 206)
#define	xdiSMTSB_Flag				(fddiSMT | 209)
#define hlsSMTRemoteDisconnectStationID         (fddiSMT | 255)
/* 910122-005 LJP Removed unused XDI attributes */

/*
*	MAC Attribute Constants
*/
#define	fddiMACCapabilitiesGrp			(fddiMAC | 10)
#define	fddiMACFrameStatusCapabilities		(fddiMAC | 11)
#define	fddiMACBridgeFunction			(fddiMAC | 12)
#define	fddiMACT_MaxGreatestLowerBound		(fddiMAC | 13)
#define	fddiMACTVXGreatestLowerBound		(fddiMAC | 14)

#define	fddiMACConfigGrp			(fddiMAC | 20)
#define	fddiMACPathsAvailable			(fddiMAC | 22)
#define	fddiMACCurrentPath			(fddiMAC | 23)
#define	fddiMACUpstreamNbr			(fddiMAC | 24)
#define	fddiMACDownstreamNbr			(fddiMAC | 25)
#define	fddiMACOldUpstreamNbr			(fddiMAC | 26)
#define	fddiMACOldDownstreamNbr			(fddiMAC | 27)
#define	fddiMACRootConcentratorMAC		(fddiMAC | 28)
#define	fddiMACDup_Addr_Test			(fddiMAC | 29)
#define	fddiMACPathsRequested			(fddiMAC | 32)
#define	fddiMACDownstreamPORTType		(fddiMAC | 33)

#define	fddiMACAddressGrp			(fddiMAC | 40)
#define	fddiMACSMTAddress			(fddiMAC | 41)
#define	fddiMACLongAliases			(fddiMAC | 42)
#define	fddiMACShortAliases			(fddiMAC | 43)
#define	fddiMACLongGrpAddrs			(fddiMAC | 44)
#define	fddiMACShortGrpAddrs			(fddiMAC | 45)

#define	fddiMACOperationGrp			(fddiMAC | 50)
#define	fddiMACT_Req				(fddiMAC | 51)
#define	fddiMACT_Neg				(fddiMAC | 52)
#define	fddiMACT_Max				(fddiMAC | 53)
#define	fddiMACTvxValue				(fddiMAC | 54)
#define	fddiMACT_Min				(fddiMAC | 55)
#define	fddiMACT_Pri0				(fddiMAC | 56)
#define	fddiMACT_Pri1				(fddiMAC | 57)
#define	fddiMACT_Pri2				(fddiMAC | 58)
#define	fddiMACT_Pri3				(fddiMAC | 59)
#define	fddiMACT_Pri4				(fddiMAC | 60)
#define	fddiMACT_Pri5				(fddiMAC | 61)
#define	fddiMACT_Pri6				(fddiMAC | 62)
#define	fddiMACFrameStatus			(fddiMAC | 63)

#define	fddiMACCountersGrp			(fddiMAC | 70)
#define	fddiMACFrame_Ct				(fddiMAC | 71)
#define	fddiMACCopied_Ct			(fddiMAC | 72)
#define	fddiMACTransmit_Ct			(fddiMAC | 73)
#define	fddiMACToken_Ct				(fddiMAC | 74)

#define	fddiMACErrorCtrsGrp			(fddiMAC | 80)
#define	fddiMACError_Ct				(fddiMAC | 81)
#define	fddiMACLost_Ct				(fddiMAC | 82)
#define	fddiMACTvxExpired_Ct			(fddiMAC | 83)
#define	fddiMACNotCopied_Ct			(fddiMAC | 84)
#define	fddiMACLate_Ct				(fddiMAC | 85)
#define	fddiMACRingOp_Ct			(fddiMAC | 86)

#define	fddiMACFrameErrorConditionGrp		(fddiMAC | 90)
#define	fddiMACBaseFrame_Ct			(fddiMAC | 91)
#define	fddiMACBaseError_Ct			(fddiMAC | 92)
#define	fddiMACBaseLost_Ct			(fddiMAC | 93)
#define	fddiMACBaseTimeFrameError		(fddiMAC | 94)
#define	fddiMACFrameErrorThreshold		(fddiMAC | 95)
#define	fddiMACFrameErrorRatio			(fddiMAC | 96)

#define	fddiMACNotCopiedConditionGrp		(fddiMAC | 100)
#define	fddiMACBaseNotCopied_Ct			(fddiMAC | 101)
#define	fddiMACBaseTimeNotCopied		(fddiMAC | 102)
#define	fddiMACNotCopiedThreshold		(fddiMAC | 103)
#define	fddiMACBaseCopied_Ct			(fddiMAC | 104)
#define	fddiMACNotCopiedRatio			(fddiMAC | 105)

#define	fddiMACStatusGrp			(fddiMAC | 110)
#define	fddiMACRMTState				(fddiMAC | 111)
#define	fddiMACDa_Flag				(fddiMAC | 112)
#define	fddiMACUnaDa_Flag			(fddiMAC | 113)
#define	fddiMACFrameErrorCondition		(fddiMAC | 114)
#define	fddiMACNotCopiedCondition		(fddiMAC | 115)
#define	fddiMACLLCServiceAvailable		(fddiMAC | 116)

#define	fddiMACRootMACStatusGrp			(fddiMAC | 120)
#define	fddiMACMasterSlaveLoopStatus		(fddiMAC | 121)
#define	fddiMACRootMACDownstreamPORTType	(fddiMAC | 122)
#define	fddiMACRootMACCurrentPath		(fddiMAC | 123)

/* XDI added attributes */
#define	xdiMACRMTDupPolicy1			(fddiMAC | 201)
#define	xdiMACRMTDupPolicy2			(fddiMAC | 202)
#define	xdiMACResourceIndex			(fddiMAC | 203)
#define	xdiMACConnectedIndex			(fddiMAC | 204)
#define	xdiMACDataAddress			(fddiMAC | 205)
#define	xdiMACOperational			(fddiMAC | 207)

/*
*	Path Class Attributes
*/
#define	fddiPATHConfigGrp			(fddiPATHClass | 10)
#define	fddiPATHClassTrace_MaxExpiration	(fddiPATHClass | 12)
#define	fddiPATHClassTVXLowerBound		(fddiPATHClass | 13)
#define	fddiPATHClassT_MaxLowerBound		(fddiPATHClass | 14)

/*
*	Path Class Path Attributes
*/
#define	fddiPATHClassPATHConfigGrp		(fddiPATHClassPATH | 10)
#define	fddiPATHClassPATHClassType		(fddiPATHClassPATH | 11)
#define	fddiPATHClassPATHPORTOrder		(fddiPATHClassPATH | 12)
#define	fddiPATHClassPATHRingLatency		(fddiPATHClassPATH | 13)
#define	fddiPATHClassPATHTraceStatus		(fddiPATHClassPATH | 14)
#define	fddiPATHClassPATHSba			(fddiPATHClassPATH | 15)
#define	fddiPATHClassPATHSbaOverhead		(fddiPATHClassPATH | 16)
#define	fddiPATHClassPATHStatus			(fddiPATHClassPATH | 17)
#define	fddiPATHClassPATHConfiguration		(fddiPATHClassPATH | 18)
#define	fddiPATHClassPATHT_Rmode		(fddiPATHClassPATH | 19)

/*
*	Port Attributes
*/
#define	fddiPORTConfigGrp			(fddiPORT | 10)
#define	fddiPORTPC_Type				(fddiPORT | 12)
#define	fddiPORTPC_Neighbor			(fddiPORT | 13)
#define	fddiPORTConnectionPolicies		(fddiPORT | 14)
#define	fddiPORTRemoteMACIndicated		(fddiPORT | 15)
#define	fddiPORTCE_State			(fddiPORT | 16)
#define	fddiPORTPathsRequested			(fddiPORT | 17)
#define	fddiPORTMACPlacement			(fddiPORT | 18)
#define	fddiPORTAvailablePaths			(fddiPORT | 19)
#define	fddiPORTMACLoop_Time			(fddiPORT | 21)
#define	fddiPORTFotxClass			(fddiPORT | 22)

#define	fddiPORTOperationGrp			(fddiPORT | 30)
#define	fddiPORTMaintLineState			(fddiPORT | 31)
#define	fddiPORTTB_Max				(fddiPORT | 32)
#define	fddiPORTBS_Flag				(fddiPORT | 33)

#define	fddiPORTErrorCtrsGrp			(fddiPORT | 40)
#define	fddiPORTEBError_Ct			(fddiPORT | 41)
#define	fddiPORTLCTFail_Ct			(fddiPORT | 42)

#define	fddiPORTLerGrp				(fddiPORT | 50)
#define	fddiPORTLer_Estimate			(fddiPORT | 51)
#define	fddiPORTLem_Reject_Ct			(fddiPORT | 52)
#define	fddiPORTLem_Ct				(fddiPORT | 53)
#define	fddiPORTBaseLer_Estimate		(fddiPORT | 54)
#define	fddiPORTBaseLem_Reject_Ct		(fddiPORT | 55)
#define	fddiPORTBaseLem_Ct			(fddiPORT | 56)
#define	fddiPORTBaseLer_TimeStamp		(fddiPORT | 57)
#define	fddiPORTLer_Cutoff			(fddiPORT | 58)
#define	fddiPORTLer_Alarm			(fddiPORT | 59)

#define	fddiPORTStatusGrp			(fddiPORT | 60)
#define	fddiPORTConnectState			(fddiPORT | 61)
#define	fddiPORTPCMState			(fddiPORT | 62)
#define	fddiPORTPC_Withhold			(fddiPORT | 63)
#define	fddiPORTLerCondition			(fddiPORT | 64)

/* XDI added attributes */
#define	xdiPORTResourceIndex			(fddiPORT | 201)
#define	xdiPORTConnectedIndex			(fddiPORT | 202)
#define	xdiPORTOperational			(fddiPORT | 203)

/*
*	Attachment Attributes
*/
#define	fddiATTACHMENTConfigGrp			(fddiATTACHMENT | 10)
#define	fddiATTACHMENTClass			(fddiATTACHMENT | 11)
#define	fddiATTACHMENTOpticalBypassPresent	(fddiATTACHMENT | 12)
#define	fddiATTACHMENTI_MaxExpiration		(fddiATTACHMENT | 13)
#define	fddiATTACHMENTInsertedStatus		(fddiATTACHMENT | 14)
#define	fddiATTACHMENTInsertPolicy		(fddiATTACHMENT | 15)


/*********************************************************************
	MIB Actions
*********************************************************************/

#define	fddiSMTStationAction			(fddiSMT | 60)

#define	fddiMACAction				(fddiMAC | 130)

#define	fddiPORTAction				(fddiPORT | 70)


/*********************************************************************
	MIB Events
*********************************************************************/

#define	fddiSMTConfigurationChgEvent		(fddiSMT | 70)

#define	fddiMACDuplicateAddressCondition	(fddiMAC | 140)
#define	fddiMACFrameErrorConditionEvent		(fddiMAC | 141)
#define	fddiMACNotCopiedConditionEvent		(fddiMAC | 142)
#define	fddiMACNeighborChangeEvent		(fddiMAC | 143)

#define	fddiPATHTraceStatusEvent		(fddiPATHClass | 30)

#define	fddiPORTLerConditionEvent		(fddiPORT | 80)
#define	fddiPORTUndesiredConnectionAttempt	(fddiPORT | 81)
#define	fddiPORTEBErrorConditionEvent		(fddiPORT | 82)


/*********************************************************************
*
*       The following constants are from the mib.h for SMT 5.1.
*	They are redefined here using the new values.
*
*	NOTE: A few attributes are no longer supported by the SMT
*	MIB. If the new MIB has a reasonable alternative, then it is
*	used. Otherwise, the attribute value will be undefined
*	with a size of zero (0).
*
*********************************************************************/

#define	NOT_SUPPORTED	0xFFFF

/*
*	SMT Station Attributes.  Section 3.4.4.1
*/
#define SMTSTATIONID		fddiSMTStationId
#define SMTSTATIONTYPE		NOT_SUPPORTED	/* 910122-005 LJP */
#define SMTOPVERSIONID		fddiSMTOpVersionId
#define SMTMANUFACTURERDATA	fddiSMTManufacturerData
#define SMTUSERDATA		fddiSMTUserData
#define SMTVERSIONIDLIST	fddiSMTOpVersionId
#define SMTMACCOUNT		fddiSMTMAC_Ct
#define SMTATTACHCOUNT		fddiSMTNonMaster_Ct
#define SMTMASTERCOUNT		fddiSMTMaster_Ct
#define SMTCONFIGPOLICY		fddiSMTConfigPolicy
#define SMTCONNECTPOLICY	fddiSMTConnectionPolicy
#define SMTPATHLATENCYRING1	NOT_SUPPORTED
#define SMTPATHLATENCYRING2	NOT_SUPPORTED
#define SMTTIMESTAMP		fddiSMTMsgTimeStamp
#define SMTECMSTATE		fddiSMTECMState
#define SMTCFMSTATE		fddiSMTCF_State

#define SMTTOPOLOGY		xdiSMTTopology
#define DUPLADDRSTATUS		fddiMACDa_Flag
#define	RMTDUPPOLICY1		xdiMACRMTDupPolicy1
#define	RMTDUPPOLICY2		xdiMACRMTDupPolicy2

/*
*	MAC Attributes.
*/
#define MACSMTADDRESS		fddiMACSMTAddress
#define MACLONGALIASES		fddiMACLongAliases
#define MACSHORTALIASES		fddiMACShortAliases
#define MACLONGGRPADDRS		fddiMACLongGrpAddrs
#define MACSHORTGRPADDRS	fddiMACShortGrpAddrs
#define MACUPSTREAMNBR		fddiMACUpstreamNbr
#define	MACDOWNSTREAMNBR	fddiMACDownstreamNbr
#define MACRESOURCEINDEX	xdiMACResourceIndex
#define MACCONNECTEDRESID	xdiMACConnectedIndex
#define MACTREQ			fddiMACT_Req
#define MACTNEG			fddiMACT_Neg
#define MACTMAX			fddiMACT_Max
#define MACTVXVALUE		fddiMACTvxValue	
#define MACTMIN			fddiMACT_Min
#define MACTPRI1		fddiMACT_Pri0
#define MACTPRI2		fddiMACT_Pri1
#define MACTPRI3		fddiMACT_Pri2
#define MACTPRI4		fddiMACT_Pri3
#define MACTPRI5		fddiMACT_Pri4
#define MACTPRI6		fddiMACT_Pri5
#define MACTPRI7		fddiMACT_Pri6
#define MACSBA			fddiPATHClassPATHSba
#define MACFRAMECT		fddiMACFrame_Ct
#define MACRECEIVECT		fddiMACCopied_Ct
#define MACTRANSMITCT		fddiMACTransmit_Ct
#define MACTOKENCT		fddiMACToken_Ct
#define MACERRORCT		fddiMACError_Ct
#define MACLOSTCT		fddiMAVLost_Ct
#define MACTVXEXPIREDCT		fddiMACTvxExpired_Ct
#define MACNOTCOPIEDCT		fddiMACNotCopied_Ct
#define MACLATECT		fddiMACLate_Ct
#define MACINTERNALERRORCT	NOT_SUPPORTED
#define MACRINGOPCT		fddiMACRingOp_Ct
#define MACTOKENCLASS		NOT_SUPPORTED
#define	MACDATAADDRESS		fddiMACSMTAddress
#define	MACRMTSTATE		fddiMACRMTState
#define	MACAVAILFLAG		xdiMACAvailableFlag
#define	MACLOOPFLAG		xdiMACLoopFlag

/*
*	PHY Attributes.
*/
#define PHYTTYPE		fddiPORTPC_Type
#define PHYREMOTETYPE		fddiPORTPC_Neighbor
#define PHYCONNECTSTATE		fddiPORTConnectState
#define PHYREMOTEMACINDICATED	fddiPORTRemoteMACIndicated
#define PHYRESOURCEINDEX	xdiPORTResourceIndex
#define PHYCONNECTEDRESOURCID	xdiPORTConnectedIndex
#define PHYPCMSTATE		fddiPORTPCMState
#define PHYLERCUTOFF		fddiPORTLer_Cutoff
#define PHYLERALARM		fddiPORTLer_Alarm
#define PHYLERESTIMATE		fddiPORTLer_Estimate
#define PHYLEMCNT		fddiPORTLem_Ct	
#define PHYLEMREJECTCNT		fddiPORTLem_Reject_Ct
#define PHYOUTRING1		NOT_SUPPORTED	/* 910122-005 LJP */
#define PHYOUTRING2		NOT_SUPPORTED	/* 910122-005 LJP */
#define PHYEBERRCNT		fddiPORTEBError_Ct
#define	PHYCONNECTIONPOLICIES	fddiPORTConnectionPolicies

/*
*	PMD Attributes
*/
#define PMDOPTICALBYPASS	fddiATTACHMENTOpticalBypassPresent


