/*
@(#) fbmhdr.h V6.2.3:cs.910920.2:6:6 Mon Nov 11 16:39:36 1991 Copyright 1990,1991 XLNT Designs, Inc.
*/
/*********************************************************************
	Frame Services Process Header File
	
	FBM Header File
	
	File:		fbmhdr.h
	Created:	09/05/90

	Version:	V6.2.3	Mon Nov 11 16:39:36 1991
	Last Modified:	cs.910920.2	09/20/91
	
	Copyright 1990,1991 XLNT Designs, Inc.
	
	This is the header file used by all FBM modules. This file contains
	definitions for data structures and defined values.

	Modification History:

	*** Updated to SMT 6.2 ***
	910122-005	LJP
		Removed structure FBMPORTInfo.
	910128-002	LJP
		Removed constants MIB_PHY_S, MIB_PHY_A and MIB_PHY_B.
		These are already defined in fddhdr.h.
*********************************************************************/

/*********************************************************************
	Data Structures
*********************************************************************/

/*
*	The following data structures define the global data used 
*	throughout FBM. The data is divided to correspond to the station,
*	each MAC, and each PORT.
*/

/*
*	This data structure defines the set of data associated with the
*	station.
*/

struct	FBMStationInfo {
	/* MIB SMT values */
	uChar	macCount;		/* total # of MACs */
	uChar	attachCount;		/* # of attach PHYs */
	uChar	masterCount;		/* # of master PHYs */
	uInt16	opVersionID;		/* operational version */
	uInt16	hiVersionID;		/* highest version supported */
	uInt16	loVersionID;		/* lowest version supported */
	uInt32	T_Notify;		/* NN protocol value */
	uInt32	reportLimit;		/* Status report protocol value */
	uChar	useSRP;			/* SET if using SRP */

	/* SMT values from other attributes */
	uChar	usePMF;			/* SET if supporting PMFs */
	uChar	useAuthorization;	/* SET if authorization required */

	/* Locally determined values */
	uInt16	phyCount;		/* total # of PHYs */
	Flag	FBMInitialized;		/* SET after FBM initialized */
	uInt16	latencyRing1;		/* ring 1 latency in bytes */
	uInt16	latencyRing2;		/* ring 2 latency in bytes */

	/* State information */
	uInt32	TSR;			/* timer for next SRF */
	uInt32	nextSRF;		/* time interval between SRFs */
};

/*
*	This data structure defines the set of data associated with the
*	MACs.
*/

struct	FBMMACInfo {
	/* MIB MAC values */
	MACAddr48	SMTAddress;	/* MAC's SMT address */

	/* MAC values from other attributes */
	Flag		operational;	/* SET if MAC is working */

	/* State information */
	MACAddr48	UNA;		/* MAC's upstream neighbor */
	MACAddr48	DNA;		/* MAC's downstream neighbor */
	uChar		myDuplicate;	/* my MAC detected a dupl */
	uChar		myUNADuplicate;	/* my UNA detected a dupl */
	uInt16		dupAddrTest;	/* dupl address test result */
	Int32		TNN;		/* NN protocol timer */
	Int32		TVU;		/* NN protocol timer */
	Int32		TVD;		/* NN protocol timer */
	uInt32		NNTransactionID;/* NN protocol value */
};

	/*
	*	910122-005	LJP
	*	Removed PORT info structure since it was not used.
	*/


/*********************************************************************
	Defined Values
*********************************************************************/

/*
*	Operational Values
*
*	These defined values control the various operational features
*	in the FBM system.
*/

/*
*	Number of seconds between clock ticks.
*/
#define	FBM_CLOCK_TICK	2


/*
*	Flag SET if PMFs are supported.
*/
#define	FBM_PMF_SUPPORTED	CLEAR

/*
*	910128-002	LJP
*	Removed constants MIB_PHY_S, MIB_PHY_A and MIB_PHY_B.
*/

/*
*	Byte order defines.
*/
#define	NET_ORDER		SET
#define	HOST_ORDER		CLEAR


/*
*	Action queue type IDs.
*/
#define	FBM_Q_FRAME		1
#define	FBM_Q_MESSAGE		2
#define	FBM_Q_TIMER		3
