#ifdef USE_WHAT_STRING
static char xdi_id[] = "@(#) fbmproc.c V6.2.3:cs.622c:5:5 Mon Nov 11 16:39:36 1991 Copyright 1990,1991 XLNT Designs, Inc.";
#endif
/*********************************************************************
	Frame Services Process Module

	FBM Queue Processing Module

	File:		fbmproc.c
	Created:	12/12/90

	Version:	V6.2.3	Mon Nov 11 16:39:36 1991
	Last Modified:	cs.622c	08/02/91

	Copyright 1990,1991 XLNT Designs, Inc.

	This module is the processing entry point for FSP. The function
	ProcessFBM() begins the processing of any actions placed
	in the FBM work queue. This function is called from
	the event handling routine or any other interface routine
	that causes FSP to begin executing.

	Modification History:
	910315-002	LJP
		When FSP has not been initialized, ProcessFBM() simply
		empties the queue. The call to ReadFBMQueue() in this
		case did not include all parameters. Now the call
		includes all parameters.
*********************************************************************/

#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smterror.h"
#include	"smtmacro.h"
#include	"smtmsg.h"
#include	"fddihdr.h"
#include	"fbmmacro.h"
#include	"fbmhdr.h"
#include	"fbmframe.h"
#include	"fbmglbl.h"


/*********************************************************************
	External Function Declarations
*********************************************************************/

extern	uInt32	ReadFBMQueue ();
extern	void	ProcessFBMFrame ();
extern	void	ProcessFBMTimer ();
extern	void	ProcessFBMMessage ();
extern	void	FreeFrameBuffer ();
extern	void	FreeMessageBuffer ();


/*********************************************************************
	Processing Global Variables
*********************************************************************/

/*
*	Flag to prevent re-entrant operation.
*/
static	Flag	operating = CLEAR;	/* flag SET if already running */


/*********************************************************************
	Queue Processing Functions
*********************************************************************/

uInt32
InitProcessFBM ()
/*********************************************************************
Function:	Initialize system for processing CSP events.
Parameters:	None.
Input:		None.
Output:		Sets operating flag to CLEAR.
Return:		0 if successful, otherwise error code.
Modification History:
*********************************************************************/
{
	operating = CLEAR;
	return (0);
}

void
ProcessFBM (onState)
	ProcState	*onState;
/*********************************************************************
Function:	Process all actions in the work queue. For each action
		read from the queue, this function calls the appropriate
		processing routine.
Parameters:	onState	= the processor interrupt state value to use
			when interrupts are enabled.
Input:		Reads from queue.
Output:		None.
Return:		None.
Notes:		IMPORTANT! Interrupts must be disabled when this function is
		called. This function will enable interrupts to the level
		specified by onState.
*********************************************************************/
{
#if 0
ProcState	saveState;
#endif
uInt16		actionType,
		actionLen,
		actionEntity;
uChar		*actionPtr,
		actionEAC;

	/*
	*	If an interrupt occurred during FSP processing and this
	*	function is called again from an interrupt handler, the
	*	operating flag must be checked to insure that FSP is not
	*	invoked more than once.
	*/
	if (operating)
		return;

	/*
	*	If FSP has not been completely initialized, then
	*	ignore any signal that are in the queue.
	*/
	if (!fbmStationData.FBMInitialized)
	{
		/* 910315-002 LJP */
		while (ReadFBMQueue (&actionType, &actionPtr, &actionLen,
			&actionEntity, &actionEAC) != EFBM_Q_MT) ;
		return;
	}

	/*
	*	Set operating flag.
	*	(Note: Interrupts are still off.)
	*/
	operating = SET;

	/*
	*	Loop through all signals in the signal queue.
	*/
	while (ReadFBMQueue (&actionType, &actionPtr, &actionLen,
		&actionEntity, &actionEAC) != EFBM_Q_MT)
	{
		/*
		*	Enable interrupts.
		*/
		MRestoreInterrupts (onState);

		/*
		*	Process action as needed.
		*/
		switch (actionType)
		{
		case FBM_Q_FRAME:
		        FBMDPT("$ProcessFBMFrame inside ProcessFBM$");
			ProcessFBMFrame (actionPtr, actionLen,
				actionEntity, actionEAC);
			FreeFrameBuffer (actionPtr);
			break;

		case FBM_Q_MESSAGE:
			ProcessFBMMessage ((SMTMessage *) actionPtr);
			FreeMessageBuffer ((SMTMessage *) actionPtr);
			break;

		case FBM_Q_TIMER:
			ProcessFBMTimer ();
			break;

		default:
			break;
		}

		/*
		*	Disable interrupts while checking queue to avoid
		*	race condition where a action is put on the queue
		*	after ReadFBMQueue() indicates the queue is empty.
		*/
		MDisableInterrupts (onState);
	}

	/*
	*	Clear operating flag.
	*/
	operating = CLEAR;

	return;
}
