/*********************************************************************
	Management Information Base Module

	Implementation-dependent system initialization routines.

	THIS FILE IS TO BE PORTED BY THE IMPLEMENTOR.

	File:		mibinim.c
	Created:	12/01/89
	SMT Version:	6.2

	SID:		1.3
	Last Modified:	1/28/91
	
	Copyright 1990,1991 XLNT Designs Inc.

	This module contains two implementation-dependent
	initialization routine. The first routine allocates and clears
	a block of memory used to store the MIB data base. The other
	routine initializes all hardware-related MIB attribute values. 
	The non-hardware MIB values get initialized by the XLNT Manager
	MIB start-up routines.

	Modification History:

	*** Updates to SMT 6.2 ***

*********************************************************************/

#include	"smtdefs.h"
#include	"smttypes.h"
#include	"fddihdr.h"
#include	"smtmacro.h"
#include	"mibdefs.h"
#include        "mibtypes.h"
#include	"mibglbl.h"
#include	"mibconf.h"
#include	<eeprecs.h>
#include	<nvrecs.h>

/*********************************************************************
	Defined Values
*********************************************************************/
#define EEP_FDDI	eep_mfg_rec.eep_fddi

/*********************************************************************
	Initialization Routines
*********************************************************************/

MIBType *
CreateMIB ()
/*********************************************************************
Function:	Allocate and clear a block of memory large enough to
		hold a MIB structure.
Parameters:     None.
Input:          None.
Output:		Allocates memory and clears all locations to 0.
Return:         Pointer to start of memory block if successful.
		NULL if MIB memory could not be allocated.
Modification History:
	*** CREATED FOR SMT 6.2 ***
*********************************************************************/
{
MIBType	*mibptr;

	mibptr = (MIBType *) GETMEMORY (sizeof (MIBType));
        SMTDPT2("\nMIB Pointer = %x.   Size = %d\n", mibptr, sizeof(MIBType));
	if (mibptr)
		MEMZERO (mibptr, sizeof (MIBType));

        SMTDPT("\nClearing Memory Done.\n");
        return (mibptr);
}

uInt32
SetupMIB (mib)
	MIBType	*mib;
/*********************************************************************
Function:	Fill in hardware-based MIB attribute values. The sample
		configuration given represents a SM-DAS. Refer to file
		mibconf.h for the values of the DEFAULT_ manifest
		constants.
Parameters:     mib	= pointer to a MIB structure.
Input:          None.
Output:		Fills in appropriate MIB attribute values.
Return:         0		if successful.
		EMIB_INIT_MIB	if error initializing MIB.
Modification History:
	*** CREATED FOR SMT 6.2 ***
*********************************************************************/
{
int	i, mask;
NVR_FDDI *FddiRec;

        FddiRec = &nvr_fddi_rec;

        /*
        *       Initialize fddiSMTStationIdGrp
        */
        SMTDPT("Init SMTMIB\n");
#if 0
	MEMCOPY (&mib->SMTStationIdGrp.StationId,
		 &NVR_FDDI_SMT.stationID, sizeof(SMTStationIdType));
#else
#ifdef __FEBRIDGE
        MCopyAddress(mib->SMTStationIdGrp.StationId.IEEEAddress, MyNid(3));
#else
        MCopyAddress(mib->SMTStationIdGrp.StationId.IEEEAddress, MyNid(2));
#endif
        swap_bits(mib->SMTStationIdGrp.StationId.IEEEAddress,
		  sizeof(mib->SMTStationIdGrp.StationId.IEEEAddress));
#endif
	memcpy (mib->SMTStationIdGrp.UserData, NVR_FDDI_SMT.userData,
		sizeof(mib->SMTStationIdGrp.UserData));
 
	/*
	*	Initialize fddiSMTStationConfigGrp
	*/
	mib->SMTStationConfigGrp.MAC_Ct = EEP_FDDI.smtMac_Ct;
	mib->SMTStationConfigGrp.NonMaster_Ct = EEP_FDDI.smtNonmaster_Ct;
	mib->SMTStationConfigGrp.Master_Ct = EEP_FDDI.smtMaster_Ct;
	mib->SMTStationConfigGrp.PathsAvailable = EEP_FDDI.smtPathAvailable;
	mib->SMTStationConfigGrp.ConfigCapabilities 
					= EEP_FDDI.smtConfigCapabilities;
	mib->SMTStationConfigGrp.ConfigPolicy = NVR_FDDI_SMT.configPolicy;
	mib->SMTStationConfigGrp.ConnectionPolicy 
					= NVR_FDDI_SMT.connectionPolicy;
	mib->SMTStationConfigGrp.ReportLimit  	/* SMT default */
					= EEP_FDDI.smtStatusReporting;
		/* StatusReporting set by core modules */
	mib->SMTStationConfigGrp.T_Notify = NVR_FDDI_SMT.T_Notify;

	/*
	*	Initialize fddiSMTStatusGrp
	*
	*	This group is initialized by the core modules.
	*       (in InitMIB())
	*/

	/*
	*	Initialize fddiSMTMIBOperationGrp
	*
	*	This group is initialized by the core modules.
	*/

        MEMZERO (&mib->SMTMIBOperationGrp.MsgTimeStamp, sizeof(SMTTimeStamp));
        MEMZERO (&mib->SMTMIBOperationGrp.TransitionTimeStamp, 
		 sizeof(SMTTimeStamp));
        MEMZERO (&mib->SMTMIBOperationGrp.SetCount, sizeof(SetCountType));
        MEMCOPY (&mib->SMTMIBOperationGrp.LastSetStationId,
		 &NVR_FDDI_SMT.stationID, sizeof(SMTStationIdType));

	/*
	*	MAC Group Initialization (one per MAC)
	*
	*	Since the default initialization is for a single MAC
	*	station, only one MAC is initialized. Otherwise,
	*	mib->SMTStationConfigGrp.MAC_Ct MACs need to be
	*	initialized.
	*/

        SMTDPT("Init MAC MIB\n");
             for (i=0; i < EEP_FDDI.smtMac_Ct; i++)
	     {
		/*
		*	Initialize fddiMACCapabilitiesGrp
		*/
		mib->MACCapabilitiesGrp[i].FrameStatusCapabilities 
			= EEP_FDDI.macFrameStatusCapabilities[i];
		mib->MACCapabilitiesGrp[i].BridgeFunction
			= EEP_FDDI.macBridgeFunction[i];
		mib->MACCapabilitiesGrp[i].T_MaxGreatestLowerBound
			= NVR_FDDI_MAC[i].T_MaxGreatestLowerBound;
		mib->MACCapabilitiesGrp[i].TVXGreatestLowerBound
			= NVR_FDDI_MAC[i].TVXGreatestLowerBound;

		/*
		*	Initialize fddiMACConfigGrp
		*/
		mib->MACConfigGrp[i].PathsAvailable 
			= EEP_FDDI.macPathAvailable[i];
		mib->MACConfigGrp[i].PathsRequested 
			= NVR_FDDI_MAC[i].pathRequested;
			/*
			*	UNAs and DNAs set by core modules.
			*	RootConcentratorMAC, Dup_Addr_Test, &
			*	DownstreamPORTType set by core modules.
			*       (in InitMIB())
			*/

		/*
		*	Initialize fddiMACAddressGrp
		*
		*	Fill in any mechanism for supporting group
		*	addressing.
		*/
#if 0
		MCopyAddress (mib->MACAddressGrp[i].SMTAddress,
			      NVR_FDDI_MAC[i].SMTAddress);
#else
#ifdef __FEBRIDGE
		MCopyAddress (mib->MACAddressGrp[i].SMTAddress,
			      MyNid(3));
#else
		MCopyAddress (mib->MACAddressGrp[i].SMTAddress,
			      MyNid(i));
#endif
		swap_bits(mib->MACAddressGrp[i].SMTAddress,
			  sizeof(mib->MACAddressGrp[i].SMTAddress));
#endif

		/* Set OUI from primary MAC address */
		mib->SMTStationIdGrp.ManufacturerData.OUI[0]
			= mib->MACAddressGrp[i].SMTAddress[0];
		mib->SMTStationIdGrp.ManufacturerData.OUI[1]
			= mib->MACAddressGrp[i].SMTAddress[1];
		mib->SMTStationIdGrp.ManufacturerData.OUI[2]
			= mib->MACAddressGrp[i].SMTAddress[2];
		MEMCOPY(mib->SMTStationIdGrp.ManufacturerData.data,
		        NVR_FDDI_SMT.manufacturerData.data,
			sizeof(mib->SMTStationIdGrp.ManufacturerData.data));

/*              We use a different address for the Concentrator.
 *              So, it's not needed at this moment.
 *		MCopyAddress (mib->SMTStationIdGrp.StationId.IEEEAddress,
 *			mib->MACAddressGrp[i].SMTAddress);
 */

		/*
		*	Initialize fddiMACOperationGrp
		*
		*	Only the FrameStatus is set here. All other values
		*	must be provided by the implementor.
		*/
		mib->MACOperationGrp[i].T_Req = NVR_FDDI_MAC[i].T_Req;
		mib->MACOperationGrp[i].T_Max = NVR_FDDI_MAC[i].T_Max;
		mib->MACOperationGrp[i].T_Min = NVR_FDDI_MAC[i].T_Min;
		mib->MACOperationGrp[i].TvxValue = NVR_FDDI_MAC[i].TVXValue;
		mib->MACOperationGrp[i].T_Pri0 = NVR_FDDI_MAC[i].T_Pri[0];
		mib->MACOperationGrp[i].T_Pri1 = NVR_FDDI_MAC[i].T_Pri[1];
		mib->MACOperationGrp[i].T_Pri2 = NVR_FDDI_MAC[i].T_Pri[2];
		mib->MACOperationGrp[i].T_Pri3 = NVR_FDDI_MAC[i].T_Pri[3];
		mib->MACOperationGrp[i].T_Pri4 = NVR_FDDI_MAC[i].T_Pri[4];
		mib->MACOperationGrp[i].T_Pri5 = NVR_FDDI_MAC[i].T_Pri[5];
		mib->MACOperationGrp[i].T_Pri6 = NVR_FDDI_MAC[i].T_Pri[6];
		mib->MACOperationGrp[i].FrameStatus 
			= NVR_FDDI_MAC[i].frameStatus;

		/*
		*	Initialize:
		*		fddiMACCountersGrp
		*		fddiMACErrorCtrsGrp
		*		fddiMACFrameErrorConditionGrp
		*		fddiMACNotCopiedConditionGrp
		*		fddiMACStatusGrp
		*		fddiMACRootMACStatusGrp
		*
		*	These groups are initialized by the core modules.
		*/
		mib->MACFrameErrorConditionGrp[i].FrameErrorThreshold
		        = NVR_FDDI_MAC[i].FrameErrorThreshold;
		mib->MACNotCopiedConditionGrp[i].NotCopiedThreshold
		        = NVR_FDDI_MAC[i].NotCopiedThreshold;

		/*
		*	Initialize XDIMACGrp
		*
		*	The implementor only needs to provide the RMTDupPolicy1,
		*	RMTDupPolicy2, and operational values for each MAC.
		*/
		mib->XDIMACGrp[i].RMTDupPolicy1 
			= NVR_FDDI_MAC[i].xdiRMTDupPolicy1;
		mib->XDIMACGrp[i].RMTDupPolicy2 
			= NVR_FDDI_MAC[i].xdiRMTDupPolicy2;
		mib->XDIMACGrp[i].Operational 
			= NVR_FDDI_MAC[i].xdiOperational;

            } /* for mac initialization */

	/*
	*	Initialize fddiPATHClassConfigGrp
	*
	*	Trace_MaxExpiration initialized by the core modules.
	*
	*	NOTE: Due to confusion in the use of PATH Class
	*	attributes in SMT 6.2, the XLNT Manager uses only one
	*	set of attributes for both local and non-local paths.
	*	The values for the local path are read-only. To change
	*	any of these attributes, the requestor must set
	*	the non-local path values.
	*/

        SMTDPT("Init PATH MIB\n");
	 mib->ClassConfigGrp.TVXLowerBound
		= NVR_FDDI_PATH[0].TVXLowerBound;
	 mib->ClassConfigGrp.T_MaxLowerBound
		= NVR_FDDI_PATH[0].T_MAXLowerBound;

	/*
	*	PATH Class PATH Group Initialization
	*
	*	Since the default initialization assumes only one PATH
	*	in the station, only one PATH is initialized. Otherwise,
	*	each PATH must be initialized.
	*
	*	NOTE: SMT 6.2 defines PATH Class PATH attributes for
	*	non-local paths only.
	*/
	for (i=0, mask=1; i < MAX_PATH_COUNT; i++, mask<<=1)
        {
		/*
		*	Initialize fddiPATHClassPATHConfigGrp
		*
		*	TraceStatus, Status, & Configuration set
		*	by the core modules.
		*/
	   mib->ClassPATHConfigGrp[i].Type = (EEP_FDDI.pathType[i] & mask);
	   mib->ClassPATHConfigGrp[i].PORTOrder
			= EEP_FDDI.pathPortOrder[i];
	   mib->ClassPATHConfigGrp[i].T_Rmode = NVR_FDDI_PATH[i].T_Rmode;
        } /* for PATH Class Group */

	/*
	*	PORT Group Initialization (one per PORT)
	*/
        SMTDPT("Init PORT MIB\n");
	for (i = 0; i < (mib->SMTStationConfigGrp.NonMaster_Ct
		+ mib->SMTStationConfigGrp.Master_Ct); i++)
	{
		/*
		*	Initialize fddiPORTConfigGrp
		*	PC_Neighbor, RemoteMACIndicated, CE_State,
		*	& MACPlacement are set by the core modules.
		*/
	        if (i < mib->SMTStationConfigGrp.NonMaster_Ct)
		{
		   mib->PORTConfigGrp[i].MACPlacement = i + 1 +
		     (mib->SMTStationConfigGrp.NonMaster_Ct
		      + mib->SMTStationConfigGrp.Master_Ct);
		}

		mib->PORTConfigGrp[i].PC_Type = NVR_FDDI_PORT[i].PC_Type;
		mib->PORTConfigGrp[i].ConnectionPolicies 
			= NVR_FDDI_PORT[i].connectionPolicies;
		mib->PORTConfigGrp[i].PathsRequested 
			= NVR_FDDI_PORT[i].pathRequested;
		mib->PORTConfigGrp[i].AvailablePaths 
			= EEP_FDDI.portAvailPath[i];
		mib->PORTConfigGrp[i].MACLoop_Time 
			= NVR_FDDI_PORT[i].MACLoop_Time;
		mib->PORTConfigGrp[i].FotxClass = EEP_FDDI.portFotxClass[i];

		/*
		*	Initialize fddiPORTOperationGrp
		*
		*	This group is set by core modules.
		*/

		/*
		*	Initialize fddiPORTErrorCtrsGrp
		*
		*	This group is set by core modules.
		*/

		/*
		*	Initialize fddiPORTLerGrp
		*
		*	Ler_Estimate, Lem_Reject_Ct, Lem_Ct, &
		*	BaseLer values are set by core modules.
		*/
		mib->PORTLerGrp[i].Ler_Cutoff = NVR_FDDI_PORT[i].LER_Cutoff;
		mib->PORTLerGrp[i].Ler_Alarm = NVR_FDDI_PORT[i].LER_Alarm;
		mib->PORTLerGrp[i].Ler_Estimate 
		  = mib->PORTLerGrp[i].BaseLer_Estimate = LER_MAX;
		mib->PORTStatusGrp[i].LerCondition = FALSE;

		/*
		*	Initialize fddiPORTStatusGrp
		*
		*	This group is set by core modules.
		*/

		/*
		*	Initialize XDIPORTGrp
		*
		*	The implementor only needs to provide the operational
		*	value for each PORT.
		*/
		mib->XDIPORTGrp[i].Operational 
			= NVR_FDDI_PORT[i].xdiOperational;

	} /* for PORT Group */

	/*
	*	ATTACHMENT Group Initialization (one per PORT or PORT pair)
	*
	*	The default initialization is for a dual attachment
	*	station. Therefore, a two-port pair is initialized and
	*	no master ports are set.
	*
	*	NOTE: The attachment ports (S or A/B) will always be
	*	the first ATTACHMENT entry. Master attachment indexes
	*	on a concentrator will match the indexes of the Master
	*	PORTs.
	*
	*	I_MaxExpiration, InsertedStatus, & InsertPolicy set
	*	by core modules.
	*/
        SMTDPT("Init ATTACH MIB\n");
	for (i = 0; i < (mib->SMTStationConfigGrp.NonMaster_Ct
		+ mib->SMTStationConfigGrp.Master_Ct); i++)
	{
		/*
		*	Initialize fddiATTACHMENTConfigGrp
		*/
		mib->ATTACHMENTConfigGrp[i].Class
			= EEP_FDDI.attachClass[i];
		mib->ATTACHMENTConfigGrp[i].OpticalBypassPresent
			= NVR_FDDI_ATTACHMENT[i].opticalBypassPresent;
	}

	/*
	*	Initialize XDISMTGrp
	*
	*	The implementor only needs to provide BothWrapCapability
	*	and BothWrapPolicy if this is a dual MAC station.
	*/
	mib->XDISMTGrp.BothWrapCapability = EEP_FDDI.xdiBothWrapCapability;
	mib->XDISMTGrp.BothWrapPolicy = NVR_FDDI_SMT.xdiBothWrapPolicy;

	return (0);
}

