/*********************************************************************
	Connection Services Process Module

	System Interface Routines

	THIS FILE IS TO BE PORTED BY THE IMPLEMENTOR.

	File:		cspsysif.c
	Created:	12/01/89

	SID:		1.3
	Last Modified:	1/28/91

	Copyright 1990,1991 XLNT Designs Inc.

	All functions listed here are used by CSP to access
	environment capabilities.

	Modification History:

	*** Updated to SMT 6.2 ***

*********************************************************************/

#include        "constant.h"
#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smtmsg.h"
#include	"smtmacro.h"
#include        "mibdefs.h"
#include        "mibtypes.h"
#include        "mibglbl.h"
#include	"fddihdr.h"
#include	"cspmacro.h"
#include	"csphdr.h"
#include	"cspglbl.h"
#include        "drv.h"
#include        "fddiled.h"


/*********************************************************************
        Global Variables
*********************************************************************/
uInt32 PortWrap[2];
static uChar currentBeaconType[2]={ 0, 0 };
static char beaconFrame[2][23];

uChar PreviousPHYConfigure[2];       /* for PHY_A & PHY_B only */
extern byte frontPanelLed[];
extern  void    SendCSPMessage ();

/*********************************************************************
	Environment Interface Routines
*********************************************************************/

uInt32
ReadSystemTimer ()
/*********************************************************************
Function:	Read the current number of microseconds remaining before
		the next CSP time value expires in the system timer .
Parameters:	None.
Input:
Output:
Return:		Number of microseconds remaining.
Notes:		None.
Modification History:
*********************************************************************/
{
	return (DRV_ReadSystemTimer());
}

void
SetSystemTimer (interval)
	uInt32	interval;
/*********************************************************************
Function:	Set the system timer to time the next CSP timer event.
Parameters:	interval = number of microseconds until timer expiration.
Input:		None.
Output:		None.
Return:		No value returned.
Notes:		If the interval has the value of 0, then the timer is
		to be turned off.
Modification History:
*********************************************************************/
{
        DRV_SetSystemTimer (interval);
}


/*********************************************************************
	Station Interface Routines
*********************************************************************/

Flag
StationPathTest ()
/*********************************************************************
Function:	Perform a station path test.
Parameters:	None.
Input:		None.
Output:		None.
Return:		New value for path test variable:
		PT_Passed if path test passes
		PT_Failed if path test fails
Modification History:
*********************************************************************/
{
   uInt32 result;
        CSPDPT("CSP: Start Station Path Test.\n");
	result = (DRV_ControlReq(PRIMARY_MAC, SM_MA_CTRL_PATH_TEST, 
			      DONT_CARE));
        CSPDPT1("CSP: Station Path Test %s.\n", 
		(result  == RC_SUCCESS)	? "is successful" : "fails");
	return ((result  == RC_SUCCESS)	? TRUE : FALSE);
}

void
BypassRequest (bypassState)
	uInt16	bypassState;
/*********************************************************************
Function:	Implement the SM_PM_BYPASS.request primitive to change 
		the state of the bypass relay.
Parameters:	bypassState	= one of the defined values:
				INSERTED to insert the relay
				DEINSERTED to deinsert the relay
Input:		None.
Output:		None.
Return:		No value returned.
Notes:		None.
Modification History:
*********************************************************************/
{
    DRV_ControlReq(DONT_CARE, SM_PM_CTRL_BYPASS_REQ, 
		   (uInt32) ((bypassState == INSERTED)
		            ? DRV_ENABLE : DRV_DISABLE));
#if 0
    SMTMessage      eventMsg;               /* message to send */

    /*
     *       Create header.
     */
    eventMsg.source = CSP_MSG_ID;
    eventMsg.destination = MIB_MSG_ID;
    eventMsg.type = CSP_EVENT_NOTIFY_MIB;
    eventMsg.typeInfo = fddiATTACHMENTInsertedStatus;
    eventMsg.entity = PHY_A;
    eventMsg.localID = 0;
    eventMsg.len1 = 0;
    eventMsg.len2 = 0;
    eventMsg.data.b8 = (bypassState == INSERTED)? SET : CLEAR;
     
    /*
     *       Send message.
     */
    SendCSPMessage (&eventMsg);
    eventMsg.entity = PHY_B;
    SendCSPMessage (&eventMsg);
#endif    
}

uInt16
ReadLineState (phyID)
	uInt16	phyID;
/*********************************************************************
Function:	Implement the SM_PH_CONTROL.request where Control_Action
		is set to Requested_Status. The status returned is the
		set of line states received since the last time this
		request was made.
Parameters:	phyID	= index of PHY to read.
Input:		None.
Output:		None.
Return:		Bit vector value indicating line states.
Notes:		
Modification History:
*********************************************************************/
{
   uInt32 status;

   DRV_StatusReq((uInt32) phyID, SM_PM_STATUS_RX_LINE_STATE,
		 &status);
   return status;
}

void
SendLineState (phyID, ls)
	uInt16		phyID;
	LineState	ls;
/*********************************************************************
Function:	Implement the SM_PH_LINE-STATE.request primitive to cause
		the PHY to transmit a specified symbol stream.
Parameters:	phyID	= index of PHY to change.
		ls	= defined value indicating symbol stream to transmit.
Input:		None.
Output:		None.
Return:		No value returned.
Notes:		None.
Modification History:
*********************************************************************/
{
   DRV_ControlReq ((uInt32) phyID, SM_PM_CTRL_TX_SYMBOL, (uInt32) ls);
}


void
ConfigureMaster (phyID, CCE_State)
	uInt16	phyID;
	uChar	CCE_State;
/*********************************************************************
Function:	Set the configuration hardware for the specified
		M port to the CCE configuration given.
Parameters:	phyID		= CSP index of port to configure.
		CCE_State	= state for hardware configuration as
				defined in the M port CEM state machine.
Input:		None.
Output:		None.
Return:		No value returned.
Notes:		This routine may be stubbed out if the software is not
		implemented in a concentrator.
Modification History:
*********************************************************************/
{
   uInt32 TxLineState=DRV_QUIET_LS;
   BOOLEAN changed;
   uChar macID;

   DRV_StatusReq(phyID, SM_PM_STATUS_TX_LINE_STATE, 
		 &TxLineState);
   
   if (TxLineState == DRV_ACTIVE_LS)
   {
      changed = TRUE;
      SendLineState (phyID, (LineState) ILS);
   }
   else
   {
      changed = FALSE;
   }

   DRV_ControlReq((uInt32) phyID, SM_PH_CTRL_CONFIG, (uInt32) CCE_State);

   if (changed)
   {
      SendLineState (phyID, (LineState) ALS);
   }

   if (CCE_State == CE_ISOLATED)
   {
      SetPortLed(Port2LedMap[phyID], LED_SET2, LED_TURN_OFF);
   }
   else
   {
         SetPortLed(Port2LedMap[phyID], LED_ALL, LED_TURN_OFF);
         SetPortLed(Port2LedMap[phyID], 
		 (LED_ACTIVE_READY | 
		  ((mib->PORTConfigGrp[phyID].PathsRequested == PA_PRIMARY)
		  ? 0 : LED_PRIMARY_SECONDARY) |
		 LED_PEER_TREE), 
		 LED_TURN_ON);
   }

   if (stationData.cfState == CF_ISOLATED)
   {
      macID = (mib->PORTConfigGrp[phyID].PathsRequested == PA_PRIMARY)? 0 : 1;
      if (!mib->MACConfigGrp[macID].RootConcentratorMAC)
      {
         mib->MACConfigGrp[0].RootConcentratorMAC
	   = mib->MACConfigGrp[1].RootConcentratorMAC = SET;
      }
   }
}

void
ConfigureAttach (CF_State)
	uChar	CF_State;
/*********************************************************************
Function:	Set the configuration hardware for the attachment
		ports to the CFM configuration given.
Parameters:	CF_State	= state for hardware configuration as
				defined in the CFM state machine.
Input:		None.
Output:		None.
Return:		No value returned.
Notes:		The implementor may use the given CFM state configuration
		or the CCE state configuration specified by the CEM
		state (cemData[].ceState) for the attachment ports.
Modification History:
*********************************************************************/
{
   uInt32 TxLineState=DRV_QUIET_LS;
   uChar i;
   BOOLEAN changed;

   if (stationData.attachCount == 1)              /* SAS */
   {
      mib->MACConfigGrp[0].RootConcentratorMAC = SET;

      if (CF_State == CF_WRAP_S)
      {
	 PortWrap[PHY_S] = TRUE;
      }
      else
      {
	 PortWrap[PHY_S] = FALSE;
      }

      DRV_StatusReq(PHY_S, SM_PM_STATUS_TX_LINE_STATE, 
		    &TxLineState);

      if (TxLineState == DRV_ACTIVE_LS)
      {
	 changed = TRUE;
	 SendLineState (PHY_S, (LineState) ILS);
      }
      else
      {
         changed = FALSE;
      }

      DRV_ControlReq(PHY_S, SM_PH_CTRL_CONFIG, 
		     (uInt32) cemData[PHY_S].ceState);

      if (changed)
      {
	 SendLineState (PHY_S, (LineState) ALS);
      }

      if (cemData[PHY_S].ceState == CE_ISOLATED)
      {
         SetPortLed(Port2LedMap[PHY_S], LED_SET2, LED_TURN_OFF);
      }
      else
      {
         SetPortLed(Port2LedMap[PHY_S], LED_ALL, LED_TURN_OFF);
         SetPortLed(Port2LedMap[PHY_S], 
		    LED_ACTIVE_READY,
		    LED_TURN_ON);
	 SetPortLed(Port2LedMap[PHY_S], 
		    LED_PRIMARY_SECONDARY, 
		    LED_TURN_OFF);
      }
   }
   else                                           /* DAS */
   {
      mib->MACConfigGrp[0].RootConcentratorMAC
	= mib->MACConfigGrp[1].RootConcentratorMAC = SET;

      switch (CF_State)
	{
	case CF_WRAP_A:
	  {
	    PortWrap[PHY_A] = TRUE;
	    PortWrap[PHY_B] = FALSE;
	    if (Port2LedMap[PHY_A])
	    {
	       frontPanelLed[Port2LedMap[PHY_A]-1] |= RMON_LED_PS << 4;
	    }
	    if (Port2LedMap[PHY_B])
	    {
	       frontPanelLed[Port2LedMap[PHY_B]-1] &= ~(RMON_LED_PS << 4);
	    }
	    break;
	  }
	case CF_WRAP_B:
	  {
	    PortWrap[PHY_A] = FALSE;
	    PortWrap[PHY_B] = TRUE;
	    if (Port2LedMap[PHY_A])
	    {
	       frontPanelLed[Port2LedMap[PHY_A]-1] &= ~(RMON_LED_PS << 4);
	    }
	    if (Port2LedMap[PHY_B])
	    {
	       frontPanelLed[Port2LedMap[PHY_B]-1] |= RMON_LED_PS << 4;
	    }
	    break;
	  }
	case CF_WRAP_AB:
	  {
	    PortWrap[PHY_A] = TRUE;
	    PortWrap[PHY_B] = TRUE;
	    if (Port2LedMap[PHY_A])
	    {
	       frontPanelLed[Port2LedMap[PHY_A]-1] |= RMON_LED_PS << 4;
	    }
	    if (Port2LedMap[PHY_B])
	    {
	       frontPanelLed[Port2LedMap[PHY_B]-1] |= RMON_LED_PS << 4;
	    }
	    break;
	  }
	default:
	  {
	    PortWrap[PHY_A] = FALSE;
	    PortWrap[PHY_B] = FALSE;
	    if (Port2LedMap[PHY_A])
	    {
	       frontPanelLed[Port2LedMap[PHY_A]-1] &= ~(RMON_LED_PS << 4);
	    }
	    if (Port2LedMap[PHY_B])
	    {
	       frontPanelLed[Port2LedMap[PHY_B]-1] &= ~(RMON_LED_PS << 4);
	    }
	  }
	}

      for (i=PHY_A; i <= PHY_B;  i++)
      {
	 if (phyData[i].PC_Neighbor == PC_Type_M) 
	 {
	    mib->MACConfigGrp[0].RootConcentratorMAC
	      = mib->MACConfigGrp[1].RootConcentratorMAC = SET;
	 }

         if (cemData[i].ceState != PreviousPHYConfigure[i])
	 {
	    DRV_StatusReq(i, SM_PM_STATUS_TX_LINE_STATE, 
			  &TxLineState);

	    if (TxLineState == DRV_ACTIVE_LS)
	    {
	       SendLineState (i, (LineState) ILS);
	       changed = TRUE;
	    }
	    else
	    {
	       changed = FALSE;
	    }

	    PreviousPHYConfigure[i] = cemData[i].ceState;
	    DRV_ControlReq(i, SM_PH_CTRL_CONFIG, 
			   (uInt32) cemData[i].ceState);

	    if (changed)
	    {
	       SendLineState (i, (LineState) ALS);
	    }
	 }

	 if (cemData[i].ceState == CE_ISOLATED)
	 {
#ifdef __FEBRIDGE
	    SetPTLedOff(i);		/* turn off peer/tree LED for port */
#else
	    SetPortLed(Port2LedMap[i], LED_SET2, LED_TURN_OFF);
#endif
	 }
	 else if (phyData[i].PC_Type != PC_Type_M)
	 {
	    SetPortLed(Port2LedMap[i], LED_ALL, LED_TURN_OFF);
	    SetPortLed(Port2LedMap[i], 
		       LED_ACTIVE_READY,
		       LED_TURN_ON);
	    if (phyData[i].PC_Type != PC_Type_S)
	    {
	       SetPortLed(Port2LedMap[i], 
			  LED_PRIMARY_SECONDARY, 
			  ((i == PHY_A)
			   ? LED_TURN_OFF : LED_TURN_ON));
	    }
	    else 
	    {
	       SetPortLed(Port2LedMap[i], 
			  ((mib->PORTConfigGrp[i].PathsRequested == PA_PRIMARY)
			   ? 0 : LED_PRIMARY_SECONDARY) |
			  LED_PEER_TREE, 
			  LED_TURN_ON);
	    }
	 }
      }

   }

}

/*********************************************************************
	PHY Interface Routines
*********************************************************************/

void
TransmitPMD (phyID, state)
	uInt16	phyID;
	uInt16	state;
/*********************************************************************
Function:	Implement the SM_PM_CONTROL.request primitive. The
		implementation of this primitive is not required unless the
		station supports control over the PMD.
Parameters:	phyID	= change PMD for PHY with index phyID.
		state	= new state of PMD, either ENABLE or DISABLE.
Input:		None.
Output:		None.
Return:		No value returned.
Notes:		None.
Modification History:
*********************************************************************/
{
   DRV_ControlReq ((uInt32) phyID, SM_PM_CTRL_TX_REQ, 
		   (uInt32) ((state == ENABLE) 
			     ? DRV_ENABLE : DRV_DISABLE));
}

void
SetSILSDetect (phyID, state)
	uInt16	phyID;
	uInt16	state;
/*********************************************************************
Function:	Change the state of the SILS interrupt. This function
		turns on/off the interrupt due to SILS.
Parameters:	phyID	= change SILS detection for PHY with index phyID.
		state	= new state of interrupt, either ENABLE or DISABLE.
Input:		None.
Output:		None.
Return:		No value returned.
Notes:		None.
Modification History:
*********************************************************************/
{
   DRV_ControlReq ((uInt32) phyID, SM_PM_CTRL_SILS_REQ, 
		   (uInt32) ((state == ENABLE)
			     ? DRV_ENABLE : DRV_DISABLE));
}

/*********************************************************************
	MAC Interface Routines
*********************************************************************/

void
MACSetInterrupts (macID, state)
	uInt16	macID;
	uInt16	state;
/*********************************************************************
Function:	Change the MAC's interrupt settings.
Parameters:	macID	= index of MAC to reset.
		state	= ENABLE to allow all required interrupts.
			  DISABLE to stop interrupts.
Input:		None.
Output:		None.
Return:		No value returned.
Notes:		None.
Modification History:
*********************************************************************/
{
   CSPDPT2("MAC %d %s interrupts\n", macID, (state==ENABLE)? "enables" :
	  "disables");
   DRV_ControlReq ((uInt32) macID, SM_MA_CTRL_MAC_INT, 
		   (uInt32) ((state == ENABLE)
			     ? DRV_ENABLE : DRV_DISABLE));
}

void
MACResetRequest (macID)
	uInt16	macID;
/*********************************************************************
Function:	Implement the SM_MA_CONTROL.request primitive for the
		control_action parameter set to Reset.
Parameters:	macID	= index of MAC to reset.
Input:		None.
Output:		None.
Return:		No value returned.
Notes:		None.
Modification History:
*********************************************************************/
{
   DRV_ControlReq ((uInt32) macID, SM_MA_CTRL_RESET, DONT_CARE);
}

void
MACClaimRequest (macID)
	uInt16	macID;
/*********************************************************************
Function:	Implement the SM_MA_CONTROL.request primitive for the
		control_action parameter set to Claim. The MAC is put
		into states T4:CLAIM/R0:LISTEN.
Parameters:	macID	= index of MAC to start claiming.
Input:		None.
Output:		None.
Return:		No value returned.
Notes:		None.
Modification History:
*********************************************************************/
{
     DRV_ControlReq ((uInt32) macID, SM_MA_CTRL_CLAIM_REQ, DONT_CARE);
}

Flag
ValidClaimReceived (macID)
	uInt16	macID;
/*********************************************************************
Function:	Determine if the condition for RMT transition RM(34c)
		is met in the current MAC state. This requires checking
		to see if the MAC is in the T4:Claim state, it is
		receiving a claim frame with My_Address, and
		that the T_Bid != T_Req.
Parameters:	macID	= index of MAC to reset.
Input:		Current T_Req.
Output:		None.
Return:		TRUE if the transition condition is met.
		FALSE otherwise.
Notes:		Some implementations may not be able to check for this
		condition. If not some action should be taken to assure
		that this MAC and its suspected duplicate are not in lock
		step in entering Claim and Beacon states so that RM(34a)
		or RM(34b) will detect the duplicate. If nothing can be
		done, then return FALSE with possible indication to the
		MAP.
Modification History:
*********************************************************************/
{
   uInt32 status;
 
   if (DRV_StatusReq((uInt32) macID, SM_MA_STATUS_DUP_ADDR,
			      &status) == RC_SUCCESS)
   {
      return status;
   }
   else
   {
      return TRUE;
   }
}


void
SetBeacon (macID, beaconType, DA, infoLength, beaconInfo)
	uInt16		macID;
	uChar		beaconType;
	MACAddr48	*DA;
	uInt16		infoLength;
	uChar		*beaconInfo;
/*********************************************************************
Function:	Change the beacon frame sent out by the MAC. This will NOT
		cause the MAC to beacon.
Parameters:	macID		= index of MAC to change.
		beaconType	= value to place in beacon type field.
		DA		= destination address to use.
		infoLength	= length of beacon info field (must be signed).
		beaconInfo	= buffer containing beacon info.
Input:		None.
Output:		Changes beacon frame to be transmitted.
Return:		No value returned.
Notes:		None.
Modification History:
*********************************************************************/
{
   if (currentBeaconType[macID] == 1 && beaconType == 0) 
   {
      DRV_ControlReq ((uInt32) macID, SM_MA_CTRL_INTER_BEACON, 
		      DONT_CARE);
   }

   currentBeaconType[macID] = beaconType;

   if (beaconType == 1) 
   {
      MEMZERO(beaconFrame[macID], 23);
      beaconFrame[macID][0] = 0xc2;
      MEMCOPY(&(beaconFrame[macID][1]), (char *) (*DA), 6);
      beaconFrame[macID][13] = beaconType;
      MEMCOPY(&(beaconFrame[macID][17]), beaconInfo, infoLength);
      DRV_ControlReq ((uInt32) macID, SM_MA_CTRL_EXTER_BEACON, 
		      (uInt32) beaconFrame[macID]);
   }
}

void
BeaconRequest (macID)
	uInt16	macID;
/*********************************************************************
Function:	Implement the SM_MA_CONTROL.request primitive for the
		control_action parameter set to Beacon.
Parameters:	macID	= index of MAC to start beaconing.
Input:		None.
Output:		None.
Return:		No value returned.
Notes:		None.
Modification History:
*********************************************************************/
{
   DRV_ControlReq ((uInt32) macID, SM_MA_CTRL_BEACON_REQ, 
		   DONT_CARE);
}

void
ChangeMACAddress (macID, newAddress)
	uInt16		macID;
	MACAddr48	*newAddress;
/*********************************************************************
Function:	Change the MAC's address to a new, long address.
Parameters:	macID		= index of MAC to start beaconing.
		newAddress	= new MAC address to use.
Input:		None.
Output:		Set new address in MAC.
Return:		No value returned.
Notes:		None.
Modification History:
*********************************************************************/
{
   DRV_ControlReq ((uInt32) macID, SM_MA_CTRL_SET_LONG_ADDR, 
		   (uInt32) newAddress);
}

void
ChangeMACTBid (macID, newTBid)
	uInt16	macID;
	uInt32	newTBid;
/*********************************************************************
Function:	Change the MAC's bid T_Req value. This function should
		change the value in the claim frame AND in the MAC.
Parameters:	macID	= index of MAC to start beaconing.
		newTBid	= new bid value for T_Req.
Input:		None.
Output:		None.
Return:		No value returned.
Modification History:
*********************************************************************/
{
   DRV_ControlReq ((uInt32) macID, SM_MA_CTRL_SET_TBID, 
		   newTBid);
}

void
SetMACInput (macID, state)
	uInt16	macID;
	Flag	state;
/*********************************************************************
Function:	Perform special configuration control for Jam_A_Actions.
		This function will (dis)connect the MAC's input from
		the data path.
Parameters:	macID	= index of MAC to change.
		state	= MAC input connection state
				  TRUE if connected.
				  FALSE if not connected.
Input:		None.
Output:		None.
Return:		No value returned.
Notes:		If the station does not have the hardware capability to
		leave the MAC operational and have its output active with
		the input disconnect, then the Jam_A_Actions policy should
		not be allowed.
Modification History:
*********************************************************************/
{
   DRV_ControlReq ((uInt32) macID, SM_MA_CTRL_PHY2MAC, 
		   (uInt32) ((state) ? DRV_ENABLE : DRV_DISABLE));
}

void
ConfigureMAC (macID, state, path)
	uInt16	macID;
	Flag	state;
	uInt16	path;
/*********************************************************************
Function:	This routine implements the MAC Placement mechanism.
		The specified MAC is placed in the data path or removed
		from the data path based on parameter state. When putting
		a MAC in the data path, the station path to use is given
		by path.
Parameters:	macID	= CSP index of MAC to configure.
		state	= ENABLE if the MAC is to be placed in the data path
				and activated.
			  DISABLE if the MAC is to be removed and turned off.
		path	= indicates which path to use: PA_PRIMARY,
			  PA_SECONDARY, or PA_LOCAL (note this value is a 
			  bit string).
Input:		None.
Output:		None.
Return:		None.
Notes:
Modification History:
*********************************************************************/
{
   DRV_ControlReq ((uInt32) macID, SM_MA_CTRL_CONFIG_MAC, 
		   (uInt32) ((state) ? DRV_START : DRV_STOP));
}

Flag
ReadMACR_Flag (macID)
	uInt16	macID;
/*********************************************************************
Function:	Read the current setting of the MAC's R_Flag.
Parameters:	macID	= index of MAC to reset.
Input:		None.
Output:		None.
Return:		TRUE if the R_Flag is SET
		FALSE otherwise.
Modification History:
*********************************************************************/
{
   uInt32 status;

   if (DRV_StatusReq ((uInt32) macID, SM_MA_STATUS_R_FLAG, &status)==RC_SUCCESS)
   {
      return status;
   }
   else
   {
      return FALSE;
   }
}


/*********************************************************************
	LEM Interface Routines
*********************************************************************/

void
SetLEMCounter (phyID, threshold)
	uInt16	phyID;
	uInt16	threshold;
/*********************************************************************
Function:	Set the LEM hardware counter to cause an interrupt when
		it counts threshold number of errors.
Parameters:	phyID		= index of PHY whose link is to be monitored.
		threshold	= number of error to count before giving
					an interrupt.
Input:		None.
Output:		None.
Return:		None.
Modification History:
*********************************************************************/
{
   DRV_ControlReq ((uInt32) phyID, SM_PH_CTRL_LEM_THRESHOLD, 
		   (uInt32) threshold);
}

uInt16
ReadLEMCounter (phyID)
	uInt16	phyID;
/*********************************************************************
Function:	Read the LEM hardware counter.
Parameters:	phyID	= index of PHY whose link is being monitored.
Input:		None.
Output:		None.
Return:		Number of errors left to count before threshold is reached.
Modification History:
*********************************************************************/
{
   uInt32 status;

   if (DRV_StatusReq ((uInt32) phyID, SM_PH_STATUS_LEM_COUNT, 
		      &status)==RC_SUCCESS)
   {
      return status;
   }
   else
   {
      return FALSE;
   }
}

void
SetLEMState (phyID, state)
	uInt16	phyID;
	Flag	state;
/*********************************************************************
Function:	Enable or disable the LEM hardware for a link.
Parameters:	phyID	= index of PHY whose link is being monitored.
		state	= ENABLE to start monitoring the link
			  DISABLE to stop monitoring the link
Input:		None.
Output:		None.
Return:		None.
Modification History:
*********************************************************************/
{
   DRV_ControlReq ((uInt32) phyID, SM_PH_CTRL_LEM_CONFIG, 
		   (uInt32) ((state == ENABLE)
			     ? DRV_ENABLE : DRV_DISABLE));
}

void
SetupMACLCT (phyID)
	uInt16	phyID;
/*********************************************************************
Function:	Prepare MAC for use during link confidence test.
Parameters:	phyID	= index of PHY on link to be tested.
Input:		None.
Output:		None.
Return:		None.
*********************************************************************/
{
   DRV_ControlReq ((uInt32) phyID, SM_PH_CTRL_LCT, 
		   (uInt32) DRV_START);
}

void
FinishMACLCT (phyID)
	uInt16	phyID;
/*********************************************************************
Function:	Restore MAC from use during link confidence test.
Parameters:	phyID	= index of PHY on link tested.
Input:		None
Output:		None
Return:		None.
*********************************************************************/
{
   DRV_ControlReq ((uInt32) phyID, SM_PH_CTRL_LCT, 
		   (uInt32) DRV_STOP);
}


/*********************************************************************
	PATH Scrubbing Interface Routines
*********************************************************************/

void
StartScrubbing (pathID, entity)
	uInt16	pathID, entity;
/*********************************************************************
Function:	Implement a particular scrubbing mechanism on the given
		path.
Parameters:	pathID	= path (PRIMARY, SECONDARY, or LOCAL) to scrub.
Input:
Output:
Return:		None.
Notes:		The default (and probably easiest) mechanism for scrubbing
		is to source IDLE symbols from a PHY on the given path.
		This mechanism is handled by the PCM state machine by
		sending a SIG_PC_Scrub_Start signal to any PHY on the
		path. The PCM state machine handles the timing and stopping
		of the scrub function. Other mechanisms may be used,
		however, their implementation is left to the implementor.
			Also, the PCM state machine only allows one PHY
		on the local path at any given time. Therefore, the local
		path does not need to be scrubbed.
Modification History:
*********************************************************************/
{
uInt16	i;				/* loop counter */
extern	void	SMTSendSignal();	/* CSP signal queue */

	/* if local path, then skip scrubbing */
	if (pathID == PATH_L)
		return;

/* find the first PHY on the path */
	for (i = 0; i < stationData.phyCount; i++)
	{
		/* if this PORT is ACTIVE */
		if (pcmData[i].pcState == PC_ACTIVE)
		{
			/* if PORT is on the requested path */
		        if ((cemData[i].ceState == CE_INSERT_X)
			    || ((pathID == PATH_P) &&
				(cemData[i].ceState == CE_INSERT_P))
			     || ((pathID == PATH_S) &&
				 (cemData[i].ceState == CE_INSERT_S)))
			{
				/* this port is on the path */
				SMTSendSignal (SIG_PC_Scrub_Start,
					i, (uInt32) 0);
				break;
			}
		}
	}
	/* if no ports on the path, then ignore the request */

	return;
}

