/*********************************************************************
	Connection Services Process Module
	
	CSP Local Processing Module

	THIS FILE IS TO BE PORTED BY THE IMPLEMENTOR.
	
	File:		csplocal.c
	Created:	12/01/89

	SID:		1.3
	Last Modified:	1/28/91
	
	Copyright 1990,1991 XLNT Designs Inc.
	
	This module contains functions relevant to a particular
	implementation. The implementor may provide any additional 
	support and functionality required for the product. Those
	areas in the CSP that have specific local action
	references call functions located in this file.

	Modification History:

	*** Updated to SMT 6.2 ***

*********************************************************************/

#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smterror.h"
#include	"smtmacro.h"
#include	"fddihdr.h"
#include	"smtmsg.h"
#include	"cspmacro.h"
#include	"csphdr.h"
#include	"cspglbl.h"


/*********************************************************************
	External Function Declarations
*********************************************************************/
extern uChar PreviousPHYConfigure[];
extern void CSPInterruptHandler ();

/*********************************************************************
	Local Processing Functions
*********************************************************************/
static word *CSPstack;

uInt32
InitCSPLocal ()
/*********************************************************************
Function:	Provide local initialization support. Such support can
		include hardware initialization, local data initialization,
		system communications, etc.
Parameters:	None.
Input:		None.
Output:		None.
Return:		0 if initialization is successful, otherwise an error code
		is returned.
*********************************************************************/
{
   uInt16 i;

   for (i=PHY_A; i <= PHY_B; i++)
   {
      PreviousPHYConfigure[i] = CE_ISOLATED;
   }

   if (!(CSPstack = (word*) lmalloc(CSP_STACK_BYTE_SIZE)))
   {
      printf("\nCSP stack allocation fails.\n");
      return 1;
   }
   CreatTask(CSPInterruptHandler, CSPstack, 
	     CSP_STACK_BYTE_SIZE, NULL);
   ReSchedule();
   return (0);
}

uInt32
LocalCSPMessages (smtmsg)
	SMTMessage	*smtmsg;
/*********************************************************************
Function:	Process messages not handled through standard CSP
		message processing.
Parameters:	smtmsg	= address of SMT message buffer.
Input:		smtmsg	= contains message to process.
Output:		Implementor defined.
Return:		Return value is reserved. This routine should
		return currently 0 to indicate no errors.
*********************************************************************/
{
	return (0);
}

