/*********************************************************************
	Connection Services Process Module

	Interrupt/Event/Invocation Interface Routines

	THIS MODULE IS TO BE PORTED BY THE IMPLEMENTOR.

	File:		cspintif.c
	Created:	12/01/89

	SID:		1.3
	Last Modified:	1/28/91

	Copyright 1990,1991 XLNT Designs Inc.

	This module provides the interface routines to handle event
	conditions that must be reported to CSP.

	Modification History:

	*** Updated to SMT 6.2 ***

*********************************************************************/

#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smtmacro.h"
#include	"fddihdr.h"
#include	"smtmsg.h"
#include	"cspmacro.h"
#include	"csphdr.h"
#include	"cspglbl.h"

#include	"mibdefs.h"
#include	"mibtypes.h"
#include	"mibglbl.h"
#include        "ifglobal.h"
#include        "drv.h"
#include        "msgutil.h"

/*********************************************************************
	Interrupt Interface Defined Values
*********************************************************************/


/*********************************************************************
	Global Interrupt Values
*********************************************************************/
uInt32 currentIntState=TRUE;
static uChar  Running;

/*********************************************************************
	Interrupt Interface Routines
*********************************************************************/

void
CSPInterruptHandler ()
/*********************************************************************
Function:	This routine may do any number of things depending
		upon the implementation. Generally, this routine
		invokes CSP by calling ProcessCSP(). This routine
		may be called as an ISR or as the entry point from
		an executive scheduler.
Parameters:	Implementor defined.
Input:		Implementor defined.
Output:		Implementor defined.
Return:		None.
*********************************************************************/
{
TLVParamType buffer;
ProcState pState;
SignalMsgType  *signal;
uInt16 DriverSignal, entity;
      
   InitSignalStack();
   Running = TRUE;

   while (Running)
   {
      RcvSignal (&Sema_CSP);
      MDisableCSPInterrupts (&pState);
      while (PopSignal(&DriverSignal, &entity))
      {
	 MRestoreCSPInterrupts (&pState);
	 buffer.paramType = fddiPORTAction;
	 buffer.paramLen  = 4;
	 buffer.PORTINDEX = entity + 1;
	 buffer.PORTPARAM16 = DriverSignal;
	 CSPChangeMIBAttr (sizeof(buffer), &buffer, (SetCountType*) NULL);
	 MDisableCSPInterrupts (&pState);
      }

      ProcessCSP (&pState);
      MRestoreCSPInterrupts (&pState);
   }

   return;
}

uInt32
InitCSPInterrupts ()
/*********************************************************************
Function:	Initialize system for processing CSP interrupts.
Parameters:	None.
Input:		None.
Output:		Set system signal processing.
Return:		0 if successful, error number if failed.
*********************************************************************/
{
   return (0);
}

/*
*	Note: An exit routine might be necessary if CSP could possible
*	stop executing. The exit routine would turn off interrupt
*	processing.
*/

void CSPTerminate ( void )
{
   Running = FALSE;
   SendSignal (&Sema_CSP);
}

