#ifdef USE_WHAT_STRING
static char xdi_id[] = "@(#) csp.c V6.2.3:cs.622c:5:5 Mon Nov 11 16:39:36 1991 Copyright 1990,1991 XLNT Designs, Inc.";
#endif
/*********************************************************************
	Connection Services Process Module
	
	CSP Entry Module
	
	File:		csp.c
	Created:	12/01/89

	Version:	V6.2.3	Mon Nov 11 16:39:36 1991
	Last Modified:	cs.622c	08/02/91
	
	Copyright 1990,1991 XLNT Designs, Inc.
	
	This module is the CSP entry point for starting connection
	processing. The CSP system initialization is directed from here.
	In interrupt-driven systems, the CSP start-up will either enter
	a permanent wait state (e.g., a continuous loop) or return to
	the calling process since any further processing will be initiated
	by an interrupt or signal.

	Modification History:

	*** Updated to SMT 6.2 ***

*********************************************************************/

#include	"smtdefs.h"
#include	"smttypes.h"
#include	"smterror.h"
#include	"smtmacro.h"
#include	"fddihdr.h"
#include	"cspmacro.h"
#include	"csphdr.h"
#include	"cspglbl.h"

/*********************************************************************
	External Function Declarations
*********************************************************************/

extern	uInt32	InitProcessCSP ();
extern	uInt32	InitSignalQueue ();
extern	uInt32	InitCSPTimer ();
extern	uInt32	InitCSPData ();
extern	uInt32	InitCSPInterrupts ();
extern	uInt32	InitCSPMessage ();
extern	uInt32	InitCSPLocal ();


/*********************************************************************
	CSP Start-up Routines
*********************************************************************/

uInt32
CSPMain ()
/*********************************************************************
Function:	Start-up code for the CSP system.
Parameters:	None.
Input:		None.
Output:		Initializes CSP system by calling initialization routines.
Return:		0 is returned if the initialization was successful. Otherwise,
		the initialization error is returned.
Notes:		If initialization is not successful, this routine guarantees
		that the system will be returned to a known state (e.g., no
		communication mechanisms will be left open).
Modification History:
*********************************************************************/
{
uInt32		result;

	/*
	*	Initialize system internal structures.
	*/
	if ((result = InitSignalQueue ()) != 0)
		return (result);

	if ((result = InitCSPTimer ()) != 0)
		return (result);

	if ((result = InitProcessCSP ()) != 0)
		return (result);

	if ((result = InitCSPData ()) != 0)
		return (result);

	if ((result = InitCSPInterrupts ()) != 0)
		return (result);

	if ((result = InitCSPMessage ()) != 0)
		return (result);

	/*
	*	Initialize local interfaces.
	*/
	if ((result = InitCSPLocal ()) != 0)
		return (result);
	
	return (0);
}
