#include "smtdefs.h"
#include "smttypes.h"
#include "smtmsg.h"
#include "fddihdr.h"
#include "mibdefs.h"
#include "fbmframe.h"
#include "smtmacro.h"
#include "maphdr.h"
#include "mapglbl.h"
#include "a_queue.h"
#include "fdrmonty.h"
#include "fdrextrn.h"

#define PATH_DESCRIPTOR_SIZE 256
#define UNRESOLVED           -1
#define ROOT_TREE_DEPTH       0

uInt16 MACResIndex;
static struct 
{
   uInt16 nextEntity;
   uChar  ConnectState;
}  PathDesc[PATH_DESCRIPTOR_SIZE];

static queue_head *RingMapHdr;
static uChar MapPortID;
static Int16 NodeClass;

extern HOSTENTRY* MONP_hash(byte*, uint32, bool);
extern  void      AttrNetOrder ();

uInt32 BuildPathDesc ( TLVPtr, portCount, macCount, macAddr, activePortCount, wrapped )
TLVHdrType *TLVPtr;
uChar portCount, macCount;
MACAddr48 macAddr;
Int16 *activePortCount;
uChar *wrapped;
{
   uInt16 i, totalCount, macIndex, portIndex, j;
   PathPORTRecordType *PortRec;
   PathMACRecordType  *MacRec;
   uChar notFound;

   MEMZERO (PathDesc, sizeof(PathDesc));

   if ((portCount+macCount) > PATH_DESCRIPTOR_SIZE)
   {
      printf("MAP: Path Descriptor is out of space\n");
      return  0;   /* failure */
   }

   for (PortRec = (PathPORTRecordType *) (TLVPtr+1),
	i=1; i <= portCount; i++, PortRec++)
   {
      PathDesc[i].nextEntity = ntohs(PortRec->ConResourceIndex);
      PathDesc[i].ConnectState = PortRec->ConnectState;
      if (!(wrapped &&
	    ((PortRec->PORTType == PC_Type_A) 
	     || (PortRec->PORTType == PC_Type_B))))
      {
	 wrapped = FALSE;
      }
   }

   for (MacRec = (PathMACRecordType *) PortRec, macIndex = 0,
	totalCount = macCount + portCount;
	i <= totalCount; i++, MacRec++)
   {
      PathDesc[i].nextEntity = ntohs(MacRec->ConResourceIndex);
      MCompareAddress (macAddr, MacRec->MAC_Addr, notFound);
      if (!notFound)
      {
	 macIndex = MACResIndex = i;
      }
   }

   if (macIndex)
   {                /* At each path, there is at most 1 MAC */
      printf("\n***PathDesc(Index): %d");
      for (i=macIndex, *activePortCount = 0, j=portCount+macCount;
	   (i != macIndex) && i && j--;
	   i = PathDesc[i].nextEntity, PathDesc[i].nextEntity = 0)
      {
	 printf("-%d", PathDesc[i].nextEntity);
	 if ((i <= portCount) && (PathDesc[i].ConnectState == Connect_Active))
	 {
	    *activePortCount++;
	 }
      }

      printf("***\n");
      if (*activePortCount)
      {
         *activePortCount--;        /* excluding the port
				      which connects with parents */
      }

      if ((wrapped) && (macCount == 1))  /* if (Wrap_A or Wrap_B happens)
					    and (it's a SAC), then 
					    count those active port on 
					    the non-MAC path */
      {
	 for (i=1; 
	      (i <= portCount) 
	      && (!PathDesc[i].nextEntity
		  || (PathDesc[i].ConnectState != Connect_Active)); 
	      i++);

	 if (i <= portCount)   /* if the non-MAC path exists 
				  and is active */
	 {
	    for (portIndex=i; (i != portIndex) && i;
		 i = PathDesc[i].nextEntity)
	    {
	       if ((i <= portCount) 
		   && (PathDesc[i].ConnectState == Connect_Active))
	       {
		  *activePortCount++;
	       }
	    }

	 }
      }

      return RC_SUCCESS;
   }
   return 0;
}


uInt32 UpdateStationStatus ( macID, framePtr )
uInt16 macID;
uChar *framePtr;
{
   SMTFrameHdrType *frameHdr;
   TLVHdrType *TLVPtr;
   StationDescParamType *descPtr;
   StationStateParamType *state;
   HOSTENTRY *host;
   uChar portCount, macCount, wrapped;;

   printf("UpdateStationStatus\n");
   frameHdr = (SMTFrameHdrType *) framePtr;
   if (!(host = MONP_hash ((byte*) frameHdr->macHdr.SA, (uint32) macID, TRUE)))
   {
      printf("MAP: No Host Entry.\n");
      return 0; /* failure */
   }

   if (TLVPtr=(TLVHdrType *)FindFrameParam(STATION_DESC_PARAM_TYPE, framePtr))
   {
      descPtr = (StationDescParamType *) (TLVPtr);
      if ((host->rs_entry->NodeClass=descPtr->NodeClass) == SMT_Type_Station)
      {
	 MACResIndex = 0;
	 return RC_SUCCESS;
      }
      
      if (TLVPtr=(TLVHdrType *)FindFrameParam(STATION_STATE_PARAM_TYPE, framePtr))
      {
	 state = (StationStateParamType *) (TLVPtr);
	 wrapped = state->Topology & Topology_Wrapped;
	 
	 if (TLVPtr=(TLVHdrType *)FindFrameParam(PATH_DESC_PARAM_TYPE, framePtr))
	 {
	    portCount = descPtr->Master_Ct + descPtr->NonMaster_Ct;
	    macCount  = descPtr->Mac_Ct;
	    printf("PortCount = %d    MacCount = %d\n", portCount, macCount);
	    if (BuildPathDesc (TLVPtr, portCount, macCount, frameHdr->macHdr.SA,
			       &host->rs_entry->ActivePortCount, &wrapped) == RC_SUCCESS)
	    {
	      
	       host->rs_entry->TopologyWrapped = wrapped;
	       return RC_SUCCESS;
	    }
	 }
      }

      host->rs_entry->ActivePortCount = UNRESOLVED;
   }

   host->rs_entry->NodeClass = UNRESOLVED;
   return 0; /* failure */
}

void UpdatePortStatistics (port_pstats)
FDDI_PSTATS *port_pstats;
{
   fddi_port_pstats_tbl[MapPortID].PStatsDropEvents 
                              += port_pstats->PStatsDropEvents;
   fddi_port_pstats_tbl[MapPortID].PStatsOctets += port_pstats->PStatsOctets;
   fddi_port_pstats_tbl[MapPortID].PStatsPkts += port_pstats->PStatsPkts;
   fddi_port_pstats_tbl[MapPortID].PStatsDataBroadcastPkts 
                              += port_pstats->PStatsDataBroadcastPkts;
   fddi_port_pstats_tbl[MapPortID].PStatsDataMulticastPkts
                              += port_pstats->PStatsDataMulticastPkts;
   fddi_port_pstats_tbl[MapPortID].PStatsSmtBroadcastPkts
                              += port_pstats->PStatsSmtBroadcastPkts;
   fddi_port_pstats_tbl[MapPortID].PStatsSmtMulticastPkts 
                              += port_pstats->PStatsSmtMulticastPkts;
   fddi_port_pstats_tbl[MapPortID].PStatsMacOctets 
                              += port_pstats->PStatsMacOctets;
   fddi_port_pstats_tbl[MapPortID].PStatsMacPkts += port_pstats->PStatsMacPkts;
   fddi_port_pstats_tbl[MapPortID].PStatsSmtOctets 
                              += port_pstats->PStatsSmtOctets;
   fddi_port_pstats_tbl[MapPortID].PStatsSmtPkts += port_pstats->PStatsSmtPkts;
   fddi_port_pstats_tbl[MapPortID].PStatsAsyncOctets 
                              += port_pstats->PStatsAsyncOctets;
   fddi_port_pstats_tbl[MapPortID].PStatsAsyncPkts 
                              += port_pstats->PStatsAsyncPkts;
   fddi_port_pstats_tbl[MapPortID].PStatsSyncOctets 
                              += port_pstats->PStatsSyncOctets;
   fddi_port_pstats_tbl[MapPortID].PStatsSyncPkts 
                              += port_pstats->PStatsSyncPkts;
   fddi_port_pstats_tbl[MapPortID].PStatsDataPkts18to63Octets 
                              += port_pstats->PStatsDataPkts18to63Octets;
   fddi_port_pstats_tbl[MapPortID].PStatsDataPkts64to127Octets 
                              += port_pstats->PStatsDataPkts64to127Octets;
   fddi_port_pstats_tbl[MapPortID].PStatsDataPkts128to255Octets
                              += port_pstats->PStatsDataPkts128to255Octets;
   fddi_port_pstats_tbl[MapPortID].PStatsDataPkts256to511Octets
                              += port_pstats->PStatsDataPkts256to511Octets;
   fddi_port_pstats_tbl[MapPortID].PStatsDataPkts512to1023Octets
                              += port_pstats->PStatsDataPkts512to1023Octets;
   fddi_port_pstats_tbl[MapPortID].PStatsDataPkts1024to2047Octets
                              += port_pstats->PStatsDataPkts1024to2047Octets;
   fddi_port_pstats_tbl[MapPortID].PStatsDataPkts2048to4095Octets
                              += port_pstats->PStatsDataPkts2048to4095Octets;
   fddi_port_pstats_tbl[MapPortID].PStatsDataPkts4096orGreaterOctets
                             += port_pstats->PStatsDataPkts4096orGreaterOctets;

   MONP_FreePstats (port_pstats);
}

uInt32 ParsePortChildren (UNHost, treeDepth)
HOSTENTRY  **UNHost;
uChar treeDepth;
{
   uInt16 activePortCount;

   (*UNHost)->rs_entry->TreeDepth = ++treeDepth;

   if (!UNHost)
   {
      printf("Can't find the upstream host.\n");
      return 0; /* failure */
   }

   if (!(*UNHost)->portflag)           /* if port number is unknown */
   {
      (*UNHost)->portno = MapPortID;
      (*UNHost)->portflag = TRUE;
      UpdatePortStatistics ((*UNHost)->port_pstats);
   }
   
   NodeClass = (*UNHost)->rs_entry->NodeClass;
   activePortCount = (*UNHost)->rs_entry->ActivePortCount;

   *UNHost = prev_in_queue (RingMapHdr, *UNHost);

   if (NodeClass != SMT_Type_Station)
   {
      if ((NodeClass == UNRESOLVED) || (activePortCount == UNRESOLVED))
      {
	 return 0; /* failure */
      }

      for (; activePortCount ; activePortCount--)
      {
	 ParsePortChildren (UNHost, treeDepth);
      }
   }

   return RC_SUCCESS;
}



uInt32 MapPortChildren ( portID, UNHost, path)
uChar portID;
HOSTENTRY  **UNHost;
uChar path;
{
   TLVParamType mibData;
   uChar wrapped;

   mibData.paramType = fddiPORTPathsRequested;
   mibData.paramLen = 4;
   mibData.PORTINDEX = portID + 1;
   MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
   if (mibData.PORTPARAM8 == path)
   {
      mibData.paramType = fddiPORTConnectState;
      mibData.paramLen = 4;
      mibData.PORTINDEX = portID + 1;
      MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
      if (mibData.PORTPARAM16 == Connect_Active)
      {
	 wrapped = (*UNHost)->rs_entry->TopologyWrapped;
	 MapPortID = portID;
	 return (ParsePortChildren ( UNHost , ROOT_TREE_DEPTH) &&
	         ((wrapped && (*UNHost)->rs_entry->TopologyWrapped)? 
		  ParsePortChildren ( UNHost , ROOT_TREE_DEPTH) : TRUE));
      }
   }
   return RC_SUCCESS;
}

void DoPhysicalPortMapping ( macID )
uInt16 macID;
{
   extern uChar PortNum[];
   extern uChar mibPortNum[];
   HOSTENTRY  *UNHost, *host;
   uChar i, endPort;

   RingMapHdr = fddiHost_control_tbl[macID].CurHead;
   host = first_in_queue (RingMapHdr);
   host->rs_entry->TreeDepth = ROOT_TREE_DEPTH;
   UNHost = (HOSTENTRY *) prev_in_queue (RingMapHdr, host);

   if (macID)            /* the MAC on secondary ring */
   {
      endPort = (mapInfo.PORTConfigGrp[PHY_B].PC_Type == PC_Type_M) ?
                 PortNum[PHY_B] : (PortNum[PHY_B]-1);
      for (i=(PortNum[PHY_A]+1); i <= endPort ; i++)  /* not including PHY_A */
      {
	 if (!MapPortChildren (mibPortNum[i-1]-1, &UNHost, PA_SECONDARY))
	 {
	    return; /* failure */
	 }
      }

      if (mapInfo.PORTConfigGrp[PHY_A].PC_Type == PC_Type_M)
      { 
	 MapPortChildren (PHY_A, &UNHost, PA_SECONDARY);
      }
   }
   else                     /* the MAC on primary ring */
   {
      endPort = (mapInfo.PORTConfigGrp[PHY_A].PC_Type == PC_Type_M) ?
	         PortNum[PHY_A] : (PortNum[PHY_A]+1);
      for (i=(PortNum[PHY_B]-1); i >= endPort; i--) /* not including PHY_B */
      {
	 if (!MapPortChildren (mibPortNum[i-1]-1, &UNHost, PA_PRIMARY))
	 {
	    return; /* failure */
	 }
      }

      if (mapInfo.PORTConfigGrp[PHY_B].PC_Type == PC_Type_M)
      { 
	 MapPortChildren (PHY_B, &UNHost, PA_PRIMARY);
      }
   }

   UNHost->rs_entry->TreeDepth = ROOT_TREE_DEPTH; /* ending mark */
}

void PrintTree(host)
HOSTENTRY *host;
{
   uChar treeDepth, i;
   uInt16 space;
   space = host->rs_entry->TreeDepth * 2 - 1;
   for (i=0; i < space; i++)
   {
      printf(" ");
   }
   printf("-%02x.02x.02x.02x.02x.02x", 
	  host->macAddress[1],
	  host->macAddress[2],
	  host->macAddress[3],
	  host->macAddress[4],
	  host->macAddress[5],
	  host->macAddress[6]);
   printf("\n");
}

void DisplayPhysicalMap (macID)
uChar macID;
{
   HOSTENTRY *UNHost, *host;

   RingMapHdr = fddiHost_control_tbl[macID].CurHead;
   host = first_in_queue (RingMapHdr);
   PrintTree (host);
   UNHost = (HOSTENTRY *) prev_in_queue (RingMapHdr, host);
   while (UNHost->rs_entry->TreeDepth != ROOT_TREE_DEPTH)
   {
      PrintTree(UNHost);
      UNHost = (HOSTENTRY *) prev_in_queue (RingMapHdr, UNHost);
   }
}


void BuildRingMap ( smtmsg )
SMTMessage *smtmsg;
{
   SMTFrameHdrType *frameHdr;
   uInt16 macID;

   macID = smtmsg->entity;
   frameHdr = (SMTFrameHdrType *) smtmsg->p2;

   if (fddiHost_control_tbl[macID].transID != ntohl(frameHdr->smtHdr.Transaction_ID))
   {
      printf("Receive a late SIF response.\n");
      return;
   }
   
   if ((UpdateStationStatus ( macID,  smtmsg->p2) == RC_SUCCESS)
    && (BuildLogicalMap(smtmsg))
    && (fddiHost_control_tbl[macID].RingOrderChanged))
   {
      DoPhysicalPortMapping ( macID );
      fddiHost_control_tbl[macID].RingOrderChanged = FALSE;
   }
}
