/*********************************************************************
	Management Application Module

	MAP Menu Module

	File:		mapmenu.c
	Created:	12/01/89

	SID:		1.1
	Last Modified:	4/22/91

	Copyright 1990,1991 XLNT Designs, Inc.

	This module contains the MAP menu processing routines.

	Modification History:
*********************************************************************/

#include        "ctype.h"
#include        "smtdefs.h"
#include        "smttypes.h"
#include        "smtmsg.h"
#include        "fddihdr.h"
#include        "fbmframe.h"
#include        "fbmmacro.h"
#include        "mibdefs.h"
#include	"maphdr.h"
#include        "cmtflag.h"


extern	void	DisplayMenu ();
extern	void	RemoveMenu ();
extern	int	WindowVisible ();
extern  void    EnableEventLog();
extern  void    DisableEventLog();


/* Station control */
/* Backplane */
extern void AB2FrontPort();
extern void AB2Backplane();
extern void ChangeRingNumber();

/*	SMT */
/*		SMT Actions */
extern	void	DoConnect ();
extern	void	DoDisconnect ();
/*		Parameters */
extern	void	SMTParameters ();

/*	MAC */
/*		Parameters */
extern	void	MACParameters ();

/*	PATH */
/*		Parameters */
extern	void	PATHParameters ();

/*	PORT */
/*		PORT Actions */
extern	void	DoPORTStart ();
extern	void	DoPORTStop ();
extern	void	DoPORTEnable ();
extern	void	DoPORTDisable ();
extern	void	DoPORTMaint ();
/*		Parameters */
extern	void	PORTParameters ();

/* Frame */
extern	void	DoSendFrame ();
extern	void	DoFrameTrace ();
extern	void	DoFrameDisplay ();
extern	void	EmptyFrameBuffer ();

/* MIB */
extern	void	DoGetMIB ();
extern	void	DoGetRemote ();
extern	void	DoSetRemote ();

/* Display */
extern	void	ViewSMTStatus ();
extern	void	ViewMACStats ();
extern  void    DoSMTWindow();
extern  void    DoMACStatWindow();
extern	void	DoEventLogging ();

/* Test */
extern	void	DoPORTTest ();
extern	void	DoECHOTraffic ();
extern	void	ReadMemory ();
extern	void	WriteMemory ();
extern	void	ShowMemory ();

/*	Special */
extern	void	DoNIFTest ();


/*********************************************************************
	Menu Structures
*********************************************************************/
#ifndef __CMT_ONLY
#   if 0
static
ItemType mainMenu[] = {
{ "Main", ' ', 5 },
	{  "Control Station", 'C', 5 },
		{ "MAP Control", 'M', 1 },
			{ "EVENT Display", 'E', 2 },
                                { "Enable", 'E', 0, EnableEventLog },
			        { "Disable", 'D', 0, DisableEventLog },
		{ "SMT Control", 'S', 2 },
			{ "SMT Actions", 'A', 2 },
				{ "Connect", 'C', 0, DoConnect },
				{ "Disconnect", 'D', 0, DoDisconnect },
			{ "SMT Parameters", 'P', 0, SMTParameters },
		{ "MAC Control", 'M', 2 },
			{ "MAC Actions", 'A', 0 },
			{ "MAC Parameters", 'P', 0, MACParameters },
		{ "PATH Control", 'T', 1 },
			{ "PATH Parameters", 'P', 0, PATHParameters },
		{ "PORT Control", 'P', 2 },
			{ "PORT Actions", 'A', 5 },
				{ "Start", '1', 0, DoPORTStart },
				{ "Stop", '2', 0, DoPORTStop },
				{ "Enable", '3', 0, DoPORTEnable },
				{ "Disable", '4', 0, DoPORTDisable },
				{ "Maintenance", '5', 0, DoPORTMaint },
			{ "PORT Parameters", 'P', 0, PORTParameters },
	{ "Frame", 'F', 4 },
		{ "Send Frame", 'S', 0, DoSendFrame },
		{ "Toggle Capture", 'C', 0, DoFrameTrace },
		{ "View Frames", 'V', 0, DoFrameDisplay },
		{ "Empty Buffer", 'E', 0, EmptyFrameBuffer },
	{ "MIB", 'I', 3 },
		{ "Get MIB", 'G', 0, DoGetMIB },
		{ "Remote Get", 'R', 0, DoGetRemote },
		{ "Remote Set", 'S', 0, DoSetRemote },
	{ "Display", 'D', 4 },
		{ "SMT Status", 'S', 0, ViewSMTStatus },

		{ "MAC Statistics", 'M', 0, ViewMACStats },
		{ "Report Events", 'E', 0, DoEventLogging },
		{ "Ring Map", 'R', 0 },
	{ "Test", 'T', 6 },
		{ "PORT Connect", 'P', 0, DoPORTTest },
		{ "ECHO Traffic", 'E', 0, DoECHOTraffic },
		{ "Read Memory", 'R', 0, ReadMemory },
		{ "Write Memory", 'W', 0, WriteMemory },
		{ "Memory Left", 'M', 0, ShowMemory },
		{ "Special Features", 'X', 1 },
				{ "Do XM Req", 'X', 0, DoNIFTest },
	{ "", 0, 0 }
};
#   else
static
ItemType mainMenu[] = {
{ "Main", ' ', 3 },
	{  "Control Station", 'C', 6 },  
		{ "Backplane Control", 'B', 3 },
			{ "A-B ports to Backplane", 'B', 0,  AB2Backplane},
                        { "A-B ports to Front", 'F', 0,  AB2FrontPort},
                        { "change Ring number ", 'R', 0,  ChangeRingNumber},
		{ "MAP Control", 'M', 1 },
			{ "EVENT Display", 'E', 2 },
                                { "Enable", 'E', 0, EnableEventLog },
			        { "Disable", 'D', 0, DisableEventLog },
		{ "SMT Control", 'S', 2 },
			{ "SMT Actions", 'A', 2 },
				{ "Connect", 'C', 0, DoConnect },
				{ "Disconnect", 'D', 0, DoDisconnect },
			{ "SMT Parameters", 'P', 0, SMTParameters },
		{ "MAC Control", 'M', 1 },
/*			{ "MAC Actions", 'A', 0 },*/
			{ "MAC Parameters", 'P', 0, MACParameters },
		{ "PATH Control", 'T', 1 },
			{ "PATH Parameters", 'P', 0, PATHParameters },
		{ "PORT Control", 'P', 2 },
			{ "PORT Actions", 'A', 5 },
				{ "Start", '1', 0, DoPORTStart },
				{ "Stop", '2', 0, DoPORTStop },
				{ "Enable", '3', 0, DoPORTEnable },
				{ "Disable", '4', 0, DoPORTDisable },
				{ "Maintenance", '5', 0, DoPORTMaint },
			{ "PORT Parameters", 'P', 0, PORTParameters },
	{ "MIB", 'I', 3 }, 
		{ "Get MIB", 'G', 0, DoGetMIB },
		{ "Remote Get", 'R', 0, DoGetRemote },
		{ "Remote Set", 'S', 0, DoSetRemote },
	{ "Display", 'D', 2 },
		{ "SMT Status", 'S', 0, DoSMTWindow },
		{ "MAC Statistics", 'M', 0, DoMACStatWindow },
	{ "", 0, 0 }
};

#   endif
#else
static
ItemType mainMenu[] = {
{ "Main", ' ', 3 },
	{  "Control Station", 'C', 3 },  
		{ "MAP Control", 'M', 1 },
			{ "EVENT Display", 'E', 2 },
                                { "Enable", 'E', 0, EnableEventLog },
			        { "Disable", 'D', 0, DisableEventLog },
		{ "SMT Control", 'S', 2 },
			{ "SMT Actions", 'A', 2 },
				{ "Connect", 'C', 0, DoConnect },
				{ "Disconnect", 'D', 0, DoDisconnect },
			{ "SMT Parameters", 'P', 0, SMTParameters },
		{ "PORT Control", 'P', 2 },
			{ "PORT Actions", 'A', 5 },
				{ "Start", '1', 0, DoPORTStart },
				{ "Stop", '2', 0, DoPORTStop },
				{ "Enable", '3', 0, DoPORTEnable },
				{ "Disable", '4', 0, DoPORTDisable },
				{ "Maintenance", '5', 0, DoPORTMaint },
			{ "PORT Parameters", 'P', 0, PORTParameters },
/*	{ "MIB", 'I', 1 }, */
		{ "Get MIB", 'G', 0, DoGetMIB },
/*	{ "Display", 'D', 1 }, */
		{ "SMT Status", 'S', 0, DoSMTWindow },
/*		{ "MAC Statistics", 'M', 0, DoMACStatWindow },*/
	{ "", 0, 0 }
};
#endif
/* current menu name */
static	char	blank[] = "                    ";
char		*curMenu;

/*********************************************************************
	Menu Routines
*********************************************************************/

ItemType
*SearchMenu (menu, key)
	ItemType	*menu;
	int		key;
{
int		i;
ItemType	*m;

	if (isalpha (key))
		key = toupper (key);

	for (i = 0, m = menu->subItem;
		m && (i < menu->numItems); 
		i++)
	{
		if (m->selector == key)
			return (m);
		m = m->nextItem;
	}

	return (NULL);
}

int
DoMenus (menu)
	ItemType	*menu;
/*********************************************************************
Function:	General menu processor.
Parameters:	menu	= current menu to process.
Input:		None.
Output:		None.
Return:		0 if menu item processed
		1 if returning to previous menu
*********************************************************************/
{
int		c = 0;
ItemType	*item;
extern WINDOW	*inputwin;
extern	void	WorkLoop ();

	DisplayMenu (menu); 
	while ((c != CHAR_RETURN) && (c != CHAR_LINE_FEED))
	{
		c = WGETCH (inputwin);
		item = SearchMenu (menu, c);
		if (item)
		{
			if (item->subItem)
			{
				if ((c = DoMenus (item)) != 0)
					return (c);
				DisplayMenu (menu);
			}
			else
			{
				wprintw (inputwin,
					"\n\n%s:\n", item->name);
				curMenu = item->name;
				if (item->func)
				{
					/* restore windows */
					RemoveMenu ();
					WindowVisible (WORK_WIN, TRUE);
					(*item->func) ();
					return (1);
				}
			 }
		}
	}

	return (0);
}

uInt32
MainMenu ()
/*********************************************************************
Function:	Main menu processor.
Parameters:	None.
Input:		Uses mainMenu.
Output:		None.
Return:		None.
*********************************************************************/
{
	/* make work window invisible */
	WindowVisible (WORK_WIN, FALSE);

	while (DoMenus(mainMenu));
#if 0
	if (DoMenus (mainMenu) == 0)
	{
		/* nothing selected, restore windows */
		RemoveMenu ();
		WindowVisible (WORK_WIN, TRUE);
	}
	curMenu = blank;

	/* turn off cursor */
	cursoff ();

#endif
	return (0);
}

uInt16
BuildMenu (menuNum)
	uInt16	menuNum;
/*********************************************************************
Function:	Build a menu.
Parameters:	menu	= element index into mainMenu of menu title item.
Input:		Uses mainMenu.
Output:		None.
Return:		None.
*********************************************************************/
{
int	i, m;

	/* move to next item in list */
	m = menuNum + 1;
	
	/* this next item is subitem */
	if (mainMenu[menuNum].numItems)
		mainMenu[menuNum].subItem = mainMenu + m;

	/* process all subitems in this menu */
	for (i = 0; i < mainMenu[menuNum].numItems; i++)
	{
		/* build submenu */
		m = BuildMenu (m);
	}

	/* set next menu item */
	mainMenu[menuNum].nextItem = mainMenu + m;

	return (m);
}

uInt32
InitMAPMenu ()
/*********************************************************************
Function:	Initialize MAP menus.
Parameters:	None.
Input:		None.
Output:		None.
Return:		None.
*********************************************************************/
{
	curMenu = blank;
	BuildMenu (0);
	return (0);
}

