/*********************************************************************
	Management Application Module

	MAP Frame Processing Module

	File:		mapframe.c
	Created:	12/01/89

	SID:		1.2
	Last Modified:	5/2/91

	Copyright 1990,1991 XLNT Designs, Inc.

	This module contains functions relevant to a particular
	implementation. The implementor may provide any additional
	support and functionality required for the product. Those
	areas in the CMT system that have specific local action
	references call functions located in this file.

	Modification History:
	910124-001	LJP
		Integrate David Johnson's changes: remove use of
		sprintf().
*********************************************************************/

#include        "ctype.h"
#include        "smtdefs.h"
#include        "smttypes.h"
#include        "smtmsg.h"
#include        "fddihdr.h"
#include        "fbmframe.h"
#include        "fbmmacro.h"
#include        "fbmhdr.h"
#include        "mibdefs.h"
#include	"maphdr.h"
#include	"mapglbl.h"

/*********************************************************************
	External Function Declarations
*********************************************************************/


extern	WINDOW	*parsewin;
extern	char	*TYPESTATION[];
extern	char	*PCTYPE[];
extern	char	*PCMODE[];
extern	char	*PCWITHHOLD[];
extern	char	*PATHTEST[];
extern	char	*ECMSTATE[];
extern	char	*CFMSTATE[];
extern	char	*PCMSTATE[];
extern	char	*RMTSTATE[];
extern	char	*CONSTATE[];
extern	char	*FRAMECLASS[];
extern	char	*FRAMETYPE[];
extern	char	*MIBOBJECT[];

extern	uInt16	ntohs ();
extern	uInt32	ntohl ();
extern	void	AttrNetOrder ();

extern	WINDOW	*framewin, *parsewin;


/*********************************************************************
	Global Values
*********************************************************************/

uInt16	numMAC, numAttach, numMaster;


/*********************************************************************
	Defined Values
*********************************************************************/

#define	MACFRAMECAP	0x200B


/*********************************************************************
	Frame Display Functions
*********************************************************************/

void
DoDump (p, limit, win)
	uChar	*p;
	uInt16	limit;
	WINDOW	*win;
/*********************************************************************
Function:	Hex dump a string of data.
Parameters:	p	= address of first byte
		limit	= number of bytes to dump
Input:		None.
Output:		None.
Return:		None.
*********************************************************************/
{
uInt16	i, j;

	for (i = 0; i < limit; i += 16)
	{
		for (j = 0; j < 16; j++)
		{
			if (j == 8)
			{
				waddstr (win, "   ");
			}

			if ((j + i) >= limit)
			{
				waddstr (win, "   ");
			}
			else
			{
				wprintw (win, "%02x ", p[i + j]);
			}
		}

	  	waddstr (win, "   ");

		for (j = 0; (j < 16) && ((j + i) < limit); j++)
		{
			if (j == 8)
			{
			  	waddstr (win, "   ");
			}
			wprintw (win, "%c",
				isprint (p[i + j]) ? p[i + j] : '.');
		}

		waddstr(win, "\n");
	}

	return;
}

void
DisplaySMTHeader (machdr)
	MACHdrType	*machdr;
{
SMTHdrType	*smthdr;

	smthdr = (SMTHdrType *) (machdr + 1);
	wprintw (parsewin, "MAC & SMT Frame Header:\n");
	wprintw (parsewin, "FC Field: %02x - ", machdr->FC);
	switch (machdr->FC)
	{
	case SMT_INFO_FC:
		wprintw (parsewin, "SMT Info Frame\n");
		break;

	case SMT_NSA_FC:
		wprintw (parsewin, "SMT Next Station Addressing\n");
		break;

	default:
		wprintw (parsewin, "Unknown FC Type\n");
		break;
	}

	wprintw (parsewin,
	"Dest = %02x%02x %02x%02x %02x%02x  ",
		machdr->DA[0],
		machdr->DA[1],
		machdr->DA[2],
		machdr->DA[3],
		machdr->DA[4],
		machdr->DA[5]);
	wprintw (parsewin,
	"Source = %02x%02x %02x%02x %02x%02x  ",
		machdr->SA[0],
		machdr->SA[1],
		machdr->SA[2],
		machdr->SA[3],
		machdr->SA[4],
		machdr->SA[5]);
	wprintw (parsewin,
	"ID = %02x%02x %02x%02x %02x%02x\n",
		smthdr->Station_ID.IEEEAddress[0],
		smthdr->Station_ID.IEEEAddress[1],
		smthdr->Station_ID.IEEEAddress[2],
		smthdr->Station_ID.IEEEAddress[3],
		smthdr->Station_ID.IEEEAddress[4],
		smthdr->Station_ID.IEEEAddress[5]);
	wprintw (parsewin, "Class: %02x - %s  Type: %02x - %s  Version: %04x\n",
		smthdr->Frame_Class, FRAMECLASS[smthdr->Frame_Class],
		smthdr->Frame_Type, FRAMETYPE[smthdr->Frame_Type],
		ntohs (smthdr->Version_ID));
	wprintw (parsewin, "Transaction ID: %-10ld  Info Len: %d\n",
		ntohl (smthdr->Transaction_ID),
		ntohs (smthdr->InfoField_Length));

	return;
}

void
DumpParam (phdr)
	ParamHdrType	*phdr;
{
	wprintw (parsewin, 
		"  Parameter Type  : 0x%04x (%d)\n"
		"  Parameter Length: 0x%04x (%d)\n",
		ntohs (phdr->type), ntohs (phdr->type),
		ntohs (phdr->length), ntohs (phdr->length));
	DoDump ((uChar *) (phdr + 1), ntohs (phdr->length), parsewin);
	return;
}

void
DisplayUNA (phdr)
	ParamHdrType	*phdr;
{
UNAParamType		*unaptr;

	unaptr = (UNAParamType *) phdr;
	wprintw (parsewin,
		"Upstream Neighbor Address:\n"
		"  %02x%02x %02x%02x %02x%02x\n",
		unaptr->UNA[0],
		unaptr->UNA[1],
		unaptr->UNA[2],
		unaptr->UNA[3],
		unaptr->UNA[4],
		unaptr->UNA[5]);
	return;
}

void
DisplayStationDescriptor (phdr)
	ParamHdrType	*phdr;
{
StationDescParamType	*sdescptr;

	sdescptr = (StationDescParamType *) phdr;
	wprintw (parsewin, "Station Descriptor:\n");
	wprintw (parsewin, "  %s\n",
		(sdescptr->NodeClass < 2)
			? TYPESTATION[sdescptr->NodeClass]
			: "Invalid node class");
	wprintw (parsewin,
	"  %d MAC(s)\n  %d Attach PORT(s)\n  %d Master PORT(s)\n",
		sdescptr->Mac_Ct, sdescptr->NonMaster_Ct,
		sdescptr->Master_Ct);

	numMAC = sdescptr->Mac_Ct;
	numAttach = sdescptr->NonMaster_Ct;
	numMaster = sdescptr->Master_Ct;

	return;
}

void
DisplayStationState (phdr)
	ParamHdrType	*phdr;
{
StationStateParamType	*sstateptr;

	sstateptr = (StationStateParamType *) phdr;
	wprintw (parsewin,
		"Station State:\n"
		"  Topology (0x%04x)\n"
		"    %s\n",
		sstateptr->Topology,
		(sstateptr->Topology & Topology_Wrapped)
			? "Wrapped" : "Thru");
	if (sstateptr->Topology & Topology_Unrooted)
		wprintw (parsewin, "    Unrooted Concentrator\n");

	if (sstateptr->Topology & Topology_Twisted_AA)
		wprintw (parsewin, "    Twisted A-A\n");

	if (sstateptr->Topology & Topology_Twisted_BB)
		wprintw (parsewin, "    Twisted B-B\n");

	if (sstateptr->Topology & Topology_Rooted_Station)
		wprintw (parsewin, "    Rooted Station\n");

	if (sstateptr->Topology & Topology_SRF)
		wprintw (parsewin, "    SRFs used\n");

	wprintw (parsewin, "  Duplicates (0x%04x)\n",
		sstateptr->DuplAddr);

	if (sstateptr->DuplAddr
		& (DuplAddr_My_Duplicate | DuplAddr_My_UNA_Duplicate))
	{
		if (sstateptr->DuplAddr & DuplAddr_My_Duplicate)
			wprintw (parsewin, "    My_DA\n");

		if (sstateptr->DuplAddr & DuplAddr_My_UNA_Duplicate)
			wprintw (parsewin, "    My_UNA_DA\n");
	}
	else
		wprintw (parsewin, "    None\n");

	return;
}

void
DisplayTimeStamp (phdr)
	ParamHdrType	*phdr;
{
MsgTimeStampParamType	*tsptr;

	tsptr = (MsgTimeStampParamType *) phdr;
	wprintw (parsewin, "Time Stamp:\n  %08lx %08lx\n",
		ntohl (tsptr->MsgTimeStamp.hiword),
		ntohl (tsptr->MsgTimeStamp.loword));
	return;
}

void
DisplayStationPolicies (phdr)
	ParamHdrType	*phdr;
{
StationPoliciesParamType	*spolicyptr;

	spolicyptr = (StationPoliciesParamType *) phdr;
	wprintw (parsewin,
		"Station Policies:\n  Hold (0x%04x) = %s\n",
		spolicyptr->ConfigPolicy,
		(spolicyptr->ConfigPolicy) ? "Available" : "None");
	wprintw (parsewin,
		"  Policies (0x%04x) = Reject ",
		spolicyptr->ConnectionPolicy);
	if (spolicyptr->ConnectionPolicy)
	{
		if (spolicyptr->ConnectionPolicy & FBM_rejectA_A)
			wprintw(parsewin, "A-A ");
		if (spolicyptr->ConnectionPolicy & FBM_rejectB_B)
			wprintw (parsewin, "B-B ");
		if (spolicyptr->ConnectionPolicy & FBM_rejectS_S)
			wprintw (parsewin, "S-S ");
		if (spolicyptr->ConnectionPolicy & FBM_rejectA_M)
			wprintw (parsewin, "A-M ");
		if (spolicyptr->ConnectionPolicy & FBM_rejectB_M)
			wprintw (parsewin, "B-M ");
		if (spolicyptr->ConnectionPolicy & FBM_rejectA_S)
			wprintw (parsewin, "A-S ");
		if (spolicyptr->ConnectionPolicy & FBM_rejectB_S)
			wprintw (parsewin, "B-S ");
	}
	else
		wprintw (parsewin, "None");

	wprintw (parsewin, "\n");
	return;
}

void
DisplayPathLatency (phdr)
	ParamHdrType	*phdr;
{
PathLatencyParamType	*platencyptr;

	platencyptr = (PathLatencyParamType *) phdr;
	wprintw (parsewin, "Path Latency:\n"
		"  Out 1 = %-6d  Latency 1 = %-6d\n"
		"  Out 2 = %-6d  Latency 2 = %-6d\n",
		ntohs (platencyptr->PORTOutIndex1),
		ntohs (platencyptr->PathLatencyRing1),
		ntohs (platencyptr->PORTOutIndex2),
		ntohs (platencyptr->PathLatencyRing2));
	return;
}

void
DisplayMACNeighbors (phdr)
	ParamHdrType	*phdr;
{
MACNeighborsParamType	*mnbrptr;

	mnbrptr = (MACNeighborsParamType *) phdr;
	wprintw (parsewin, 
		"MAC Neighbors:\n"
		"  MAC Index %d\n"
		"    UNA = %02x%02x %02x%02x %02x%02x\n"
		"    DNA = %02x%02x %02x%02x %02x%02x\n",
		ntohs (mnbrptr->MAC_Index),
		mnbrptr->UNA[0], mnbrptr->UNA[1], mnbrptr->UNA[2],
		mnbrptr->UNA[3], mnbrptr->UNA[4], mnbrptr->UNA[5],
		mnbrptr->DNA[0], mnbrptr->DNA[1], mnbrptr->DNA[2],
		mnbrptr->DNA[3], mnbrptr->DNA[4], mnbrptr->DNA[5]);
	return;
}

void
DisplayPathDescriptor (phdr)
	ParamHdrType	*phdr;
{
PathPORTRecordType	*precptr;
PathMACRecordType	*mrecptr;
int			i;

	precptr = (PathPORTRecordType *)(phdr + 1);
	wprintw (parsewin, "PathDescriptor:\n");
	for (i = 0; i < numAttach + numMaster; i++)
	{
		wprintw (parsewin, 
		"  %2d:PORT %s %-10s Remote type: %s, "
		"Remote MAC: %3s, ConID: %2d\n",
			i + 1,
			(precptr->PORTType < 5)
				? PCTYPE[precptr->PORTType]
				: "Invalid",
			(precptr->ConnectState < 4)
				? CONSTATE[precptr->ConnectState]
				: "Invalid",
			(precptr->RemotePORTType < 5)
				? PCTYPE[precptr->RemotePORTType]
				: "Invalid",
			(precptr->RemoteMAC)
				? "Yes"
				: "No",
			ntohs (precptr->ConResourceIndex));
		precptr++;
	}
	mrecptr = (PathMACRecordType *) precptr;
	for (i = 0; i < numMAC; i++)
	{
		wprintw (parsewin,
		"  %2d:MAC    %02x%02x %02x%02x %02x%02x  ConID: %d\n",
			i + numAttach + numMaster + 1,
			mrecptr->MAC_Addr[0],
			mrecptr->MAC_Addr[1],
			mrecptr->MAC_Addr[2],
			mrecptr->MAC_Addr[3],
			mrecptr->MAC_Addr[4],
			mrecptr->MAC_Addr[5],
			ntohs (mrecptr->ConResourceIndex));
		mrecptr++;
	}
	return;
}

void
DisplayMACStatus (phdr)
	ParamHdrType	*phdr;
{
MACStatusParamType	*mstatptr;

	mstatptr = (MACStatusParamType *) phdr;
	wprintw (parsewin, "MAC Status:\n"
		"  MAC Index %d\n",
		ntohs (mstatptr->MAC_Index));
	wprintw (parsewin, "    TReq: %08lx (%10lu us)\n",
		ntohl (mstatptr->T_Req), 
		-MFddi2Usecs (ntohl (mstatptr->T_Req)));
	wprintw (parsewin, "    TNeg: %08lx (%10lu us)\n",
		ntohl (mstatptr->T_Neg), 
		-MFddi2Usecs (ntohl (mstatptr->T_Neg)));
	wprintw (parsewin, "    TMax: %08lx (%10lu us)\n",
		ntohl (mstatptr->T_Max), 
		-MFddi2Usecs (ntohl (mstatptr->T_Max)));
	wprintw (parsewin, "    TVX : %08lx (%10lu us)\n",
		ntohl (mstatptr->TVXValue), 
		-MFddi2Usecs (ntohl (mstatptr->TVXValue)));
	wprintw (parsewin, "    TMin: %08lx (%10lu us)\n",
		ntohl (mstatptr->T_Min), 
		-MFddi2Usecs (ntohl (mstatptr->T_Min)));
	return;
}

void
DisplayLERStatus (phdr)
	ParamHdrType	*phdr;
{
LERStatusParamType	*plerptr;

	plerptr = (LERStatusParamType *) phdr;
	wprintw (parsewin, 
		"PORT LER Status:\n"
		"  PORT Index %d\n"
		"    Cutoff Rate   : 10E-%02d\n"
		"    Alarm Rate    : 10E-%02d\n"
		"    Estimated Rate: 10E-%02d\n"
		"    Reject Count  : %ld\n"
		"    LEM Count     : %ld\n",
		ntohs (plerptr->PORT_Index),
		plerptr->Ler_Cutoff,
		plerptr->Ler_Alarm,
		plerptr->Ler_Estimate,
		ntohl (plerptr->Lem_Reject_Ct),
		ntohl (plerptr->Lem_Ct));
	return;
}

void
DisplayFrameCounters (phdr)
	ParamHdrType	*phdr;
{
FrameCountersParamType	*mcntsptr;

	mcntsptr = (FrameCountersParamType *) phdr;
	wprintw (parsewin,
		"MAC Frame Counters:\n"
		"  MAC Index %d\n"
		"    Receive Count : %ld\n"
		"    Transmit Count: %ld\n",
		ntohs (mcntsptr->MAC_Index),
		ntohl (mcntsptr->Receive_Ct),
		ntohl (mcntsptr->Transmit_Ct));
	return;
}

void
DisplayFrameNotCopied (phdr)
	ParamHdrType	*phdr;
{
FrameNotCopiedParamType	*mcopiedptr;

	mcopiedptr = (FrameNotCopiedParamType *) phdr;
	wprintw (parsewin,
		"MAC Frame Not Copied Count\n"
		"  MAC Index %d\n"
		"    Not Copied Count: %ld\n",
		ntohs (mcopiedptr->MAC_Index),
		ntohl (mcopiedptr->NotCopied_Ct));
	return;
}

void
DisplayPriorityValues (phdr)
	ParamHdrType	*phdr;
{
PriorityValuesParamType	*mpriptr;

	mpriptr = (PriorityValuesParamType *) phdr;
	wprintw (parsewin, "MAC Priority Values:\n");
	wprintw (parsewin, "  MAC Index %d\n", ntohs (mpriptr->MAC_Index));
	wprintw (parsewin, "    6: %10lu usecs     2: %10lu usecs\n",
		-MFddi2Usecs (ntohl (mpriptr->T_Pri6)),
		-MFddi2Usecs (ntohl (mpriptr->T_Pri2)));
	wprintw (parsewin, "    5: %10lu usecs     1: %10lu usecs\n",
		-MFddi2Usecs (ntohl (mpriptr->T_Pri5)),
		-MFddi2Usecs (ntohl (mpriptr->T_Pri1)));
	wprintw (parsewin, "    4: %10lu usecs     0: %10lu usecs\n",
		-MFddi2Usecs (ntohl (mpriptr->T_Pri4)),
		-MFddi2Usecs (ntohl (mpriptr->T_Pri0)));
	wprintw (parsewin, "    3: %10lu usecs\n",
		-MFddi2Usecs (ntohl (mpriptr->T_Pri3)));
	return;
}

void
DisplayEBStatus (phdr)
	ParamHdrType	*phdr;
{
EBStatusParamType	*pebptr;

	pebptr = (EBStatusParamType *) phdr;
	wprintw (parsewin, 
		"PORT EB Status\n"
		"  PORT Index %d\n"
		"    EB Error Count: %ld\n",
		ntohs (pebptr->PORT_Index),
		ntohl (pebptr->EbErrorCt));
	return;
}

void
DisplayManufacturerData (phdr)
	ParamHdrType	*phdr;
{

	wprintw (parsewin, "Manufacturer Data:\n");
	if (ntohs (phdr->type) == fddiSMTManufacturerData)
		wprintw (parsewin, "  (MIB Attribute)\n");
	else
		wprintw (parsewin, "  (Frame Parameter)\n");
	DumpParam (phdr);
	return;
}

void
DisplayUserData (phdr)
	ParamHdrType	*phdr;
{

	wprintw (parsewin, "User Field:\n");
	if (ntohs (phdr->type) == fddiSMTUserData)
		wprintw (parsewin, "  (MIB Attribute)\n");
	else
		wprintw (parsewin, "  (Frame Parameter)\n");
	DumpParam (phdr);
	return;
}

void
DisplayEcho (phdr)
	ParamHdrType	*phdr;
{
	wprintw (parsewin, "Echo Data:\n");
	DumpParam (phdr);
	return;
}

void
DisplayReasonCode (phdr)
	ParamHdrType	*phdr;
{
ReasonCodeParamType	*reasonptr;

	reasonptr = (ReasonCodeParamType *) phdr;
	wprintw (parsewin, "Reason Code:\n");
	wprintw (parsewin, "  0x%04lx - %s\n",
		ntohl (reasonptr->reason),
		REASONCODE[ntohl (reasonptr->reason)]);
	return;
}

void
DisplayRejectedFrame (phdr)
	ParamHdrType	*phdr;
{
	wprintw (parsewin, "Rejected Frame Beginning:\n");
	DumpParam (phdr);
	return;
}

void
DisplaySupportedVersions (phdr)
	ParamHdrType	*phdr;
{
SupportedVersionsParamType	*sversptr;

	sversptr = (SupportedVersionsParamType *) phdr;
	wprintw (parsewin, 
		"Supported SMT Versions:\n"
		"  %d Version(s)\n"
		"    Low         %d\n"
		"    High        %d\n"
		"    Operational %d\n",
		sversptr->numVersions, ntohs (sversptr->Version[0]),
		ntohs (sversptr->Version[sversptr->numVersions - 1]),
		ntohs (sversptr->Version[sversptr->indexOpVersion - 1]));
	return;
}

void
DisplayESFID (phdr)
	ParamHdrType	*phdr;
{

	wprintw (parsewin, "ESF ID:\n");
	DumpParam (phdr);
	return;
}

void
DisplayMACFrameStatusCap (phdr)
	ParamHdrType	*phdr;
{
TLVParamType	*param;

	param = (TLVParamType *) phdr;

	AttrNetOrder (param, HOST_ORDER);
	wprintw (parsewin, 
		"MAC Frame Capabilities:\n"
		"  MAC Index %d\n",
		param->MACINDEX);
	if (!(param->MACPARAM16 & (FSC_Type0 | FSC_Type1 | FSC_Type2)))
		wprintw (parsewin, "    No frame capabilities available\n");

	else
	{
		if (param->MACPARAM16 & (FSC_Type0 | FSC_Type0_Pgm))
		{
			wprintw (parsewin,
			"    Repeats A/C indicator                 : ");
			wprintw (parsewin, "%5s %s\n",
				(param->MACPARAM16 & FSC_Type0)
					? "SET" : "clear",
				(param->MACPARAM16 & FSC_Type0_Pgm)
					? "(programmable)" : "");
		}
		if (param->MACPARAM16 & (FSC_Type1 | FSC_Type1_Pgm))
		{
			wprintw (parsewin,
			"    Set C, not A on copying for forwarding: ");
			wprintw (parsewin, "%5s %s\n",
				(param->MACPARAM16 & FSC_Type1)
					? "SET" : "clear",
				(param->MACPARAM16 & FSC_Type1_Pgm)
					? "(programmable)" : "");
		}
		if (param->MACPARAM16 & (FSC_Type2 | FSC_Type2_Pgm))
		{
			wprintw (parsewin,
			"    Reset C, set A on C=s and A=r         : ");
			wprintw (parsewin, "%5s %s\n",
				(param->MACPARAM16 & FSC_Type2)
					? "SET" : "clear",
				(param->MACPARAM16 & FSC_Type2_Pgm)
					? "(programmable)" : "");
		}
	}
	AttrNetOrder (param, NET_ORDER);

	return;
}

void
DisplaySMTSetCount (phdr)
	ParamHdrType	*phdr;
{
TLVSetCountType	*setCount;

	setCount = (TLVSetCountType *) phdr;
	wprintw (parsewin, "SMT Set Count:\n");
	wprintw (parsewin, "  Count     : 0x%04x (%ld)\n",
		ntohl (setCount->paramValue.count),
		ntohl (setCount->paramValue.count));
	wprintw (parsewin, "  Time Stamp: 0x%04x%04x\n",
		ntohl (setCount->paramValue.setTimeStamp.hiword),
		ntohl (setCount->paramValue.setTimeStamp.loword));
	return;
}

void
DisplayOther (phdr)
	ParamHdrType	*phdr;
{
TLVParamType		*mibData;

	if (ntohs (phdr->type) & MIB_OBJECT_MASK)
	{
		mibData = (TLVParamType *) phdr;
		AttrNetOrder (mibData, HOST_ORDER);
		wprintw (parsewin, "MIB Attribute:"
			"  %s %d (0x%04x)\n",
			MIBOBJECT[(mibData->paramType >> 12) & 0xf],
			mibData->paramType & MIB_ID_MASK,
			mibData->paramType);
		if (mibData->paramType >= fddiMAC)
		{
			wprintw (parsewin,
				"  Entity %d\n", mibData->MACINDEX);
		}
		wprintw (parsewin, "\n");
		if (mibData->paramType >= fddiMAC)
			DoDump ((uChar *) (mibData->MACOTHER),
				mibData->paramLen - sizeof (TLV16BitType),
				parsewin);
		else
			DoDump ((uChar *) (mibData->SMTOTHER),
				mibData->paramLen, parsewin);
		/* restore */
		AttrNetOrder (mibData, NET_ORDER);
	}

	else
	{
		wprintw (parsewin, "Undefined Frame Parameter:\n");
		DumpParam (phdr);
	}
	return;
}

void
DisplayParam (msg, pstart)
	SMTMessage	*msg;
	uChar		*pstart;
{
ParamHdrType		*phdr;

	werase (parsewin);
	wmove (parsewin, 1, 0);

	/*
	*	If parameter is frame header,
	*	display header.
	*/
	if (pstart == msg->p2)
	{
		DisplaySMTHeader (msg->p2);
		return;
	}

	/*
	*	Get parameter header.
	*/
	phdr = (ParamHdrType *) pstart;

	switch (ntohs (phdr->type))
	{
	case UNA_PARAM_TYPE:
		DisplayUNA (phdr);
		break;

	case STATION_DESC_PARAM_TYPE:
		DisplayStationDescriptor (phdr);
		break;

	case STATION_STATE_PARAM_TYPE:
		DisplayStationState (phdr);
		break;

	case MSG_TIME_STAMP_PARAM_TYPE:
		DisplayTimeStamp (phdr);
		break;

	case STATION_POLICIES_PARAM_TYPE:
		DisplayStationPolicies (phdr);
		break;

	case PATH_LATENCY_PARAM_TYPE:
		DisplayPathLatency (phdr);
		break;

	case MAC_NEIGHBORS_PARAM_TYPE:
		DisplayMACNeighbors (phdr);
		break;

	case PATH_DESC_PARAM_TYPE:
		DisplayPathDescriptor (phdr);
		break;

	case MAC_STATUS_PARAM_TYPE:
		DisplayMACStatus (phdr);
		break;

	case LER_STATUS_PARAM_TYPE:
		DisplayLERStatus (phdr);
		break;

	case FRAME_COUNTERS_PARAM_TYPE:
		DisplayFrameCounters (phdr);
		break;

	case FRAME_NOT_COPIED_PARAM_TYPE:
		DisplayFrameNotCopied (phdr);
		break;

	case PRIORITY_VALUES_PARAM_TYPE:
		DisplayPriorityValues (phdr);
		break;

	case EB_STATUS_PARAM_TYPE:
		DisplayEBStatus (phdr);
		break;

	case fddiSMTManufacturerData:
	case MANUFACTURER_PARAM_TYPE:
		DisplayManufacturerData (phdr);
		break;

	case fddiSMTUserData:
	case USER_PARAM_TYPE:
		DisplayUserData (phdr);
		break;

	case ECHO_PARAM_TYPE:
		DisplayEcho (phdr);
		break;

	case REASON_CODE_PARAM_TYPE:
		DisplayReasonCode (phdr);
		break;

	case REJECTED_FRAME_PARAM_TYPE:
		DisplayRejectedFrame (phdr);
		break;

	case SUPPORTED_VERSIONS_PARAM_TYPE:
		DisplaySupportedVersions (phdr);
		break;

	case ESFID_PARAM_TYPE:
		DisplayESFID (phdr);
		break;

	case fddiMACFrameStatusCapabilities:
		DisplayMACFrameStatusCap (phdr);
		break;

	case fddiSMTSetCount:
		DisplaySMTSetCount (phdr);
		break;

	default:
		DisplayOther (phdr);
		break;
	}

	return;
}

void
DrawParam (msg, param, startPos)
	SMTMessage	*msg;
	uChar 		*param;
	int		startPos;
{
uInt16	pos, y, x, len;
ParamHdrType	*phdr;

	/*
	*	If frame header,
	*/
	if (msg->p2 == param)
	{
		pos = 0;
		len = sizeof (SMTFrameHdrType) - FC_PAD_SIZE;
		param += FC_PAD_SIZE;
	}

	else
	{
		pos = (uInt16) (param - msg->p2) - FC_PAD_SIZE;
		pos -= startPos;
		phdr = (ParamHdrType *) param;
		len = ntohs (phdr->length) + sizeof (ParamHdrType);
	}

	while (len)
	{
		y = (pos / 16) + 1;	/* skip first line */
		x = (pos % 16);		/* get horizontal position */
		if (x > 7) x++;		/* skip dividing space */
		x *= 3;
		wmove (framewin, y, x);
		wprintw (framewin, "%02x", *param);
		pos++;
		param++;
		len--;
	}

	return;
}

void
HiliteParam (msg, param, startPos)
	SMTMessage	*msg;
	uChar 		*param;
	int		startPos;
{
	wstandout (framewin);
	DrawParam (msg, param, startPos);
	wstandend (framewin);
	return;
}

void
UnhiliteParam (msg, param, startPos)
	SMTMessage	*msg;
	uChar		*param;
	int		startPos;
{
	DrawParam (msg, param, startPos);
	return;
}

