/*********************************************************************
	Management Application Module

	MAP Command Module

	File:		mapcom.c
	Created:	12/01/89

	SID:		1.1
	Last Modified:	4/22/91

	Copyright 1990,1991 XLNT Designs, Inc.

	This module is the MAP entry point for starting connection
	processing. The MAP system initialization is directed from here.
	This module has two primary routines. MAPMain() initializes the
	management process. ProcessMAP() controls the operation of the
	application.

	Modification History:
*********************************************************************/

#include        "ctype.h"
#include        "smtdefs.h"
#include        "smttypes.h"
#include        "smtmsg.h"
#include        "fddihdr.h"
#include        "fbmframe.h"
#include        "smtmacro.h"
#include        "fbmmacro.h"
#include        "mibdefs.h"
#include	"maphdr.h"
#include	"mapglbl.h"

extern  uInt32 RemoteSetCount;
extern	WINDOW	*inputwin;
extern	WINDOW	*WindowGet ();
extern	int	WindowVisible ();
extern	PTVF_t	WindowUpdate ();
extern	void	WorkLoop ();
extern	void	DoSMTWindow ();
extern	void	DoMACStatWindow ();
extern	void	DisplayMIBAttr ();
extern	void	SendMAPMessage ();

extern	uInt32	MAPGetMIBAttr ();
extern	uInt32	MAPChangeMIBAttr ();

#if 0
void	SendMAPMessage (msg)
SMTMessage *msg;
{
   switch (msg->destination) 
   {
      case MIB_MSG_ID:
         ProcessMIBMessage (msg);         /* Call directly without allocate
                                             extra memory and copy the data 
					   */
             break;

      case CSP_MSG_ID:
	 ReceiveCSPMessage (msg);         /* Call directly without allocate
                                             extra memory and copy the data
                                           */
             break;

      case FBM_MSG_ID:
	 ProcessFBMMessage (msg);         /* Call directly without allocate
                                             extra memory and copy the data
                                           */
	       break;
   }


   return;
   
	 
}

uInt32	MAPGetMIBAttr (bufSize, bufData, setCount)
        uInt16          bufSize;
        uChar           *bufData;
        TLVSetCountType *setCount;
{
   return GetMIBAttr(bufSize, bufData, setCount);
}

uInt32	MAPChangeMIBAttr  (bufSize, bufData, setCount, stationID)
        uInt16                  bufSize;
        uChar                   *bufData;
        TLVSetCountType         *setCount;
        SMTStationIdType        *stationID;
{
   return ChangeMIBAttr(bufSize, bufData, setCount, stationID);
}

#endif

uInt16 macTotal = 2;
uInt16 phyTotal = 6;
uInt16 masterTotal = 4;
uInt32 MACnumSent;
char	mapinstr[255];
uInt16  MAP_ActiveMACID;
SendFrameBuf	frameBuf;

/*********************************************************************
	Menu Command Support Routines
*********************************************************************/

uInt32
GetHexData (p)
char *p;
{
int     count = 0;
char    *ptmp, val;

        wgetstr (inputwin, mapinstr);

	ptmp = mapinstr;

	while (*ptmp)
	{
		if (isxdigit (*ptmp))
		{
			/* check first character */
			val = (*ptmp < 'A')
				? *ptmp - '0' : toupper (*ptmp) - 'A' + 10;
			ptmp++;

			if (isxdigit (*ptmp))
			{
				/* check second character */
				val *= 16;
				val += (*ptmp < 'A')
					? *ptmp - '0' 
					: toupper (*ptmp) - 'A' + 10;
			}
			else
				ptmp--;

			p[count++] = val;
		}
		ptmp++;
	}

        return (count);
}

void
GetAddress (a)
        MACAddr48       *a;
{
static  MACAddr48       defaultAddr;

        wprintw (inputwin, "Enter address ");
        MCopyAddress(a, &defaultAddr);
        AskNid("", a);
        MCopyAddress (&defaultAddr, a);
        return;
}

uInt32
DoMIBSet (len, param, setCount)
	uInt16		len;
	uChar		*param;
	TLVSetCountType	*setCount;
/*********************************************************************
Function:	Change a MIB attribute through the use of the MIB Change
		operation.
Parameters:	len		= length of parameter buffer.
		param		= parameter buffer.
		setCount	= buffer for current set count value.
Input:		None.
Output:		None.
Return:		Result of change operation.
*********************************************************************/
{
TLVParamType	mibData;

	/* clear buffer */
	MEMZERO (&mibData, sizeof (mibData));

	/* get set count */
	mibData.paramType = fddiSMTSetCount;
	mibData.paramLen = 4;
	MAPGetMIBAttr (sizeof (mibData), &mibData, setCount);

	return (MAPChangeMIBAttr (len, param, setCount));
}


/*********************************************************************
	Menu Command MIB Menu
*********************************************************************/

void
DoGetMIB ()
{
extern	MIBBufferType	mibAttr;
TLVParamType	*mibPtr;
uInt32		result, entity;

        MEMZERO((uChar*) mibAttr, sizeof(MIBBufferType));
	mibPtr = (TLVParamType *) mibAttr;

	wprintw (inputwin, "Enter MIB attribute ID (in hex): ");
	wscanw (inputwin, "%x", &mibPtr->paramType);
	if (mibPtr->paramType >= fddiMAC)
	{
		wprintw (inputwin, "Enter entity value    : ");
		wscanw (inputwin, "%d", &entity);
		mibPtr->MACINDEX = entity;
/*		mibPtr->MACINDEX = 
		  ((mibPtr->paramType == fddiPORT) ||
		   (mibPtr->paramType == fddiATTACHMENT))
		    ? mibPortNUm[entity-1] : entity;
*/
		mibPtr->paramLen = 4;
	}
	else
		mibPtr->paramLen = 0;

	result = MAPGetMIBAttr (sizeof (MIBBufferType),
		(uChar *) mibPtr, (SetCountType *) NULL);

	if (result != RC_SUCCESS)
		wprintw (inputwin, "GET FAILED for attribute 0x%04x - %02x",
			mibPtr->paramType, result);

	else
		DisplayMIBAttr (mibPtr, TRUE);

	wprintw (inputwin, "\n");

	return;
}

void
DoGetRemote ()
{
extern	void	MakeFrameMessage ();

	wprintw (inputwin, "Get Remote MIB Attribute\n");
	GetAddress (&frameBuf.frameData.pmf.destAddr);
        frameBuf.frameData.pmf.sourceMAC
	  = QueryUnsigned ("Enter the MAC number to send the frame",
			    frameBuf.frameData.pmf.sourceMAC, 0, 1);
        frameBuf.frameData.pmf.attribute.paramType = 
	  QueryUnsignedHex ("Enter MIB attribute ID (in hex): ",
			    ntohs(frameBuf.frameData.pmf.attribute.paramType),
			    0, 0x060ff);
	if ((frameBuf.frameData.pmf.attribute.paramType & MIB_OBJECT_MASK)
		!= fddiSMT)
	{
	        if (ntohs(frameBuf.frameData.pmf.attribute.MACINDEX) > 1)
		    frameBuf.frameData.pmf.attribute.MACINDEX = 0;
		frameBuf.frameData.pmf.attribute.MACINDEX =
		  QueryUnsigned("Enter entity value (in hex)    : ",
				ntohs(frameBuf.frameData.pmf.attribute.MACINDEX),
				1, 2);
		frameBuf.frameData.pmf.attribute.paramLen = 4;
	}
	else
		frameBuf.frameData.pmf.attribute.paramLen = 0;

	frameBuf.frameData.pmf.FC = SMT_INFO_FC;
	frameBuf.frameClass = PMFGET_CLASS;
	frameBuf.frameType = SMTREQUEST;
	MakeFrameMessage (&frameBuf, 0, NULL);

	return;
}

void
DoSetRemote ()
{
extern	void	MakeFrameMessage ();

	wprintw (inputwin, "Change Remote MIB Attribute\n");
	GetAddress (&frameBuf.frameData.pmf.destAddr);
        frameBuf.frameData.pmf.sourceMAC
	  = QueryUnsigned ("Enter the MAC number to send the frame",
			   frameBuf.frameData.pmf.sourceMAC, 0, 1);
        wprintw (inputwin, "Enter MIB attribute ID (in hex): ");
        frameBuf.frameData.pmf.attribute.paramType = 
	  QueryUnsignedHex ("Enter MIB attribute ID (in hex): ",
			    ntohs(frameBuf.frameData.pmf.attribute.paramType),
			    0, 0x060ff);
	if ((frameBuf.frameData.pmf.attribute.paramType & MIB_OBJECT_MASK)
		!= fddiSMT)
	{
	        if (ntohs(frameBuf.frameData.pmf.attribute.MACINDEX) > 1)
		    frameBuf.frameData.pmf.attribute.MACINDEX = 0;
		frameBuf.frameData.pmf.attribute.MACINDEX =
		  QueryUnsignedHex
		    ("Enter entity value (in hex)    : ",
		     ntohs(frameBuf.frameData.pmf.attribute.MACINDEX),
		     1, 2);

		wprintw (inputwin, "Enter new attribute value (hex digits): ");
		frameBuf.frameData.pmf.attribute.paramLen =
			GetHexData (&frameBuf.frameData.pmf.attribute.MACOTHER);
	}
	else
	{
		wprintw (inputwin, "Enter new attribute value (hex digits): ");
		frameBuf.frameData.pmf.attribute.paramLen =
			GetHexData (&frameBuf.frameData.pmf.attribute.SMTOTHER);
	}

        frameBuf.frameData.pmf.setCount.paramValue.count 
	  = RemoteSetCount;
	frameBuf.frameData.pmf.setCount.paramType = fddiSMTSetCount;
	frameBuf.frameData.pmf.setCount.paramLen = 12;

	frameBuf.frameData.pmf.FC = SMT_INFO_FC;
	frameBuf.frameClass = PMFCHANGE_CLASS;
	frameBuf.frameType = SMTREQUEST;
	MakeFrameMessage (&frameBuf, 0, NULL);

	return;
}


/*********************************************************************
	Menu Command Frame Menu
*********************************************************************/

void
MakeFrameMessage (bufptr, l, data)
	SendFrameBuf	*bufptr;
	uInt16		l;
	uChar		*data;
/*********************************************************************
Function:	Create a send frame message and send it.
Parameters:	bufptr	= send frame buffer structure.
		l	= length of additional data.
		data	= address of additional data.
Input:		None.
Output:		None.
Return:		None.
*********************************************************************/
{
#if 0
SMTMessage	*fmsg;
uInt16		size;

	size = l + sizeof (SMTMessage) + sizeof (SendFrameBuf);
	fmsg = (SMTMessage *) GETMEMORY (size);
	if (fmsg == NULL)
	{
		wprintw (inputwin, "Cannot allocate buffer.\n");
		return;
	}
#else

SMTMessage	fmsg;

#endif
	fmsg.destination = FBM_MSG_ID;
	fmsg.source = MAP_MSG_ID;
	fmsg.type = FBM_ACTION_SEND_FRAME;
	fmsg.typeInfo = 0;
	fmsg.p1.sendFrameBuf = bufptr;
	fmsg.len1 = sizeof (SendFrameBuf);
	fmsg.len2 = l;

	if (l)
		fmsg.p2 = data;

	SendMAPMessage (&fmsg);
#if 0
	FREEMEMORY (fmsg);
#endif

	return;
}

void BuildSIFSend ( MACnum, frameClass, frameType, frameControl, 
	       DestMACAddr)
uInt16    MACnum;
uChar     frameClass;
uChar     frameType;
uChar     frameControl;
MACAddr48 *DestMACAddr;
{
    SendFrameBuf	buf;

	buf.frameData.sif.sourceMAC = MACnum;
	buf.frameData.sif.FC = frameControl;
	buf.frameClass = frameClass;
	buf.frameType = frameType;
	MCopyAddress (buf.frameData.sif.destAddr, *DestMACAddr);
	MakeFrameMessage (&buf, 0, NULL);
}

void DoNIFSend ()
{
   SendFrameBuf	buf;
   uInt16 frameType;
	wprintw (inputwin, "Send NIF Frame\n");

	wprintw (inputwin, "(A)nnounce or (R)equest: ");
	wgetstr (inputwin, mapinstr);

	if (*mapinstr == 'a')
		frameType = SMTANNOUNCE;
	else
		frameType = SMTREQUEST;

	GetAddress (&buf.frameData.nif.destAddr);
        buf.frameClass = NIF_CLASS;
        buf.frameType  = frameType;
        buf.frameData.nif.sourceMAC = MAP_ActiveMACID;
        buf.frameData.nif.FC = SMT_INFO_FC;
        buf.frameData.nif.transID = 0;
        MakeFrameMessage (&buf, 0, NULL);
	return;
}

void DoSIFConSend ()
{
   MACAddr48 DestAddr;

	wprintw (inputwin, "Send SIF Config Frame\n");
	GetAddress (&DestAddr);
        BuildSIFSend (MAP_ActiveMACID, SIFCONFIG_CLASS, SMTREQUEST, SMT_INFO_FC, &DestAddr);
	return;
}

void DoSIFOpSend ()
{
   MACAddr48 DestAddr;

	wprintw (inputwin, "Send SIF Operation Frame\n");
	GetAddress (&DestAddr);
        BuildSIFSend (MAP_ActiveMACID, SIFOP_CLASS, SMTREQUEST, SMT_INFO_FC, &DestAddr);
	return;
}

void DoEchoSend ()
{
SendFrameBuf	buf;

	wprintw (inputwin, "Send Echo Request Frame\n");
	GetAddress (&buf.frameData.ecf.destAddr);
	wprintw (inputwin, "Enter Echo data: ");
	wgetstr (inputwin, mapinstr);
	buf.frameData.ecf.sourceMAC = MAP_ActiveMACID;
	buf.frameData.ecf.FC = SMT_INFO_FC;
	buf.frameClass = ECHO_CLASS;
	buf.frameType = SMTREQUEST;
	MakeFrameMessage (&buf, strlen (mapinstr), mapinstr);

	return;
}

void DoRAFSend ()
{
	wprintw (inputwin, "RAF NOT SUPPORTED\n");

	return;
}

void DoRDFSend ()
{

	wprintw (inputwin, "RDF NOT SUPPORTED.\n");

	return;
}

void DoESFSend ()
{
SendFrameBuf	buf;
MACAddr48	esfID;

	wprintw (inputwin, "Send Extended Service Frame\n");
	wprintw (inputwin, "Enter ESF identifier (in HEX): ");
	GetHexData (&esfID);
	wprintw (inputwin, "Enter info field data (in ASCII): ");
	wgetstr (inputwin, mapinstr);
	GetAddress (&buf.frameData.esf.destAddr);
	buf.frameData.esf.sourceMAC = MAP_ActiveMACID;
	buf.frameData.esf.FC = SMT_INFO_FC;
	buf.frameClass = ESF_CLASS;
	buf.frameType = SMTREQUEST;
	MCopyAddress (buf.frameData.esf.esfID, esfID);
	MakeFrameMessage (&buf, strlen (mapinstr), mapinstr);

	return;
}

void
DoSendFrame ()
{

	wprintw (inputwin,
"Enter request type (nif, sifop, sifcon, echo, raf, rdf, esf): ");
	wgetstr (inputwin, mapinstr);

	if (strcmp (mapinstr, "nif") == 0)
		DoNIFSend ();

	else if (strcmp (mapinstr, "sifcon") == 0)
		DoSIFConSend ();

	else if (strcmp (mapinstr, "sifop") == 0)
		DoSIFOpSend ();

	else if (strcmp (mapinstr, "echo") == 0)
		DoEchoSend ();

	else if (strcmp (mapinstr, "raf") == 0)
		DoRAFSend ();

	else if (strcmp (mapinstr, "rdf") == 0)
		DoRDFSend ();

	else if (strcmp (mapinstr, "esf") == 0)
		DoESFSend ();

	return;
}

void
DoEventLogging ()
{
	eventLogging = !eventLogging;
	wprintw (inputwin, "Event logging is %s\n", 
		eventLogging ? "ON" : "OFF");
	return;
}


/*********************************************************************
	Window Control Menu Commands
*********************************************************************/

void
ViewSMTStatus ()
{
void	(*curproc)();
WINDOW	*win;

	win = WindowGet (SMT_WIN);
	werase (win);

	curproc = WindowUpdate (SMT_WIN, NULL);

	/* if it was off, then turn on, else leave off */
	if (curproc != DoSMTWindow)
	{
		WindowVisible (SMT_WIN, TRUE);
		WindowUpdate (SMT_WIN, DoSMTWindow);
	}

	return;
}

void
ViewMACStats ()
{
WINDOW	*win;
void	(*curproc)();

	win = WindowGet (MAC_STAT_WIN);
	werase (win);

	curproc = WindowUpdate (MAC_STAT_WIN, NULL);

	/* if it was off, then turn on, else leave off */
	if (curproc != DoMACStatWindow)
	{
		WindowVisible (MAC_STAT_WIN, TRUE);
		WindowUpdate (MAC_STAT_WIN, DoMACStatWindow);

		mvwprintw (win, 0, 0, "Primary MAC");
		mvwprintw (win, 1, 0, "UNA:xxxx xxxx xxxx  DNA:xxxx xxxx xxxx");

		mvwprintw (win, 3, 0, "Counters Grp         Error Ctrs Grp");
		mvwprintw (win, 4, 0, "Frame    ##########  Error  ##########");
		mvwprintw (win, 5, 0, "Copied   ##########  Lost   ##########");
		mvwprintw (win, 6, 0, "Transmit ##########  TVXExp ##########");
		mvwprintw (win, 7, 0, "Token    ##########  NotCop ##########");
		mvwprintw (win, 8, 21, "Late   ##########");
		mvwprintw (win, 9, 21, "RingOp ##########");

		if (mapInfo.SMTStationConfigGrp.MAC_Ct > 1)
		{
			mvwprintw (win, 0, 40, "Secondary MAC");
			mvwprintw (win, 1, 40, 
				"UNA:xxxx xxxx xxxx  DNA:xxxx xxxx xxxx");

			mvwprintw (win, 3, 40, 
				"Counters Grp         Error Ctrs Grp");
			mvwprintw (win, 4, 40, 
				"Frame    ##########  Error  ##########");
			mvwprintw (win, 5, 40, 
				"Copied   ##########  Lost   ##########");
			mvwprintw (win, 6, 40, 
				"Transmit ##########  TVXExp ##########");
			mvwprintw (win, 7, 40, 
				"Token    ##########  NotCop ##########");
			mvwprintw (win, 8, 61, "Late   ##########");
			mvwprintw (win, 9, 61, "RingOp ##########");
		}
	}

	return;
}

