/*********************************************************************
	Management Application Module

	MAP Local Processing Module

	File:		localmap.c
	Created:	12/01/89

	SID:		1.1
	Last Modified:	4/22/91

	Copyright 1990,1991 XLNT Designs, Inc.

	This module contains functions relevant to a particular
	implementation. The implementor may provide any additional
	support and functionality required for the product. Those
	areas in the CMT system that have specific local action
	references call functions located in this file.

	Modification History:
*********************************************************************/

#include        "fddi.h"
#include        "smttypes.h"
#include        "smtmsg.h"
#include        "smtmacro.h"
#include        "mibdefs.h"
#include	"maphdr.h"
#include	"mapglbl.h"
#include        "fdrmonty.h"
#include        "fdrextrn.h"

/*********************************************************************
	External Function Declarations
*********************************************************************/

extern	void	InstallWaitProc ();
extern	Flag	EmptyFBMQueue ();
extern	void	FBMInterruptHandler ();
extern	uInt32	MAPGetMIBAttr ();
extern	uInt32	ReceiveMAPMessage ();
extern 	void	ProcessMAPMessage ();
extern	void	FreeMAPMessage ();
extern	void	DrawScreen ();


/*********************************************************************
	Local Processing Functions
*********************************************************************/

TLVParamType *
FindGroupAttr (base, attrID)
	TLVParamType	*base;
	uInt16		attrID;
/*********************************************************************
Function:	Get a specific attribute from within a MIB attribute
		group.
Parameters:	base	= pointer to start of MIB attribute group.
		index	= MIB attribute ID to get
Input:		None.
Output:		None.
Return:		Pointer to parameter type of requested parameter.
		NULL if not found.
Notes:		List of attributes must end with a 0 parameter type.
Modification History:
*********************************************************************/
{
	while (base->paramType != 0)
	{
		if (base->paramType == attrID)
			return (base);
		base = (TLVParamType *) (((uChar *) base) +
			base->paramLen + 4);
	}

	return (NULL);
}


void
ReadData ()
{
uInt16	i, numPhys;
TLVParamType	mibData;

	mibData.paramType = fddiSMTECMState;
	mibData.paramLen = 0;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.SMTStatusGrp.ECMState = mibData.SMTPARAM8;

	mibData.paramType = fddiSMTCF_State;
	mibData.paramLen = 0;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.SMTStatusGrp.CF_State = mibData.SMTPARAM8;

	mibData.paramType = fddiMACUpstreamNbr;
	mibData.paramLen = 4;
	mibData.MACINDEX = 1;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	MCopyAddress (mapInfo.MACConfigGrp[0].UpstreamNbr, mibData.MACADDR);

	mibData.paramType = fddiMACDownstreamNbr;
	mibData.paramLen = 4;
	mibData.MACINDEX = 1;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	MCopyAddress (mapInfo.MACConfigGrp[0].DownstreamNbr, mibData.MACADDR);

	mibData.paramType = fddiMACRMTState;
	mibData.paramLen = 4;
	mibData.MACINDEX = 1;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.MACStatusGrp[0].RMTState = mibData.MACPARAM8;

    numPhys = mapInfo.SMTStationConfigGrp.NonMaster_Ct
	+ mapInfo.SMTStationConfigGrp.Master_Ct;
    for (i = 0; i < numPhys; i++)
    {
	mibData.paramType = fddiPORTPC_Neighbor;
	mibData.paramLen = 4;
	mibData.PORTINDEX = i + 1;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.PORTConfigGrp[i].PC_Neighbor = mibData.PORTPARAM8;

	mibData.paramType = fddiPORTRemoteMACIndicated;
	mibData.paramLen = 4;
	mibData.PORTINDEX = i + 1;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.PORTConfigGrp[i].RemoteMACIndicated = mibData.PORTPARAM8;

	mibData.paramType = fddiPORTPCMState;
	mibData.paramLen = 4;
	mibData.PORTINDEX = i + 1;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.PORTStatusGrp[i].PCMState = mibData.PORTPARAM8;

	mibData.paramType = fddiPORTLer_Estimate;
	mibData.paramLen = 4;
	mibData.PORTINDEX = i + 1;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.PORTLerGrp[i].Ler_Estimate = mibData.PORTPARAM8;

	mibData.paramType = fddiPORTLCTFail_Ct;
	mibData.paramLen = 4;
	mibData.PORTINDEX = i + 1;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.PORTErrorCtrsGrp[i].LCTFail_Ct = mibData.PORTPARAM32;

	mibData.paramType = fddiPORTCE_State;
	mibData.paramLen = 4;
	mibData.PORTINDEX = i + 1;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.PORTConfigGrp[i].CE_State = mibData.PORTPARAM8;

	mibData.paramType = fddiPORTPC_Type;
	mibData.paramLen = 4;
	mibData.PORTINDEX = i + 1;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.PORTConfigGrp[i].PC_Type = mibData.PORTPARAM8;

    }

	return;
}

void
InitMIBInfo ()
{
int	i;
TLVParamType	mibData;

	mibData.paramType = fddiSMTStationId;
        mibData.paramLen = 0;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	MEMCOPY ((uChar *) &mapInfo.SMTStationIdGrp.StationId,
		(uChar *) &mibData.SMTOTHER, sizeof (SMTStationIdType));

	mibData.paramType = fddiSMTMAC_Ct;
        mibData.paramLen = 0;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.SMTStationConfigGrp.MAC_Ct = mibData.SMTPARAM8;

	mibData.paramType = fddiSMTNonMaster_Ct;
        mibData.paramLen = 0;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.SMTStationConfigGrp.NonMaster_Ct = mibData.SMTPARAM8;

	mibData.paramType = fddiSMTMaster_Ct;
        mibData.paramLen = 0;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
	mapInfo.SMTStationConfigGrp.Master_Ct = mibData.SMTPARAM8;

	for (i = 0;
		i < mapInfo.SMTStationConfigGrp.MAC_Ct;
		i++)
	{
		mibData.paramType = fddiMACSMTAddress;
		mibData.paramLen = 4;
		mibData.MACINDEX = i + 1;
		MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
		MCopyAddress (mapInfo.MACAddressGrp[i].SMTAddress,
			mibData.MACADDR);

		mibData.paramType = fddiMACPathsAvailable;
		mibData.paramLen = 4;
		mibData.MACINDEX = i + 1;
		MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
		mapInfo.MACConfigGrp[i].PathsAvailable = mibData.MACPARAM8;

		mibData.paramType = fddiMACFrameStatusCapabilities;
		mibData.paramLen = 4;
		mibData.MACINDEX = i + 1;
		MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
		mapInfo.MACCapabilitiesGrp[i].FrameStatusCapabilities 
			= mibData.MACPARAM16;

		mibData.paramType = fddiMACT_Max;
		mibData.paramLen = 4;
		mibData.MACINDEX = i + 1;
		MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
		mapInfo.MACOperationGrp[i].T_Max = mibData.MACPARAM32;
	}

	for (i = 0;
		i < mapInfo.SMTStationConfigGrp.NonMaster_Ct
			+ mapInfo.SMTStationConfigGrp.Master_Ct;
		i++)
	{
		mibData.paramType = fddiPORTPC_Type;
		mibData.paramLen = 4;
		mibData.PORTINDEX = i + 1;
		MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
		mapInfo.PORTConfigGrp[i].PC_Type = mibData.PORTPARAM8;

		mibData.paramType = fddiPORTAvailablePaths;
		mibData.paramLen = 4;
		mibData.PORTINDEX = i + 1;
		MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);
		mapInfo.PORTConfigGrp[i].AvailablePaths = mibData.PORTPARAM8;
	}

        ReadData ();
	return;
}

uInt32
LocalMAPMessage (smtmsg)
	SMTMessage	*smtmsg;
/*********************************************************************
Function:	Provide local SMT message processing.
Parameters:	smtmsg	= addres of message buffer.
Input:		smtmsg	= contains message to process.
Output:		Implementor defined.
Return:		0 if processing is successful, otherwise an error code
		is returned.
*********************************************************************/
{
	return (0);
}

uInt32
InitMAPLocal ()
/*********************************************************************
Function:	Provide local SMT message processing.
Parameters:	None.
Input:		
Output:		Implementor defined.
Return:		0 if processing is successful, otherwise an error code
		is returned.
*********************************************************************/
{
extern	void	WorkLoop ();
extern  uInt16  MAP_ActiveMACID;

	InstallWaitProc (WorkLoop);
        MAP_ActiveMACID = 0;
        fddiHost_control_tbl[0].RingOrderChanged =
        fddiHost_control_tbl[0].RingOrderChanged =
        fddiHost_control_tbl[0].PortChanged = 
        fddiHost_control_tbl[0].PortChanged = FALSE;

	return (0);
}

void
UpdateMAP ()
{
SMTMessage 	*msgp;
static int	doingUpdate = FALSE;

	if (doingUpdate)
		return;

	doingUpdate = TRUE;

	while (ReceiveMAPMessage (&msgp) == 0)
	{
		ProcessMAPMessage (msgp);
		FreeMAPMessage (msgp);
		ReadData ();
		DrawScreen ();
	}

	ReadData ();
	DrawScreen ();

	doingUpdate = FALSE;

	return;
}

void
WorkLoop ()
{
	if (!EmptyFBMQueue ())
		FBMInterruptHandler ();

	UpdateMAP ();

	return;
}

#ifdef __FEBRIDGE
GetFddiCFState()
{
	TLVParamType	mibData;

	mibData.paramType = fddiSMTCF_State;
	mibData.paramLen = 0;
	MAPGetMIBAttr (sizeof (mibData), (uChar *) &mibData, NULL);

	return mibData.SMTPARAM8;
}
#endif
