/*************************************************************
 *   $Log:   /usr/shasta/pvcs/fddicon/include/nvrfddi.h_v  
 * 
 *    Rev 1.8   20 Apr 1993 11:31:30   shekhar
 * Add a ui_defaults data structure in the fddi record
 * 
 *    Rev 1.7   20 Apr 1993 11:29:52   shekhar
 * 
 *    Rev 1.6   13 Apr 1993 13:39:10   jang
 * added one more record to store the port connect state
 * 
 *    Rev 1.5   09 Apr 1993 14:51:36   jang
 * changed all the nvram record marker
 * 
 *    Rev 1.4   19 Feb 1993 16:16:32   shekhar
 * added alarm and events structures to store these entries in NVRAM.
 * 
 *    Rev 1.3   16 Feb 1993 11:13:24   jang
 * modified NVR_PORT_LOCK
 ************************************************************/



#ifndef __NVRFDDI_H
#define __NVRFDDI_H

#include <nvrecs.h>
#include <smtdefs.h>
#include <fddihdr.h>
#include <smttypes.h>
#include <mibdefs.h>
#include <mibconf.h>
#include <trigger.h>
#include <fddi.h>
#include <monp.h>
#include <defalarm.h>

/****************************************************\
   FDDI NVRAM MACROs to access the NVRAM_FDDI record 
\****************************************************/
#define NVR_FDDI_SMT             FddiRec->SMTInfo
#define NVR_FDDI_MAC             FddiRec->MACInfo
#define NVR_FDDI_PATH            FddiRec->PATHInfo
#define NVR_FDDI_PORT            FddiRec->PORTInfo
#define NVR_FDDI_ATTACHMENT      FddiRec->ATTACHMENTInfo

/**************************************************/
#define SMT_CONNECTION_POLICY	( Policy_rejectA_A | Policy_rejectA_S\
				| Policy_rejectB_B | Policy_rejectB_S\
				| Policy_rejectS_A | Policy_rejectS_B\
				| Policy_rejectS_S | Policy_rejectM_M )

/**************************************************\
     FDDI Concentrator NVRAM Records 
\**************************************************/
   typedef struct NVR_FDDI
   {
      int  nvr_fddi_marker;

      struct fddi_smt
      {
         SMTStationIdType stationID;
	 u_short opVersionID;
	 u_short hiVersionID;
	 SMTManufacturerDataType manufacturerData;
	 SMTUserDataType userData;
	 u_short configPolicy;
	 u_short connectionPolicy;
	 int     reportLimit;
	 u_short T_Notify;
	 char    xdiBothWrapPolicy;
	 byte    pad;
      }  SMTInfo;

      struct fddi_mac
      {
	 int     T_MaxGreatestLowerBound;
	 int     TVXGreatestLowerBound;
	 byte    pathRequested;
	 MACAddr48 SMTAddress;
	 int     T_Req;
	 int     T_Max;
	 int     TVXValue;
	 int     T_Min;
	 int     T_Pri[NO_OF_TPRI];
	 u_short FrameErrorThreshold;
	 u_short NotCopiedThreshold;
	 u_short frameStatus;
	 byte    xdiRMTDupPolicy1;
	 byte    xdiRMTDupPolicy2;
	 byte    xdiOperational;
	 byte    pad;
      }  MACInfo[MAX_MAC_RESERVED];

      struct fddi_path
      {
	 int     TVXLowerBound;
	 int     T_MAXLowerBound;
	 int     T_Rmode;
	 int     Trace_MaxExpiration;
      }  PATHInfo[MAX_PATH_RESERVED];

      struct fddi_port
      {
	 byte    PC_Type;
	 byte    connectionPolicies;
	 byte    pathRequested;
	 byte    xdiOperational;
         int     port_state;  /* can be chagned to byte if more fields to be added */
	 int     MACLoop_Time;
	 u_short LER_Cutoff;
	 u_short LER_Alarm;
	 int     TB_Max;
      }  PORTInfo[MAX_PORT_RESERVED];

      struct fddi_attachment
      {
	 byte    opticalBypassPresent;
	 byte    pad;
      } ATTACHMENTInfo[MAX_ATTACH_RESERVED];

      struct ui_defaults
      {
	     byte Port1_PC_Type;
	     byte Port6_PC_Type;
      } UI_Defaults;
      
      char       reserve[2046];
      ushort     nvr_fddi_checksum;

   } NVR_FDDI;


typedef struct _nvr_port_lock_ {
  int nvr_port_lock_marker;
  PORT_INFO port_lock[FDDI_MASTER_PORTS];
  PORT_INFO res_plock[4];
  int  res[512];
  ushort nvr_checksum;
} NVR_PORT_LOCK;

 
typedef struct
    {
    int                 nvr_alarm_marker;
    uint                alarmEntries;
    NVR_ALARM_ENTRY     nvr_al_tbl[MAX_AL_SUPPORTED];
    NVR_ALARM_ENTRY     res_block[20];
    ushort              nvr_alarm_checksum;
    } NVR_ALARM;
 
typedef struct
    {
    int                 nvr_event_marker;
    uint                eventEntries;
    NVR_EVENT_ENTRY     nvr_ev_tbl[MAX_EV_SUPPORTED];
    NVR_EVENT_ENTRY     res_block[20];
    ushort              nvr_event_checksum;
    } NVR_EVENT;
 
typedef struct _port_init_record {  /* port initializeation state */
  int nvr_port_init_marker;
  int port_state[FDDI_MASTER_PORTS];
  int res_port_state[20];
  ushort  nvr_port_init_checksum;
} NVR_PORT_INIT;
extern  NVR_PORT_INIT nvr_port_init;

extern  NVR_FDDI nvr_fddi_rec;

#define NVR_TRIG_ADDR   (NVR_BOOT_ADDR + NVR_BOOT_SIZE)
#define NVR_TRIG_SIZE   ALIGN(TRIGGER_SIZE, 2)
#define NVR_TRIG_MARKER   0x54524947

#define NVR_FDDI_MARKER   0x46444449
#define NVR_FDDI_ADDR   (NVR_TRIG_ADDR + NVR_TRIG_SIZE)
#define NVR_FDDI_SIZE   ALIGN(sizeof(NVR_FDDI), 2)

/* define for port locking */
#define NVR_PORT_LOCK_MARKER  0x4c4f434b
#define NVR_PORT_LOCK_ADDR    (NVR_FDDI_ADDR + NVR_FDDI_SIZE)
#define NVR_PORT_LOCK_SIZE    ALIGN(sizeof(NVR_PORT_LOCK), 2)

/* defines for alarms */
#define NVR_ALARM_MARKER    0x414c524d
#define NVR_ALARM_ADDR      (NVR_PORT_LOCK_ADDR + NVR_PORT_LOCK_SIZE)
#define NVR_ALARM_SIZE      ALIGN(sizeof(NVR_ALARM), 2)

/* defines for events */ 
#define NVR_EVENT_MARKER    0x45564e53
#define NVR_EVENT_ADDR      (NVR_ALARM_ADDR + NVR_ALARM_SIZE)
#define NVR_EVENT_SIZE      ALIGN(sizeof(NVR_EVENT), 2)
 
#define NVR_PORT_INIT_MARKER 0x494e4954
#define NVR_PORT_INIT_SIZE  ALIGN(sizeof(NVR_PORT_INIT), 2)
#define NVR_PORT_INIT_ADDR  (NVR_EVENT_ADDR + NVR_EVENT_SIZE)


#endif /* __NVRFDDI_H */
