#ifndef __EDFDDINVR_H
#define __EDFDDINVR_H
#include "fddi.h"
#include "fddihdr.h"
#include "mibconf.h"

#define MAX(a,b)     (((a) > (b))? (a) : (b))
#define MIN(a,b)     (((a) < (b))? (a) : (b))

/*   Timer calculation's cofficients */
#define M_MAX       1000           /* Maximum Number of MAC entities */
#define F_MAX       (uTime) 361    /* Maximum Frame 
				      (9000 Symbols) Time */
#define TOKEN_TIME  (uTime) 1      /* 22 Symbols for Token Length */
#define CLAIM_FR    (uTime) (256/100) /* Claim Frame Length */
#define S_MIN       (uTime) 365    /* Minimum Safty Timing Allowance */
#define A_MAX       (uTime) 1000   /* Maximum Signal Acquisition */
#define T_RESP      (uTime) ((3*D_Max) + (2*M_MAX*CLAIM_FR) \
			       + S_MIN)
#define T_REACT(tvx) (uTime) (I_Max_Default + D_Max + A_MAX + tvx)

/* LER */
#define LER_MIN                    4
#define LER_MAX                    15

/* Timer timeout defaults */
#define T_NOTIFY_MIN               2                /* 2 seconds */
#define T_NOTIFY_MAX               30               /* 30 seconds */
#define T_MAX_MIN(tvx)             (uTime) (2*T_REACT(tvx) + 6*T_RESP)
#define T_MAX_MAX                  (uTime) 1342177  /* 1.342177 Seconds */
#define T_REQ_MAX(tvx)             (uTime) T_MAX_MIN(tvx)
#define T_MIN_MAX                  (uTime) 4000     /* 4 ms */
#define TVX_MIN                    (uTime) (MAX(D_Max,F_MAX) + TOKEN_TIME + F_MAX + S_MIN)
#define TVX_MAX                    (uTime) 1342177  /* 1.342177 Seconds */
#define T_NEXT9_MIN                (uTime) 200000   /* 200 ms */
#define TRACE_MAX_MIN              Min_Trace_Max
#define TB_MAX_MIN                 30000

/* ID Tags */
#define BOOT_DISPLAY               "D"
#define BOOT_EDIT                  "E"
#define BOOT_MASK                  0x0ff
#define BOOT_TYPE_MASK             0x0f00
#define BOOT_FDDI_SMT              0x100
#define BOOT_FDDI_MAC              0x200
#define BOOT_FDDI_PATH             0x300
#define BOOT_FDDI_PORT             0x400
#define BOOT_FDDI_ATTACH           0x500

#define BOOT_FDDI_MANUOUI          (BOOT_FDDI_SMT | 2)
#define BOOT_FDDI_MANUDATA         (BOOT_FDDI_SMT | 3)
#define BOOT_FDDI_USERINFO         (BOOT_FDDI_SMT | 4)
#define BOOT_FDDI_CONFPOLICY       (BOOT_FDDI_SMT | 5)
#define BOOT_FDDI_CONNPOLICY       (BOOT_FDDI_SMT | 6)
#define BOOT_FDDI_REPORTLIMIT      (BOOT_FDDI_SMT | 7)
#define BOOT_FDDI_T_NOTIFY         (BOOT_FDDI_SMT | 8)
#define BOOT_FDDI_MAXNUM           7

#define BOOT_MAC_T_MAX_GLBOUND     (BOOT_FDDI_MAC | 2)
#define BOOT_MAC_TVX_GLBOUND       (BOOT_FDDI_MAC | 3)
#define BOOT_MAC_PATHREQ           (BOOT_FDDI_MAC | 4)
#define BOOT_MAC_ADDRESS           (BOOT_FDDI_MAC | 5)
#define BOOT_MAC_T_REQ             (BOOT_FDDI_MAC | 6)
#define BOOT_MAC_T_MAX             (BOOT_FDDI_MAC | 7)
#define BOOT_MAC_TVX               (BOOT_FDDI_MAC | 8)
#define BOOT_MAC_T_MIN             (BOOT_FDDI_MAC | 9)
#define BOOT_MAC_FRFAME_STATUS     (BOOT_FDDI_MAC | 10)
#define BOOT_MAC_ADDRDUP1          (BOOT_FDDI_MAC | 11)
#define BOOT_MAC_ADDRDUP2          (BOOT_FDDI_MAC | 12)
#define BOOT_MAC_FERR_THRESHOLD    (BOOT_FDDI_MAC | 13)
#define BOOT_MAC_NOT_COPIED_THRESHOLD    (BOOT_FDDI_MAC | 14)
#define BOOT_MAC_MAXNUM            13

#define BOOT_PATH_TVX_LBOUND      (BOOT_FDDI_PATH | 2)
#define BOOT_PATH_T_MAX_LBOUND    (BOOT_FDDI_PATH | 3)
#define BOOT_PATH_TRACE_MAX       (BOOT_FDDI_PATH | 4)
#define BOOT_PATH_MAXNUM           3

#define BOOT_PORT_TYPE             (BOOT_FDDI_PORT | 2)
#define BOOT_PORT_CONNPOLICY       (BOOT_FDDI_PORT | 3)
#define BOOT_PORT_PATHREQ          (BOOT_FDDI_PORT | 4)
#define BOOT_PORT_T_NEXT9          (BOOT_FDDI_PORT | 5)
#define BOOT_PORT_LER_CUTOFF       (BOOT_FDDI_PORT | 6)
#define BOOT_PORT_LER_ALARM        (BOOT_FDDI_PORT | 7)
#define BOOT_PORT_TB_MAX           (BOOT_FDDI_PORT | 8)
#define BOOT_PORT_MAXNUM           7

#define BOOT_ATTACH_OPTBYPASS      (BOOT_FDDI_ATTACH | 2)
#define BOOT_ATTACH_MAXNUM         1

#define CT_POWER2               32
#define CT_SMTCONFIG_POLICY     4
#define CT_SMTCONFIG_CAPABILITY 4
#define CT_FRAME_STATUS         3
#define CT_CONNECTION_POLICY    16
#define CON_POLICY_COLUMN       4
#define CT_PATH                 4
#define CT_PATH_AVAIL           7
#define MAC_LONG_ADDRESS_LEN    6
#define CT_PORT_CONNPOLICY      3
#define CT_PORT_TYPE            4
#define CT_PORT_FOTX            4
#define CT_DUP_ADDR_POLICY      4
#define CT_BILOGIC              2
#define TEMP_BUF_SIZE           255

#endif /* __EDFDDINVR_H */
