/*****************************************************************
 *      Copyright (c) 1992 by Hughes LAN Systems
 *
 *      Program Name:   FDDI Concentrator application
 *
 *      Filename:       miscsmtmib.h
 *
 *
 *      Description: This file contains definitions of SMT mib objects
 *					 which are not accessible from the SMT API.
 *
 *	$Log:   /user/pvcs/fddicon/include/miscsmtmib.h_v  $
 * 
 *    Rev 1.4   12 Oct 1993 12:42:42   gregs
 * No change.
 * 
 *    Rev 1.3   15 Sep 1993 09:24:14   gregs
 * No change.
 * 
 *    Rev 1.2   02 Apr 1993 17:06:18   jlin
 * 
 *    Rev 1.1   02 Apr 1993 16:53:36   jlin
 * 
 *    Rev 1.0   01 Feb 1993 18:05:06   shekhar
 * Initial revision.
 * 
 *      Revision:
 *      1-000                   Jan-31-93      Shekhar Ambe. 
 *              - Original.
 *
 *******************************************************************
 */

#ifndef __MISCSMTMIB_H
#define __MISCSMTMIB_H

#include <fddi.h>

typedef struct 
	{
	  uint	PathTraceStarted;
	  uint	PathTraceTerminated;
	  uint	PathTracePropagated;
        } SMT_PRIVATE_MAC_OBJECTS;

typedef struct
        {
	  uint	LerConditionCts;
	  uint	UndesiredConnectionCts;
	  uint	EbErrorConditionCts;
	} SMT_PRIVATE_PORT_OBJECTS;

extern SMT_PRIVATE_MAC_OBJECTS SmtMibMacObjects[];
extern SMT_PRIVATE_PORT_OBJECTS SmtMibPortObjects[];

#endif



