/*****************************************************************
 *      Copyright (c) 1992 by Hughes LAN Systems
 *
 *      Program Name:   FDDI Concentrator application
 *
 *      Filename:       fdrextrn.h
 *
 *      Description: This file contains the external definitions
 *		     for RMON Module.
 *
 *  $Log:   /user/pvcs/fddicon/include/fdrextrn.h_v  $
 * 
 *    Rev 1.4   12 Oct 1993 12:42:36   gregs
 * No change.
 * 
 *    Rev 1.3   15 Sep 1993 09:24:00   gregs
 * No change.
 * 
 *    Rev 1.2   08 Jan 1993 16:20:48   jlin
 * Changed PSTATS table.
 * 
 *    Rev 1.1   18 Dec 1992 16:43:28   shekhar
 *
 *	Revision :
 *	1-000		12-14-92		Shekhar Ambe
 *		- Original
 *
 *******************************************************************
 */

#include <fdrmonty.h>

/* EXPORT */

extern FDDI_MLSTATS	fddi_mlstats_tbl[];/* only for MACS   */
extern FDDI_PSTATS	fddi_if_pstats_tbl[];/* for MAC */
extern FDDI_PSTATS	fddi_port_pstats_tbl[];/* for PORTS */
extern FDDI_SMT_STATS  	fddi_smt_stats_tbl[];/* only for MACS   */

/* FDDI Ring station Control Table; One entry per MAC 	*/
extern FDDI_RS_CONTROL_TBL fddi_rs_control_tbl[];

/* FDDI Host Control Table; One Entry per MAC		*/
extern FDDIHOST_CONTROL_TABLE fddiHost_control_tbl[];

/* FDDI Port Control Table; One entry per Port		*/
extern FDDIPORT_CONTROL_TABLE fddiPort_control_tbl[];

/* Allocate space for max number of host entries	*/
extern HOSTENTRY	fddihosts[CON_MAC_COUNT][MAX_HOST_COUNT];

/* Allocate space for max number of Stations		*/
extern FDDI_RS_ENTRY	fddi_RStations[CON_MAC_COUNT][MAX_HOST_COUNT];

