#
#   Make Dependences
#
DEP_FLAG= -Dr -S -Q
MAKEDEPENDENCY = TRUE           #used in global.mak
FLAGFILE1= change
FLAGFILE2= reentry
.include $(ROOT)/global.mak

%if %defined(LDLIBS)      #----------------------
LIBOBJ = $(ROOT)/fddicon/lib/$(LDLIBS)

${LDLIBS}: ${LIBOBJ}

${LIBOBJ}: $(CSOURCES:.c=.o)
	${LD} ${ARCH} -o $@ -r $(**:.s=.o)

%endif #-----------------------------------------

%if %defined(LRLIBS)      #----------------------
LIBOBJ = $(ROOT)/fddicon/lib/$(LRLIBS)

${LRLIBS}: ${LIBOBJ}

${LIBOBJ}: $(CSOURCES:.c=.o)
	${AR} ${ARFLAGS} $@ $(**:.s=.o)

%endif #-----------------------------------------

.PROLOG:
		@rm -f $(FLAGFILE1)

.ERROR:
		@rm -f $(FLAGFILE1)
		@rm -f $(FLAGFILE2)
		@echo 
		@exit 20

REALMAKE:
                @echo Learning file dependencies...
                @makedeps HDRDIR=$(ISMTHDR) HDRIFDIR=$(ISMTIFHDR) \
		ROOT=$(ROOT) GBASE=$(G960HDR)\
		-C$(ROOT)/fddicon/mkdeps.cfg $(DEP_FLAG) *.c *.s
	        @echo Chagned > $(FLAGFILE1)
		%if (!%exists($(FLAGFILE2)))
	           @echo Chagned > $(FLAGFILE2)
		   .noshell
                   :@make REV=$(REV)
		   .shell
 		   %foreach mkloop in 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47 48 49 50
		      @echo $(mkloop)
		      %if (%exists($(FLAGFILE1)))
		         .noshell
                         :@make REV=$(REV) 
		         .shell
		      %else
		         @rm -f $(FLAGFILE2)
		         @%abort
		      %endif
                   %endfor
#----------------> Increase the loop items
		   %exit 20
		%else
		   @%abort
		%endif


%if %exists(Makedepend) ############################

.include Makedepend

Makedepend:  makefile $(ROOT)/fddicon/mkdeps.cfg $(ROOT)/fddicon/fddi.mak $(CSOURCES) 

dummy:



%else ##############################################



Makedepend: makefile $(ROOT)/fddicon/mkdeps.cfg $(ROOT)/fddicon/fddi.mak $(CSOURCES) 

dummy:

%endif
#
# 
#

