/*************************************************************************
 *  File:      drv_mem.c
 *
 *  Description
 *      This file does the BSI buffer memory and DBD management. Memory
 *      allocation is initialized to several blocks:
 *
 *  Copyright (c) 1992, 1993 Hughes Lan Systems
 *
 *  Author:     Jiawei Jang
 *
 *  $Log:   /user/pvcs/fddicon/drv/src/drv_mem.c_v  
 * 
 *    Rev 1.35.1.6   12 Oct 1993 11:12:30   gregs
 * No change.
 * 
 *    Rev 1.35.1.5   29 Sep 1993 13:29:56   gregs
 * No change.
 * 
 *    Rev 1.35.1.4   21 Sep 1993 10:45:06   jang
 * integrated with concentrator code 
 * 
 *    Rev 1.35.1.2   30 Jul 1993 09:40:18   jang
 * fixed the bug that when psp desc is full, increase the pkt cnt
 * before free the buffer
 * 
 *    Rev 1.35.1.1   29 Jul 1993 12:31:48   jang
 * added a function MEM_GetPktHeader() so that the pktBufLen can be initialized
 * 
 *    Rev 1.35.1.0   28 Jul 1993 13:38:02   jang
 * checked in so it can be backup to the tape. ch 1 & 2 are working
 * 
 *    Rev 1.35   08 Jul 1993 19:30:44   jang
 * get rid of init_pkt() and also some compiler warning info
 * 
 *    Rev 1.35   08 Jul 1993 14:18:56   jang
 * clean  house to delete some compiler warning message
 * 
 *    Rev 1.34   17 Jun 1993 14:13:16   jang
 * added code to count psp_count mainly for debugging
 * 
 *    Rev 1.33   07 Jun 1993 17:49:44   jang
 * changed bsi_dev[] to bsis[]
 * 
 *    Rev 1.32   07 May 1993 17:15:26   jang
 * changed get_dbd() to MEM_GetDataBuf()
 * 
 *    Rev 1.31   05 May 1993 15:02:28   jang
 * added code to divide the DBDs to Tx and Rx pool
 * 
 *    Rev 1.30   29 Apr 1993 17:21:52   jang
 * return NULL if dbd_count == 1
 * 
 *    Rev 1.29   28 Apr 1993 15:22:22   jang
 * changed get_debug() to if DRV_DEBUG
 * 
 *    Rev 1.28   23 Mar 1993 12:03:22   jang
 * chagned parameter of MEM_SetChPsp()
 * 
 *    Rev 1.27   18 Mar 1993 18:30:42   jang
 * 
 *    Rev 1.26   05 Mar 1993 10:11:44   jang
 * chagned pkt to dbd for channel 2
 * 
 *    Rev 1.25   01 Mar 1993 19:42:00   jang
 * added a flag so that ch 2 won't be written unless the buffer pool has already
 * been initialized
 * 
 *    Rev 1.24   17 Feb 1993 15:37:24   jlin
 * 
 *    Rev 1.23   12 Feb 1993 10:29:54   jlin
 * 
 *    Rev 1.22   08 Feb 1993 18:49:26   jang
 * modified the code to make it faster
 * 
 *    Rev 1.21   04 Feb 1993 19:20:56   jang
 * all the debug printf are gone
 * 
 *    Rev 1.20   03 Feb 1993 13:23:06   jang
 * this version works with lanhawk dumping data
 * 
 *    Rev 1.19   03 Feb 1993 09:03:32   jang
 * work version in slow traffic
 * 
 *    Rev 1.18   30 Jan 1993 16:26:14   jang
 * modified the memory allocation
 * 
 *    Rev 1.17   29 Jan 1993 16:58:36   jang
 * chagned PSP_BUF_ALIGN to FDDI_BUF_ALIGN
 * 
 *    Rev 1.16   26 Jan 1993 11:25:56   jang
 * checked in for integration only. printf() is for testing
 * 
 *    Rev 1.15   19 Jan 1993 15:05:52   jang
 * 
 *    Rev 1.14   07 Jan 1993 09:36:42   jang
 * changed the address scheme
 ************************************************************************/

 
#include <fddi.h>
#include <krnl.h>
#include <dbd.h>
#include <drv.h>
#include <bsi.h>
#include <pkt.h>
#include <dips.h>
#include <malloc.h>
#include <nodbd.h>


/*
 *------------------------------------------------------------------------
 *          Import variables
 *------------------------------------------------------------------------
 */
extern BSI_TYPE bsis[];
extern BSI_ADDR_TYPE bsi_dev[];
extern MBOX FreeMbox;           /* Mbox for DBD */
extern void free_dbd();
extern int dbd_count;

#define SP_DEBUG               0

#if NODBD_DEBUG
extern int drv_get_dbd_cnt;
#endif

#if 1
int drv_no_dbd_cnt;

#endif



/*
 *------------------------------------------------------------------------
 *          Export variables
 *------------------------------------------------------------------------
 */
int free_psp_count; /* total free psp available */


/*
 *------------------------------------------------------------------------
 *          Local variables
 *------------------------------------------------------------------------
 */

/* all the data buffers are aligned with 4k boundary. All the free data
   buffers are stored in a stack. The stack grows from high addr to low
   addr. */
static int *buf_stack_sp;  /* stack pointer to the free data buffer */
static int *buf_stack_end; /* end of the stack */
static int *buf_stack_top; /* top of the stack */

static bool init_shared_psp = FALSE;

static byte *rx_start_ptr;  /* align to 4k. the start ptr to rx buffer pool */

#if 1
char *psp_pktstart;
#endif


/***
    The dbd in this list is waiting to be freed. When process a TX frame,
    the TX_DBD is put in this list. When a corresponding CNF is received,
    the DBD in this list is freed
***/
#define PSP_LIST_NUM            (BSI_REQ_UID_MAX * 2)


/*
 *---------------------------------------------------------------------------
 *          function prototypes
 *---------------------------------------------------------------------------
 */
#define TOTAL_PKTS   358
#if 1
int init_pspPkt ()
{
   pktInit();
  if ((psp_pktstart = (char*)lmalloc(sizeof(char)*4096*(TOTAL_PKTS+1))) == NULL) {
    printf("error: no memory for pkt\n");
    return (1);
  }

  psp_pktstart = (char *)ALIGN(psp_pktstart,4096);
  if (MEM_InitPSPPool(psp_pktstart,TOTAL_PKTS) != OK) {
    printf("MEM_initpsppool() return error\n");
    return (1);
  }


  return 0;
}

#endif

#if 1
static bool psp_debug;
extern int get_txpkt_cnt, free_txpkt_cnt, free_txpkt;
#endif


/***************************************************************************
 *  Function MEM_InitPSPPool
 *
 *  Description
 *    This function initializes the PSP buffer pool
 *
 *  Parameters:
 *    char *start_ptr
 *    int  buf_num
 *
 *  Return: OK | FDDI_ERROR
 ***************************************************************************/
int MEM_InitPSPPool (start_ptr, buf_num)
char *start_ptr;
int buf_num;
{
  int i, *ptr;

  if ((int)start_ptr & 0x00000007)  /* check for 4K boundary */
    return FDDI_ERROR;

#ifdef __FEBRIDGE
  if (!(buf_stack_top = (int *)smalloc(sizeof(int)*buf_num)))
    return FDDI_ERROR;
#else
  if (!(buf_stack_top = (int *)lmalloc(sizeof(int)*buf_num)))
    return FDDI_ERROR;
#endif

#if 1
  psp_debug = FALSE;
#endif

  free_psp_count = 0;
  buf_stack_sp = buf_stack_top + (buf_num - 1);
  buf_stack_end = buf_stack_top + buf_num;
  for (i=0, ptr = buf_stack_top; i < buf_num; i++, ptr++) {
#if SP_DEBUG
    if (ptr > buf_stack_end) {
      printf("stack sp wrong, sp %x, end %x\n",ptr, buf_stack_end);
      asm("fmark");
    }
#endif
    *ptr = (int) start_ptr;
    start_ptr += 0x1000;
    free_psp_count += 1;
  }

  return OK;
}
 
/***************************************************************************
 *  Function MEM_GetFreePsp
 *
 *  Description
 *      This function get a free PSP address from the shared psp free list
 *
 *  Parameter:  none
 *
 *  Return: pointer to a free data buffer
 **************************************************************************/
char *MEM_GetFreePsp ()
{
  int *p;
  register word save_pc = modpc(0x001f0000,0x001f0000);

  if (buf_stack_sp < buf_stack_top)  /* stack empty */ {
    modpc(0x001f0000,save_pc);
    enter_debug(0x99,buf_stack_sp,buf_stack_top);
    return NULL;
  }
  if (free_psp_count <= 0)
	return NULL;

  if (p = (int *)*buf_stack_sp) {
    *p = 0;    /* initialize pkt count */
    p = (int *) (((int) p) + BSI_BUF_CTRL);  /* reserve 8 words */
    if (buf_stack_sp > buf_stack_top) {
      buf_stack_sp--;
      free_psp_count--;
    }
  }

  modpc(0x001f0000,save_pc);

  return ((char *)p);
}


/***************************************************************************
 *  Function MEM_FreePSPBuf
 *
 *  Description
 *      This function push a free data buffer to the free data buffer
 *      stack.
 *
 *  Parameter:
 *      uint32  addr - rx data buffer address, it is aligned to 4k boundary.
 *
 *  Return: void
 **************************************************************************/
void MEM_FreePSPBuf (addr)
uint32 addr;
{
  register char *ptr;
  register int pkt_cnt;
  register word save_pc = modpc(0x001f0000,0x001f0000);

  if (addr == 0L) {
    modpc(0x001f0000,save_pc);
    enter_debug(0x123);
    return;
  }

  ptr = (char *) (addr & BSI_DBD_ADDR_MASK);
  pkt_cnt = *ptr;
  if (pkt_cnt <= 0) {
#if SP_DEBUG
    printf("addr %x pkt_cnt is %x\n",addr,pkt_cnt);
    enter_debug(0xbad001, addr, pkt_cnt);
#endif
    modpc(0x001f0000,save_pc);
    return;
  }

  pkt_cnt -= 1;
  *ptr = pkt_cnt;
#if 0
  printf("MEM_FreePSPBuf(), addr %x, ptr %x, cnt %d, free %d\n",addr,ptr,pkt_cnt,free_psp_count);
#endif
  if (pkt_cnt) {
    modpc(0x001f0000,save_pc);
    return;
  }

  if (buf_stack_sp >= buf_stack_end) {
#if SP_DEBUG
    printf("stack overflow, sp %x, sp_end %x\n",buf_stack_sp,buf_stack_end);
    enter_debug(0xbad002, buf_stack_sp, buf_stack_end);
#endif
    modpc(0x001f0000,save_pc);
    return;
  }

  buf_stack_sp++;
  *buf_stack_sp = (int) ptr;
  free_psp_count++;

  modpc(0x001f0000,save_pc);
} 


/***************************************************************************
 *  Function  MEM_GetPkt
 *
 *  Parameter:
 *    THis function get a PKT header and a buffer link to the pktBufPtr. Note
 *    that the pkt_cnt will be initialized to 1.
 *
 *  Parameter:  none
 *
 *  Return: PKT
 **************************************************************************/
PKT *MEM_GetPkt ()
{
  int tmp_cnt, *tmp;
  register PKT *pkt;
  register char *pktbuff;
  extern char *shmalloc();
  extern int shfree();
  extern int FreeThisPktBuf();
  
  if( (pkt = (PKT *)GetPkt()) == NULL) {
#if 0
    printf("no pkt header\n");
#endif
    return(NULL);
  }

  if ((pktbuff = MEM_GetFreePsp()) == NULL) {
#if 0
    printf("no free psp, free_psp_count %d\n",free_psp_count);
#endif
    pkt->pktFree(pkt);
    return NULL;
  }

  /* initalize the packet header */
  pkt->pktTotalSize = 0;
  pkt->pktBufLink = NULL;
  pkt->pktBufPtr = pktbuff;
  pkt->pktDataPtr = pktbuff;
  pkt->pktBufLen = BSI_PSP_SIZE;
  pkt->pktDriverFree = (void *)MEM_FreePSPBuf;
  pkt->pktDriverInfo = (unsigned)pktbuff;
  INC_PKT_CNT(pktbuff);
#if 1
  get_txpkt_cnt++;
#endif
  return pkt;
}

/***************************************************************************
 *  Function  MEM_GetPktHeader
 *
 *  Parameter:
 *    THis function get a PKT header.
 *
 *  Parameter:  none
 *
 *  Return: PKT
 **************************************************************************/
PKT *MEM_GetPktHeader ()
{
  PKT *pkt;
  
  if ((pkt = (PKT *)GetPkt()) != NULL)
    pkt->pktBufLen = BSI_PSP_SIZE;
#if 0
  else 
    printf("no pkt header\n");
#endif

  return pkt;
}

/***************************************************************************
 *  Function    MEM_SetBsiPsp
 *
 *  Description
 *      This function initializes the PSP descriptors for each channel.
 *
 *  Parameters:
 *      uint16 bsi_num - bsi number
 *
 *  Return: void
 **************************************************************************/
void MEM_SetBsiPsp (bsi_num)
uint32 bsi_num;
{
  int i;
    
  for (i=0; i < BSI_INDCH_NUM; i++) {
    switch (i) {
    case 0:     /* indicate channel 0: SMT/MAC frames */
      MEM_SetChPsp(bsi_num,BSI_SMT_PSP_NUM,(bsi_dev+bsi_num)->ich0,BSI_INDCH0,FALSE);
      break;

    case 1:     /* indicate channel 1: internal mac LLC frames */
      MEM_SetChPsp(bsi_num,BSI_LLC_PSP_NUM,(bsi_dev+bsi_num)->ich1,BSI_INDCH1,FALSE);
      break;

    case 2:     /* indicate channel 2: CAM monitoring LLC frames */
      MEM_SetChPsp(bsi_num,BSI_MON_PSP_NUM,(bsi_dev+bsi_num)->ich2,BSI_INDCH2,FALSE);
      break;
    }   /* switch */
  }   /* for */
}

/***************************************************************************
 *  Function    MEM_SetChPsp
 *
 *  Description
 *      This function put free rx data buffers to a specified channel PSP
 *      descriptor.
 *
 *  Parameter:
 *      uint32 bsi_num
 *      uint32 num - number of PSP to get
 *      BSI_INCH_TYPE *ch_ptr;
 *      uint32 ch_num - [BSI_INDCH0 | BSI_INDCH1 | BSI_INDCH2]
 *
 *  Return: # of PSPs has put into the specified channel
 *************************************************************************/
uint32 MEM_SetChPsp (bsi_num,num,ch_ptr,ch_num,force)
uint32 bsi_num;
uint32 num;
BSI_INCH_TYPE *ch_ptr;
uint32 ch_num;
bool force;
{
  uint32 i, addr;
  byte *bufp;
  int *tmp, tmp_cnt;
  /*****/
  register int *p;
  /*****/

  for (i=0; i < num; i++) {
#if FS_PERFORM
    if ((bufp = (byte *)MEM_GetDataBuf()) == NULL) 
      return i;
#endif
	/************* INLINE ABOVE CODE ***********/
  if (free_psp_count <= DRV_TXBUF_CNT)
    return i;

  if (buf_stack_sp < buf_stack_top)  /* stack empty */ {
    return i;
  }
  if (p = (int *)*buf_stack_sp) {
    *p = 0;    /* initialize pkt count */
    p = (int *) (((int) p) + BSI_BUF_CTRL);  /* reserve 8 words */
    if (buf_stack_sp > buf_stack_top) {
      buf_stack_sp--;
      free_psp_count--;
    }
  }
  bufp = (byte *)p;
	/*******************************************/
    
    if (BSI_WritePsp(bsi_num,ch_ptr,bufp,force) != OK) {  /* queue full */
      INC_PKT_CNT(bufp);
      MEM_FreePSPBuf((uint32)bufp);
      return i;
    }
#if NODBD_DEBUG
    drv_get_dbd_cnt++;
    ch_ptr->pspq->psp_count++;
#endif
  }       /* for */

  return (i);
}

/**************************************************************************
 *  Function  MEM_GetDataBuf
 * 
 *  Description
 *    This function gets the data buffer from the buffer pool
 *
 *  Parameter: none
 *
 *  Return: NULL if no buffer available
 *************************************************************************/
byte *MEM_GetDataBuf ()
{
  byte *ptr;

  if (free_psp_count <= DRV_TXBUF_CNT)
    return (NULL);

  ptr = (byte *)MEM_GetFreePsp();

  return (ptr);
}

/*
 *------------------------------------------------------------------------
 *      Local functions
 *------------------------------------------------------------------------
 */



