/***********************************************************************
 *  File    bsi_isr.c
 *
 *  Description
 *          This module does the BSI interrupts
 *
 *  Copyright (c) 1992-93 Hughes Lan Systems
 *
 *  Author: Jia-wei Jang
 *
 *  $Log:   /user/pvcs/fddicon/drv/src/bsi_isr.c_v  
 * 
 *    Rev 1.82.1.10   12 Oct 1993 11:12:20   gregs
 * No change.
 * 
 *    Rev 1.82.1.9   29 Sep 1993 13:29:38   gregs
 * No change.
 * 
 *    Rev 1.82.1.8   29 Sep 1993 12:55:40   gregs
 * Jiawei put in a bug fix.
 * 
 *    Rev 1.82.1.7   21 Sep 1993 13:45:22   jang
 * deleted the code that clear BSI_RNR
 * 
 *    Rev 1.82.1.6   21 Sep 1993 10:45:12   jang
 * integrated with concentrator code 
 * 
 *    Rev 1.82.1.4   06 Aug 1993 14:56:10   gregs
 * Bug fixes for bridge Pkt driver.
 * 
 *    Rev 1.82.1.3   02 Aug 1993 13:53:12   gregs
 * Added ifdef FEBRIDGE to PollingSMT and PollingLLC routines because the bridge
 * does not have the port locking variable structures.
 * 
 *    Rev 1.82.1.2   29 Jul 1993 15:02:40   jang
 * took out debug msg in RxLLCFrameIsr() at self_test
 * 
 *    Rev 1.82.1.1   29 Jul 1993 12:30:10   jang
 * finish implementing smt channel and tesed it OK
 * 
 *    Rev 1.82.1.0   28 Jul 1993 13:41:28   jang
 * ch 1 & 2 work! checked in so it can be 
 * backup to tape
 * 
 *    Rev 1.82   15 Jul 1993 18:05:46   jang
 * changed NoSpaceAtten() from static to public
 * 
 *    Rev 1.81   08 Jul 1993 14:18:12   jang
 * clean  house to delete some compiler warning message
 * 
 *    Rev 1.80   02 Jul 1993 19:42:44   jlin
 * db_contrl == 0 put in the right place
 * 
 *    Rev 1.79   01 Jul 1993 19:20:50   jang
 * fix db_contrl == 0
 * 
 *    Rev 1.79   01 Jul 1993 19:12:16   jang
 * fixed db_contrl == 0 bug
 * 
 *    Rev 1.78   29 Jun 1993 14:22:14   gregs
 * Removed static type from RxSMTFrameIsr() and RxLLCFramisrIsr().
 * 
 *    Rev 1.77   25 Jun 1993 15:58:52   gregs
 * return dbd_ptr in RxLLCFrameIsr() for fddi-eth bridge.
 * 
 *    Rev 1.76   22 Jun 1993 10:30:48   nayan
 * modification to use ui portnums for locking on source and
 * destination addr.
 * 
 *    Rev 1.75   18 Jun 1993 15:30:06   jang
 * set port_pstats == NULL when portflag is set to FALSE
 * 
 *    Rev 1.74   17 Jun 1993 14:12:10   jang
 * deleted LLCActive/FBMActive checking, also added more debug info
 * 
 *    Rev 1.73   12 Jun 1993 10:56:38   jang
 * deleted REQ_STOP_NOCNF
 * 
 *    Rev 1.72   10 Jun 1993 14:37:52   jang
 * fixed the bug in RxSMTFrameIsr(), moved the FC up
 * 
 *    Rev 1.71   10 Jun 1993 12:30:56   jang
 * added FBMActive and LLCActive
 * 
 *    Rev 1.70   09 Jun 1993 18:57:50   jang
 * fixed port lock bug
 * 
 *    Rev 1.70   09 Jun 1993 18:52:08   jang
 * fixed bug of port locking
 * 
 *    Rev 1.70   09 Jun 1993 18:35:24   jang
 * fixed the bug of port locking
 * 
 *    Rev 1.71   09 Jun 1993 12:59:02   jang
 * do port locking for unkcast frame only
 * 
 *    Rev 1.70   09 Jun 1993 12:19:24   jang
 * 
 *    Rev 1.69   09 Jun 1993 12:07:44   jang
 * set portflag to FALSE if port is locked
 * 
 *    Rev 1.68   09 Jun 1993 11:06:02   jang
 * check DA in smt frame for port locking
 * 
 *    Rev 1.67   09 Jun 1993 10:18:06   jang
 * fixed the bug of port locking
 * 
 *    Rev 1.66   08 Jun 1993 07:43:30   jang
 * added code to count IF_ENTRY/ifcntrs for smt frames and monitor frames
 * 
 *    Rev 1.65   07 Jun 1993 17:18:30   jang
 * changed bsi from interrupt driven to polling
 * 
 *    Rev 1.59   30 Apr 1993 09:49:42   jang
 * added code to flick LED when see pkt on the interface. Also changed get_debug()
 * to #if BSI_DEBUG
 * 
 *    Rev 1.58   28 Apr 1993 15:26:20   jang
 * deleted fatal_error() call
 * 
 *    Rev 1.57   24 Apr 1993 11:04:50   jang
 * changed the pstats implementation
 * 
 *    Rev 1.56   22 Apr 1993 16:32:34   jang
 * comment out state attention interrupt
 * 
 *    Rev 1.55   21 Apr 1993 18:35:22   jang
 * fixed the bug which can't ping to ourself
 * 
 *    Rev 1.54   20 Apr 1993 16:56:48   jang
 * added code to do performance test. also fixed the bug which in smt frame the
 * fc was not initialized
 * 
 *    Rev 1.53   13 Apr 1993 13:33:16   jang
 * fixed the pstats bug
 * 
 *    Rev 1.52   07 Apr 1993 09:14:30   jang
 * added code to count MLSTATS DROP EVENT
 * 
 *    Rev 1.51   05 Apr 1993 11:55:24   jang
 * added more debug info when IDUD status error
 * 
 *    Rev 1.50   05 Apr 1993 08:13:26   jang
 * added more debug info
 * 
 *    Rev 1.48   02 Apr 1993 12:15:06   jang
 * added ifcntrs for the statistics
 * 
 *    Rev 1.47   31 Mar 1993 18:40:32   jang
 * added code to handle consistancy failure exception
 * 
 *    Rev 1.46   23 Mar 1993 12:01:28   jang
 * changed the parameter of MEM_SetChPsp()
 * 
 *    Rev 1.45   18 Mar 1993 18:39:22   jang
 * 
 *    Rev 1.43   08 Mar 1993 09:23:46   jang
 * driver doesn't collect hostentry, pass it to collector
 * 
 *    Rev 1.42   05 Mar 1993 10:12:54   jang
 * added more info for debug when no cnf
 * 
 *    Rev 1.41   02 Mar 1993 18:30:26   jang
 * pass up the rcvportno equals to the mac number
 * 
 *    Rev 1.40   01 Mar 1993 19:58:30   jang
 * 
 *    Rev 1.39   01 Mar 1993 15:23:02   jang
 * 
 *    Rev 1.38   23 Feb 1993 18:10:40   jang
 * deleted some printf from isr
 * 
 *    Rev 1.37   23 Feb 1993 09:40:38   jang
 * add 1 to dbd->db_rcvportno
 * 
 *    Rev 1.35   21 Feb 1993 12:27:46   jang
 * seperated RxFrameIsr() to llc/smt to increase speed
 * . Also manully swap LLC DA because BSI ACR doesn't work
 * 
 *    Rev 1.34   19 Feb 1993 18:01:22   jang
 * 
 *    Rev 1.32   16 Feb 1993 11:02:38   jang
 * changed the parameter passing of BSI_ProcessCNF(). Also fixed the bug
 * of calculating the dbd header for ip frame
 * 
 *    Rev 1.31   12 Feb 1993 10:29:38   jlin
 * 
 *    Rev 1.30   08 Feb 1993 18:50:44   jang
 * checked in to test FBM
 * 
 *    Rev 1.29   05 Feb 1993 14:36:34   jang
 * checked in for performance test
 * 
 *    Rev 1.28   05 Feb 1993 11:42:10   jang
 * added some debug counters
 * 
 *    Rev 1.27   04 Feb 1993 19:19:50   jang
 * all the debug printf are gone
 * 
 *    Rev 1.26   03 Feb 1993 13:22:54   jang
 * this version works with lanhawk dumping data
 * 
 *    Rev 1.25   03 Feb 1993 09:03:08   jang
 * work version in slow traffic
 * 
 *    Rev 1.24   01 Feb 1993 14:32:32   jang
 * a bug of cnfq overflow
 * 
 *    Rev 1.23   30 Jan 1993 16:26:04   jang
 * modified the memory allocation
 * 
 *    Rev 1.22   29 Jan 1993 16:57:06   jang
 * 
 *    Rev 1.21   26 Jan 1993 11:24:56   jang
 * checked in for integration only. A lot of printf()s in the code for testing
 * 
 *    Rev 1.20   19 Jan 1993 15:05:44   jang
 * 
 *    Rev 1.19   12 Jan 1993 09:30:28   jang
 * modified the isr to collect pstats for mac and phys
 * 
 *    Rev 1.18   11 Jan 1993 09:58:30   shekhar
 *  fddi_pstats_tbl is split into fddi_if_pstats_tbl and fddi_port_pstats_tbl.
 * 
 *    Rev 1.17   07 Jan 1993 09:35:08   jang
 * added rmon statistics
 *********************************************************************/

#include <fddi.h>
#include <drv.h>
#include <bsi.h>
#include <krnl.h>
#include <pkt.h>
#ifdef __FDDI_CON
#include <dbd.h>
#endif
#include <msgutil.h>
#include <fdrmonty.h>
#include <monp.h>
#include <phy.h>
#include <dips.h>
#include <bmac.h>
#include <tcpip.h>
#include <msgutil.h>
#include <memory.h>
#include <nodbd.h>






#define PKT_DEBUG     1
#if PKT_DEBUG
int polling_llc = 0, rx_llc = 0, ip_rx = 0;
#endif

#ifdef __FEBRIDGE
#define NUM_PROC_FRAME      1
#else
#define NUM_PROC_FRAME      2
#endif

#define BSI_DEBUG       0
#define  HOST_DEBUG     0
#define  PSTATS_DEBUG   0
#define  PERFORMANCE_TEST    0
#if PERFORMANCE_TEST
static byte     *perf_ptr = (byte *)UNUSED_U107_PIN4;
static int      perf_count;
#endif

#if LOSTPKT_DEBUG
extern int rx_llcpkt_cnt;
#endif

#if 1
int trans_flag;
int flag_1;
int debug_count;
int lo_psp;
int smt_rx_pkt, llc_rx_pkt;
int total_pkts = 0;

int total_proc_pkt = 0;  /* total pkts been processed by task */
uint32 thru_put;
uint32 no_sp=0, lo_sp=0;


#endif

/*
 *-------------------------------------------------------------------------
 *          Local Defines
 *-------------------------------------------------------------------------
 */ 
#define NO_SPACE_PSP_NUM       5       /* get # psps if no space interrupt */

/* used to tell the status of previous rcv frame */
#define RX_FIRST               0x01    /* rx BSI_FIRST */
#define RX_MIDDLE              0x02
#define RX_LAST                0x04
#define RX_ONLY                0

/*
 *-------------------------------------------------------------------------
 *          Local variables
 *-------------------------------------------------------------------------
 */ 
static char broadcast[6] = {0xff,0xff,0xff,0xff,0xff,0xff};
static FDDI_PSTATS pstats_dummy;
                            
/*
 *----------------------------------------------------------------------
 *      import variables
 *----------------------------------------------------------------------
 */

extern MBOX RxSMTFrameMBox;
extern MBOX MonpMbox;
extern IF_ENTRY *ifcntrs;

extern bool bsi_init_flag;
extern BMAC_TYPE bmacs[];
extern PKT *test_pktp;
extern MBOX ReceiveMbox;
extern BSI_TYPE bsis[];
extern BSI_ADDR_TYPE bsi_dev[];
extern FDDI_CON_TYPE fddi_board;
extern DRV_MIBS_TYPE drv_mibs[];
extern FDDI_PSTATS fddi_if_pstats_tbl[];
extern FDDI_PSTATS fddi_port_pstats_tbl[];
extern PLAYER_TYPE phys[];
extern drv_generic_msg *MONP_get_free_monp_msg();
extern PORT_INFO *plock_ptr;
extern MBOX PortLockMbox;
extern MBOX pLockMsgMbox; /* store msg headers */
extern unsigned char UI2PortMap[];
extern unsigned char  Port2LedMap[];
extern int drv_init_flag;


#if 1
extern int dbdbuf_flag;
extern int ch2_psp_wrap;
#endif
/*
 *----------------------------------------------------------------------
 *      local functions
 *----------------------------------------------------------------------
 */
#ifdef DO_LINT
static void IndLowSpaceIsr(uint32,BSI_INCH_TYPE *,uint32);
static void ErrorResetBsi(uint16);
static void IndExceptionIsr(uint32,BSI_INCH_TYPE*);
static void MonitorFrameIsr(void);
static void WriteFrameStatus(GenericMsgType *,IDUD_DESCR_TYPE *);
static status_type GetFragFrame(DBD *,IDUD_DESCR_TYPE*,BSI_INDQ_TYPE*,uint32,uint32);
#else

PKT *RxSMTFrameIsr(); 
int PollingSMTFrame();
static status_type IndLowSpaceIsr();
static void ErrorResetBsi();
static void IndExceptionIsr();
static void ReqAttenISR();
static void release_rx_dbd();
void NoSpaceAtten(uint32,volatile BSI_REG_TYPE *);
#endif


/*************************************************************************
 *  Function  BSI_poll
 *
 *  Description
 *    This function polls the BSI for events
 *
 *  Parameter: none
 *
 *  Return: void
 ***********************************************************************/
void BSI_poll (bsi_num)
uint32 bsi_num;
{
  volatile BSI_REG_TYPE *r_ptr;
  byte mar, rar;

  if (!drv_init_flag) 
    return;


  MONP_Process(bsi_num);      /* monitor rx pkts */
  PollingSMTFrame(bsi_num);
  PollingLLCFrame(bsi_num);

  r_ptr = bsi_dev[bsi_num].base_addr;
  mar = r_ptr->mar;
  if (mar & BSI_MAR_NSA)    /* take care of the BSI no space attention */
    NoSpaceAtten(bsi_num,r_ptr);

  BSI_ProcessCNF(bsi_num);
  /* take care of the request attention */
  if (mar & BSI_MAR_RQA) {        
    rar = r_ptr->rar;
    ReqAttenISR(bsi_num,r_ptr,rar);
  }
}


/*
 *-----------------------------------------------------------------------
 *          Local Function
 *-----------------------------------------------------------------------
 */


void PollingLLCFrame (bsi_num)
uint32 bsi_num;
{
#ifndef __FEBRIDGE  
  int proc_frame = 0;
  PKT *pktp;
  DBD *dbdp;
  FDDI_PSTATS *pstats_ptr;
  HOSTENTRY *sa_host, *da_host;
  drv_generic_msg *monp, *msg;
  bool lock_port;
  unsigned int  ui_portnum;

  while (proc_frame++ < NUM_PROC_FRAME) {
    if ((pktp = (PKT *)RxLLCFrameIsr(bsi_num)) == NULL)
      break;

    if (!(dbdp = get_dbd())) {
#if PKT_DEBUG
      printf("can't get dbd in PollingLLCFrame()\n");
#endif
      FreePktBuf(pktp);
      break;
    }
    dbdp->db_actcnt = pktp->pktDataSize + 1;
    dbdp->nb_len = dbdp->db_actcnt - FDDI_HEADER_LEN;
    dbdp->nb_prot = dbdp->db_buffer + 3;
    memcpy(dbdp->nb_prot,pktp->pktDataPtr-1,dbdp->db_actcnt);
    dbdp->nb_destination = dbdp->db_buffer + FDDI_DA_OFFSET;
    dbdp->nb_source = dbdp->db_buffer + FDDI_SA_OFFSET;
    dbdp->nb_tstamp = RealTimeTicks();
    dbdp->db_rcvportno = /* pktp->pktRcvPort; */ bsi_num;
    dbdp->db_nxtdbd = NULL;
    FreePktBuf(pktp);

    /* swap SA and DA before doing the hash */
    swap_bits(dbdp->nb_destination,6);
    swap_bits(dbdp->nb_source,6);

    da_host = MONP_hash(dbdp->nb_destination,bsi_num,TRUE);
    if ((sa_host = MONP_hash(dbdp->nb_source,bsi_num,TRUE)) != NULL) {
      if ((pstats_ptr = sa_host->port_pstats) == NULL) {
	if ((pstats_ptr = MONP_get_free_pstats()) != NULL) {
	  da_host->port_pstats = pstats_ptr;
	}
	else {
	  pstats_ptr = &pstats_dummy;
	}
      }
      MONP_PstatsDataPkt(pstats_ptr,dbdp->db_actcnt,*(dbdp->nb_prot));
    }
    else
      pstats_ptr = &pstats_dummy;

    /* update interface counters */
    MONP_PstatsDataPkt(&fddi_if_pstats_tbl[bsi_num],dbdp->db_actcnt,*(dbdp->nb_prot));

    if (memcmp(dbdp->nb_destination,broadcast,6) == 0)  {
      dbdp->nb_flags = PKT_IEEEHDR | PKT_RCV_BROADCAST;
      pstats_ptr->PStatsDataBroadcastPkts++;
    }    /* broadcast  frame */
    else if (dbdp->nb_destination[0]==0x80) /* group bit is set */{
      dbdp->nb_flags = PKT_IEEEHDR | PKT_GROUP;
      pstats_ptr->PStatsDataMulticastPkts++;
    }    /* group frame */
    else {
      dbdp->nb_flags = PKT_IEEEHDR;
      /* check for port locking */
      if (sa_host != NULL && sa_host->portflag) {
	lock_port = FALSE;
	ui_portnum = Port2LedMap[sa_host->portno - 1];

	if ((plock_ptr+ui_portnum)->src_addr_num != 0) {
	  if (!chk_lock_addr(ui_portnum,LOCK_SRC_ADDR,dbdp->nb_source)) 
	    lock_port = TRUE;
	}
	if (!lock_port && (plock_ptr+ui_portnum)->dest_addr_num != 0) {
	  if (!chk_lock_addr(ui_portnum,LOCK_DEST_ADDR,dbdp->nb_destination))
	    lock_port = TRUE;
	}
	if (lock_port) {
	  if ((msg=(drv_generic_msg *)AcptMessage(&pLockMsgMbox))==NULL) {
	    if (get_debug() == DEBUG_ON)
	      printf("Error: no msg header in pLockMsgMbox\n");
	  }
	  else {
	    /* unmatch address, lock the port */
	    sa_host->portflag = FALSE;
	    sa_host->port_pstats = NULL;
	    PHY_Isolate(sa_host->portno-1);
	    msg->port_lock_type = LOCK_PORT_BY_ADDR;
	    msg->dev_num = sa_host->portno-1;
	    msg->msg_type = PORT_LOCK_MSG_TYPE;
	    SendMessage((MSGHDR *)msg,&PortLockMbox);
	  }
	}  /* lock_port */
      }
    }   /* else unicast frame */
    /* send msg to collector */
    if ((monp=MONP_get_free_monp_msg()) != NULL) {
      monp->dev_num = bsi_num;
      monp->frame_len = dbdp->db_actcnt;
      monp->frame_flag = dbdp->nb_flags;
      monp->DAhost_ptr = da_host;
      monp->SAhost_ptr = sa_host;
      SendMessage((MSGHDR*)monp,&MonpMbox);
    }
    else
      MONP_MLstats(bsi_num,MLSTATS_DROP_EVNT);
    
    /* swap SA and DA back before passing it up */
    swap_bits(dbdp->nb_destination,6);
    swap_bits(dbdp->nb_source,6);

    dbdp->nb_prot += FDDI_HEADER_LEN;
    dbdp->db_actcnt -= FDDI_HEADER_LEN;

    /* send it to tcpip stack */
    SendMessage((MSGHDR*)dbdp,&ReceiveMbox);
  }  /* while */
#endif
}


/**************************************************************************
 *  Function    RxLLCFrameIsr
 *
 *  Description
 *      This function puts the received MAC/SMT or local LLC frames to
 *      the mailbox. It returns OK if no error occurs during the processing.
 *
 *  Paramete:
 *      uint16 bsi_num
 *
 *  Return: PKT *
 **************************************************************************/
PKT *RxLLCFrameIsr (bsi_num)
uint32 bsi_num;
{
  BSI_INCH_TYPE *ch_ptr = bsi_dev[bsi_num].ich1;
  BSI_INDQ_TYPE *q_ptr;    /* point to idud queue */
  BSI_INDQ_TYPE *psp_q;
  IDUD_DESCR_TYPE *d_ptr; /* point to idud queue slot itself */
  PKT *pktp;
  uint32 addr, fl;
  byte fc;   /* field control field */
  int *tmp, tmp_cnt;

  q_ptr = ch_ptr->idudq;
  psp_q = ch_ptr->pspq;

  while (TRUE) {
    d_ptr = (IDUD_DESCR_TYPE *)q_ptr->qp;
    /* using 2nd word as a null descriptor */
    if ((d_ptr->loc & IDUD_ADDR_MASK) == 0L) {
      return NULL;
    }
    /* undocument bsi bug:
       if the cnt field is 0, the loc points to the previous psp */
    if (d_ptr->cnt == 0) {
      NULLIFY_DESC2ND(d_ptr);
      NEXT_QSLOT_ADDR(q_ptr->qp);
      BSI_WriteIDUD(bsi_num,ch_ptr,FALSE);
      return NULL;
    }

#ifdef __FDDI_CON
    LED_SetInterfaceLED(bsi_num);
#endif

    MEM_SetChPsp(bsi_num,1,ch_ptr,BSI_INDCH1,FALSE);
    BSI_WriteIDUD(bsi_num,ch_ptr,FALSE);

    fl = d_ptr->loc & BSI_ADDRFL_MASK;
    addr = (uint32) BSI2CPU(d_ptr->loc & BSI_ADDR28);
    INC_PKT_CNT(addr);  /* increment the pkt cnt */

    /* in frame per page mode, no LLC frame will be
       over 4k. SO if it is not BSI_ONLY, throw it
       away */
    if (fl != BSI_ONLY) {
      MEM_FreePSPBuf(addr);
      NULLIFY_DESC2ND(d_ptr);
      NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
      NULLIFY_DESC2ND(psp_q->qp);
      psp_q->psp_count--;
#endif
      NEXT_QSLOT_ADDR(psp_q->qp);
      (ifcntrs + bsi_num)->inerrpkts++;
#ifdef __FDDI_CON
      MONP_MLstats(bsi_num,MLSTATS_DROP_EVNT);
#endif  /* __FDDI_CON */
      continue;
    }

    /* check the rx frame status. don't pass it up if error occured */
    if (BSI_ChkIdudStatus(d_ptr,BSI_LLC_FRAME) != OK) {
#if BSI_DEBUG
      printf("bad LLC. idud-> w0: %x, w1: %x\n",((GENERIC_DESC_TYPE *) d_ptr)->w0,((GENERIC_DESC_TYPE *) d_ptr)->w1);
#endif
      MEM_FreePSPBuf(addr);
      NULLIFY_DESC2ND(d_ptr);
      NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
      NULLIFY_DESC2ND(psp_q->qp);
      psp_q->psp_count--;
#endif
      NEXT_QSLOT_ADDR(psp_q->qp);
      (ifcntrs + bsi_num)->inerrpkts++;
      /*	MONP_MLstats(bsi_num,MLSTATS_DROP_EVNT);   */
      continue;
    }  /* bad frame */

    /* up to here, the frame is good, process it */
    if (pktp = (PKT *)MEM_GetPktHeader()) {
      pktp->pktDriverFree = MEM_FreePSPBuf;
      pktp->pktDriverInfo = (unsigned) addr;
    }
    else {  /* no PKT, return */
      MEM_FreePSPBuf(addr);   /* free the buffer */
      NULLIFY_DESC(d_ptr);
      NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
      NULLIFY_DESC2ND(psp_q->qp);
      psp_q->psp_count--;
#endif
      NEXT_QSLOT_ADDR(psp_q->qp);
      (ifcntrs + bsi_num)->inDiscards++;
#ifdef __FDDI_CON
      MONP_MLstats(bsi_num,MLSTATS_DROP_EVNT);
#endif  /* __FDDI_CON */
      return NULL;
    }

    fc = *((int *)addr);
    pktp->pktRcvPort = bsi_num;
    /*pktBufPtr = pktDataPtr == DA */
    pktp->pktBufPtr = pktp->pktDataPtr = (char *) (addr+1);
    /* len starts from DA */
    pktp->pktDataSize = pktp->pktTotalSize = d_ptr->cnt - FDDI_FCS_BYTES - 1;

    if ((bsis[bsi_num].do_scrub) && (fc == 0)) { /* doing scrubing */
      MEM_FreePSPBuf(addr);   /* free the buffer */
      NULLIFY_DESC2ND(d_ptr);
      NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
      NULLIFY_DESC2ND(psp_q->qp);
      psp_q->psp_count--;
#endif
      NEXT_QSLOT_ADDR(psp_q->qp);
      bsis[bsi_num].do_scrub = FALSE;
      return NULL;
    }

    if (bsis[bsi_num].self_test) {   /* this is the self test frame */
      test_pktp = pktp;
      NULLIFY_DESC2ND(d_ptr);
      NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
      NULLIFY_DESC2ND(psp_q->qp);
      psp_q->psp_count--;
#endif
      NEXT_QSLOT_ADDR(psp_q->qp);
      bsis[bsi_num].self_test = FALSE;
      return NULL;
    }

#if NOSAR
    /* swap DA if not broadcast. ACR doesn't work */
    swap_bits(pktp->pktDataPtr,6);
    swap_bits(pktp->pktDataPtr+6,6);
#endif

    /* pass it up */
    pktp->pktBufLink = NULL;

    /* nullify the processed frame */
    NULLIFY_DESC2ND(d_ptr);
    NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
      NULLIFY_DESC2ND(psp_q->qp);
      psp_q->psp_count--;
#endif
    NEXT_QSLOT_ADDR(psp_q->qp);
#if PKT_DEBUG
    rx_llc++;
#endif
    return(pktp);
  }  /* while */
} 

/**************************************************************************
 *  Function    RxSMTFrameIsr
 *
 *  Description
 *      This function puts the received MAC/SMT or local LLC frames to
 *      the mailbox. It returns OK if no error occurs during the processing.
 *
 *  Paramete:
 *      uint16 bsi_num
 *
 *  Return: [OK | FDDI_ERROR]
 **************************************************************************/
int PollingSMTFrame (bsi_num)
uint32 bsi_num;
{
#ifndef __FEBRIDGE
  byte fc;   /* field control field */
  FDDI_PSTATS *pstats_ptr;
  HOSTENTRY *da_host = 0, *sa_host = 0;
  drv_generic_msg *monp, *msg;
  uint32  lock_port, pkt_flags;
  unsigned int ui_portnum;
  int proc_frame = 0, pkt_len;
  PKT *pktp;
  char da[6], sa[6];

  while (proc_frame++ < NUM_PROC_FRAME) {
    if ((pktp = RxSMTFrameIsr(bsi_num,&da_host,&sa_host)) == NULL)
      return FDDI_ERROR;

    pktp->pktUseCount += 1;
    pkt_len = pktp->pktTotalSize;
    memcpy(da,pktp->pktDataPtr+1,6);
    memcpy(sa,pktp->pktDataPtr+7,6);
    fc = *((byte *)pktp->pktDataPtr);

    FreePktBuf(pktp);
    if (!sa_host || !da_host)
      return FDDI_ERROR;

    if ((pstats_ptr = sa_host->port_pstats) == NULL) {
      if ((pstats_ptr = MONP_get_free_pstats()) != NULL) {
	da_host->port_pstats = pstats_ptr;
      }
      else {
#if BSI_DEBUG
	printf("ERROR: no free pstats_ptr\n");
#endif
	pstats_ptr = &pstats_dummy;
      }
    }
    MONP_PstatsDataPkt(pstats_ptr,pkt_len,fc);

    /* update interface counters */
    MONP_PstatsDataPkt(&fddi_if_pstats_tbl[bsi_num],pkt_len,fc);

    if (memcmp(da,broadcast,6) == 0)  {
      /* update IF_ENTRY */
      (ifcntrs + bsi_num)->inbmcastpkts++;
      pkt_flags = PKT_RCV_BROADCAST;
      pstats_ptr->PStatsSmtBroadcastPkts++; 
    }    /* broadcast  frame */
    else if (da[0] == 0x80) /* group bit is set */{
      /* update IF_ENTRY */
      (ifcntrs + bsi_num)->inbmcastpkts++;
      pkt_flags = PKT_GROUP;
      pstats_ptr->PStatsSmtMulticastPkts++;
    }    /* group frame */
    else {
      pkt_flags = 0;
      (ifcntrs + bsi_num)->inucastpkts++;
      /* check for port locking */
      if (sa_host->portflag) {
	ui_portnum = Port2LedMap[sa_host->portno - 1];
	lock_port = FALSE;
	if ((plock_ptr+ui_portnum)->src_addr_num != 0) {
	  if (!chk_lock_addr(ui_portnum,LOCK_SRC_ADDR,sa)) 
	    lock_port = TRUE;
	}
	if (!lock_port && (plock_ptr+ui_portnum)->dest_addr_num != 0) {
	  if (!chk_lock_addr(ui_portnum,LOCK_DEST_ADDR,da))
	    lock_port = TRUE;
	}
	if (lock_port) {
	  if ((msg=(drv_generic_msg *)AcptMessage(&pLockMsgMbox))==NULL) {
	    if (get_debug() == DEBUG_ON)
	      printf("Error: no msg header in pLockMsgMbox\n");
	  }
	  else {
	    /* unmatch address, lock the port */
	    sa_host->portflag = FALSE;
	    sa_host->port_pstats = NULL;
	    PHY_Isolate(sa_host->portno-1);
	    msg->port_lock_type = LOCK_PORT_BY_ADDR;
	    msg->dev_num = sa_host->portno-1;
	    msg->msg_type = PORT_LOCK_MSG_TYPE;
	    SendMessage((MSGHDR *)msg,&PortLockMbox);
	  }
	}
      }
    }   /* unicast smt frame */


    /* send msg to collector */
    if ((monp=MONP_get_free_monp_msg()) != NULL) {
      monp->dev_num = bsi_num;
      monp->frame_len = pkt_len; 
      monp->frame_flag = pkt_flags;
      monp->DAhost_ptr = da_host;
      monp->SAhost_ptr = sa_host;
      SendMessage((MSGHDR*)monp,&MonpMbox);
    }
    else 
      MONP_MLstats(bsi_num,MLSTATS_DROP_EVNT);
  }  /* while */

  return OK;
#endif
}


#ifdef __FEBRIDGE
PKT *RxSMTFrameIsr (bsi_num)
uint32 bsi_num;
#else
PKT *RxSMTFrameIsr (bsi_num,da_host,sa_host)
uint32 bsi_num;
HOSTENTRY **da_host, **sa_host;
#endif
{
  register BSI_INCH_TYPE *ch_ptr = bsi_dev[bsi_num].ich0;
  register BSI_INDQ_TYPE *q_ptr;    /* point to idud queue */
  BSI_INDQ_TYPE *psp_q;
  IDUD_DESCR_TYPE *d_ptr; /* point to idud queue slot itself */
  GenericMsgType *msg;
  uint32 addr, fl;
  int *tmp, tmp_cnt;
  register PKT *pktp;
  byte fc;

  q_ptr = ch_ptr->idudq;
  /* added pspq for debugging only. The pspq->qp should equal to 
     the idudq.loc if nothing goes wrong. */
  psp_q = ch_ptr->pspq;
  while (TRUE) {
    d_ptr = (IDUD_DESCR_TYPE *)q_ptr->qp;

    if ((d_ptr->loc & IDUD_ADDR_MASK) == 0L) {  /* using 2nd word as a null descriptor */
      return NULL;
    }
    /* undocument bsi bug:
       if the cnt field is 0, the loc points to the previous psp */
    if (d_ptr->cnt == 0) {
      NULLIFY_DESC2ND(d_ptr);
      NEXT_QSLOT_ADDR(q_ptr->qp);
      BSI_WriteIDUD(bsi_num,ch_ptr,FALSE);
      return NULL;
    }

#ifndef __FEBRIDGE
    LED_SetInterfaceLED(bsi_num);
#endif

    MEM_SetChPsp(bsi_num,1,ch_ptr,BSI_INDCH0,FALSE);
    BSI_WriteIDUD(bsi_num,ch_ptr,FALSE);
#if PERFORMANCE_TEST
	perf_count++;
#endif
    /* restore the DBD pointer. */
    fl = d_ptr->loc & BSI_ADDRFL_MASK;
    addr = (uint32) BSI2CPU(d_ptr->loc & BSI_ADDR28);
    INC_PKT_CNT(addr);  /* increment the pkt cnt */

    if (fl != BSI_ONLY) {
      /* throw away the packet */
      MEM_FreePSPBuf(addr);
      NULLIFY_DESC2ND(d_ptr);
      NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
      NULLIFY_DESC2ND(psp_q->qp);
      psp_q->psp_count--;
#endif
      NEXT_QSLOT_ADDR(psp_q->qp);
      (ifcntrs + bsi_num)->inerrpkts++;
#ifndef __FEBRIDGE
      MONP_MLstats(bsi_num,MLSTATS_DROP_EVNT);
#endif
      continue;
    }    /* !BSI_ONLY */

    /* check the rx frame status. don't pass it up if error occured */
    if (BSI_ChkIdudStatus(d_ptr,BSI_SMT_FRAME) != OK) {
#if BSI_DEBUG
      printf("bad SMT. qp %x, idud-> w0:%x, w1: %x\n",q_ptr->qp,((GENERIC_DESC_TYPE *) d_ptr)->w0,((GENERIC_DESC_TYPE *) d_ptr)->w1);
#endif
      MEM_FreePSPBuf(addr);
      NULLIFY_DESC2ND(d_ptr);
      NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
      NULLIFY_DESC2ND(psp_q->qp);
      psp_q->psp_count--;
#endif
      NEXT_QSLOT_ADDR(psp_q->qp);
      (ifcntrs + bsi_num)->inerrpkts++;
#ifndef __FEBRIDGE
/*      MONP_MLstats(bsi_num,MLSTATS_DROP_EVNT);   */
#endif
      continue;
    }


    fc = *(byte *)addr;
    /* check the MAC frame. don't pass it up if it is one */
    if ((fc & FC_MAC_FRAME) == FC_MAC_FRAME) {
      MEM_FreePSPBuf(addr);
      NULLIFY_DESC2ND(d_ptr);
      NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
      NULLIFY_DESC2ND(psp_q->qp);
      psp_q->psp_count--;
#endif
      NEXT_QSLOT_ADDR(psp_q->qp);
#ifndef __FEBRIDGE
      if (fc == FC_BEACON_FRAME)
	MONP_MLstats(bsi_num,MLSTATS_BCN_PKT);
      else if (fc == FC_CLAIM_FRAME)
	MONP_MLstats(bsi_num,MLSTATS_CLM_PKT);
#endif  /* __FEBRIDGE */
      continue;
    }

    /* up to here, the frame is good, process it */
    if (pktp = (PKT *)MEM_GetPktHeader()) {
      pktp->pktDriverFree = MEM_FreePSPBuf;
      pktp->pktDriverInfo = (unsigned) addr;
    }
    else {  /* no PKT, return */
      MEM_FreePSPBuf(addr);   /* free the buffer */
      NULLIFY_DESC(d_ptr);
      NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
      NULLIFY_DESC2ND(psp_q->qp);
      psp_q->psp_count--;
#endif
      NEXT_QSLOT_ADDR(psp_q->qp);
      (ifcntrs + bsi_num)->inDiscards++;
#ifndef __FEBRIDGE
      MONP_MLstats(bsi_num,MLSTATS_DROP_EVNT);
#endif  /* __FEBRIDGE */
      return NULL;
    }

    pktp->pktRcvPort = bsi_num;
    /*pktBufPtr = pktDataPtr == FC */
	pktp->pktDataPtr = (char *)addr+1;
    pktp->pktBufPtr = (char *) (addr - FDDI_FC_OFFSET);
    pktp->pktDataSize = pktp->pktTotalSize = d_ptr->cnt - FDDI_FCS_BYTES;

    if (bsis[bsi_num].self_test) {   /* this is the self test frame */
      test_pktp = pktp;
      NULLIFY_DESC2ND(d_ptr);
      NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
      NULLIFY_DESC2ND(psp_q->qp);
      psp_q->psp_count--;
#endif
      NEXT_QSLOT_ADDR(psp_q->qp);
      bsis[bsi_num].self_test = FALSE;
      return NULL;
    }
    
    (ifcntrs + bsi_num)->inbytecnt += pktp->pktDataSize;

    /* get message header, if no room in mailbox, don't process it,
       don't nullify it so we can process it next time */
    if ((msg = (GenericMsgType *)AcptFDDIMsgHdr()) == NULL) {
#if BSI_DEBUG
      printf("no msg header to pass smt frame, free pktp %x\n",pktp);
#endif
      FreePktBuf(pktp);
      return NULL;
    }


#ifndef __FEBRIDGE
    /* do the hash here for the smt collector/ring map. Since bridge
       doesn't support these 2 features and hash takes 100 msec, 
       we limit it for concentrator only */
    *da_host = MONP_hash((byte*)pktp->pktDataPtr+FDDI_DA_OFFSET,bsi_num,TRUE);
    *sa_host = MONP_hash((byte*)pktp->pktDataPtr+FDDI_SA_OFFSET,bsi_num,TRUE);
#else
	/* for bridge, the ACR is configured to swap addresses by H/W */
	swap_bits(pktp->pktDataPtr,12);
#endif   /* __FEBRIDGE */

    msg->ptr = (byte *)pktp;
    msg->msg_type = DRV_RX_MSG_TYPE;
    msg->dev_num = bsi_num;
    msg->frame_status = (((GENERIC_DESC_TYPE *)d_ptr)->w0 & BSI_IDUD_FRS_MASK) >> 16;

    SendMessage((MSGHDR*)msg,&RxSMTFrameMBox);

    /* nullify the processed frame */
    NULLIFY_DESC2ND(d_ptr);
    NEXT_QSLOT_ADDR(q_ptr->qp);
#if NODBD_DEBUG
      NULLIFY_DESC2ND(psp_q->qp);
      psp_q->psp_count--;
#endif
    NEXT_QSLOT_ADDR(psp_q->qp);
    
    return (pktp);
  }       /* while */
} 

#if 0
/****************************************************************************
 *  Function    TestNextNullIdud
 *
 *  Description
 *      This function tests next IDUD descriptor slot to see if it is NULL.
 *      It returns TRUE if it is NULL descriptor.
 *
 *  Parameter:
 *      uint32 - address of IDUD slot
 *
 *  Return: [TRUE | FALSE]
 ***************************************************************************/
static bool TestNextNullIdud(idud_qptr)
BSI_INDQ_TYPE *idud_qptr;
{
  GENERIC_DESC_TYPE *tst_desc;
  
  tst_desc = (GENERIC_DESC_TYPE *)idud_qptr->qp;
  NEXT_QSLOT_ADDR(idud_qptr->qp);
  if (tst_desc->w0 == 0 && tst_desc->w1 == 0)     /* null descriptor */ {
    return (TRUE);
  }
  
  return (FALSE);        
}
#endif 
/**************************************************************************
 *  Function    IndLowSpaceIsr
 *
 *  Description
 *      This function processes indicate channel low space interrupt
 *
 *  Parameter:
 *      BSI_INCH_TYPE *ch_ptr
 *      BSI_REG_TYPE *r_ptr;
 *
 *  Return: void
 *************************************************************************/
static status_type IndLowSpaceIsr (bsi_num,ch_ptr,ch_num)
uint32 bsi_num;
BSI_INCH_TYPE *ch_ptr;
uint32 ch_num;
{
  BSI_INDQ_TYPE *q_ptr = ch_ptr->pspq;
  int val;

  ch_ptr->info->low_space_cnt++;
  if (ch_ptr->pspq->lmop_count >= BSI_PSP_PIPELINE_NUM) { 
    /* already has some DBDs available */
    val = q_ptr->next_slot & BSI_OFFSET_MASK;
    if ((lmop(bsi_num,ch_ptr->pqli_addr,LMOP_WRITE,&val)) == OK) {
      q_ptr->lmop_count = 0;
    }
  }

  /* 2 is for pipeline */
  MEM_SetChPsp(bsi_num,NO_SPACE_PSP_NUM,ch_ptr,ch_num,TRUE);

  return OK;
}
 
/************************************************************************
 *  Function  ReqAttenISR
 *
 *  Description
 *    This funtion processes the request attention interrupt
 *
 *  Parameters:
 *    uint32 bsi_num
 *    volatile BSI_REG_TYPE *r_ptr
 *    byte rar
 *
 *  Return: void
 ***********************************************************************/
#ifdef __FEBRIDGE 
void ReqAttenISR (bsi_num,r_ptr,rar)
#else
static void ReqAttenISR (bsi_num,r_ptr,rar)
#endif
uint32 bsi_num;
volatile BSI_REG_TYPE *r_ptr;
byte rar;
{
  BSI_REQCH_TYPE *ch_ptr;
  BSI_REQQ_TYPE *q_ptr;

  if (rar & BSI_RAR_USRR0) {
    if (!bmacs[bsi_num].ring_op) {  /* due to ringOP == 0 */
#if BSI_DEBUG 
      {
	printf("\nUnserviceable request to BSI %d chnl 0: ring down\n",bsi_num);
	printf("bmac ring_op %x\n",bmacs[bsi_num].reg_base->relr0);
      }
#endif
      bsis[bsi_num].bsi_status |= REQ_STOP_RINGOP;
    }
    else if (r_ptr->nsar & BSI_NSAR_NSR0) {  /* no cnf status */
      ch_ptr = bsi_dev[bsi_num].rch0;
      q_ptr = ch_ptr->cnfq;
#if BSI_DEBUG
      {
	printf("\nUnserviceable request: no CNF at bsi %d, ch 0\n",bsi_num);
	printf("s/w qp %x, ql %x\n",q_ptr->qp,q_ptr->ql);
	BSI_ReadCNFDesc(bsi_num,ch_ptr,q_ptr);
      }
#endif

      if (BSI_WriteCNF(bsi_num,ch_ptr,TRUE) != OK)  {
	ch_ptr->cnfq->status |= CNF_NO_SPACE;
      }
    }
  }

  if (rar & BSI_RAR_USRR1) {
    if (!bmacs[bsi_num].ring_op) {  /* due to ringOP == 0 */
#if BSI_DEBUG
	printf("Unserviceable request to BSI %d chnl 1: Ring down\n",bsi_num);
#endif
      bsis[bsi_num].bsi_status |= REQ_STOP_RINGOP;
    }
    else if (r_ptr->nsar & BSI_NSAR_NSR1) {  /* no cnf status */
      ch_ptr = bsi_dev[bsi_num].rch0;
      q_ptr = ch_ptr->cnfq;

#if BSI_DEBUG
      {
	printf("\nUnserviceable request: no CNF at bsi %d, ch 0\n",bsi_num);
	printf("s/w qp %x, ql %x\n",q_ptr->qp,q_ptr->ql);
      }
#endif
      if (BSI_WriteCNF(bsi_num,ch_ptr,TRUE) != OK)  {
	ch_ptr->cnfq->status |= CNF_NO_SPACE;
      }
      else
	r_ptr->rar &= ~BSI_RAR_USRR1;   /* clear the bit */
    }
  }

  if (rar & BSI_RAR_EXCR0) {  /* exception occur */
/*    r_ptr->rnr &= BSI_RNR_EXCR0N;     mask off the interrupt bit */
    r_ptr->rar &= BSI_RAR_EXCR0;      /* clear the bit */
    bsi_dev[bsi_num].rch0->info_ptr->excep_flag = TRUE;
  }

  if (rar & BSI_RAR_EXCR1) {
/*    r_ptr->rnr &= BSI_RNR_EXCR0N;      mask off the interrupt bit */
    r_ptr->rar &= BSI_RAR_EXCR0;      /* clear the bit */
    bsi_dev[bsi_num].rch1->info_ptr->excep_flag = TRUE;
  }
}
  
/************************************************************************
 *  Function    IndExceptionIsr
 *
 *  Description
 *      This function process the indication exception. It does nothing
 *      except discard the frame.
 *
 *  Parameters:
 *      BSI_INCH_TYPE *ch_ptr
 *
 *  Return: void
 ***********************************************************************/
static void IndExceptionIsr (bsi_num,ch_ptr,ch_num)
uint32 bsi_num;
BSI_INCH_TYPE *ch_ptr;
uint32 ch_num;
{
#if 1
    printf("an ind exception error on ch %d\n",ch_num);
#endif    
}
 
/************************************************************************
 *  Function    ErrorResetBsi
 *
 *  Description
 *      This function resets the BSI chip due to unrecover hw error
 *
 *  Parameter:
 *      uint32 bsi_num
 *      byte star
 *
 *  Return: void
 **********************************************************************/
static void ErrorResetBsi (bsi_num,star)
uint32 bsi_num;
byte star;
{ 

}

/*************************************************************************
 *  Function  release_rx_dbd
 *
 *  Description
 *    This function release the receive dbds
 *
 *  Parameters:
 *    DBD *dbdp
 *
 *  Return: void
 ***********************************************************************/
static void release_rx_dbd (dbdp)
DBD *dbdp;
{
#ifndef __FEBRIDGE
  DBD *p;

  if (dbdp->db_nxtdbd == NULL) {
    chnl_free_dbd(dbdp);   /* special case, most of the time */
    return;
  }

  p = dbdp->db_nxtdbd;
  if (p->db_nxtdbd != NULL) {
    chnl_free_dbd(p->db_nxtdbd);
  }
  chnl_free_dbd(p);
  chnl_free_dbd(dbdp);
#endif
}



/************************************************************************************
 *  Function  NoSpaceAtten
 * 
 *  Description
 *   This function process the No Space Attention.
 *
 *  Parameter:
 *   uint32 bsi_num -
 *   BSI_REG_TYPE *r_ptr
 *
 *  Return: void
 ***********************************************************************************/
void NoSpaceAtten (bsi_num,r_ptr)
uint32 bsi_num;
volatile BSI_REG_TYPE *r_ptr;
{
  byte nsar;
  register BSI_INCH_TYPE *ch_ptr;
  int qp, ql, i;
  IDUD_DESCR_TYPE *d_ptr; /* point to idud queue slot itself */
  byte old_icr;
  drv_generic_msg *msg;
  PKT *pktp;

  nsar = r_ptr->nsar;

  if (bsis[bsi_num].bsi_status & (BSI_IND_STOP | BSI_REQ_STOP | BSI_SP_STOP) != 0)  {
#if LOSTPKT_DEBUG
    printf("bsi engine stop, status %x\n",bsis[bsi_num].bsi_status);
#endif
    return;
  }

  if (nsar  & BSI_NSAR_LDI0) {
    IndLowSpaceIsr(bsi_num,bsi_dev[bsi_num].ich0,BSI_INDCH0);
  }
  if (nsar  & BSI_NSAR_LDI1) {
    IndLowSpaceIsr(bsi_num,bsi_dev[bsi_num].ich1,BSI_INDCH1);
  }
  if (nsar & BSI_NSAR_LDI2) {
    IndLowSpaceIsr(bsi_num,bsi_dev[bsi_num].ich2,BSI_INDCH2);
  }

  if (nsar & BSI_NSAR_NSI2)  { /* no IDUD space on ichn2 */
    bsi_dev[bsi_num].ich2->info->no_space_cnt++;
    ch_ptr = bsi_dev[bsi_num].ich0;
    strobe_wdt();

    if (pktp = DRV_GetOneRxPkt(bsi_num))
      FreePktBuf(pktp);

    lmop(bsi_num,ch_ptr->iqli_addr,LMOP_READ,&ql);
    ql |= (ch_ptr->idudq->base & LMOP_ADDR_MASK);
    ptop(bsi_num,ch_ptr->iqpi_addr,PTOP_READ,&qp);
    qp = BSI2CPU(qp);
    if ((!BSI_Qfull(qp,ql)) && (!(nsar & BSI_NSAR_LDI2)))
      BSIREG_SetNsar(bsi_num,~BSI_NSAR_NSI2);
    else {  
      strobe_wdt();
      for (i = 0; i < 2; i++) 
	BSI_WriteIDUD(bsi_num,ch_ptr,FALSE);
      lmop(bsi_num,ch_ptr->iqli_addr,LMOP_READ,&ql);
      ql |= (ch_ptr->idudq->base & LMOP_ADDR_MASK);
      if ((!BSI_Qfull(qp,ql)) && (!(nsar & BSI_NSAR_LDI2)))
	BSIREG_SetNsar(bsi_num,~BSI_NSAR_NSI2);
    }
  }
  if (nsar & BSI_NSAR_NSI1)  { /* no space on ichn1 */
    bsi_dev[bsi_num].ich1->info->no_space_cnt++;
    strobe_wdt();
    ch_ptr = bsi_dev[bsi_num].ich0;

    if (pktp = RxLLCFrameIsr(bsi_num))
      FreePktBuf(pktp);

    lmop(bsi_num,ch_ptr->iqli_addr,LMOP_READ,&ql);
    ql |= (ch_ptr->idudq->base & LMOP_ADDR_MASK);
    ptop(bsi_num,ch_ptr->iqpi_addr,PTOP_READ,&qp);
    qp = BSI2CPU(qp);
    if ((!BSI_Qfull(qp,ql)) && (!(nsar & BSI_NSAR_LDI1)))
	BSIREG_SetNsar(bsi_num,~BSI_NSAR_NSI1);
    else {  
      strobe_wdt();
      for (i = 0; i < 2; i++)       
	BSI_WriteIDUD(bsi_num,ch_ptr,FALSE);
      lmop(bsi_num,ch_ptr->iqli_addr,LMOP_READ,&ql);
      ql |= (ch_ptr->idudq->base & LMOP_ADDR_MASK);
      if ((!BSI_Qfull(qp,ql)) && (!(nsar & BSI_NSAR_LDI1)))
	BSIREG_SetNsar(bsi_num,~BSI_NSAR_NSI1);
    }
  }

  if (nsar & BSI_NSAR_NSI0)  { /* no space on ichn0 */
    bsi_dev[bsi_num].ich0->info->no_space_cnt++;
    strobe_wdt();
    ch_ptr = bsi_dev[bsi_num].ich0;
    RxSMTFrameIsr(bsi_num);

    lmop(bsi_num,ch_ptr->iqli_addr,LMOP_READ,&ql);
    ql |= (ch_ptr->idudq->base & LMOP_ADDR_MASK);
    ptop(bsi_num,ch_ptr->iqpi_addr,PTOP_READ,&qp);
    qp = BSI2CPU(qp);
    /* make sure if IDUD has some descriptors and PSP has some buffers */
    if ((!BSI_Qfull(qp,ql)) && (!(nsar & BSI_NSAR_LDI0)))
	BSIREG_SetNsar(bsi_num,~BSI_NSAR_NSI0);
    else {  
      strobe_wdt();
      for (i = 0; i < 2; i++)
	BSI_WriteIDUD(bsi_num,ch_ptr,TRUE);
      lmop(bsi_num,ch_ptr->iqli_addr,LMOP_READ,&ql);
      ql |= (ch_ptr->idudq->base & LMOP_ADDR_MASK);
      if ((!BSI_Qfull(qp,ql)) && (!(nsar & BSI_NSAR_LDI0)))
	BSIREG_SetNsar(bsi_num,~BSI_NSAR_NSI0);
    }
  }
  
  if (nsar & BSI_NSAR_NSR0) { /* no CNF space */
    /* when cnf no space, bsi stops process request */
    bsi_dev[bsi_num].rch0->info_ptr->no_space_cnt++;
    bsi_dev[bsi_num].rch0->cnfq->status |= CNF_NO_SPACE;
    BSIREG_SetNsar(bsi_num,~BSI_NSAR_NSR0);
  }
  if (nsar & BSI_NSAR_NSR1) { 
    bsi_dev[bsi_num].rch1->info_ptr->no_space_cnt++;
    bsi_dev[bsi_num].rch1->cnfq->status |= CNF_NO_SPACE;
    BSIREG_SetNsar(bsi_num,~BSI_NSAR_NSR1);
  }
}
