
/**
 *	Program Name:	nim960 program
 *
 *	Filename:	util.c
 *
 *	$Log:   /b/gregs/bridge/util/util.c_v  $
 * 
 *    Rev 1.8   23 Dec 1993 10:11:04   gregs
 * 
 *    Rev 1.7   23 Dec 1993 10:09:36   gregs
 * Removed the unused function MacAddrRevBits().
 * 
 *    Rev 1.6   26 Oct 1993 16:57:30   vinay
 * Added Isolate_Pys in reset.
 * 
 *    Rev 1.5   12 Oct 1993 09:20:08   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 09:39:56   franks
 * No change.
 * 
 *    Rev 1.3   10 Sep 1993 15:16:30   franks
 * No change.
 * 
 *    Rev 1.2   08 Sep 1993 10:36:06   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 10:30:36   vinay
 * modified ErrorAbort()
 * 
 *    Rev 1.0   30 Jul 1993 13:30:12   franks
 * Initial revision.
 * 
 *    Rev 1.7   14 May 1992 19:30:04   kwok
 * disable the watch dog timer in ErrorAbort();
 * 
 *    Rev 1.6   13 May 1992 18:44:10   suresh
 * Added routine InitAbort to be called only after the kernel is invoked
 * 
 *    Rev 1.5   11 May 1992 13:23:14   kwok
 * Print the error message "Porgram Aborted" in the function ErrorAbort().
 * 
 *    Rev 1.4   11 May 1992 12:06:08   kwok
 * Adding the function ErrorAbort to flicker the ACT and READY LEDs on
 * POST failure.
 * 
 *    Rev 1.3   08 May 1992 18:26:38   suresh
 * fix to disable a software crash log, during push button reset.
 * 
 *    Rev 1.2   16 Apr 1992 15:16:02   pvcs
 * sammy add some sonic driver utility
 * 
 *    Rev 1.1   10 Apr 1992 16:57:58   kwok
 * Adding the function TransceiverType().
 * 
 *    Rev 1.0   30 Mar 1992 17:44:48   pvcs
 * Initial revision.
 *
 *	Comment:
 *
 *	Copyright (c) 1992 by Hughes LAN Systems.
 **/
#include <krnl.h>
#include <memory.h>
#include <uart.h>
#include <tmr.h>
#include <sys.h>
#include <dips.h>
#include <led.h>
#include <eeprecs.h>
#include <target.h>
#include <xlate.h>
#include <tr_sled.h>

extern word ram_control_table[];
extern word ram_int_table[];
extern	EEP_MFG	eep_mfg_rec;
extern	NumberOfSonicPort;
extern word debg;
extern word fault_cnt;
extern APPL apl;
SYS	sys;

char *TransTypeToStr(int type);

Ei()
{
	/* Setup Interrupt Mapping Register IMAP0 */
	ram_control_table[7] &= 0xfbff; /* global interrupt enable */
	send_sysctl(0x401, 0, 0);
}

Di()
{
	/* Setup Interrupt Mapping Register IMAP0 */
	ram_control_table[7] |= 0x400; /* global interrupt disable */
	send_sysctl(0x401, 0, 0);
}

/*inline WDT_reset()*/
inline RefreshWDT()
{
	*(ushort *)WDOGIO = 0;
}

NID *MyNid(PortNo)
register word PortNo;
	
	{
	return (NID *)&sys.sys_nid[PortNo];
	}


IsMyNid(nid, port)
register NID *nid;
register int port;
{
	register int i;
	extern char Port4EthNid[6];

	for (i = 0; i != NumberOfSonicPort+1; i++)
	{
		if (ncompare(nid, (NID *)&(sys.sys_nid[i])))
			return TRUE;
	}
   /***********************************************************
	** Change make to accomadate FDDI bit-ordering scheme.    
	** Look at port 4 address using the ethernet bit format.
   ***********************************************************/  
	if( port == 3 ) {
		if(ncompare(nid, (NID *)(&Port4EthNid[0])))
			return TRUE;
	}
	
	return FALSE;
}

SetMyNids()
	{
	int	i;
	byte	MacAddress[6];
	ushort	HubId;
	ushort	SlotId;

	/*
	 *	We form the MAC address from the hud-id and the
	 *	slot id.
	 *	i.e. 00.80.bb.ab.cd.ef
	 *	where	'abcd'H is the hub-id
	 *		'e'H is the slot id
	 *		'f' is 0 to f.
	 */
	MacAddress[0] = 0;
	MacAddress[1] = 0x80;
	MacAddress[2] = 0xbb;
	HubId = GetHubID();
	SlotId = GetSlotID();
	MacAddress[3] = (byte)(HubId >> 8);	/* 'ab'	*/
	MacAddress[4] = (byte) HubId;		/* 'cd'	*/
	MacAddress[5] = (byte)(SlotId << 4);	/* 'e'	*/
	for (i = 0; i < NumberOfSonicPort+1; i++)
		{
		ncopy(&sys.sys_nid[i], &MacAddress);
		MacAddress[5]++;	/* increment 'f'	*/
		}
/*	swap_bits(&sys.sys_nid[i-1],6); */
	}

SysCardPresent()
{
	return ((*(ushort *)CARRIERIO & SYSCARD_INSTALLED) == 0);
}

IsStandalone()
{

	return ((*(ushort *)CARRIERIO & BACK_PLANE_TYPE_MASK) 
		== BACK_PLANE_STANDALONE);
}

GetHubID()
{
	/*
	 *	We complement the hud id because
	 *	an ON on the DIP switch is 0 and the user
	 *	expects to see a 1.
	 */
	return ~*(ushort *)HUBIDIO & 0xffff;
}

GetSlotID()
{
	return *(ushort *)CARRIERIO & SLOTID_MASK;
}

error_output(s, led_status)
register char *s;
register word led_status;
{
  	register word *DIP_SWITCH_ADDR = (word *)DIPIO;
	register int baud;

	set_leds(LED_MONO, LED_MONO_COLOR, led_status);
	baud = GetDipBaud();
	SCCinit(CONSOLE, baud);
	while (*s != '\0')
		SCCput(CONSOLE, *s++);
	error();		
}

ErrorPuts(string)
register char	*string;

	{
	while(*string != '\0')
		SCCput(CONSOLE, *string++);
	}
/*
 * Timer routines
 */

stc_control(bvalue)
byte bvalue;
{
	register byte *stc_control_port = (byte *)STC_CONTROL_IO;
	wait_uart();
	*stc_control_port = bvalue;
}

stc_data(svalue)
ushort svalue;
{
	register ushort *stc_data_port = (ushort *)STC_DATA_IO;
	wait_uart();
	*stc_data_port = svalue;
}


#ifndef raise_lower		/* GJS */
/*
* raise or lower the flash eprom voltage
*/
VppUp()
{
	set_ctrl1(CTRL1_VPP, VPP_ON);
	FlashDelay10Ms();		/* wait for voltage to ramp up */
}

VppDown()
{
	set_ctrl1(CTRL1_VPP, VPP_OFF);
}

#else

RaiseVoltage()
{
	set_ctrl1(CTRL1_VPP, VPP_ON);
	FlashDelay10Ms();		/* wait for voltage to ramp up */
}

LowerVoltage()
{
	set_ctrl1(CTRL1_VPP, VPP_OFF);
}
#endif		/* GJS */

init_nmi(char * addr)
{
	register int *int_loc;

	int_loc = (int *)0;

	*int_loc = ram_int_table[248 + 1] = (word)addr;
}

int_nmi()
{
	Di();
	*(ushort *)SNCENA = (ushort)(DISABLE_NVR | ENABLE_SYS_WDT | DISABLE_BUS_WDT);
	error();
	/* ##### to be implemented later */
}

NmiInt_c()
{
	register SYS *sys_ptr = &sys;

	Dip_reset();
	if (sys_ptr->sys_switch & DIP_DEBUG_ON)
	{
		debg = 0;
		enter_debug();
		debg = 1;
	}
	else
	{
		fault_cnt = 1;
		printf("\nPush Button Reset\n");
		fault_cnt = 0;
		inc_reset_type();
		apl.run_appl = APPL_RESET;
		reset();
	}
}


/*
 *
 *  addr = is the address of the int routine
 *  int_num = 0 to 7
 *  vect = 18 34 50 66 82 98 114 130 146 162 178 194 210 226 242
 */

init_hw_int(int int_num, int vect, char * addr)
{
	register int *int_loc;
	register word imap;

	if ((int_num < 0) && (int_num > 7))
		return;

	disable_imsk(1 << int_num);

	int_loc = (int *)(4 + (int_num * 4));

	*int_loc = ram_int_table[vect + 1] = (word)addr;

	imap = vect & 0x000000f0;

	switch (int_num)
	{
	case 0:
		ram_control_table[4] |= (imap >> 4);
		break;
	case 1:
		ram_control_table[4] |= (imap);
		break;
	case 2:
		ram_control_table[4] |= (imap << 4);
		break;
	case 3:
		ram_control_table[4] |= (imap << 8);
		break;
	case 4:
		ram_control_table[5] |= (imap >> 4);
		break;
	case 5:
		ram_control_table[5] |= (imap);
		break;
	case 6:
		ram_control_table[5] |= (imap << 4);
		break;
	case 7:
		ram_control_table[5] |= (imap << 8);
		break;
	}
	send_sysctl(0x401, 0, 0);
	clear_ipnd(1 << int_num);
	enable_imsk(1 << int_num);
}


clr_hw_int(int int_num)
{
	if ((int_num < 0) && (int_num > 7))
		return;

	clear_ipnd(1 << int_num);
	disable_imsk(1 << int_num);
	switch (int_num)
	{
	case 0:
		ram_control_table[4] &= 0xfffffff0;
		break;
	case 1:
		ram_control_table[4] &= 0xffffff0f;
		break;
	case 2:
		ram_control_table[4] &= 0xfffff0ff;
		break;
	case 3:
		ram_control_table[4] &= 0xffff0fff;
		break;
	case 4:
		ram_control_table[5] &= 0xfff0ffff;
		break;
	case 5:
		ram_control_table[5] &= 0xff0fffff;
		break;
	case 6:
		ram_control_table[5] &= 0xf0ffffff;
		break;
	case 7:
		ram_control_table[5] &= 0x0fffffff;
		break;
	}
	send_sysctl(0x401, 0, 0);
}

GetDipBaud()

	{
	int	baud;

	switch (sys.sys_switch & DIP_BAUD_MASK)
		{
		case DIP_BAUD_1200:
				baud = BCODE_1200;
				break;
		case DIP_BAUD_2400:
				baud = BCODE_2400;
				break;
		case DIP_BAUD_4800:
				baud = BCODE_4800;
				break;
		case DIP_BAUD1_9600:
				baud = BCODE_9600;
				break;
		}
	return baud;
	}

EnableSonic(int port)
	{
	uint	PortMask;
	uint	PortMode;

	switch (port)
		{
		case 0:
			PortMask = CTRL1_LR0;
			PortMode = ENABLE_LR0;
			break;

		case 1:
			PortMask = CTRL1_LR1;
			PortMode = ENABLE_LR1;
			break;
		case 2:
			PortMask = CTRL1_LR2;
			PortMode = ENABLE_LR2;
			break;
		case 3:
			PortMask = CTRL1_LR3;
			PortMode = ENABLE_LR3;
			break;
		default:
			/*
			 *	we support up to 3 so far
			 */
			return;
		}
	set_ctrl1(PortMask, PortMode);
	}

DisableSonic(int port)
	{
	uint	PortMask;
	uint	PortMode;

	switch (port)
		{
		case 0:
			PortMask = CTRL1_LR0;
			PortMode = DISABLE_LR0;
			break;

		case 1:
			PortMask = CTRL1_LR1;
			PortMode = DISABLE_LR1;
			break;
		case 2:
			PortMask = CTRL1_LR2;
			PortMode = DISABLE_LR2;
			break;
		case 3:
			PortMask = CTRL1_LR3;
			PortMode = DISABLE_LR3;
			break;
		default:
			/*
			 *	we support up to 3 so far
			 */
			return;
		}
	set_ctrl1(PortMask, PortMode);
	}

EnableNvram()
	{
	/*
	 *	reset a bit to disable the lock on eeprom.
	 */
	set_ctrl1(CTRL1_NVR, ENABLE_NVR);	
	}

DisableNvram()
	{
	set_ctrl1(CTRL1_NVR, DISABLE_NVR);	
	}

EnableEeProm()
	{
	set_ctrl1(CTRL1_EEPROM, ENABLE_EEPROM);	
	}

DisableEeProm()
	{
	set_ctrl1(CTRL1_EEPROM, DISABLE_EEPROM);	
	}

/************************************************/
/* Reset Board                         		*/
/************************************************/

reset()
{
	CloseTelnet();
	AdmConClose(0);
	AdmFuncardReset();
	PHY_Isolate(0);
	PHY_Isolate(1);
	/* reset using watch dog timer */
	Di();
	log_reset();
	set_ctrl1(CTRL1_SYS_WDT, ENABLE_SYS_WDT);
	for(;;)
	;
}

/*
** Function to reset the box.  This is similar to the function above
** except that the log_reset() is not called
**
*/
reset_brg()
{
	CloseTelnet();
	AdmConClose(0);
	AdmFuncardReset();
	PHY_Isolate(0);
	PHY_Isolate(1);
	/* reset using watch dog timer */
	Di();
	set_ctrl1(CTRL1_SYS_WDT, ENABLE_SYS_WDT);
	for(;;)
	;
}
/*
 *	Print a character if the 
 *	Debugging switch is on.
 */
void debugc(c)
int	c;

	{
	if (Dip_read() & DIP_DEBUG_ON)
		putchar(c);
	}

Nop()
{
	return 0;
}


SaveEepBoot()
	{
	int	err;

	err = PutEeprom(EEP_BOOT_ADDR, &eep_boot_rec, EEP_BOOT_SIZE);
	if (err != EEPROM_AOK)
		printf("EEPROM error %d: Cannot save the BOOT record to EEPROM\n");
	return err;
	}


TransceiverType()

	{
	return ~Dip_read() & TRANSCEIVER_TYPE_MASK;
	}

/* for sonic driver utility */

snc_gen_flk_led(value)
word value;
{
  flk_led(LED_MONO,value);
}

fill_snc_flk_tx(flick_tx)
word *flick_tx;
{
  flick_tx[0] = LED_TX1;
  flick_tx[1] = LED_TX2;
  flick_tx[2] = LED_TX3;
#ifdef notdef		/* gjs */
  flick_tx[3] = LED_TX4;
#endif
}

fill_snc_flk_rx(flick_rx)
word *flick_rx;
{
  flick_rx[0] = LED_RX1;
  flick_rx[1] = LED_RX2;
  flick_rx[2] = LED_RX3;
#ifdef notdef		/* gjs */
  flick_rx[3] = LED_RX4;
#endif
}

InitAbort()
{
	flush();
	ErrorAbort();
}

ErrorAbort(int err_no)
	{
extern int led_test_in_progress;
	Di();
	fault_cnt = 1;
	printf("\nProgram aborted\n");
	set_leds(LED_BI, LED_ACT | LED_RDY, LED_ACT_RED | LED_RDY_RED);
	disable_wdt();
	led_test_in_progress = 1;
	for(;;)
		{
		SetSegDisp_E();
		sec_delay();
		set_leds(LED_BI, LED_BI_COLOR, LED_RDY_OFF|LED_ACT_OFF);
		set_leds(LED_BI, LED_BI_COLOR, LED_RDY_OFF|LED_ACT_RED);

		if(err_no > 9)
			Set7SegLed(1);
		else
			Set7SegLed(err_no);
		sec_delay();
		set_leds(LED_BI, LED_BI_COLOR, LED_RDY_OFF|LED_ACT_OFF);
		set_leds(LED_BI, LED_BI_COLOR, LED_ACT_OFF|LED_RDY_RED);
		if(err_no > 9)
			Set7SegLed(err_no-10);
		sec_delay();
		}
	}

SetSegDisp_E()
{
	
	register SYS	*sys_ptr = &sys;
	register word	val;

	val = sys_ptr->sys_ledsg & 0x1;
	val = (SLED_BAR_6|SLED_BAR_5);
	val |= ~(SLED_BAR_1 | SLED_BAR_2 | SLED_BAR_3 | SLED_BAR_4 | SLED_BAR_7);
	sys_ptr->sys_ledsg = val;

	*(byte *)TR_SLED_REG = val;
	return 0;
}

Display7Seg(int err_no)
{
	SetSegDisp_E();
	sec_delay();
	if(err_no > 9)
	{
		Set7SegLed(1);
		sec_delay();
		Set7SegLed(err_no-10);
		sec_delay();
	}
	else
	{
		Set7SegLed(err_no);
		sec_delay();
	}
}
	
	
