#include <types.h>
#include <malloc.h>
#include <krnl.h>

Header shbase;
Header *shfreep ;

initshmalloc(start_addr,size)
char *start_addr;
int  size;
{
  int  freemem_size;
  Header *ptr;
  
  if(size > 0x4000)
    freemem_size = 0x4000 - (int) ((int)start_addr & 0x00000fff);
  else
    freemem_size = size;

  shbase.s.ptr = (Header *) start_addr;
  shbase.s.size = 0;
  shfreep = (Header *) start_addr;
  shfreep->s.size = freemem_size/sizeof(Header)  - 1;
  shfreep->s.ptr = &shbase;

  /* this routine divides the memory into 4k chunks and frees them back */
  size -= freemem_size;
  start_addr += freemem_size;
  while(size > 0)
    {
      if(size > 0x1000)
	freemem_size = 0x1000;
      else
	freemem_size = size;
      size -= freemem_size;
      
      memset(start_addr,0,freemem_size);
      ptr = (Header *)start_addr;
      ptr ->s.size = freemem_size/sizeof(Header) - 1; /* leave holes */
      ptr->s.marker = MALLOC_MARKER;
      shfree(ptr + 1);
      start_addr += freemem_size;
    }
}

void *shmalloc(unsigned int nbytes)
{
   register ulong saveMask;
   Header *p,*prevp;
   unsigned nunits;

   MaskAllInts(saveMask);
   nunits = (nbytes + sizeof(Header)-1)/sizeof(Header) +1;
   prevp = shfreep;

   for (p = prevp->s.ptr;;prevp = p, p = p->s.ptr) 
     {
      if (p->s.size >= nunits) 
	{ /* big enough */
	  if (p->s.size == nunits) /* exactly */
	    {
	      prevp->s.ptr = p->s.ptr;
	    }
	  else {  /*allocate tail end */
	    p->s.size -= nunits;
	    p += p->s.size;
	    p->s.size = nunits;
	  }
	  shfreep = prevp;
	  /********************************************/
	  p->s.marker = MALLOC_MARKER;
	  /********************************************/
	  RestoreIntMask(saveMask);
	  return (void*)(p+1);
	}
      if (p == shfreep)	/* wrap around */
	{
		RestoreIntMask(saveMask);
		/* enter_debug(0x1bad55,nbytes, shfreep);  */ 
		return NULL;
	}
    }
	RestoreIntMask(saveMask);
	return NULL;
 }



void shfree(void *ap)
{
   Header *bp, *p;
   int	count = 0;
   register ulong saveMask;
   

   MaskAllInts(saveMask);
   bp = (Header *)ap - 1;
   /***********************************/
   if(bp->s.marker != MALLOC_MARKER)
     enter_debug(0xbbbb,bp,ap);
   /***********************************/
   for (p=shfreep ,count=0; !(bp > p && bp < p->s.ptr); p = p->s.ptr,count++)
   {
      if (p >= p->s.ptr && (bp > p || bp < p->s.ptr))
	 break;
   }
	
   if (bp + bp->s.size == p->s.ptr) { /* join to upper */
      bp->s.size += p->s.ptr->s.size;
      bp->s.ptr = p->s.ptr->s.ptr;
   } else
      bp->s.ptr = p->s.ptr;
   if (p + p->s.size == bp) { /* join to lower */
      p->s.size += bp->s.size;
      p->s.ptr = bp->s.ptr;
   } else
      p->s.ptr = bp;
   shfreep = p;
   RestoreIntMask(saveMask);
 }

