/**
 *	Program Name:	nim960 bridge
 *	
 *	Filename:	testutil.c
 *
 *	$Log:   /b/gregs/bridge/tester/testutil.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 09:22:56   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 09:45:14   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:25:58   franks
 * Initial revision.
 * 
 *    Rev 1.1   10 Apr 1992 16:44:50   kwok
 * Remove some '\n' on PrintManuRecord such that the information will
 * no scroll off the screen.
 * 
 *    Rev 1.0   30 Mar 1992 17:42:32   pvcs
 * Initial revision.
 *
 *	Comments:	utility functions for the TESTER
 *
 *	Copyright (c) 1992 by Hughes LAN Systems
 */

#include <types.h>
#include <eeprecs.h>
#include <sys.h>

char *inet_ntoa(in_name);
char *NidToString(byte *);
/*
 *	PrintManuRecord	- print out the manufacturer record.
 */
PrintManuRecord(EEP_MFG *MfgRec)

	{

	printf("Manufacturer data:\n");
	printf("S/N: %05d", MfgRec->eep_srlno);
	p_date("\tMfg date:", MfgRec->eep_mfgdt);
	p_date("\tFCO date:", MfgRec->eep_altdt);
	printf("\tRev Level: %d.%d\n", 
		MfgRec->eep_level >> 8, 
		MfgRec->eep_level & 0xff);
	printf("Configured size of:\n");
	printf("\tSRAM:  %6d KB\tDRAM:  %6d KB\tSHRAM: %6d KB\n",
	MfgRec->eep_sram_size / 1024,
		MfgRec->eep_dram_size / 1024,
		MfgRec->eep_shram_size / 1024);
	printf("\tNVRAM: %6d KB\tEEPROM:%6d KB\tFEPROM:%6d KB\n",
		MfgRec->eep_nvram_size / 1024,
		MfgRec->eep_eeprom_size / 1024,
		MfgRec->eep_fprom_size / 1024);
	}

PrintMacAddress()
	{
	int	port;
	unsigned char	*nid;

	printf("MAC addresses:\n");
	for (port = 0; port < NO_OF_PORTS; port++)
		{
		nid = (byte *)&sys.sys_nid[port];
		printf("\tPort %d: %s",	port + 1, NidToString(nid));
		if ((port & 1) != 0)
			putchar('\n');
		}
	}

p_date(str, date)
char		*str; 	/* tag */
unsigned	 date;	/* date */
	{
	char *m;

	switch(date & 0x0f)
		{
	case 0: m = "Jan"; break;
	case 1: m = "Feb"; break;
	case 2: m = "Mar"; break;
	case 3: m = "Apr"; break;
	case 4: m = "May"; break;
	case 5: m = "Jun"; break;
	case 6: m = "Jul"; break;
	case 7: m = "Aug"; break;
	case 8: m = "Sep"; break;
	case 9: m = "Oct"; break;
	case 10:m = "Nov"; break;
	case 11:m = "Dec"; break;
	default:m = "###";
		}
	printf("%s %s %d", str, m, 1990 + (date >> 4));
	}

Port4Status()
{
	return (word)eep_boot_rec.eep_ThinNet;
}


Port4Config(status)
word status;
{

	if (eep_boot_rec.eep_ThinNet != status)
		{
		eep_boot_rec.eep_ThinNet = (ushort)status;
		SaveEepBoot();
		}
	if (eep_boot_rec.eep_ThinNet)
		set_ctrl1(CTRL1_ETHER, ENABLE_THINET);
	else
		set_ctrl1(CTRL1_ETHER , DISABLE_THINET);

}

