
/**
 *	Program Name:	nim960 bridge
 *
 *	Filename:	testeeprom.c
 *
 *	$Log:   /b/gregs/bridge/tester/testeeprom.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 09:22:54   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 09:45:10   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:25:56   franks
 * Initial revision.
 * 
 *    Rev 1.0   30 Mar 1992 17:42:30   pvcs
 * Initial revision.
 *
 *	Comments:
 *	
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/

#include <types.h>
#include <memory.h>
#include <eeprecs.h>

unsigned char *TestEepromPage(unsigned char *PageAddress);
unsigned char *TestEepromLock(unsigned char *LastPage);

/*
 *	Test the Eeprom
 */
int TestEeprom()

	{
	unsigned char	*ErrorAddress;
	unsigned short	checksum;
	unsigned char	*LastPage;	/*	of eeprom 	*/

	/*
	 *	Manufacturer record
	 */
	EEP_MFG	*MfgPtr = &eep_mfg_rec; 
#ifdef kwok
	/*
	 *	Check for the record checksum
	 */
	if (MfgPtr->eep_marker != EEP_MARKER)
		{
		printf("EEPROM error: Invalid manufacturer record at %X\n",
			MfgPtr);
		return 1;
		}
	checksum = cksum(MfgPtr, sizeof(EEP_MFG) >> 1);
	if (checksum != 0 && checksum != 0xffff)
		{
		printf("EEPROM error: Manufacturer checksum error at %X\n", 
			MfgPtr->eep_checksum);
		return 1;
		}
#endif
	/*
	 *	Test the last page only.
	 */
	LastPage = (unsigned char *)EEPROM + MfgPtr->eep_eeprom_size
			- EEP_PAGE_SIZE;
	if ((ErrorAddress = TestEepromPage(LastPage)) != NULL)
		{
		printf("EEPROM error: address %X\n", ErrorAddress);
		return 1;
		}
	if ((ErrorAddress = TestEepromLock(LastPage)) != NULL)
		{
		printf("\nEEPROM error: Protection circuitry failed\n");
		return 1;
		}
	return 0;
	}

unsigned char *TestEepromPage(unsigned char *PageAddress)

	{
	volatile char *address = (volatile char *)PageAddress;
	unsigned  char	pattern = 0x55;
	int	RecordSize;	/* in number of words	*/
	int	i;

	for (i = 0; i < 2; i++)
		{
		if (i == 1)
			{
			/*
			 *	pattern is different for the 2nd pass
			 */
			pattern = 0xaa;			
			}
		RecordSize = EEP_PAGE_SIZE;
		/*
		 *	Write to the page
		 */
		EnableEeProm();
		Di();
		while(RecordSize--)
			*address++ = (char)pattern;
		Ei();
		DisableEeProm();
		delay(2);	/* wait a bit	*/
		RecordSize = EEP_PAGE_SIZE;
		/*
		 *	restore the address
		 */
		address = (volatile char *)PageAddress;
		while(RecordSize--)
			{
			if (*address++ != pattern)
				return (unsigned char *)address - 1;
			}
		address = (volatile char *)PageAddress;
		}
	return NULL;
	}

unsigned char *TestEepromLock(unsigned char *LastPage)

	{
	unsigned char	data[EEP_PAGE_SIZE];
	int	RecordSize;
	int	i;

	/*
	 *	Save the original data
	 */
	memcpy(data, LastPage, EEP_PAGE_SIZE);
	/*
	 *	Write to the eeprom without releasing the lock.
	 */
	DisableEeProm();	/* make sure it is disabled	*/
	Di();
	for (RecordSize = 0; RecordSize < EEP_PAGE_SIZE; RecordSize++)
		{
		LastPage[RecordSize] = ~data[RecordSize];
		}
	Ei();
	delay(2);
	/*
	 *	Since we have not release the lock, the data should 
	 *	not be changed at all.
	 */
	for (RecordSize = 0; RecordSize < EEP_PAGE_SIZE; RecordSize++)
		{
		if (LastPage[RecordSize] != data[RecordSize])
			{
			/*
			 *	If the record has been changed,
			 *	then we restore the data.
			 */
			Di();
			for (i = 0; i < EEP_PAGE_SIZE; i++)
				LastPage[i] = data[i];
			Ei();
			return LastPage + RecordSize;
			}
		}
	return NULL;
	}
