
/**
 *	Program Name:	nim960 bridge
 *
 *	Filename:	test.c
 *
 *	$Log:   /b/gregs/bridge/tester/test.c_v  $
 * 
 *    Rev 1.4   12 Oct 1993 09:22:52   franks
 * No change.
 * 
 *    Rev 1.3   01 Oct 1993 14:00:54   gregs
 * Added LoopBackMode arg to chnl_test call.
 * 
 *    Rev 1.2   29 Sep 1993 09:45:08   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 10:35:54   vinay
 * added routine to test the 7seg disp, modified sonic test routine
 * 
 *    Rev 1.0   30 Jul 1993 13:25:54   franks
 * Initial revision.
 * 
 *    Rev 1.1   10 Apr 1992 16:43:30   kwok
 * DIP 9 - 16 display is removed.
 * 
 *    Rev 1.0   30 Mar 1992 17:42:30   pvcs
 * Initial revision.
 *
 *	Comments:
 *	
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/


#include <types.h>
#include <memory.h>
#include <eeprecs.h>
#include <dips.h>
#include <led.h>
#include <nim960h.h>
#include <uart.h>
#include <sonic.h>

extern	void *lmalloc();
volatile int tmr_flag;

extern tmrInt();
extern usecInt();
extern TimeTicksInt();
extern TimeSliceInt();

unsigned char *TestEepromPage(unsigned char *PageAddress);
char *inet_ntoa(in_name ip);

/*
 *	Dram testing
 */

int TestDram()

	{
	int retcode;

	/*******************************************************************
	The booter occupies the area of DRAM from BOOT_AREA_START to
	BOOT_AREA_END.  First we test the DRAM area below the booter,
	then, if there is RAM beyond the boot area, we test that. 
	*******************************************************************/

	retcode=RamTest(DRAM, BOOT_AREA_START - DRAM, "DRAM");
	if(retcode == 0  &&  eep_mfg_rec.eep_dram_size > BOOT_AREA_END - DRAM )
		retcode=RamTest(BOOT_AREA_END, eep_mfg_rec.eep_dram_size +
				DRAM - BOOT_AREA_END, "DRAM");
	return retcode;
	}

/* This test is quicker and is used as the POST */
int TestDramQuick()
{
	int retcode;

	/* The booter occupies the area of DRAM from BOOT_AREA_START to
		BOOT_AREA_END.  First we test the DRAM area below the booter,
		then, if there is RAM beyond the boot area, we test that. */
	retcode=RamWordAddressTest(DRAM, BOOT_AREA_START - DRAM);
	if(retcode == 0  &&  eep_mfg_rec.eep_dram_size > BOOT_AREA_END - DRAM )
		retcode=RamWordAddressTest(BOOT_AREA_END, eep_mfg_rec.eep_dram_size +
				DRAM - BOOT_AREA_END);
	return retcode;
}

/*
 *	Static ram test
 */
int TestSram()

	{
	return RamTest(SRAM+SMALLOC_SIZE, eep_mfg_rec.eep_sram_size-SMALLOC_SIZE, "SRAM");
	}
/*
 *	Shared ram test
 */
int TestSharedRam()

	{

	return RamTest(SHRAM, eep_mfg_rec.eep_shram_size, "SHRAM");
	}
/*
 *	Admin bus ram test
 */
int TestAdminBus()

	{
	return RamTest(ADMRAM, ADMRAM_SIZE, "ADMIN");
	}

int PostTestAdminBus()
	{
	return RamTest(ADMRAM + 1024, ADMRAM_SIZE - 1024, "ADMIN");
	}

/*
 *	7 Segment display Test
 */
int Test7SegDisp()
{
	int i;
	printf("\t (please watch the 7 segment display for numbers 0x0 - 0xf)\n");
	
	for(i = 0 ; i <= 0x0f ; i++)
	{
		Set7SegLed(i);
		delay(50);
	}
	return 0;
}
	
/*
 * 	TestUart - display the tty sequence
 */
int TestUart()
	{
	int	i;
	int	j;
	int	ret;
#ifdef 0
	if ((ret = uart_test(CONSOLE)) != 0)
		return ret;
	if ((ret = uart_test(SLIP_PORT)) != 0)
		return ret;
	return 0;
#endif
	/* preamble */
	printf("\t (please watch the terminal for ascii characters\n");
	printf("\t\t  0x20 - 0x7f, repeated 2 times)\n\n");
	/*
	 *	give the remote console a chance to run, if active,
	 *	in order to print the message.
	 */
	delay(200);	/* let person read the message */

	/* test */
	for (j = 0; j < 2; j++)
		{
		for (i = 0x20; i < 0x80; i++)
			putchar(i);
		putchar('\n');
		}
	printf("\n\n");

	/* postamble */
	delay(200);	/* let person examine the characters */
	return 0;
	}


/*
 * 	TestDips - display the dip pattern on the screen
 */

int TestDips()
	{
	int	dipval;	/*	dips pattern	*/
	int	i;

	/* preamble */
	dipval = Dip_reset();
	printf("\n\n\n");
	printf("\t         DIP  SWITCH  SETTINGS   2      \n");
	printf("\t  1    2    3    4    5    6    7    8\n");
	printf("\t");
	for (i = 0x80; i > 0 ; i /= 2)
		printf((dipval & i) ? " ON  " : "     ");
	printf("\n\t");
	for (i = 0x80; i > 0; i /= 2)
		printf((dipval & i) ? "     " : " OFF ");
	printf("\n\n");
	printf("\t         DIP  SWITCH  SETTINGS   1     \n");
	printf("\t  1    2    3    4    5    6    7    8\n");
	printf("\t");
	printf(" NA  ");
	for (i = 0x4000; i > 0xff; i= i/2)
	{
		if(i & 0x1000)
			printf(" NA  ");
		else
			printf((dipval & i) ? " ON  " : "     ");
	}
	printf("\n\t");
	printf("     ");
	for (i = 0x4000; i > 0xff; i =  i / 2)
	{
		if(i & 0x1000)
			printf("     ");
		else
			printf((dipval & i) ? "     " : " OFF ");
	}
	printf("\n\n");
	return 0;
	}

/*
 *	DRAM Refresh test.
 */
int TestRefresh()
	{
	EEP_MFG	*MfgPtr = &eep_mfg_rec; 
	volatile unsigned 	*address;
	volatile unsigned	*data;
	int	size;
	int 	i,j;
	int	DelaySeconds = 30;	/* 30 seconds	*/

	printf("(This test takes approximately 30 seconds)\n");
	/*
	 *	give the remote console a chance to run, if active,
	 *	in order to print the message.
	 */
	flush();
	/*
	 *	In here, we assume that there will be at least 1 K
	 *	of free dram above the heap.  In order to save memory as
	 *	we cannot free up the memory after "lmalloc", we ask for
	 *	1 byte of memory but assume that there will be at least
	 *	1 K byte of free dram. This is wrong but it works to
	 *	some extend as when the testing is running, no other
	 *	program is active.
	 */
	address = (unsigned *)malloc(0);/* get some unused dram for testing */
	data = address;		/* save the testing area	*/
	size = 256;		/* test for 1 K		*/

	while(size--)
		{
		*address = (unsigned)address;
		address--;
		}

	/*
	 *	wait for about 30 seconds
	 */
	while(DelaySeconds--)
		{
		delay(100);
		putchar('.');
		}
	putchar('\n');

	address = (unsigned *)data;
	size = 256;
	while(size--)
		{
		if (*address != (unsigned)address)
			{
			printf("Error: Dynamic RAM refresh failure\n");
			return 1;
			}
		address--;
		}
	return 0;
	}

/*
 * 	TestLeds - display the led sequence
 */

int TestLeds()
	{
	printf("\t (please watch the leds for test pattern)\n");
	delay(50);	/* let user read the above message */
	test_led();
	/*
	 *	give the remote console a chance to run, if active,
	 *	in order to print the message.
	 */
	return 0;
	}
/*
 *	system configuration display
 */
int TestConfig()
	{
	EEP_MFG		*MfgRec;	/* manufacturer record	*/
	EEP_BOOT	*BootRec;	/* boot record		*/
	byte		*nid;		/* ethernet address	*/
	int		port;		/* which port 0 - 3	*/

	MfgRec = &eep_mfg_rec; 
	BootRec = &eep_boot_rec; 

	PrintHdr();
	printf("\n");
	if (MfgRec->eep_marker != EEP_MARKER)
		printf("Error: The manufacturer record is invalid\n\n");
	else
		{
		PrintManuRecord(MfgRec);
		PrintMacAddress();
		}
	/*
	 *	Display the boot record, i.e. my ip address, server ip
	 *	tftp file ...etc.
	 */
	if (BootRec == NULL)
		printf("Error: The boot record is invalid\n\n");
	else
		{
		PrintBootRecord(BootRec);
		}
	}
TestTimer()

	{
	if (tmr_test(0, 1) != 0 || tmr_test(1, 1))
		return 1;
	return 0;
	}
/*
 *	return 1 to abort the sonic test
 */
static TestPortAbort()
	{
	/*
	 *	Abort if a key has been pressed
	 */
	return getch() == -1 ? 0 : 1;
	}
	
/*
 *	Loopback test on the sonic
 *		portlist - 0x1, 0x02, 0x04 0x08 for port 1 to 4
 *		LoopBackMode - 	0x01 for internal loopback.
 *				0x02 for external loopback;
 *				0x00 for both internal and external loopback
 */
TestPort(int PortList, int LoopBackMode)

	{
	int	result;	/* return from son_test	*/
	int	i;	/* counter	*/
	int	CurrentPort;
	int	port = 0;
	int	PortsFailed = 0;
	int	IsPortFailed;

	snc_malloc(3);
	chnl_clear();
	/*
	 *	0x00 for both internal and external loopback.
	 *	0x00 for all ports
	 */
	if (PortList == 0)
		PortList = 0x0f;
	if (LoopBackMode == 0)
		LoopBackMode = 0x03;	
	PortList &= 0x0f;	/* make sure there is no more than 4 ports */

	CurrentPort = 0x1;
	
	while(port < 3)
		{
			
		if(CurrentPort & PortList)
		{
			result = chnl_test(port, LoopBackMode);
			if (result != 0)
				{
				IsPortFailed++;
				}
		}
		CurrentPort <<= 1;
		port++;
#ifdef 0
		IsPortFailed = 0;
		/*
		 *	Carry on with the next port if the 
		 *	current port test is not enabled.
		 */
		if ((PortList & CurrentPort) == 0)
			continue;

		if ((LoopBackMode & 0x01) != 0)
			{
			/*
			 *	Internal loopback is requested
			 */
			  switch(port)
			    {
			    case 1:
			      result = chnl_test(0,1,100,TestPortAbort,
						 0x50000000,0x70000080);
			      break;
			    case 2:
			      result = chnl_test(1,1,100,TestPortAbort,
						 0x50010000,0x70000100);
			      break;
			    case 3:
			      result = chnl_test(2,1,100,TestPortAbort,
						 0x50020000,0x70000180);
			      break;
			    case 4:
#ifdef 0
			      result = chnl_test(3,1,100,TestPortAbort,
						 0x50030000,0x70000000);
#endif
			      break;
			    }
			if (result != 0)
				{
				IsPortFailed++;
				}
			}
		if ((LoopBackMode & 0x02) != 0)
			{
			/*
			 *	External loopback is requested
			 */
			  switch(port)
			    {
			    case 1:
			      result = chnl_test(0,2,100,TestPortAbort,
						 0x50000000,0x70000080);
			      break;
			    case 2:
			      result = chnl_test(1,2,100,TestPortAbort,
						 0x50010000,0x70000100);
			      break;
			    case 3:
			      result = chnl_test(2,2,100,TestPortAbort,
						 0x50020000,0x70000180);
			      break;
#ifdef 0
			    case 4:
			      result = chnl_test(3,2,100,TestPortAbort,
						 0x50030000,0x70000000);
			      break;
#endif
			    }
			if (result != 0)
				{
				IsPortFailed++;
				}
			}
#endif
		if (IsPortFailed != 0)
			PortsFailed++;
		}
	return PortsFailed;
	}

TestExit()
	{
	return 0;
	}



tmr_test(tmr, krnl_running)
int tmr;
int krnl_running;
{
	int i, vect;

#ifdef notdef
	Di();
	stop_timers();
#endif
	Ei();

	tmr_flag = 0;

	/* some places the timers are numbered 0 to 2, other places 1 to 3 */
	if (tmr >= 0  &&  tmr <= 2 )	/* if legal timer no. */
	{
#ifdef notdef
		Init_timers();
#endif
		prog_timers(tmr+1, tmrInt, 2, 1);
	}
#ifdef notdef
	if (tmr == 0)
	{
		Init_timers();
		prog_timers(1, tmrInt, 2, 1);
	}
	else if (tmr == 1)
	{
		Init_timers();
		prog_timers(2, tmrInt, 2, 1);
	}
#endif
	else
	{
		tmr_error(tmr, "Unknown timer specified\n");
		return 1;
	}

	for (i = 0; i != 0x4000; i++)
		if (tmr_flag != 0)
			break;

	if (tmr_flag == 0)
	{
		tmr_error(tmr, "No timer Interrupt\n");
		return 1;
	}

	Di();
	if (krnl_running)
	{
		/* Di(); */
		stop_timers();
		InitKrnlTimers();
		Ei();
	}
	return 0;
}



tmr_error(tmr, str)
int tmr;
char *str;
{
	clr_hw_int(tmr);
	printf("ERROR TIMER %d : ", tmr);
	printf(str);
}

