
/**
 *	Program Name:	nim960 bridge
 *
 *	Filename:	eepedit.c
 *
 *	$Log:   /b/gregs/bridge/tester/eepedit.c_v  $
 * 
 *    Rev 1.2   12 Oct 1993 09:22:40   franks
 * No change.
 * 
 *    Rev 1.1   29 Sep 1993 09:44:58   franks
 * No change.
 * 
 *    Rev 1.0   30 Jul 1993 13:25:46   franks
 * Initial revision.
 * 
 *    Rev 1.1   10 Apr 1992 16:42:16   kwok
 * Remove some '\n' on displaying the boot record and the manufacuturer
 * record such that the information will not scroll off the screen.
 * 
 *    Rev 1.0   30 Mar 1992 17:42:22   pvcs
 * Initial revision.
 *
 *	Comments:	The eeprom editor
 *	
 *	Copyright (c) 1992 by Hughes LAN Systems
 **/


#include <types.h>
#include <eeprecs.h>
#include <sys.h>

extern AskYesNo(char *message);


/*
 *	choices item number for the manufacturer record
 */

#define	MFG_MFG_DATE	1
#define	MFG_MFG_ALTDT	2
#define	MFG_SERIAL	3
#define	MFG_LEVEL	4
#define	MFG_SRAM_SIZE	5
#define	MFG_DRAM_SIZE	6
#define	MFG_SHRAM_SIZE	7
#define	MFG_NVRAM_SIZE	8
#define	MFG_EEPROM_SIZE	9
#define	MFG_FPROM_SIZE	10
#define	MFG_PORT1_ADDR	11
#define	MFG_PORT2_ADDR	12
#define	MFG_PORT3_ADDR	13
#define	MFG_PORT4_ADDR	14

#define	MAX_MFG_ITEMS	14	/* there are 14 choices + exit	*/
/*
 *	choices for the boot records
 */
#define	BOOT_MY_IP		1
#define	BOOT_SERVER_IP		2
#define	BOOT_SUBNET_MASK	3
#define	BOOT_ROUTER1_IP		4
#define	BOOT_ROUTER2_IP		5	
#define	BOOT_REQUEST_FILE	6
#define	BOOT_CONFIG_FILE	7	
#define	BOOT_IMAGE_FILE		8	
#define	BOOT_TIME_SERVER_IP	9
#define	BOOT_TIME_OFFSET	10
#define	BOOT_BURN_DATE		11
#define	BOOT_BURN_TIME		12
#define	BOOT_AUI_PORT		13
#define	BOOT_LOCAL_CONFIG	14
#define	BOOT_HUB_ID		15
#define	BOOT_SLOT_ID		16
#define BOOT_RING_NUMBER 	17
#define	MAX_BOOT_ITEMS	17	/* there are 13 choices + exit	*/


#define	EEP_MFG_RECORD	1
#define EEP_BOOT_RECORD	2

#define EEP_RECORD_NUMBER	3

static	byte	eep_dirty[EEP_RECORD_NUMBER];

EEP_MFG		my_eep_mfg_rec; 	/* manufacturer record	*/
EEP_BOOT	my_eep_boot_rec;	/* boot record		*/

/*
 *	Read all records to myram
 */
eeedit_init()

	{
	memcpy(&my_eep_mfg_rec, &eep_mfg_rec, EEP_MFG_SIZE);
	memcpy(&my_eep_boot_rec, &eep_boot_rec, EEP_BOOT_SIZE);
	}
/*
 *	Display what are the records in eeprom
 */	
eeedit_show()

	{
	printf("There are 2 records in the eeprom:\n\n");
	printf("1) Manufacturer record - READ ONLY \n");
	printf("2) Boot record\n");
	return 0;
	}


eeedit_clear(int dummy1, int argc, int RecordNumber)

	{
	switch(RecordNumber)
		{
		case 1:
			/*
			 *	Manufacturer record
			 */
			printf("\nError: the manufacturer record is READ ONLY\n\n");
			break;
		case 2:
			/*
			 *	Boot record
			 */
			memset(&my_eep_boot_rec, 0, sizeof(EEP_BOOT));
			break;
		default:
			/*
			 * 	Error: out of range
			 */
			printf("Error: record number is out of range\n");
			break;
		}
	return 0;
	}

eeedit_update(int dummy1, int argc, int RecordNumber)

	{
	int	size;
	unsigned int	eep;	/* address to be updated	*/
	volatile unsigned *ram;	/* ram copy of the record	*/
	void	*eep_rec;
	int	error_code;

	switch(RecordNumber)
		{
	case 0:
		break;
	case 1:
		printf("Error: Manufacturer record is READ ONLY\n");
		return 0;
/********
		if (eep_dirty[RecordNumber] == 0)
			{
			printf("Manufacturer record has not been modified:\n");
			printf("Update will not be performed.\n");
			return;
			}
		printf("Updating the manufacturer record.\n");
		eep = EEP_MFG_ADDR;
		ram = (volatile unsigned *) &my_eep_mfg_rec;
		size = sizeof(EEP_MFG);	
		my_eep_mfg_rec.eep_marker = EEP_MARKER;
		eep_rec = &eep_mfg_rec;
*********/

	case 2:
		if (eep_dirty[RecordNumber] == 0)
			{
			printf("Boot record has not been modified:\n");
			printf("Update will not be performed.\n");
			return;
			}
		printf("Updating the boot record.\n");
		eep = EEP_BOOT_ADDR;
		ram = (volatile unsigned *) &my_eep_boot_rec;
		size = EEP_BOOT_SIZE;
		my_eep_boot_rec.eep_marker = EEP_MARKER;
		eep_rec = &eep_boot_rec;
		break;

	default:
		printf("Error: Invalid Entry\n");
		return 0;
		}
	if ((error_code = PutEeprom(eep, ram, size)) != EEPROM_AOK)
		printf("Error %d: cannot update eeprom\n", error_code);
	else 
		{
		/*
		 *	copy the modified record to the
		 *	RAM copy, which is will be used by 
		 *	the application.
		 */
		memcpy(eep_rec, ram, size);	
		eep_dirty[RecordNumber] = 0;
		}
	return 0;
	}

/*
 *	Display the records in the eeprom.
 */
eeedit_display(int dummy1, int argc, int RecordNumber)

	{
	char	buffer[80];
	int	item;
	char	c;

	switch(RecordNumber)
		{
	case 1:
	 	/*
	 	 *	Manufacturer record
	 	 */
	 	printf("The manufacturer record (READ ONLY) :-\n\n");
		PrintManuRecord(&my_eep_mfg_rec);
		PrintMacAddress();
		break;

	case 2:
		/*
		 *	Boot record
		 */
	
	 	printf("The boot record :\n\n");
		PrintBootRecord(&my_eep_boot_rec);
		memcpy(buffer, my_eep_boot_rec.eep_BurnDate, 8);
		buffer[8] = '\0';
		printf("%-27s%s\n", "Last Software update date:", buffer);
		memcpy(buffer, my_eep_boot_rec.eep_BurnTime, 8);
		buffer[8] = '\0';
		printf("%-27s%s\n", "Last Software update time:", buffer);
		printf("%-27s%s\n","BOOTP request mode:",  
			my_eep_boot_rec.eep_LocalConfig != 0 ? "disable" : "enable"); 
		printf("%-27s0x%04X\n", "Hub id:", 
			my_eep_boot_rec.eep_hubid);
		printf("%-27s%02d\n", "Slot id:",  
			my_eep_boot_rec.eep_slotid);
		printf("%-27s%02d\n", "FDDI Ring Number:",  
			my_eep_boot_rec.eep_ring_number);
		break;

	default:
		/*
		 * 	Error: out of range
		 */
		printf("Error: record number is out of range\n");
		break;
		}
	return 0;
	}

eeedit_edit(int dummy1, int argc, int RecordNumber)

	{
	int	choice;

	switch(RecordNumber)
		{
	case 1:
	 	/*
	 	 *	Manufacturer record
	 	 */
		printf("\nError: the manufacturer record is READ ONLY\n\n");
#ifdef kwok
	 	printf("Edit the manufacturer record :-\n");
		for (;;)
			{
		 	printf("\nThe manufacturer record edit menu :\n");
			EditMfgMenu(&my_eep_mfg_rec);
			choice = GetMenuItem(MAX_MFG_ITEMS + 1);
			if (choice == MAX_MFG_ITEMS + 1)
				{
				/*
				 *	exit
				 */
				 break;
				 }
			if (choice == -1)
				printf("Syntax error: please try again\n");
			else
				ModifyMfgRecord(&my_eep_mfg_rec, choice);
			}
#endif
		break;

	case 2:
		/*
		 *	Boot record
		 */
		for (;;)
			{
		 	printf("The boot record edit menu :\n");
			EditBootMenu(&my_eep_boot_rec);
			choice = GetMenuItem(MAX_BOOT_ITEMS + 1);
			if (choice == MAX_BOOT_ITEMS + 1)
				{
				/*
				 *	exit
				 */
				 break;
				 }
			if (choice == -1)
				printf("Syntax error: please try again\n");
			else
				ModifyBootRecord(&my_eep_boot_rec, choice);
			}
		break;
 	default:
		/*
		 * 	Error: out of range
		 */
		printf("Error: record number is out of range\n");
		break;
		}
	return 0;
	}

eeedit_exit()

	{
	int	yes;
/*****
	if (eep_dirty[EEP_MFG_RECORD] != 0)
		{
		yes = AskYesNo("The manufacturer record has not been updated.\nDo you want to exit (y/n) ?");
		return yes;
		}
*****/
	if (eep_dirty[EEP_BOOT_RECORD] != 0)
		{
		yes = AskYesNo("The boot record has not been updated.\nDo you want to exit (y/n) ?");
		return yes;
		}
	return 1;
	}

/***********
EditMfgMenu(EEP_MFG *MfgRec)
	{
	printf("%2d) Manufacturer date (%d.%d)\n", MFG_MFG_DATE, 
		(MfgRec->eep_mfgdt + 1) & 0x0f, 1990 + (MfgRec->eep_mfgdt >> 4));
	printf("%2d) Last alteration data (%d.%d)\n", MFG_MFG_ALTDT,
		(MfgRec->eep_altdt + 1) & 0x0f, 1990 + (MfgRec->eep_altdt >> 4));
	printf("%2d) Serial number (%05d)\n", MFG_SERIAL, 
		MfgRec->eep_srlno);
	printf("%2d) Revision level (%d.%d)\n", MFG_LEVEL, 
	 		MfgRec->eep_level >> 8, 
	 		MfgRec->eep_level & 0xff);
	printf("%2d) Static RAM size (%d Kbytes)\n", MFG_SRAM_SIZE,
		MfgRec->eep_sram_size / 1024);
	printf("%2d) Dynamic RAM size (%d Kbytes)\n", MFG_DRAM_SIZE,
		MfgRec->eep_dram_size / 1024);
	printf("%2d) Shared RAM size (%d Kbytes)\n", MFG_SHRAM_SIZE,
		MfgRec->eep_shram_size / 1024);
	printf("%2d) Non-volatile RAM size (%d Kbytes)\n", MFG_NVRAM_SIZE,
		MfgRec->eep_nvram_size / 1024);
	printf("%2d) EEPROM size (%d Kbytes)\n", MFG_EEPROM_SIZE,
		MfgRec->eep_eeprom_size / 1024);
	printf("%2d) Flash eprom size (%d Kbytes)\n", MFG_FPROM_SIZE,
		MfgRec->eep_fprom_size / 1024);
	printf("%2d) Port 1 Ethernet address (%s)", MFG_PORT1_ADDR,
		NidToString(&sys.sys_nid[0]));
	if (!IsStandalone())
		printf(" - READ ONLY -");
	putchar('\n');
	printf("%2d) Port 2 Ethernet address (%s)", MFG_PORT2_ADDR,
		NidToString(&sys.sys_nid[1]));
	if (!IsStandalone())
		printf(" - READ ONLY -");
	putchar('\n');
	printf("%2d) Port 3 Ethernet address (%s)", MFG_PORT3_ADDR,
		NidToString(&sys.sys_nid[2]));
	if (!IsStandalone())
		printf(" - READ ONLY -");
	putchar('\n');
	printf("%2d) Port 4 Ethernet address (%s)", MFG_PORT4_ADDR,
		NidToString(&sys.sys_nid[3]));
	if (!IsStandalone())
		printf(" - READ ONLY -");
	putchar('\n');
	printf("%2d) Exit\n", MAX_MFG_ITEMS + 1);
	}
***************/
EditBootMenu(EEP_BOOT *BootRec)

	{
	int	offset;
	char	buffer[10];

	printf("%2d) This station's IP address (%s)\n", BOOT_MY_IP,
		inet_ntoa(BootRec->eep_IP));
	printf("%2d) Server stations's IP address (%s)\n", BOOT_SERVER_IP,
		inet_ntoa(BootRec->eep_ServerIP));
	printf("%2d) This sub-net's IP net-mask (%s)\n", BOOT_SUBNET_MASK,
		inet_ntoa(BootRec->eep_NetMask));
	printf("%2d) IP primary router's IP address (%s)\n", BOOT_ROUTER1_IP,
		inet_ntoa(BootRec->eep_RouterIP[0]));
	printf("%2d) IP secondary router's IP address (%s)\n", BOOT_ROUTER2_IP,
		inet_ntoa(BootRec->eep_RouterIP[1]));
	printf("%2d) Boot request file name (%s)\n", BOOT_REQUEST_FILE,
		BootRec->eep_request_file);
	printf("%2d) Configuration file name (%s)\n", BOOT_CONFIG_FILE,
		BootRec->eep_config_file);
	printf("%2d) Load image file name (%s)\n", BOOT_IMAGE_FILE,
		BootRec->eep_image_file);
	printf("%2d) Time server stations's IP address (%s)\n", BOOT_TIME_SERVER_IP,
		inet_ntoa(BootRec->eep_TimeServer));
	printf("%2d) Local time offset (", BOOT_TIME_OFFSET);
	offset = BootRec->eep_OffsetGMT;
	if (offset < 0)
		{
		offset = 0 - offset;
		printf("-");
		}
	printf("%d hours %d minutes)\n", offset / (60 * 60), 
		(offset % (60 * 60)) / 60);
	memcpy(buffer, BootRec->eep_BurnDate, 8);
	buffer[8] = '\0';
	printf("%2d) Last Software update date (%s)\n", 
		BOOT_BURN_DATE, buffer);
	memcpy(buffer, BootRec->eep_BurnTime, 8);
	buffer[8] = '\0';
	printf("%2d) Last Software update time (%s)\n", 
		BOOT_BURN_TIME, buffer);
	printf("%2d) Load Application from ",BOOT_AUI_PORT); 
	if(BootRec->eep_ThinNet == 0)
		printf("(%s)\n","NETWORK"); 
	if(BootRec->eep_ThinNet == 1)
		printf("(%s)\n","FLASH"); 
	if(BootRec->eep_ThinNet == 2)
		printf("(%s)\n","Load from network & update flash"); 
		
	printf("%2d) BOOTP request mode (%s)\n", BOOT_LOCAL_CONFIG, 
		BootRec->eep_LocalConfig != 0 ? "disable" : "enable"); 
	printf("%2d) Hub id (0x%04X) - READ ONLY\n", BOOT_HUB_ID,  BootRec->eep_hubid);
	printf("%2d) Slot id (%02d)  - READ ONLY\n", BOOT_SLOT_ID,  BootRec->eep_slotid);
	printf("%2d) FDDI Ring Number (%d)\n", 
		BOOT_RING_NUMBER,BootRec->eep_ring_number); 
	printf("%2d) Exit\n", MAX_BOOT_ITEMS + 1);
	}


GetMenuItem(int MaxItem)

	{
	char	buffer[80];	/* for user input		*/
	int	item;		/* which item has been chosen	*/
	int	argc;		/* how many arguments have the user entered */
	char	c;		/* dummy for syntax checking	*/

	printf("\nWhich field do you want to modify (1 - %d) ==>", MaxItem);
	gets(buffer);
	argc = sscanf(buffer, "%d%c", &item, &c);
	if (argc == 0)
		return 0;
	if (argc != 1 || item > MaxItem)
		{
		/*
		 *	syntax error
		 */
		return -1;
		}
	return item;
	}

#ifdef kwok
ModifyMfgRecord(EEP_MFG	*MfgRec, int choice)

	{
	int	port = 0;	/* port 1, 2, 3, or 4	*/

	switch(choice)
		{
	case MFG_MFG_DATE:
		MfgRec->eep_mfgdt = AskDate("Enter the manufacturer date",
					MfgRec->eep_mfgdt);
		break;
		
	case MFG_MFG_ALTDT:
		MfgRec->eep_altdt = AskDate("Enter the last alteration date",
					MfgRec->eep_altdt);
		break;
	
	case MFG_SERIAL:
				
		MfgRec->eep_srlno = AskUnsigned("Enter the serial number",
					MfgRec->eep_srlno);
		break;
	
        case MFG_LEVEL:
		MfgRec->eep_level = AskLevel("Enter the revision level",
					MfgRec->eep_level);
		break;
	
	case MFG_SRAM_SIZE:
		MfgRec->eep_sram_size = AskUnsigned("Size of static ram in Kbytes",
						MfgRec->eep_sram_size / 1024) * 1024;
		break;

	case MFG_DRAM_SIZE:
		MfgRec->eep_dram_size = AskUnsigned("Size of dynamic ram in Kbytes",
						MfgRec->eep_dram_size / 1024) * 1024;
		break;


	case MFG_SHRAM_SIZE:
		MfgRec->eep_shram_size = AskUnsigned("Size of shared ram in Kbytes",
						MfgRec->eep_shram_size / 1024) * 1024;
		break;


	case MFG_NVRAM_SIZE:
		MfgRec->eep_nvram_size = AskUnsigned("Size of non-volatile ram in Kbytes",
						MfgRec->eep_nvram_size / 1024) * 1024;
		break;

	case MFG_EEPROM_SIZE:
		MfgRec->eep_eeprom_size = AskUnsigned("Size of eeprom in Kbytes",
						MfgRec->eep_eeprom_size / 1024) * 1024;
		break;


	case MFG_FPROM_SIZE:
		MfgRec->eep_fprom_size = AskUnsigned("Size of flash prom in Kbytes",
						MfgRec->eep_fprom_size / 1024) * 1024;
		break;


	case MFG_PORT1_ADDR:
		port = 1;

	case MFG_PORT2_ADDR:
		/*
		 *	If not fall through from above
		 *	set port to 2
		 */
		if (port == 0)
			port = 2;

	case MFG_PORT3_ADDR:
		/*
		 *	If not fall through from above
		 *	set port to 3
		 */
		if (port == 0)
			port = 3;

	case MFG_PORT4_ADDR:
		/*
		 *	If not fall through from above
		 *	set port to 4
		 */
		if (port == 0)
			port = 4;
		port--;
		/*
		 *	The Ethernet address can only be modified as a 
		 *	standaline product.
		 */
		if (IsStandalone())
			{	
			AskNid("Enter the Ethernet address ", &sys.sys_nid[port]);
			ncopy(&MfgRec->eep_nid[port], &sys.sys_nid[port]);
			}
		else
			{
			printf("Error: the Ethernet address cannot be modified\n");
			return;
			}
		break;
	default:
		return;
    		}
	eep_dirty[EEP_MFG_RECORD] = 1;

	}
#endif

ModifyBootRecord(EEP_BOOT *BootRec, int choice)

	{
	char	buffer[128];

	switch(choice)
		{
	case BOOT_MY_IP	:
		AskIP("Enter this station's IP address ", 
			&BootRec->eep_IP);
		break;

	case BOOT_SERVER_IP:
		AskIP("Enter the boot server station's IP address ", 
			&BootRec->eep_ServerIP);
		break;

	case BOOT_SUBNET_MASK:
		AskIP("Enter this sub-net's IP net-mask ", 
			&BootRec->eep_NetMask);
		break;

	case BOOT_ROUTER1_IP:
		AskIP("Enter the primary IP router address ", 
			&BootRec->eep_RouterIP[0]);
		break;

	case BOOT_ROUTER2_IP:
		AskIP("Enter the secondary IP router address ", 
			&BootRec->eep_RouterIP[1]);
		break;

	case BOOT_REQUEST_FILE:
		for (;;)
			{
			printf("Enter the request file name (%s) ==>",
				BootRec->eep_request_file[0] != '\0' ?
				BootRec->eep_request_file : "NULL");
			buffer[0] = '\0';
			gets(buffer);
			/*
			 *	Copy the file name if it has been entered.
			 */
			if (buffer[0] != '\0')
				{
				strcpy(BootRec->eep_request_file, buffer);
				break;
				}
			/*
			 *	or it's ok if user wants to keep the
			 *	original value.
			 */
			else if (BootRec->eep_request_file[0] != '\0')
				break;
			}
		break;
	case BOOT_CONFIG_FILE:
		for (;;)
			{
			printf("Enter the request file name (%s) ==>",
				BootRec->eep_config_file[0] != '\0' ?
				BootRec->eep_config_file : "NULL");
			buffer[0] = '\0';
			gets(buffer);
			/*
			 *	Copy the file name if it has been entered.
			 */
			if (buffer[0] != '\0')
				{
				strcpy(BootRec->eep_config_file, buffer);
				break;
				}
			/*
			 *	or it's ok if user wants to keep the
			 *	original value.
			 */
			else if (BootRec->eep_config_file[0] != '\0')
				break;
			}
		break;
	case BOOT_IMAGE_FILE:
		for (;;)
			{
			printf("Enter the image file name (%s) ==>",
				BootRec->eep_image_file[0] != '\0' ?
				BootRec->eep_image_file : "NULL");
			buffer[0] = '\0';
			gets(buffer);
			/*
			 *	Copy the file name if it has been entered.
			 */
			if (buffer[0] != '\0')
				{
				strcpy(BootRec->eep_image_file, buffer);
				break;
				}
			/*
			 *	or it's ok if user wants to keep the
			 *	original value.
			 */
			else if (BootRec->eep_image_file[0] != '\0')
				break;
			}
		break;

	case BOOT_TIME_SERVER_IP:
		AskIP("Enter the time server station's IP address ", 
			&BootRec->eep_TimeServer);
		break;

	case BOOT_TIME_OFFSET:
		BootRec->eep_OffsetGMT = AskTimeOffset("Enter the local time offset (hours:minutes) from GMT ",
			BootRec->eep_OffsetGMT);

		break;
	case BOOT_BURN_DATE:
		memcpy(buffer, BootRec->eep_BurnDate, 8);
		buffer[8] ='\0';
		AskBurnDate("Enter the last software update date(mm-dd-yy) ", 
			buffer);
		memcpy(BootRec->eep_BurnDate, buffer, 8);
		break;

	case BOOT_BURN_TIME:
		memcpy(buffer, BootRec->eep_BurnTime, 8);
		buffer[8] ='\0';
		AskBurnTime("Enter the last software update time(hh:mm:ss) ", 
			buffer);
		memcpy(BootRec->eep_BurnTime, buffer, 8);
		break;

	case BOOT_AUI_PORT:
	/*
	 * This is now used to store the info about FLASH Update.
	 */
		BootRec->eep_ThinNet = AskPort4Config("Application source:\n((0:Network)/(1:FLASH)/(2:Load from network & Update FLASH))",BootRec->eep_ThinNet);
			
		break;

	case BOOT_LOCAL_CONFIG:
		BootRec->eep_LocalConfig = !AskEnableDisable("BOOTP request on module boot up ((e)nable/(d)isable)", BootRec->eep_LocalConfig != 0 ? 'd' : 'e'); 
		break;
	case BOOT_HUB_ID:
	case BOOT_SLOT_ID:
		printf("\nError: this record is READ ONLY\n\n");
		break;

	case BOOT_RING_NUMBER:
		BootRec->eep_ring_number = AskRingNumber("FDDI Ring Number (0-14)",
			BootRec->eep_ring_number);
		break;
	default:
		return;
		}
	/*
	 *	Re-calculate the checksum as we have modified a field.
	 */
	eep_dirty[EEP_BOOT_RECORD] = 1;
	}

