#include <types.h>
#include <krnl.h>
#include <pkt.h>


#define NumberOfPkt  256
#if 1
int free_pkt_cnt;
#endif


extern PKT 	*FreePktHead;
PKT  	*pktstart_addr;
/******** MYDEBUG **********/
int pktPtrs[NumberOfPkt];
/***************************/
#if 1
PrintPktList ()
{
   int i;
   PKT *p;

   dprintf("free pkt %d\n",free_pkt_cnt);
   for (i = 1, p=FreePktHead; p; p = p->pktMsgHdr.mh_link, i++)
     dprintf("%d  , pkt %x, UseCnt %d\n",i,p,p->pktUseCount);
	
}
#endif


/************	MYDEBUG ***************
int freepktcnt = 0;
**************************************/

/* get an address record from the free list */
PKT *get_pkt()
{
	register PKT *pkt;
	register word saveMask;

	MaskAllInts(saveMask);

	if (pkt = FreePktHead) {
		FreePktHead = (PKT *)pkt->pktMsgHdr.mh_link;
        	(PKT *)pkt->pktMsgHdr.mh_link = 0;
		/****** MYDEBUG *****
		freepktcnt--;
		*****************************************/
	}

	RestoreIntMask(saveMask);
	return pkt;
}

/* put an address record back on the free list */
put_pkt(pkt)
register PKT *pkt;
{
	register word saveMask;

	MaskAllInts(saveMask);

	if (pkt->pktMsgHdr.mh_marker == PKT_MARKER)
	{

		pkt->pktMsgHdr.mh_link = (MSGHDR *)FreePktHead;
		FreePktHead = pkt;
		/****** MYDEBUG *****
		pkt->pktApplArea[3] = 0;
		freepktcnt++;
		if(freepktcnt > 256)
			enter_debug(0xbad1,freepktcnt);
		*****************************************/
	}

	RestoreIntMask(saveMask);
}


pktInit()
{
  	register i;
	PKT	*pkt;
	ulong	savePC;
  
	/* init the free list */
	FreePktHead = 0;
	pkt = pktstart_addr = (PKT *)smalloc( sizeof(PKT) * NumberOfPkt);

  	if(!pktstart_addr)
    	{
      		printf("smalloc of packet header structure fail\n");
      		return(-1);
    	}

	memset(pktstart_addr, 0, sizeof(PKT) * NumberOfPkt);

  	/* link it together */
  	for(i = 0; i < NumberOfPkt ; i++)
    	{
		/***** MYDEBUG ****/
		pktPtrs[i] = pkt;
		/******************/
		pkt->pktMsgHdr.mh_marker = PKT_MARKER;
		put_pkt(pkt++);
    	}
}

/* get an address record from the free list */
PKT *GetPkt()
{
  	register PKT *pkt;
  	extern int FreeThisPktBuf();
  	extern Nop();
	register word saveMask;

	MaskAllInts(saveMask);

	if(pkt = (PKT *)get_pkt())
    	{
		pkt->pktBufLink = NULL;
      		pkt->pktUseCount = 1;
      		pkt->pktFree = (void *)FreeThisPktBuf;
      		pkt->pktDriverFree = (void *)Nop;
      		pkt->pktDriverInfo = 0;
      		pkt->pktXmtPort = 0;
		RestoreIntMask(saveMask);
      		return(pkt);
    	}
	RestoreIntMask(saveMask);
  	return(NULL);
}

/* get packet header and associate buffer for share ram */ 
PKT *
GetShramPktBuf(size)
word size;
{
  	register PKT *pkt;
  	register char *pktbuff;
  	extern char *shmalloc();
  	extern int shfree();
  	extern int FreeThisPktBuf();
	register word saveMask;

	MaskAllInts(saveMask);
  
  	if( (pkt = GetPkt()) == NULL) {
		RestoreIntMask(saveMask);
    		return(NULL);
	}
  	if( (pktbuff = shmalloc(size)) == NULL)
    	{
      		FreePkt(pkt);
		RestoreIntMask(saveMask);
      		return(NULL);
    	}
  	/* initalize the packet header */
  	pkt->pktTotalSize = size;
  	pkt->pktBufLink = NULL;
  	pkt->pktBufPtr = pktbuff;
  	pkt->pktDataPtr = pktbuff;
  	pkt->pktBufLen = size;
  	pkt->pktDriverFree = (void *)shfree;
  	pkt->pktDriverInfo = (unsigned)pktbuff;
  	pkt->pktFree = (void *)FreeThisPktBuf;
	RestoreIntMask(saveMask);
  	return pkt;
}

PKT *
GetDramPktBuf(size)
word size;
{
  	register PKT *pkt;
  	register char *pktbuff;
  	extern char *malloc();
  	extern int free();
  	extern int FreeThisPktBuf();
  
  	if( (pkt = GetPkt()) == NULL)
    		return(NULL);
  	if( (pktbuff = malloc(size)) == NULL)
    	{
      		FreePkt(pkt);
      		return(NULL);
    	}
  	/* initalize the packet header */
  	pkt->pktTotalSize = size;
  	pkt->pktBufLink = NULL;
  	pkt->pktBufPtr = pktbuff;
  	pkt->pktDataPtr = pktbuff;
  	pkt->pktBufLen = size;
  	pkt->pktDriverFree = (void *)free;
  	pkt->pktDriverInfo = (unsigned)pktbuff;
  	pkt->pktFree = (void *)FreeThisPktBuf;
  	return pkt;
}

char *GetDramBuf(size)
word size;
{
  	register char *ptr;
  	extern char *malloc();

  	ptr = malloc(size);
  	return(ptr);
}

char *GetShramBuf(size)
word size;
{
  	register char *ptr;
  	extern char *shmalloc();
  
  	ptr = shmalloc(size);
  	return(ptr);
}

/* free packet header */
FreePkt(pkt)
PKT *pkt;
{
	register word saveMask;

	MaskAllInts(saveMask);

  	if(!(pkt->pktUseCount & 0xff)) {
		RestoreIntMask(saveMask);
    		enter_debug(0x2222,pkt);
		return;
	}

	pkt->pktUseCount -= 1;

  	if(!(pkt->pktUseCount & 0xff))    /* free it when no use count */
		put_pkt(pkt);

	RestoreIntMask(saveMask);
}

/* free one packet header and associated buffer */
FreeThisPktBuf(pkt)
PKT *pkt;
{
	register word saveMask;

	MaskAllInts(saveMask);

  	if(!(pkt->pktUseCount & 0xff)) {
		RestoreIntMask(saveMask);
    		enter_debug(0x2222,pkt);
		return;
	}
	pkt->pktUseCount -= 1;
  	if(!(pkt->pktUseCount & 0xff))    /* free it when no use count */
	{
  		pkt->pktDriverFree(pkt->pktDriverInfo);
		put_pkt(pkt);
	}

	RestoreIntMask(saveMask);
}

/* free the packet header and associated buffer in the chain */
FreePktBuf(pkt)
PKT *pkt;
{
	PKT *pkt1;
	register word saveMask;

	MaskAllInts(saveMask);

	do
	{
		pkt1 = pkt->pktBufLink;
  		pkt->pktFree(pkt);
	} while (pkt = pkt1);

	RestoreIntMask(saveMask);
}

FreeDramBuf(ptr)
char *ptr;
{
  	free(ptr);
}

FreeShramBuf(ptr)
char *ptr;
{
  	shfree(ptr);
}

PKT *PktCopy(PKT *pkt)
{

  	PKT *dup_pkt;
  	char *dup_buffer;
  	PKT *cp_pkt;
  	extern char *malloc();

  	if( (dup_pkt = GetPkt()) == NULL)
    		return((PKT *)NULL);
  	if( (dup_buffer = malloc(pkt->pktTotalSize)) == NULL)
    	{
      		FreePkt(dup_pkt);
      		return((PKT *)NULL);
    	}

  	dup_pkt->pktTotalSize = dup_pkt->pktDataSize = pkt->pktTotalSize;
  	dup_pkt->pktRcvPort   = pkt->pktRcvPort;
  	dup_pkt->pktBufPtr    = dup_pkt->pktDataPtr = dup_buffer;
  	dup_pkt->pktFree      = (void *)FreeThisPktBuf;
  	dup_pkt->pktDriverFree = (void *)FreeDramBuf;
  	dup_pkt->pktDriverInfo = (word)dup_buffer;
  	dup_pkt->pktProtocol = pkt->pktProtocol;
/*  	dup_pkt->pktType = pkt->pktType; */
  	for(cp_pkt = pkt; cp_pkt ; cp_pkt = cp_pkt->pktBufLink)
    	{
      		memcpy(dup_buffer, cp_pkt->pktDataPtr, cp_pkt->pktDataSize);
      		dup_buffer += cp_pkt->pktDataSize;
    	}
  	return dup_pkt;
}

PKT *PktShramCopy(PKT *pkt)
{

  	PKT *dup_pkt;
  	char *dup_buffer;
  	PKT *cp_pkt;
  	extern char *malloc();
  	extern int shfree();

  	if( (dup_pkt = GetPkt()) == NULL)
    	return(NULL);
  	if( (dup_buffer = (char *)shmalloc(pkt->pktTotalSize)) == NULL)
    	{
      		FreePkt(dup_pkt);
      		return(NULL);
    	}

  	dup_pkt->pktTotalSize = dup_pkt->pktDataSize = pkt->pktTotalSize;
  	dup_pkt->pktRcvPort   = pkt->pktRcvPort;
  	dup_pkt->pktBufPtr    = dup_pkt->pktDataPtr = dup_buffer;
  	dup_pkt->pktFree      = (void *)FreeThisPktBuf;
/*  	dup_pkt->pktType      = pkt->pktType; */
  	dup_pkt->pktDriverFree = (void *)shfree;
  	dup_pkt->pktDriverInfo = (word)dup_buffer;
  	for(cp_pkt = pkt; cp_pkt ; cp_pkt = cp_pkt->pktBufLink)
    	{
      		memcpy(dup_buffer, cp_pkt->pktDataPtr, cp_pkt->pktDataSize);
      		dup_buffer += cp_pkt->pktDataSize;
    	}
  	return dup_pkt;
}

/******************************************************************************/
Spcl_free_pkt(register PKT *pp) {

	register PKT *pkt_sav;
	register word saveMask;


	MaskAllInts(saveMask);
	while(pp)  {

		pp->pktUseCount--;	
		if(!((pp->pktUseCount) & 0xff)) {
		
			pkt_sav = pp;
			pp      = pkt_sav->pktBufLink;

			/* If pkt has a buffer */
			if( pkt_sav->pktDriverFree ) {
				/* Free the buffer. */
				pkt_sav->pktDriverFree(pkt_sav->pktDriverInfo);

				/* Free the pkt structure. */
				put_pkt(pkt_sav);

			}
			/* If pkt does not have a buffer */
			else  {
				/* Free the pkt structure. */
				put_pkt(pkt_sav);
			}
			
		}
		else  {
			pp = pp->pktBufLink;
		}
	}
	RestoreIntMask(saveMask);	
	return;
}
/******************************************************************************/

PKT *GetClonePkt(register PKT *pp)
{
register PKT *pkt;
  
  if( (pkt = GetPkt()) != (PKT *)NULL ) {

		pkt->pktBufLink    = pp->pktBufLink;
		pkt->pktDriverFree = pp->pktDriverFree;
		pkt->pktDriverInfo = pp->pktDriverInfo;
		pkt->pktTotalSize  = pp->pktTotalSize;
		pkt->pktBufPtr     = pp->pktBufPtr;
		pkt->pktBufLen     = pp->pktBufLen;
		pkt->pktDataPtr    = pp->pktDataPtr; 
		pkt->pktDataSize   = pp->pktDataSize;
		pkt->pktDriverLink = pp->pktDriverLink;
	
		return(pkt);
	}
	else
		return(NULL);
}
/******************************************************************************/

void chk_pkt() {

	PKT* ptr;
	int  pkt_cnt=0;
	int  Match, i;
	extern int pktPtrs[];
	
	for(i=0; i < NumberOfPkt; i++) {

		Match = FALSE;
	    for(ptr=FreePktHead; ptr; ptr=(PKT *)ptr->pktMsgHdr.mh_link)
	    {
			if( ptr == pktPtrs[i] ) {
				Match = TRUE;
				break;
			}
	    }

		if(!Match) {
			pkt_cnt++; 
			dprintf("\n%d PKT PTR: %x",pkt_cnt,pktPtrs[i]);
		}
	}

	dprintf("\nTotal Missing Pkts: %d\n", pkt_cnt);
}
