/**************************************************************************
 *  Copyright (c) 1992 Hughes LAN Systems                                 *
 *  All rights Reserved                                                   *
 *                                                                        *
 *  This file contains unpublished proprietary source code of Hughes LAN  *
 *  Systems.                                                              *
 **************************************************************************
                                                                           
   This file defines the MIB tree for FOURPORTBRIDGE-MIB
   It is directly derived from the MIB specification using the AWK program 
   'MIBPRSE.AWK'
   Should significant changes be needed in this file that are NOT          
   reflected back into the MIB specification, then modify this header to   
   indicate that this is the case.                                         
                                                                           
 *************************************************************************/

#include <target.h>
#include <priv_tbl.h>
#include <mib.h>
#include <libfuncs.h>
#include <asn1.h>
#include <syteksnm.h>
#include <multiPortBridge.h>

static MIBLEAF_T chPortState_leaf = LEAF( VT_NUMBER,RW,49,svc_chPortState );

static MIBLEAF_T chRestrictInboundUnicast_leaf = LEAF( VT_NUMBER,RW,49,svc_chRestrictInboundUnicast );

static MIBLEAF_T chRestrictInboundMulticast_leaf = LEAF( VT_NUMBER,RW,49,svc_chRestrictInboundMulticast );

static MIBLEAF_T chRestrictOutbound_leaf = LEAF( VT_NUMBER,RW,49,svc_chRestrictOutbound );

static MIBLEAF_T chPacketSize_leaf = LEAF( VT_NUMBER,RW,49,svc_chPacketSize );

static MIBLEAF_T chReceiveDeadmanTimer_leaf = LEAF( VT_NUMBER,RW,49,svc_chReceiveDeadmanTimer );

static MIBARC_T multiPortChannelEntry_arcs[] = { 
				ARC(2,chPortState_leaf),
				ARC(3,chRestrictInboundUnicast_leaf),
				ARC(4,chRestrictInboundMulticast_leaf),
				ARC(5,chRestrictOutbound_leaf),
				ARC(6,chPacketSize_leaf),
				ARC(7,chReceiveDeadmanTimer_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T multiPortChannelEntry_node = NODE (multiPortChannelEntry_arcs);

static MIBARC_T multiPortChannelTable_arcs[] = { 
				ARC(1,multiPortChannelEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T multiPortChannelTable_node = NODE (multiPortChannelTable_arcs);

static MIBLEAF_T multiPortProtocolFilterPort_leaf = LEAF( VT_NUMBER,RO,49,svc_multiPortProtocolFilterPort );

static MIBLEAF_T multiPortProtocolFilterMode_leaf = LEAF( VT_NUMBER,RW,49,svc_multiPortProtocolFilterMode );

static MIBLEAF_T multiPortProtocolFilterType_leaf = LEAF( VT_STRING,RW,49,svc_multiPortProtocolFilterType );

static MIBARC_T multiPortProtocolFilterEntry_arcs[] = { 
				ARC(1,multiPortProtocolFilterPort_leaf),
				ARC(2,multiPortProtocolFilterMode_leaf),
				ARC(3,multiPortProtocolFilterType_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T multiPortProtocolFilterEntry_node = NODE (multiPortProtocolFilterEntry_arcs);

static MIBARC_T multiPortProtocolFilterTable_arcs[] = { 
				ARC(1,multiPortProtocolFilterEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T multiPortProtocolFilterTable_node = NODE (multiPortProtocolFilterTable_arcs);

static MIBLEAF_T userDefinedProtocolDirectoryIndex_leaf = LEAF( VT_NUMBER,RO,49,svc_userDefinedProtocolDirectoryIndex );

static MIBLEAF_T userDefinedProtocolDirectoryType_leaf = LEAF( VT_NUMBER,RW,49,svc_userDefinedProtocolDirectoryType );

static MIBLEAF_T userDefinedProtocolDirectoryName_leaf = LEAF( VT_STRING,RW,49,svc_userDefinedProtocolDirectoryName );

static MIBARC_T userDefinedProtocolDirectoryEntry_arcs[] = { 
				ARC(1,userDefinedProtocolDirectoryIndex_leaf),
				ARC(2,userDefinedProtocolDirectoryType_leaf),
				ARC(3,userDefinedProtocolDirectoryName_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T userDefinedProtocolDirectoryEntry_node = NODE (userDefinedProtocolDirectoryEntry_arcs);

static MIBARC_T userDefinedProtocolDirectoryTable_arcs[] = { 
				ARC(1,userDefinedProtocolDirectoryEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T userDefinedProtocolDirectoryTable_node = NODE (userDefinedProtocolDirectoryTable_arcs);

static MIBLEAF_T bmaskDefIndex_leaf = LEAF( VT_STRING,RO,49,svc_bmaskDefIndex );

static MIBLEAF_T bmaskDefValue_leaf = LEAF( VT_STRING,RW,49,svc_bmaskDefValue );

static MIBLEAF_T bmaskDefOffset_leaf = LEAF( VT_NUMBER,RW,49,svc_bmaskDefOffset );

static MIBLEAF_T bmaskDefCurrentUses_leaf = LEAF( VT_NUMBER,RO,49,svc_bmaskDefCurrentUses );

static MIBLEAF_T bmaskDefStatus_leaf = LEAF( VT_NUMBER,RW,49,svc_bmaskDefStatus );

static MIBARC_T bmaskDefEntry_arcs[] = { 
				ARC(1,bmaskDefIndex_leaf),
				ARC(2,bmaskDefValue_leaf),
				ARC(3,bmaskDefOffset_leaf),
				ARC(4,bmaskDefCurrentUses_leaf),
				ARC(5,bmaskDefStatus_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T bmaskDefEntry_node = NODE (bmaskDefEntry_arcs);

static MIBARC_T bmaskDefTab_arcs[] = { 
				ARC(1,bmaskDefEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T bmaskDefTab_node = NODE (bmaskDefTab_arcs);

static MIBLEAF_T bMaskExpPort_leaf = LEAF( VT_NUMBER,RO,49,svc_bMaskExpPort );

static MIBLEAF_T bMaskExpMode_leaf = LEAF( VT_NUMBER,RW,49,svc_bMaskExpMode );

static MIBLEAF_T bMaskExpString_leaf = LEAF( VT_STRING,RW,49,svc_bMaskExpString );

static MIBARC_T bMaskExpEntry_arcs[] = { 
				ARC(1,bMaskExpPort_leaf),
				ARC(2,bMaskExpMode_leaf),
				ARC(3,bMaskExpString_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T bMaskExpEntry_node = NODE (bMaskExpEntry_arcs);

static MIBARC_T bMaskExpTab_arcs[] = { 
				ARC(1,bMaskExpEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T bMaskExpTab_node = NODE (bMaskExpTab_arcs);

extern multiPortEthernetBridge_node;

static MIBARC_T multiPortBridge_arcs[] = { 
				ARC(1,multiPortEthernetBridge_node),
				ARC(2,multiPortChannelTable_node),
				ARC(3,multiPortProtocolFilterTable_node),
				ARC(4,userDefinedProtocolDirectoryTable_node),
				ARC(5,bmaskDefTab_node),
				ARC(6,bMaskExpTab_node),
			END_OF_ARC_LIST};

	MIBNODE_T multiPortBridge_node = NODE (multiPortBridge_arcs);

