/**************************************************************************
 *  Copyright (c) 1992 Hughes LAN Systems                                 *
 *  All rights Reserved                                                   *
 *                                                                        *
 *  This file contains unpublished proprietary source code of Hughes LAN  *
 *  Systems.                                                              *
 **************************************************************************
                                                                           
   This file defines the MIB tree for FOURPORTBRIDGE-MIB
   It is directly derived from the MIB specification using the AWK program 
   'MIBPRSE.AWK'
   Should significant changes be needed in this file that are NOT          
   reflected back into the MIB specification, then modify this header to   
   indicate that this is the case.                                         
                                                                           
 *************************************************************************/

#include <target.h>
#include <priv_tbl.h>
#include <mib.h>
#include <libfuncs.h>
#include <asn1.h>
#include <syteksnm.h>
#include <fourPortBridge.h>

static MIBLEAF_T chPortState_leaf = LEAF( VT_NUMBER,RW,49,svc_chPortState );

static MIBLEAF_T chRestrictInboundUnicast_leaf = LEAF( VT_NUMBER,RW,49,svc_chRestrictInboundUnicast );

static MIBLEAF_T chRestrictInboundMulticast_leaf = LEAF( VT_NUMBER,RW,49,svc_chRestrictInboundMulticast );

static MIBLEAF_T chRestrictOutbound_leaf = LEAF( VT_NUMBER,RW,49,svc_chRestrictOutbound );

static MIBLEAF_T chPacketSize_leaf = LEAF( VT_NUMBER,RW,49,svc_chPacketSize );

static MIBLEAF_T chReceiveDeadmanTimer_leaf = LEAF( VT_NUMBER,RW,49,svc_chReceiveDeadmanTimer );

static MIBARC_T fourPortChannelEntry_arcs[] = { 
				ARC(2,chPortState_leaf),
				ARC(3,chRestrictInboundUnicast_leaf),
				ARC(4,chRestrictInboundMulticast_leaf),
				ARC(5,chRestrictOutbound_leaf),
				ARC(6,chPacketSize_leaf),
				ARC(7,chReceiveDeadmanTimer_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T fourPortChannelEntry_node = NODE (fourPortChannelEntry_arcs);

static MIBARC_T fourPortChannelTable_arcs[] = { 
				ARC(1,fourPortChannelEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T fourPortChannelTable_node = NODE (fourPortChannelTable_arcs);

static MIBLEAF_T fourPortProtocolFilterPort_leaf = LEAF( VT_NUMBER,RO,49,svc_fourPortProtocolFilterPort );

static MIBLEAF_T fourPortProtocolFilterMode_leaf = LEAF( VT_NUMBER,RW,49,svc_fourPortProtocolFilterMode );

static MIBLEAF_T fourPortProtocolFilterType_leaf = LEAF( VT_STRING,RW,49,svc_fourPortProtocolFilterType );

static MIBARC_T fourPortProtocolFilterEntry_arcs[] = { 
				ARC(1,fourPortProtocolFilterPort_leaf),
				ARC(2,fourPortProtocolFilterMode_leaf),
				ARC(3,fourPortProtocolFilterType_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T fourPortProtocolFilterEntry_node = NODE (fourPortProtocolFilterEntry_arcs);

static MIBARC_T fourPortProtocolFilterTable_arcs[] = { 
				ARC(1,fourPortProtocolFilterEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T fourPortProtocolFilterTable_node = NODE (fourPortProtocolFilterTable_arcs);

static MIBLEAF_T userDefinedProtocolDirectoryIndex_leaf = LEAF( VT_NUMBER,RO,49,svc_userDefinedProtocolDirectoryIndex );

static MIBLEAF_T userDefinedProtocolDirectoryType_leaf = LEAF( VT_NUMBER,RW,49,svc_userDefinedProtocolDirectoryType );

static MIBLEAF_T userDefinedProtocolDirectoryName_leaf = LEAF( VT_STRING,RW,49,svc_userDefinedProtocolDirectoryName );

static MIBARC_T userDefinedProtocolDirectoryEntry_arcs[] = { 
				ARC(1,userDefinedProtocolDirectoryIndex_leaf),
				ARC(2,userDefinedProtocolDirectoryType_leaf),
				ARC(3,userDefinedProtocolDirectoryName_leaf),
			END_OF_ARC_LIST};

static MIBNODE_T userDefinedProtocolDirectoryEntry_node = NODE (userDefinedProtocolDirectoryEntry_arcs);

static MIBARC_T userDefinedProtocolDirectoryTable_arcs[] = { 
				ARC(1,userDefinedProtocolDirectoryEntry_node),
			END_OF_ARC_LIST};

static MIBNODE_T userDefinedProtocolDirectoryTable_node = NODE (userDefinedProtocolDirectoryTable_arcs);

extern fourPortEthernetBridge_node;

static MIBARC_T fourPortBridge_arcs[] = { 
				ARC(1,fourPortEthernetBridge_node),
				ARC(2,fourPortChannelTable_node),
				ARC(3,fourPortProtocolFilterTable_node),
				ARC(4,userDefinedProtocolDirectoryTable_node),
			END_OF_ARC_LIST};

	MIBNODE_T fourPortBridge_node = NODE (fourPortBridge_arcs);

