
/**************************************************************************
* EDIT TRACK OF THIS MODULE -- snmpeth.c for 834           1-29-92        *
***************************************************************************
* ABSTRACT : This file contains the service routines for the Ethernet     *
*            Interface. Corresponds to Internet Draft "Ethernet-Like      *
*            Objects". 							  *
*									  *
*            $Log:   /b/gregs/bridge/snmp/routines/dot3.c_v  
 * 
 *    Rev 1.4   26 Oct 1993 17:21:02   vinay
 * fixed a crashing problem in TxEnabled snc_tx() parameters were not right
 * .
 * 
 *    Rev 1.3   11 Oct 1993 16:20:54   franks
 * Changed declaration of saveMask such that it is a register type.
 * 
 *    Rev 1.2   18 Aug 1993 18:17:46   vinay
 * changed the number of ethernet interfaces to 3 in all svcs'
 * 
 *    Rev 1.1   30 Jul 1993 13:29:14   vinay
 * changed TestTdrValue to return zero instead of nosuch
 * 
 *    Rev 1.0   20 Jul 1993 09:37:04   franks
 * Initial revision.
 * 
 *    Rev 1.1   11 May 1992 09:29:00   franks
 * No change.
 * 
 *    Rev 1.0   30 Mar 1992 17:37:30   pvcs
 * Initial revision.
*			 1). svc_dot3Index                                *
*			 2). svc_dot3InitMac	                          *
*        		 3). svc_dot3MacSubLayerStat		          *
*			 4). svc_dot3MultiCastRxStat		          *
*			 5). svc_dot3TxEnabled	                          *
*			 6). svc_dot3TestTdrValue	                  *
*			 7). svc_dot3StatsIndex				  *
*			 8). svc_dot3StatsAligErr                         *
*			 9). svc_dot3StatsFCSErr                          *
*			10). svc_dot3StatsSnglCollFrm                     *
*			11). svc_dot3StatsMultiCollFrm                    *
*			12). svc_dot3StatsSQETstErr                       *
*			13). svc_dot3StatsDeferTx                         *
*			14). svc_dot3StatsLateColl                        *
*			15). svc_dot3StatsExsColl                         *
*			16). svc_dot3StatsIntMacTxErr                     *
*			17). svc_dot3StatsCarrierSenseErr                 *
*			18). svc_dot3StatsExsDefer                        *
*			19). svc_dot3StatsFrmTooLongs                     *
*			20). svc_dot3StatsInRangeLenErr                   *
*			21). svc_dot3StatsOutOfRngLenFlds                 *
*			22). svc_dot3StatsIntMacRxErr                     *
*                       23). svc_dot3CollIndex                            *
*                       24). svc_dot3CollCount                            *
*                       25). svc_dot3CollFrequencies                      *

   This file contains the service routines for RFC1284-MIB
   It is directly derived from the MIB specification using the AWK program 
   'MIBSVC.AWK'
   Should significant changes be needed in this file that are NOT          
   reflected back into the MIB specification, then modify this header to   
   indicate that this is the case.                                         
                                                                           
***************************************************************************
* CopyRight (C)  Hughes LAN Systems			   1992           *
**************************************************************************/

#include <types.h> 
#include <target.h>
#include <krnl.h>
#include <dbd.h>
#include <snmp.h>
#include <asn1.h>
#include <syteksnm.h>
#include <prcctl.h>
#include <sonic.h>
#include <sncvar.h>

#include <memory.h>

#define CHNL_0      1
#define CHNL_1      2
#define CHNL_2      3
#define CHNL_3      4
#define LENGTH1     1
#define LENGTH2     2
#define LENGTH3		3	
#define LENGTH4     4

extern word snc_init;
/**************************************************************************
*  Procedure    :   svc_dot3Index
*  Path         :   1.3.6.1.2.1.10.7.1.1.1
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                  "An index value that uniquely identifies an
*                  interface to an ethernet-like medium.  The
*                  interface identified by a particular value of this
*                  index is the same interface as identified by the
*                  same value of ifIndex."
*
**************************************************************************/

int svc_dot3Index(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		  {
		    switch(*compl)
		      {
		      case CHNL_0:
			*(int  *)value = 1;   /* channel #0 */
			break;
			
		      case CHNL_1:
			*(int  *)value = 2;   /* channel #1 */
			break;
		      case CHNL_2:
			*(int  *)value = 3;
			break;
#ifndef _FEBRIDGE
		      case CHNL_3:
			*(int  *)value = 4;
			break;
#endif
		      default:
			return NO_SUCH_NAME;
		      }
			*lenp = LENGTH3;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot3InitializeMac
*  Path         :   1.3.6.1.2.1.10.7.1.1.2
*  Access       :   RW
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                  "The initialization status of the MAC and PLS
*                  (Physical Layer Signalling) subsystems for a
*                  particular interface. The value initialized(1)
*                  signifies that the subsystems for a particular
*                  interface have been previously initialized; the
*                  value uninitialized(2) signifies that they have
*                  not been previously initialized.
*  
*                  Each alteration of an instance of this object to
*                  either of the values initialized(1) or
*                  uninitialized(2) is analogous to an invocation of
*                  the initializeMAC action defined in [9] and has
*                  the effect of (re-)initializing the MAC and PLS
*                  subsystems for the associated interface. In
*                  particular,
*                       all management counters pertaining to the MAC
*                       and PLS subsystems for said interface are
*                       reset to zero;
*  
*                       the receive and transmit layer management
*                       state variables (receiveEnabled and
*                       transmitEnabled in [9]) are set to enable
*                       reception and transmission of frames;
*  
*                       the promiscuous receive function is disabled;
*                       and
*  
*                       multicast reception is disabled."
*
**************************************************************************/

int svc_dot3InitializeMac(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;
	register SV *svp;
	

	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
		  switch(*compl)
		    {
		    case CHNL_0:
		      svp = &sv_vars[0];
		      *value = svp->sv_init;
		      break;
		    case CHNL_1:
		      svp = &sv_vars[1];
		      *value = svp->sv_init;
		      break;
		    case CHNL_2:
		      svp = &sv_vars[2];
		      *value = svp->sv_init;
		      break;
#ifndef _FEBRIDGE
		    case CHNL_3:
		      svp = &sv_vars[3];
		      *value = svp->sv_init;
		      break;
#endif
		    }
		  *lenp = LENGTH3;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		{
		  switch(*compl)
		    {
		    case CHNL_0:
		      svp = &sv_vars[0];
			if(*value != svp->sv_init)
			{
			  sonic_reinit(0);
			}
		      break;
		    case CHNL_1:
		      svp = &sv_vars[1];
			if(*value != svp->sv_init)
			{
			  sonic_reinit(1);
			}
		      break;
		    case CHNL_2:
		      svp = &sv_vars[2];
			if(*value != svp->sv_init)
			{
			  sonic_reinit(2);
			}
		      break;
#ifndef _FEBRIDGE
		    case CHNL_3:
		      svp = &sv_vars[3];
			if(*value != svp->sv_init)
			  sonic_reinit(3);
		      break;
#endif
		    }
		}
		break;
	case SNMP_TEST:
		  return(rtn_code);
		  break;
	      }
	return(0);
      }

/**************************************************************************
*  Procedure    :   svc_dot3MacSubLayerStatus
*  Path         :   1.3.6.1.2.1.10.7.1.1.3
*  Access       :   RW
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                  "The operational status of the MAC sublayer for a
*                  particular interface.  The value enabled(1)
*                  signifies that the MAC sublayer for said interface
*                  is operational for both transmitting and receiving
*                  frames -- that is, that the value of both the
*                  receive and transmit layer management state
*                  variables (receiveEnabled and transmitEnabled in
*                  [9]) for said interface are true.  The value
*                  disabled(2) signifies that the MAC sublayer for
*                  said interface is not operational for either
*                  transmitting or receiving frames. In particular,
*                  the value of an instance of this object is
*                  disabled(2) whenever the value of the
*                  corresponding instance of the dot3Enabled object
*                  is false(2).
*  
*                  Each alteration of an instance of this object to
*                  the value enabled(1) is analogous to an invocation
*                  of the enableMACSublayer action defined in [9] and
*                  has the effect of starting normal transmit and
*                  receive operations (from the ``idle'' state) on
*                  the associated interface. In particular, such an
*                  alteration has the effect of resetting the PLS for
*                  said interface and of setting the receive and
*                  transmit layer management state variables
*                  (receiveEnabled and transmitEnabled in [9]) to be
*                  true.
*                  Each alteration of an instance of this object to
*                  the value disabled(2) is analogous to an
*                  invocation of the disableMACSublayer action
*                  defined in [9] and has the effect of terminating
*                  transmit and receive operations on the associated
*                  interface. In particular, such an alteration has
*                  the effect of setting the receive and transmit
*                  layer management state variables (receiveEnabled
*                  and transmitEnabled in [9]) to be false. Any
*                  transmissions/receptions in progress are completed
*                  before operation is terminated."
*
**************************************************************************/

int svc_dot3MacSubLayerStatus(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	register word saveMask;
	int rtn_code;
	register SV *svp;
	

	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
		  switch(*compl)
		    {
		    case CHNL_0:
		      svp = &sv_vars[0];
		      *(int *)value = svp->sv_init;
		      break;
		    case CHNL_1:
		      svp = &sv_vars[1];
		      *(int *)value = svp->sv_init;
		      break;
		    case CHNL_2:
		      svp = &sv_vars[2];
		      *(int *)value = svp->sv_init;
		      break;
#ifndef _FEBRIDGE
		    case CHNL_3:
		      svp = &sv_vars[3];
		      *(int *)value = svp->sv_init;
		      break;
#endif
		    }
		  *lenp = LENGTH3;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		{
		  MaskAllInts(saveMask);
		  switch(*compl)
		    {
		    case CHNL_0:
		      svp = &sv_vars[0];
		      snc_txrx(0,*value);
		      break;
		    case CHNL_1:
		      svp = &sv_vars[1];
		      snc_txrx(1,*value);
		      break;
		    case CHNL_2:
		      svp = &sv_vars[2];
		      snc_txrx(2,*value);
		      break;
#ifndef _FEBRIDGE
		    case CHNL_3:
		      svp = &sv_vars[3];
		      snc_txrx(3,*value);
		      break;
#endif
		    }
		  RestoreIntMask(saveMask);
		}
		break;
	case SNMP_TEST:
		return(rtn_code);
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot3MulticastReceiveStatus
*  Path         :   1.3.6.1.2.1.10.7.1.1.4
*  Access       :   RW
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                  "The multicast receive status for a particular
*                  interface.  The value enabled(1) signifies that
*                  reception of multicast frames by the MAC sublayer
*                  is enabled on said interface. The value
*                  disabled(2) signifies that reception of multicast
*                  frames by the MAC sublayer is not enabled on said
*                  interface.
*  
*                  Each alteration of an instance of this object to
*                  the value enabled(1) is analogous to an invocation
*                  of the enableMulticastReceive action defined in
*                  [9] and has the effect of enabling multicast frame
*                  reception on the associated interface. Actual
*                  reception of multicast frames is only possible on
*                  an interface when the values for the associated
*                  instances of the dot3MulticastReceiveStatus and
*                  dot3MacSubLayerStatus objects are enabled(1) and
*                  enabled(1), respectively.
*  
*                  Each alteration of an instance of this object to
*                  the value disabled(2) is analogous to an
*                  invocation of the disableMulticastReceive action
*                  defined in [9] and has the effect of inhibiting
*                  multicast frame reception on the associated
*                  interface."
*
**************************************************************************/

int svc_dot3MulticastReceiveStatus(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;
	register SV *svp;
	

	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
		  switch(*compl)
		    {
		    case CHNL_0:
		      svp = &sv_vars[0];
		      *value = svp->sv_multi;
		      break;
		    case CHNL_1:
		      svp = &sv_vars[1];
		      *value = svp->sv_multi;
		      break;
		    case CHNL_2:
		      svp = &sv_vars[2];
		      *value = svp->sv_multi;
		      break;
#ifndef _FEBRIDGE
		    case CHNL_3:
		      svp = &sv_vars[3];
		      *value = svp->sv_multi;
		      break;
#endif
		    }
		  *lenp = LENGTH3;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		{
		  switch(*compl)
		    {
		    case CHNL_0:
		      svp = &sv_vars[0];
		      svp->sv_multi=*value;
		      break;
		    case CHNL_1:
		      svp = &sv_vars[1];
		      svp->sv_multi=*value;
		      break;
		    case CHNL_2:
		      svp = &sv_vars[2];
		      svp->sv_multi=*value;
		      break;
#ifndef _FEBRIDGE
		    case CHNL_3:
		      svp = &sv_vars[3];
		      svp->sv_multi=*value;;
		      break;
#endif
		    }
		}
		break;
	case SNMP_TEST:
		return(rtn_code);
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot3TxEnabled
*  Path         :   1.3.6.1.2.1.10.7.1.1.5
*  Access       :   RW
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                  "The transmit layer management state variable
*                  (transmitEnabled as defined in [9]) for a
*                  particular interface.  The value true(1) signifies
*                  that the MAC frame transmission is enabled on said
*                  interface. The value false(2) signifies that the
*                  MAC frame transmission is inhibited on said
*                  interface. In particular, the value of an instance
*                  of this object is false(2) whenever the value of
*                  the corresponding instance of the
*                  dot3MacSubLayerStatus object is disabled(2).
*  
*                  Each alteration of an instance of this object to
*                  the value true(1) is analogous to an invocation of
*                  the enableTransmit action defined in [9] and has
*                  the effect of enabling MAC sublayer frame
*                  transmission on the associated interface. In
*                  particular, such an alteration has the effect of
*                  setting the transmit layer management state
*                  variable (transmitEnabled in [9]) for said
*                  interface to be true.
*  
*                  Each alteration of an instance of this object to
*                  the value false(2) is analogous to an invocation
*                  of the disableTransmit action defined in [9] and
*                  has the effect of inhibiting MAC sublayer frame
*                  transmission on the associated interface. In
*                  particular, such an alteration has the effect of
*                  setting the transmit layer management state
*                  variable (transmitEnabled in [9]) for said
*                  interface to be false. Any transmissions in
*                  progress are completed before transmission is
*                  inhibited."
*
**************************************************************************/

int svc_dot3TxEnabled(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;
	register SV *svp;
	
	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			switch(*compl)
			  {
			  case CHNL_0:
			    svp = &sv_vars[0];
			    *value = svp->sv_txen;
			    break;
			  case CHNL_1:
			    svp = &sv_vars[1];
			    *value = svp->sv_txen;
			    break;
			  case CHNL_2:
			    svp = &sv_vars[2];
			    *value = svp->sv_txen;
			    break;
#ifndef _FEBRIDGE
			  case CHNL_3:
			    svp = &sv_vars[3];
			    *value = svp->sv_txen;
			    break;
#endif
			  }
			*lenp = LENGTH3;
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		{
			switch(*compl)
			  {
			  case CHNL_0:
			    snc_tx(0,value);
			    break;
			  case CHNL_1:
			    snc_tx(1,value);
			    break;
			  case CHNL_2:
			    snc_tx(2,value);
			    break;
#ifndef _FEBRIDGE
			  case CHNL_3:
			    snc_tx(3,*value);
			    break;
#endif
			  }
		}
		break;
	case SNMP_TEST:
		return(rtn_code);
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot3TestTdrValue
*  Path         :   1.3.6.1.2.1.10.7.1.1.6
*  Access       :   RO
*  Syntax       :   Gauge VT_GAUGE
*  Description  :   
*                 "The number of 10 MHz ticks which elapsed between
*                 the beginning of a TDR measurement and the
*                 collision which ended it, for the most recently
*                 executed TDR test.  If no TDR test has been
*                 executed, or the last TDR value is not available,
*                this object has the value 0."
*
**************************************************************************/

int svc_dot3TestTdrValue(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) 0;/* CHANGE THIS TO ACTUAL GET */
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot3StatsIndex
*  Path         :   1.3.6.1.2.1.10.7.2.1.1
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                  "An index value that uniquely identifies an
*                  interface to an ethernet-like medium.  The
*                  interface identified by a particular value of this
*                  index is the same interface as identified by the
*                  same value of ifIndex."
*
**************************************************************************/

int svc_dot3StatsIndex(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;
	register SV *svp;
	

	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
		    switch(*compl)
		      {
		      case CHNL_0:
			*(int  *)value = 1;   /* channel #0 */
			break;
			
		      case CHNL_1:
			*(int  *)value = 2;   /* channel #1 */
			break;
		      case CHNL_2:
			*(int  *)value = 3;
			break;
#ifndef _FEBRIDGE
		      case CHNL_3:
			*(int  *)value = 4;
			break;
#endif
		      default:
			return NO_SUCH_NAME;
		      }
			*lenp=LENGTH3;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot3StatsAlignmentErrors
*  Path         :   1.3.6.1.2.1.10.7.2.1.2
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                  "A count of frames received on a particular
*                  interface that are not an integral number of
*                  octets in length and do not pass the FCS check.
*                  The count represented by an instance of this
*                  object is incremented when the alignmentError
*                  status is returned by the MAC service to the LLC
*                  (or other MAC user). Received frames for which
*                  multiple error conditions obtain are, according to
*                  the conventions of [9], counted exclusively
*                  according to the error status presented to the
*                  LLC."
*
**************************************************************************/

int svc_dot3StatsAlignmentErrors(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;
	register SV *svp;
	

	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			switch(*compl)  {

				case CHNL_0:
			                svp = &sv_vars[0];
					*value =svp->sv_aln;
					break;
				case CHNL_1:
			                svp = &sv_vars[1];
					*value =svp->sv_aln;
					break;
				case CHNL_2:
			                svp = &sv_vars[2];
					*value =svp->sv_aln;
					break;
#ifndef _FEBRIDGE
				case CHNL_3:
			                svp = &sv_vars[3];
					*value =svp->sv_aln;
					break;
#endif
				default:
					return NO_SUCH_NAME;
			}
			*lenp = LENGTH3;
			break;

		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot3StatsFCSErrors
*  Path         :   1.3.6.1.2.1.10.7.2.1.3
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                  "A count of frames received on a particular
*                  interface that are an integral number of octets in
*                  length but do not pass the FCS check.
*  
*                  The count represented by an instance of this
*                  object is incremented when the frameCheckError
*                  status is returned by the MAC service to the LLC
*                  (or other MAC user). Received frames for which
*                  multiple error conditions obtain are, according to
*                  the conventions of [9], counted exclusively
*                  according to the error status presented to the
*                  LLC."
*
**************************************************************************/

int svc_dot3StatsFCSErrors(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;
	register SV *svp;
	

	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
        case SNMP_GET:
		if (rtn_code == 0)
		{	
			switch(*compl)  {

				case CHNL_0:
			                svp = &sv_vars[0];
					*value =svp->sv_crc;
					break;
				case CHNL_1:
			                svp = &sv_vars[1];
					*value =svp->sv_crc;
					break;
				case CHNL_2:
			                svp = &sv_vars[2];
					*value =svp->sv_crc;
					break;
#ifndef _FEBRIDGE
				case CHNL_3:
			                svp = &sv_vars[3];
					*value =svp->sv_crc;
					break;
#endif
				default:
					return NO_SUCH_NAME;
			}
			*lenp=LENGTH3;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot3StatsSingleCollisionFrames
*  Path         :   1.3.6.1.2.1.10.7.2.1.4
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                  "A count of successfully transmitted frames on a
*                  particular interface for which transmission is
*                  inhibited by exactly one collision.
*  
*                  A frame that is counted by an instance of this
*                  object is also counted by the corresponding
*                  instance of either the ifOutUcastPkts or
*                  ifOutNUcastPkts object and is not counted by the
*                  corresponding instance of the
*                  dot3StatsMultipleCollisionFrames object."
*
**************************************************************************/

int svc_dot3StatsSingleCollisionFrames(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;
	register SV *svp;
	

	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			switch(*compl)  {

				case CHNL_0:
			               svp = &sv_vars[0];
				       *value =svp->sv_tx_scol;
				       break;
				case CHNL_1:
			               svp = &sv_vars[1];
				       *value =svp->sv_tx_scol;
				       break;
				case CHNL_2:
			               svp = &sv_vars[2];
				       *value =svp->sv_tx_scol;
				       break;
#ifndef _FEBRIDGE
				case CHNL_3:
			               svp = &sv_vars[3];
				       *value =svp->sv_tx_scol;
				       break;
#endif
				default:
					return NO_SUCH_NAME;
			}
			*lenp=LENGTH3;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot3StatsMultipleCollisionFrames
*  Path         :   1.3.6.1.2.1.10.7.2.1.5
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                  "A count of successfully transmitted frames on a
*                  particular interface for which transmission is
*                  inhibited by more than one collision.
*  
*                  A frame that is counted by an instance of this
*                  object is also counted by the corresponding
*                  instance of either the ifOutUcastPkts or
*                  ifOutNUcastPkts object and is not counted by the
*                  corresponding instance of the
*                  dot3StatsSingleCollisionFrames object."
*
**************************************************************************/

int svc_dot3StatsMultipleCollisionFrames(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;
	register SV *svp;
	

	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			switch(*compl)  {

				case CHNL_0:
			               svp = &sv_vars[0];
				       *value =svp->sv_tx_mcol;
				       break;
				case CHNL_1:
			               svp = &sv_vars[1];
				       *value =svp->sv_tx_mcol;
				       break;
				case CHNL_2:
			               svp = &sv_vars[2];
				       *value =svp->sv_tx_mcol;
				       break;
#ifndef _FEBRIDGE
				case CHNL_3:
			               svp = &sv_vars[3];
				       *value =svp->sv_tx_mcol;
				       break;
#endif
				default:
					return NO_SUCH_NAME;
			}
			*lenp=LENGTH3;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot3StatsSQETestErrors
*  Path         :   1.3.6.1.2.1.10.7.2.1.6
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                  "A count of times that the SQE TEST ERROR message
*                  is generated by the PLS sublayer for a particular
*                  interface. The SQE TEST ERROR message is defined
*                  in section 7.2.2.2.4 of [12] and its generation is
*                  described in section 7.2.4.6 of the same
*                  document."
*
**************************************************************************/

int svc_dot3StatsSQETestErrors(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	return NO_SUCH_NAME;       /* not support at this moment */
	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) -1;/* CHANGE THIS TO ACTUAL GET */
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot3StatsDeferredTransmissions
*  Path         :   1.3.6.1.2.1.10.7.2.1.7
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                  "A count of frames for which the first
*                  transmission attempt on a particular interface is
*                  delayed because the medium is busy.
*  
*                  The count represented by an instance of this
*                  object does not include frames involved in
*                  collisions."
*
**************************************************************************/

int svc_dot3StatsDeferredTransmissions(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;
	register SV *svp;
	

	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			switch(*compl)  {

				case CHNL_0:
			               svp = &sv_vars[0];
				       *value =svp->sv_tx_def;
				       break;
				case CHNL_1:
			               svp = &sv_vars[1];
				       *value =svp->sv_tx_def;
				       break;
				case CHNL_2:
			               svp = &sv_vars[2];
				       *value =svp->sv_tx_def;
				       break;
#ifndef _FEBRIDGE
				case CHNL_3:
			               svp = &sv_vars[3];
				       *value =svp->sv_tx_def;
				       break;
#endif
				default:
					return NO_SUCH_NAME;
			}
			*lenp=LENGTH3;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot3StatsLateCollisions
*  Path         :   1.3.6.1.2.1.10.7.2.1.8
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                  "The number of times that a collision is detected
*                  on a particular interface later than 512 bit-times
*                  into the transmission of a packet.
*  
*                  Five hundred and twelve bit-times corresponds to
*                  51.2 microseconds on a 10 Mbit/s system. A (late)
*                  collision included in a count represented by an
*                  instance of this object is also considered as a
*                  (generic) collision for purposes of other
*                  collision-related statistics."
*
**************************************************************************/

int svc_dot3StatsLateCollisions(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;
	register SV *svp;
	

	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			switch(*compl)  {

				case CHNL_0:
			               svp = &sv_vars[0];
				       *value =svp->sv_tx_owc;
				       break;
				case CHNL_1:
			               svp = &sv_vars[1];
				       *value =svp->sv_tx_owc;
				       break;
				case CHNL_2:
			               svp = &sv_vars[2];
				       *value =svp->sv_tx_owc;
				       break;
#ifndef _FEBRIDGE
				case CHNL_3:
			               svp = &sv_vars[3];
				       *value =svp->sv_tx_owc;
				       break;
#endif
				default:
					return NO_SUCH_NAME;
				     }
			*lenp=LENGTH3;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot3StatsExcessiveCollisions
*  Path         :   1.3.6.1.2.1.10.7.2.1.9
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                  "A count of frames for which transmission on a
*                  particular interface fails due to excessive
*                  collisions."
*
**************************************************************************/

int svc_dot3StatsExcessiveCollisions(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;
	register SV *svp;
	

	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			switch(*compl)  {

				case CHNL_0:
			               svp = &sv_vars[0];
				       *value =svp->sv_tx_exc;
				       break;
				case CHNL_1:
			               svp = &sv_vars[1];
				       *value =svp->sv_tx_exc;
				       break;
				case CHNL_2:
			               svp = &sv_vars[2];
				       *value =svp->sv_tx_exc;
				       break;
#ifndef _FEBRIDGE
				case CHNL_3:
			               svp = &sv_vars[3];
				       *value =svp->sv_tx_exc;
				       break;
#endif
				default:
					return NO_SUCH_NAME;
			}
			*lenp=LENGTH3;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot3StatsInternalMacTransmitErrors
*  Path         :   1.3.6.1.2.1.10.7.2.1.10
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                  "A count of frames for which transmission on a
*                  particular interface fails due to an internal MAC
*                  sublayer transmit error. A frame is only counted
*                  by an instance of this object if it is not counted
*                  by the corresponding instance of either the
*                  dot3StatsLateCollisions object, the
*                  dot3StatsExcessiveCollisions object, the
*                  dot3StatsCarrierSenseErrors object, or the
*                  dot3StatsExcessiveDeferrals object.
*  
*                  The precise meaning of the count represented by an
*                  instance of this object is implementation-
*                  specific.  In particular, an instance of this
*                  object may represent a count of transmission
*                  errors on a particular interface that are not
*                  otherwise counted."
*
**************************************************************************/

int svc_dot3StatsInternalMacTransmitErrors(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;
	register SV *svp;
	

	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			switch(*compl)  {

				case CHNL_0:
			               svp = &sv_vars[0];
				       *value =svp->sv_txfail;
				       break;
				case CHNL_1:
			               svp = &sv_vars[1];
				       *value =svp->sv_txfail;
				       break;
				case CHNL_2:
			               svp = &sv_vars[2];
				       *value =svp->sv_txfail;
				       break;
#ifndef _FEBRIDGE
				case CHNL_3:
			               svp = &sv_vars[3];
				       *value =svp->sv_txfail;
				       break;
#endif
				default:
					return NO_SUCH_NAME;
			}
			*lenp=LENGTH3;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot3StatsCarrierSenseErrors
*  Path         :   1.3.6.1.2.1.10.7.2.1.11
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                  "The number of times that the carrier sense
*                  condition was lost or never asserted when
*                  attempting to transmit a frame on a particular
*                  interface.
*  
*                  The count represented by an instance of this
*                  object is incremented at most once per
*                  transmission attempt, even if the carrier sense
*                  condition fluctuates during a transmission
*                  attempt."
*
**************************************************************************/

int svc_dot3StatsCarrierSenseErrors(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;
	register SV *svp;
	

	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			switch(*compl)  {

				case CHNL_0:
			               svp = &sv_vars[0];
				       *value =svp->sv_tx_crs;
				       break;
				case CHNL_1:
			               svp = &sv_vars[1];
				       *value =svp->sv_tx_crs;
				       break;
				case CHNL_2:
			               svp = &sv_vars[2];
				       *value =svp->sv_tx_crs;
				       break;
#ifndef _FEBRIDGE
				case CHNL_3:
			               svp = &sv_vars[3];
				       *value =svp->sv_tx_crs;
				       break;
#endif
				default:
					return NO_SUCH_NAME;
			}
			*lenp=LENGTH3;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot3StatsExcessiveDeferrals
*  Path         :   1.3.6.1.2.1.10.7.2.1.12
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                  "A count of frames for which transmission on a
*                  particular interface is deferred for an excessive
*                  period of time."
*
**************************************************************************/

int svc_dot3StatsExcessiveDeferrals(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;
	register SV *svp;
	

	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			switch(*compl)  {

				case CHNL_0:
			               svp = &sv_vars[0];
				       *value =svp->sv_tx_exd;
				       break;
				case CHNL_1:
			               svp = &sv_vars[1];
				       *value =svp->sv_tx_exd;
				       break;
				case CHNL_2:
			               svp = &sv_vars[2];
				       *value =svp->sv_tx_exd;
				       break;
#ifndef _FEBRIDGE
				case CHNL_3:
			               svp = &sv_vars[3];
				       *value =svp->sv_tx_exd;
				       break;
#endif
				default:
					return NO_SUCH_NAME;
			}
			*lenp=LENGTH3;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot3StatsFrameTooLongs
*  Path         :   1.3.6.1.2.1.10.7.2.1.13
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                  "A count of frames received on a particular
*                  interface that exceed the maximum permitted frame
*                  size.
*  
*                  The count represented by an instance of this
*                  object is incremented when the frameTooLong status
*                  is returned by the MAC service to the LLC (or
*                  other MAC user). Received frames for which
*                  multiple error conditions obtain are, according to
*                  the conventions of [9], counted exclusively
*                  according to the error status presented to the
*                  LLC."
*
**************************************************************************/

int svc_dot3StatsFrameTooLongs(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;
	register SV *svp;

	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			switch(*compl)  {

				case CHNL_0:
			               svp = &sv_vars[0];
				       *value =svp->sv_tx_exd;
				       break;
				case CHNL_1:
			               svp = &sv_vars[1];
				       *value =svp->sv_tx_exd;
				       break;
				case CHNL_2:
			               svp = &sv_vars[2];
				       *value =svp->sv_tx_exd;
				       break;
#ifndef _FEBRIDGE
				case CHNL_3:
			               svp = &sv_vars[3];
				       *value =svp->sv_tx_exd;
				       break;
#endif
				default:
					return NO_SUCH_NAME;
				     }
			*lenp=LENGTH3;
		      }
		else
			return NO_SUCH_NAME;
		break;
	      }
	return 0;
      }

/**************************************************************************
*  Procedure    :   svc_dot3StatsInRangeLengthErrors
*  Path         :   1.3.6.1.2.1.10.7.2.1.14
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                  "A count of frames received on a particular
*                  interface with a length field value that falls
*                  between the minimum unpadded LLC data size and the
*                  maximum allowed LLC data size inclusive and that
*                  does not match the number of LLC data octets
*                  received.
*  
*                  The count represented by an instance of this
*                  object also includes frames for which the length
*                  field value is less than the minimum unpadded LLC
*                  data size."
*
**************************************************************************/

int svc_dot3StatsInRangeLengthErrors(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;
	register SV *svp;

	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			switch(*compl)  {

				case CHNL_0:
			               svp = &sv_vars[0];
				       *value =svp->sv_txbcnt;
				       break;
				case CHNL_1:
			               svp = &sv_vars[1];
				       *value =svp->sv_txbcnt;
				       break;
				case CHNL_2:
			               svp = &sv_vars[2];
				       *value =svp->sv_txbcnt;
				       break;
#ifndef _FEBRIDGE
				case CHNL_3:
			               svp = &sv_vars[3];
				       *value =svp->sv_txbcnt;
				       break;
#endif
				default:
					return NO_SUCH_NAME;
			}
			*lenp=LENGTH3;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot3StatsOutOfRangeLengthFields
*  Path         :   1.3.6.1.2.1.10.7.2.1.15
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                  "A count of frames received on a particular
*                  interface for which the length field value exceeds
*                  the maximum allowed LLC data size.
*  
*                  The count represented by an instance of this
*                  object is not incremented in implementations that
*                  observe Ethernet encapsulation conventions (by
*                  which the IEEE 802.3 length field is interpreted
*                  as the Ethernet Type field)."
*
**************************************************************************/

int svc_dot3StatsOutOfRangeLengthFields(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) 0;/* CHANGE THIS TO ACTUAL GET */
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot3StatsInternalMacReceiveErrors
*  Path         :   1.3.6.1.2.1.10.7.2.1.16
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                  "A count of frames for which reception on a
*                  particular interface fails due to an internal MAC
*                  sublayer receive error. A frame is only counted by
*                  an instance of this object if it is not counted by
*                  the corresponding instance of either the
*                  dot3StatsFrameTooLongs object, the
*                  dot3StatsAlignmentErrors object, the
*                  dot3StatsFCSErrors object, the
*                  dot3StatsInRangeLengthErrors object, or the
*                  dot3StatsOutOfRangeLengthFields object.
*                  The precise meaning of the count represented by an
*                  instance of this object is implementation-
*                  specific.  In particular, an instance of this
*                  object may represent a count of receive errors on
*                  a particular interface that are not otherwise
*                  counted."
*
**************************************************************************/

int svc_dot3StatsInternalMacReceiveErrors(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;
	register SV *svp;
	

#ifdef 0
	return(NO_SUCH_NAME);
#endif
	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			switch(*compl)  {
#ifdef 0
				case CHNL_0:
			               svp = &sv_vars[0];
				       *value =svp->sv_rxfifo;
				       break;
				case CHNL_1:
			               svp = &sv_vars[1];
				       *value =svp->sv_rxfifo;
				       break;
				case CHNL_2:
			               svp = &sv_vars[2];
				       *value =svp->sv_rxfifo;
				       break;
#ifndef _FEBRIDGE
				case CHNL_3:
			               svp = &sv_vars[3];
				       *value =svp->sv_rxfifo;
				       break;
#endif
#endif
				case CHNL_0:
				case CHNL_1:
				case CHNL_2:
					*value = (UINT_32_T) 0;
					break;
				default:
					return NO_SUCH_NAME;
			}
			*lenp=LENGTH3;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot3CollIndex
*  Path         :   1.3.6.1.2.1.10.7.5.1.1
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                  "The index value that uniquely identifies the
*                  interface to which a particular collision
*                  histogram cell pertains.  The interface identified
*                  by a particular value of this index is the same
*                  interface as identified by the same value of
*                  ifIndex."
*
**************************************************************************/

int svc_dot3CollIndex(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	return(NO_SUCH_NAME);
	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
		    switch(*compl)
		      {
		      case CHNL_0:
			*(int  *)value = 1;   /* channel #0 */
			break;
			
		      case CHNL_1:
			*(int  *)value = 2;   /* channel #1 */
			break;
		      case CHNL_2:
			*(int  *)value = 3;
			break;
		      case CHNL_3:
			*(int  *)value = 4;
			break;
		      default:
			return NO_SUCH_NAME;
		      }
			*lenp = LENGTH3;
		  }
		else
			return NO_SUCH_NAME;
		break;
	      }
	return 0;
      }

/**************************************************************************
*  Procedure    :   svc_dot3CollCount
*  Path         :   1.3.6.1.2.1.10.7.5.1.2
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                  "The number of per-frame media collisions for
*                  which a particular collision histogram cell
*                  represents the frequency on a particular
*                  interface."
*
**************************************************************************/

int svc_dot3CollCount(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	return(NO_SUCH_NAME);
	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) -1;/* CHANGE THIS TO ACTUAL GET */
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot3CollFrequencies
*  Path         :   1.3.6.1.2.1.10.7.5.1.3
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                  "A count of individual MAC frames for which the
*                  transmission (successful or otherwise) on a
*                  particular interface is accompanied by a
*                  particular number of media collisions."
*
**************************************************************************/

int svc_dot3CollFrequencies(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	return(NO_SUCH_NAME);
	rtn_code = chk_port(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtport((unsigned int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) -1;/* CHANGE THIS TO ACTUAL GET */
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/****************************************************************************
**
**   CHK_PORT ROUTINE
**
**   Check the instance of a tabular object which is indexed by port number.
**
**   Return: 0:            If instance count 1 and instance value is between
**                         1 and 3.
**           NO_SUCH_NAME: All other conditions.
**
****************************************************************************/

chk_port(uint inst_len, uint index) {

   if( (inst_len != 1) || (index < 1) || (index > 3) )
       return( NO_SUCH_NAME );
   else
       return(0);
}


/****************************************************************************
**
**   GET_NXTPORT ROUTINE
**
**   Increment the instance of a tabular object which is indexed
**   by port number.
**
**   Return: 0:            If instance count 1 and instance value is between
**                         1 and 3.
**           NO_SUCH_NAME: All other conditions.
**
****************************************************************************/

get_nxtport( uint *inst_len, uint *index, int retval ) {

    if( *inst_len == 0 ) {

        *inst_len = 1;
        *index    = 1;
    }
    else
    if(( retval != 0 ) || ((++(*index)) > 3))
        return(ERR_INSTANCE);

    return(0);
}

sonic_reinit(portnum)
word portnum;
{

	register SDV *sdvp=&sv_sdvs[portnum];
	register SV *svp = sdvp->sv_var_loc;

	snc_clear_cnt(portnum);    /* clear the counters */
	sdvp->sv_snc->snc_cr = SNC_CR_RST; /*software reset the sonic */

	snc_flush_rcv(portnum);
	snc_flush_xmt(portnum);
	sdvp->sv_snc->snc_cr = 0; 
}
