/**************************************************************************
 *  Copyright (c) 1992 Hughes LAN Systems                                 *
 *  All rights Reserved                                                   *
 *                                                                        *
 *  This file contains unpublished proprietary source code of Hughes LAN  *
 *  Systems.                                                              *
 **************************************************************************
                                                                           
   This file contains the service routines for RFC1286-MIB
   It is directly derived from the MIB specification using the AWK program 
   'MIBSVC.AWK'
   Should significant changes be needed in this file that are NOT          
   reflected back into the MIB specification, then modify this header to   
   indicate that this is the case.                                         
                                                                           
 *************************************************************************/

#define RFC1286-MIB_SVC

#include <types.h> 
#include <target.h>
#include <krnl.h>
#include <bridges.h>
#include <dbd.h>
#include <snmp.h>
#include <asn1.h>
#include <syteksnm.h>
#include <prcctl.h>
#include <sncvar.h>


/**************************************************************************
*  Procedure    :   svc_dot1dTpLearnedEntryDiscards
*  Path         :   1.3.6.1.2.1.17.4.1
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                 "The total number of Forwarding Database entries,
*                 which have been or would have been learnt, but
*                 have been discarded due to a lack of space to
*                 store them in the Forwarding Database.  If this
*                 counter is increasing, it indicates that the
*                 Forwarding Database is regularly becoming full (a
*                 condition which has unpleasant performance effects
*                 on the subnetwork).  If this counter has a
*                 significant value but is not presently increasing,
*                 it indicates that the problem has been occurring
*                 but is not persistent."
*
**************************************************************************/

int svc_dot1dTpLearnedEntryDiscards(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) -1;/* CHANGE THIS TO ACTUAL GET */
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot1dTpAgingTime
*  Path         :   1.3.6.1.2.1.17.4.2
*  Access       :   RW
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                 "The timeout period in seconds for aging out
*                 dynamically learned forwarding information."
*
**************************************************************************/

int svc_dot1dTpAgingTime(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) -1;/* CHANGE THIS TO ACTUAL GET */
		}
		else
			return NO_SUCH_NAME;
		break;
	case SNMP_SET:
		{
			/* FILL IN ACTUAL SET OPERATIONS HERE */
		}
		break;
	case SNMP_TEST:
		if(rtn_code == 0)
		{
			/* FILL IN ACTUAL TEST OPERATIONS HERE */
		}
		else
			return(rtn_code);
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot1dTpFdbAddress
*  Path         :   1.3.6.1.2.1.17.4.3.1.1
*  Access       :   RO
*  Syntax       :   MacAddress VT_STRING
*  Description  :   
*                 "A unicast MAC address for which the bridge has
*                 forwarding and/or filtering information."
*
**************************************************************************/

int svc_dot1dTpFdbAddress(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) -1;/* CHANGE THIS TO ACTUAL GET */
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot1dTpFdbPort
*  Path         :   1.3.6.1.2.1.17.4.3.1.2
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                 "Either the value '0', or the port number of the
*                 port on which a frame having a source address
*                 equal to the value of the corresponding instance
*                 of dot1dTpFdbAddress has been seen.  A value of
*                 '0' indicates that the port number has not been
*                 learned but that the bridge does have some
*                 forwarding/filtering information about this
*                 address (e.g. in the dot1dStaticTable).
*                 Implementors are encouraged to assign the port
*                 value to this object whenever it is learned even
*                 for addresses for which the corresponding value of
*                 dot1dTpFdbStatus is not learned(3)."
*  
*
**************************************************************************/

int svc_dot1dTpFdbPort(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) -1;/* CHANGE THIS TO ACTUAL GET */
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot1dTpFdbStatus
*  Path         :   1.3.6.1.2.1.17.4.3.1.3
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                 "The status of this entry.  The meanings of the
*                 values are:
*  
*                   other(1)   : none of the following.  This would
*                                include the case where some other
*                                MIB object (not the corresponding
*                                instance of dot1dTpFdbPort, nor an
*                                entry in the dot1dStaticTable) is
*                                being used to determine if and how
*                                frames addressed to the value of
*                                the corresponding instance of
*                                dot1dTpFdbAddress are being
*                                forwarded.
*  
*                   invalid(2) : this entry is not longer valid
*                                (e.g., it was learned but has since
*                                aged-out), but has not yet been
*                                flushed from the table.
*  
*                   learned(3) : the value of the corresponding
*                                instance of dot1dTpFdbPort was
*                                learned, and is being used.
*  
*                   self(4)    : the value of the corresponding
*                                instance of dot1dTpFdbAddress
*                                represents one of the bridge's
*                                addresses.  The corresponding
*                                instance of dot1dTpFdbPort
*                                indicates which of the bridge's
*                                ports has this address.
*  
*                   mgmt(5)    : the value of the corresponding
*                                instance of dot1dTpFdbAddress is
*                                also the value of an existing
*                                instance of dot1dStaticAddress."
*
**************************************************************************/

int svc_dot1dTpFdbStatus(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) -1;/* CHANGE THIS TO ACTUAL GET */
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot1dTpPort
*  Path         :   1.3.6.1.2.1.17.4.4.1.1
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                 "The port number of the port for which this entry
*                 contains Transparent bridging management
*                 information."
*
**************************************************************************/

int svc_dot1dTpPort(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) -1;/* CHANGE THIS TO ACTUAL GET */
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot1dTpPortMaxInfo
*  Path         :   1.3.6.1.2.1.17.4.4.1.2
*  Access       :   RO
*  Syntax       :   INTEGER VT_NUMBER
*  Description  :   
*                 "The maximum size of the INFO (non-MAC) field that
*                 this port will receive or transmit."
*
**************************************************************************/

int svc_dot1dTpPortMaxInfo(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) -1;/* CHANGE THIS TO ACTUAL GET */
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot1dTpPortInFrames
*  Path         :   1.3.6.1.2.1.17.4.4.1.3
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                 "The number of frames that have been received by
*                 this port from its segment. Note that a frame
*                 received on the interface corresponding to this
*                 port is only counted by this object if and only if
*                 it is for a protocol being processed by the local
*                 bridging function."
*
**************************************************************************/

int svc_dot1dTpPortInFrames(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) -1;/* CHANGE THIS TO ACTUAL GET */
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot1dTpPortOutFrames
*  Path         :   1.3.6.1.2.1.17.4.4.1.4
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                 "The number of frames that have been transmitted
*                 by this port to its segment.  Note that a frame
*                 transmitted on the interface corresponding to this
*                 port is only counted by this object if and only if
*                 it is for a protocol being processed by the local
*                 bridging function."
*
**************************************************************************/

int svc_dot1dTpPortOutFrames(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) -1;/* CHANGE THIS TO ACTUAL GET */
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_dot1dTpPortInDiscards
*  Path         :   1.3.6.1.2.1.17.4.4.1.5
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*                 "Count of valid frames received which were
*                 discarded (i.e., filtered) by the Forwarding
*                 Process."
*
**************************************************************************/

int svc_dot1dTpPortInDiscards(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) -1;/* CHANGE THIS TO ACTUAL GET */
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

