/**************************************************************************
 *  Copyright (c) 1992 Hughes LAN Systems                                 *
 *  All rights Reserved                                                   *
 *                                                                        *
 *  This file contains unpublished proprietary source code of Hughes LAN  *
 *  Systems.                                                              *
 **************************************************************************
                                                                           
   This file contains the service routines for HLS-ADMIN-BUS
   It is directly derived from the MIB specification using the AWK program 
   'MIBSVC.AWK'
   Should significant changes be needed in this file that are NOT          
   reflected back into the MIB specification, then modify this header to   
   indicate that this is the case.                                         

	$Log:   /b/gregs/bridge/snmp/routines/adminBus.c_v  $
 * 
 *    Rev 1.0   20 Jul 1993 09:36:58   franks
 * Initial revision.
 * 
 *    Rev 1.1   11 May 1992 09:29:30   franks
 * No change.
 * 
 *    Rev 1.0   30 Mar 1992 17:37:22   pvcs
 * Initial revision.

 *************************************************************************/

#define HLS_ADMIN_BUS_SVC

#include <types.h>
#include <target.h>
#include <krnl.h>
#include <dbd.h>
#include <asn1.h>
#include <snmp.h>
#include <syteksnm.h>
#include <prcctl.h>
#include <admdrv.h>

/**************************************************************************
*  Procedure    :   svc_hlsAdminBusConsoleRcvdOctets
*  Path         :   1.3.6.1.4.1.26.29.1
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*              "The number of  octets  received  by  the  local
*              Module  across  the  Admin  Bus  as input/output
*              to/from a Function module's virtual console."
*
**************************************************************************/

int svc_hlsAdminBusConsoleRcvdOctets(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T)AdminCounters.AdmConsoleRcvdOctets;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_hlsAdminBusConsoleSentOctets
*  Path         :   1.3.6.1.4.1.26.29.2
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*              "The number of octets sent by the  local  Module
*              across  the  Admin Bus as input/output to/from a
*              Function module's virtual console."
*
**************************************************************************/

int svc_hlsAdminBusConsoleSentOctets(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) AdminCounters.AdmConsoleSentOctets;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_hlsAdminBusTimeouts
*  Path         :   1.3.6.1.4.1.26.29.3
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*              "The number of times a data transfer across  the
*              Admin  Bus  failed  because the receiving Module
*              did not respond within the necessary timeframe."
*
**************************************************************************/

int svc_hlsAdminBusTimeouts(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) AdminCounters.AdmTimeouts;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_hlsAdminBusInits
*  Path         :   1.3.6.1.4.1.26.29.4
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*              "The  number  of  times  this  Module  has   re-
*              initialized  its  Admin Bus interface, since the
*              last time the Module rebooted."
*
**************************************************************************/

int svc_hlsAdminBusInits(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) AdminCounters.AdmInits;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_hlsAdminBusRcvdICmds
*  Path         :   1.3.6.1.4.1.26.29.5
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*              "The number of Immediate  Commands  received  by
*              the local Module across the Admin Bus."
*
**************************************************************************/

int svc_hlsAdminBusRcvdICmds(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) AdminCounters.AdmRcvdICmds;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_hlsAdminBusIssuedICmds
*  Path         :   1.3.6.1.4.1.26.29.6
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*              "The number of Immediate Commands issued by  the
*              local Module across the Admib Bus."
*
**************************************************************************/

int svc_hlsAdminBusIssuedICmds(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) AdminCounters.AdmIssuedICmds;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_hlsAdminBusUnknownICmds
*  Path         :   1.3.6.1.4.1.26.29.7
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*              "The number of Immediate Commands receved by the
*              local Module which were not recognized."
*
**************************************************************************/

int svc_hlsAdminBusUnknownICmds(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) AdminCounters.AdmUnknownICmds;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_hlsAdminBusRelayerRefuseds
*  Path         :   1.3.6.1.4.1.26.29.8
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*              "For a Function Module, the number  of  refusals
*              to  be  a  Relayer it has sent. For a Management
*              Module, the number of refusals to be  a  Relayer
*              it has received."
*
**************************************************************************/

int svc_hlsAdminBusRelayerRefuseds(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) AdminCounters.AdmRelayerRefuseds;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

/**************************************************************************
*  Procedure    :   svc_hlsAdminBusRelayerAccepteds
*  Path         :   1.3.6.1.4.1.26.29.9
*  Access       :   RO
*  Syntax       :   Counter VT_COUNTER
*  Description  :   
*              "For a Function Module, the number of  times  it
*              has  sent  an  acceptance to be a Relayer. For a
*              Management Module, the number of acceptances  to
*              be a Relayer it has received."
*
**************************************************************************/

int svc_hlsAdminBusRelayerAccepteds(service, compc, compl, lenp, value, index)
unsigned int	service;
byte		*compc;
unsigned int	*compl;
int		*lenp;
UINT_32_T	*value;
int		index;
{
	int rtn_code;

	rtn_code = chk_index(*compc, *compl);

	switch(service)
	{
	case SNMP_GETNXT:
		rtn_code = get_nxtidx((int *)compc,
					(unsigned int *)compl, rtn_code);
		/* FALL TRHROUGH */
	case SNMP_GET:
		if (rtn_code == 0)
		{
			*value = (UINT_32_T) AdminCounters.AdmRelayerAccepteds;
		}
		else
			return NO_SUCH_NAME;
		break;
	}
	return 0;
}

