/*****************************************************************
 *      Copyright (c) 1992 by Hughes LAN Systems
 *
 *      Program Name:   FDDI Concentrator application
 *
 *      Filename:       call_smt.h
 *
 *
 *      Description: This file contains the macros to get the mib
 *                   objects from the SMT domain. 
 *
 *	$Log:   /b/gregs/bridge/snmp/fddi_routines/call_smt.h_v  $
 * 
 *    Rev 1.0   30 Jul 1993 13:21:48   franks
 * Initial revision.
 * 
 *    Rev 1.4   21 Jan 1993 14:53:54   shekhar
 * 
 *    Rev 1.3   28 Dec 1992 13:53:06   shekhar
 * 
 *    Rev 1.2   17 Dec 1992 09:35:08   shekhar
 * 
 *    Rev 1.1   16 Dec 1992 10:42:18   shekhar
 *      Revision:
 *      1-000                   Nov-19-92      Shekhar Ambe. 
 *              - Original.
 *
 *******************************************************************
 */

#ifndef __CALL_SMT_h
#define __CALL_SMT_h

static u_long   chipset_objid[2] = { 0, 0 };


#ifdef TEST 

static u_char 	dummy_addr[6] = { 0, 0, 0, 0, 0, 0 };


#define GET_SMTNUMBER()			*value = (UINT_32_T) 1
#define GET_STATIONID()			*value = (UINT_32_T) 1
#define GET_OPVERSIONID()		*value = (UINT_32_T) 1
#define GET_HIVERSIONID()		*value = (UINT_32_T) 1
#define GET_LOVERSIONID()		*value = (UINT_32_T) 1
#define GET_MACCT()			*value = (UINT_32_T) 1
#define GET_NONMASTERCT()		*value = (UINT_32_T) 1
#define GET_MASTERCT()			*value = (UINT_32_T) 1
#define GET_PATHSAVAIL()		*value = (UINT_32_T) 1
#define GET_CONFIG_CAPABILITIES()	*value = (UINT_32_T) 1
#define GET_CONFIG_POLICY()		*value = (UINT_32_T) 1
#define GET_CONNECTION_POLICY()		*value = (UINT_32_T) 1
#define GET_NOTIFY()			*value = (UINT_32_T) 1
#define GET_STATUS_REPORTING()		*value = (UINT_32_T) 1
#define GET_ECM_STATE()			*value = (UINT_32_T) 1
#define GET_CF_STATE()			*value = (UINT_32_T) 1
#define GET_HOLD_STATE()		*value = (UINT_32_T) 1
#define GET_DISCONNECT_FLAG()		*value = (UINT_32_T) 1
#define GET_STATION_ACTION()		*value = (UINT_32_T) 1
#define GET_MAC_NUMBER()		*value = (UINT_32_T) 1
#define GET_MACFRAME_STATUS_CAP()	*value = (UINT_32_T) 1
#define GET_MAC_STATUS_LOWERB()		*value = (UINT_32_T) 1
#define GET_MACTVX_GREATEST_LB()	*value = (UINT_32_T) 1
#define GET_MACPATHS_AVAIL()		*value = (UINT_32_T) 1
#define GET_MACCURRENT_PATH()		*value = (UINT_32_T) 1

#define GET_MACUPSTREAMNBR() \
{	byte *tmp_ptr; \
	u_int i; \
	memcpy(value, dummy_addr, 6);\
	*lenp = 6; \
}

#define GET_MACOLDUPSTREAMNBR()	\
{       byte *tmp_ptr; \
        u_int i; \
        memcpy(value, dummy_addr, 6);\
        *lenp = 6; \
}
	
#define GET_MACDUPADDRTEST()		*value = (UINT_32_T) 1
#define GET_MACPATHSREQ()		*value = (UINT_32_T) 1 
#define GET_MACDOWNSTREAMPORTTYPE()	*value = (UINT_32_T) 1

#define GET_MACSMTADDRESS()  \
{       byte *tmp_ptr; \
        u_int i; \
        memcpy(value, dummy_addr, 6);\
        *lenp = 6; \
}

 	
#define GET_MACTREQ()			*value = (UINT_32_T) 1
#define GET_MACTNEG()			*value = (UINT_32_T) 1
#define GET_MACTMAX()			*value = (UINT_32_T) 1
#define GET_MACTVXVALUE()		*value = (UINT_32_T) 1
#define GET_MACTMIN()			*value = (UINT_32_T) 1
#define GET_CURRENTFRAMESTATUS()	*value = (UINT_32_T) 1
#define GET_MACFRAMECTS()		*value = (UINT_32_T) 1
#define GET_MACERRORCTS()		*value = (UINT_32_T) 1
#define GET_MACLOSTCTS()		*value = (UINT_32_T) 1
#define GET_MACFRAMEERRORTHRESHOLD()	*value = (UINT_32_T) 1
#define GET_MACFRAMEERRORRATIO()	*value = (UINT_32_T) 1
#define GET_MACRMTSTATE()		*value = (UINT_32_T) 1
#define GET_MACDAFLAG()			*value = (UINT_32_T) 1
#define GET_MACUNADAFLAG()		*value = (UINT_32_T) 1
#define GET_MACFRAMECONDITION()		*value = (UINT_32_T) 1
#define GET_MACACTION()			*value = (UINT_32_T) 1
#define GET_PORTNUMBER()		*value = (UINT_32_T) 1
#define GET_PORTSMTINDEX()		*value = (UINT_32_T) 1
#define GET_PORTINDEX()			*value = (UINT_32_T) 1
#define GET_PORTPCTTYPE()		*value = (UINT_32_T) 1
#define GET_PORTPCNEIGHBOR()		*value = (UINT_32_T) 1
#define GET_PORTCONNECTIONPOLICIES()	*value = (UINT_32_T) 1
#define GET_PORTREMOTEMACINDIC()	*value = (UINT_32_T) 1
#define GET_PORTCESTATE()		*value = (UINT_32_T) 1
#define GET_PORTPATHSREQ()		*value = (UINT_32_T) 1
#define GET_PORTMACPLACEMENT()		*value = (UINT_32_T) 1
#define GET_PORTAVAILPATHS()		*value = (UINT_32_T) 1
#define GET_PORTMACLOOPTIME()		*value = (UINT_32_T) 1
#define GET_PORTTBMAX()			*value = (UINT_32_T) 1
#define GET_PORTBSFLAG()		*value = (UINT_32_T) 1
#define GET_PORTLCTFAILCTS()		*value = (UINT_32_T) 1
#define GET_PORTLERESTIMATE()		*value = (UINT_32_T) 1
#define GET_PORTLEMREJECTCTS()		*value = (UINT_32_T) 1
#define GET_PORTLEMCTS()		*value = (UINT_32_T) 1
#define GET_PORTLERCUTOFF()		*value = (UINT_32_T) 1
#define GET_PORTLERALARM()		*value = (UINT_32_T) 1
#define GET_PORTCONNECTSTATE()		*value = (UINT_32_T) 1
#define GET_PORTPCMSTATE()		*value = (UINT_32_T) 1
#define GET_PORTPCWITHHOLD()		*value = (UINT_32_T) 1
#define GET_PORTLERCONDITION()	  	*value = (UINT_32_T) 1
#define GET_PORTACTION()		*value = (UINT_32_T) 1
#define GET_ATTACHMENTNUMBER()		*value = (UINT_32_T) 1
#define GET_ATTACHMENTSMTINDEX()	*value = (UINT_32_T) 1
#define GET_ATTACHMENTINDEX()		*value = (UINT_32_T) 1
#define GET_ATTACHMENTCLASS()		*value = (UINT_32_T) 1
#define GET_OPTICALBYPASS()		*value = (UINT_32_T) 1
#define GET_ATTACHMENTMAXEXP()		*value = (UINT_32_T) 1
#define GET_ATTACHMENTINSERTEDSTATUS()	*value = (UINT_32_T) 1
#define GET_ATTACHMENTINSERTPOLICY()	*value = (UINT_32_T) 1
#define GET_MACCHIPSET() \
{	UINT_32_T  *tmp_ptr; \
	u_int      i;  \
	for (i = 0; i < 2; i++) \
		*value = chipset_objid[i]; \
	*lenp = 2; \
}	
	 			
#else 

#include <smtdefs.h>
#include <mibdefs.h>
#include <smttypes.h>

#define GET_SMTNUMBER()                 1

#define GET_STATIONID() \
{	TLVParamType	buffer;\
	buffer.paramType = fddiSMTStationId;  \
	buffer.paramLen  = 0;  \
	GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
	*value = (UINT_32_T) buffer.SMTPARAM8;\
} 

#define GET_OPVERSIONID() \
{       TLVParamType    buffer;\
        buffer.paramType = fddiSMTOpVersionId;  \
        buffer.paramLen  = 0;  \
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.SMTPARAM16;\
}

#define GET_HIVERSIONID() \
{       TLVParamType    buffer;\
        buffer.paramType = fddiSMTHiVersionId;  \
        buffer.paramLen  = 0;  \
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.SMTPARAM16;\
} 

#define GET_LOVERSIONID() \
{       TLVParamType    buffer;\
        buffer.paramType = fddiSMTLoVersionId;  \
        buffer.paramLen  = 0;  \
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.SMTPARAM16;\
}

#define GET_MACCT()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiSMTMAC_Ct;  \
        buffer.paramLen  = 0;  \
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.SMTPARAM8;\
}

#define GET_NONMASTERCT()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiSMTNonMaster_Ct;  \
        buffer.paramLen  = 0;  \
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.SMTPARAM8;\
}

#define GET_MASTERCT()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiSMTMaster_Ct ;  \
        buffer.paramLen  = 0;  \
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.SMTPARAM8;\
}

#define GET_PATHSAVAIL()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiSMTPathsAvailable;  \
        buffer.paramLen  = 0;  \
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.SMTPARAM8;\
}

#define GET_CONFIG_CAPABILITIES() \
{       TLVParamType    buffer;\
        buffer.paramType = fddiSMTConfigCapabilities;  \
        buffer.paramLen  = 0;  \
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.SMTPARAM16;\
}

#define GET_CONFIG_POLICY()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiSMTConfigCapabilities;  \
        buffer.paramLen  = 0;  \
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.SMTPARAM16;\
}

#define GET_CONNECTION_POLICY()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiSMTConfigPolicy;  \
        buffer.paramLen  = 0;  \
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.SMTPARAM16;\
}

#define GET_NOTIFY()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiSMTT_Notify;  \
        buffer.paramLen  = 0;  \
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.SMTPARAM16;\
}

#define GET_STATUS_REPORTING()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiSMTStatusReporting;  \
        buffer.paramLen  = 0;  \
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.SMTPARAM8;\
}

#define GET_ECM_STATE()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiSMTECMState;  \
        buffer.paramLen  = 0;  \
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.SMTPARAM8;\
}

#define GET_CF_STATE()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiSMTCF_State;  \
        buffer.paramLen  = 0;  \
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.SMTPARAM8;\
}

#define GET_HOLD_STATE()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiSMTHoldState;  \
        buffer.paramLen  = 0;  \
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.SMTPARAM8;\
}

#define GET_DISCONNECT_FLAG() \
{       TLVParamType    buffer;\
        buffer.paramType = fddiSMTRemoteDisconnectFlag;  \
        buffer.paramLen  = 0;  \
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.SMTPARAM8;\
}

#define GET_STATION_ACTION()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiSMTStationAction;  \
        buffer.paramLen  = 0;  \
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.SMTPARAM16;\
}

	

#define GET_MAC_NUMBER()		*value = (UINT_32_T) MAX_MAC_COUNT


#define GET_MACFRAME_STATUS_CAP()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACFrameStatusCapabilities;  \
        buffer.paramLen  = 0;  \
	buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM16;\
}

#define GET_MAC_STATUS_LOWERB()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACT_MaxGreatestLowerBound;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM32;\
}

#define GET_MACTVX_GREATEST_LB()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACTVXGreatestLowerBound;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM32;\
}
#define GET_MACPATHS_AVAIL()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACPathsAvailable;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM8;\
}

#define GET_MACCURRENT_PATH()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACCurrentPath;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM16;\
}


#define GET_MACUPSTREAMNBR() \
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACUpstreamNbr; \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
	memcpy(value, buffer.MACADDR, 6);\
	*lenp = 6;\
}

#define GET_MACOLDUPSTREAMNBR()	\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACOldUpstreamNbr;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        memcpy(value, buffer.MACADDR, 6);\
	*lenp = 6;\
}

#define GET_MACDUPADDRTEST()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACDup_Addr_Test;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM32;\
}
#define GET_MACPATHSREQ()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACPathsRequested;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM16;\
}

#define GET_MACDOWNSTREAMPORTTYPE()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACDownstreamPORTType;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM16;\
}

#define GET_MACSMTADDRESS()  \
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACSMTAddress;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        memcpy(value, buffer.MACADDR, 6);\
        *lenp = 6;\
}

#define GET_MACTREQ()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACPathsRequested;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM32;\
}

#define GET_MACTNEG()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACT_Neg;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM32;\
}

#define GET_MACTMAX()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACT_Max;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM32;\
}

#define GET_MACTVXVALUE()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACTvxValue;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM32;\
}

#define GET_MACTMIN()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACT_Min;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM32;\
}

#define GET_CURRENTFRAMESTATUS()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACFrameStatus;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM16;\
}


#define GET_MACFRAMECTS()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACFrame_Ct;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM32;\
}

#define GET_MACERRORCTS()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACError_Ct;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM32;\
}

#define GET_MACLOSTCTS()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACLost_Ct;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM32;\
}

#define GET_MACFRAMEERRORTHRESHOLD()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACFrameErrorThreshold;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM16;\
}

#define GET_MACFRAMEERRORRATIO()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACFrameErrorRatio;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM16;\
}

#define GET_MACRMTSTATE()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACRMTState;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM8;\
}

#define GET_MACDAFLAG()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACDa_Flag;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM8;\
}

#define GET_MACUNADAFLAG()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACUnaDa_Flag;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM8;\
}

#define GET_MACFRAMECONDITION()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACFrameErrorCondition;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM8;\
}

#define GET_MACACTION() \
{       TLVParamType    buffer;\
        buffer.paramType = fddiMACAction;  \
        buffer.paramLen  = 0;  \
        buffer.MACINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.MACPARAM16;\
}


#define GET_PORTNUMBER()		*value = (UINT_32_T) MAX_PORT_COUNT


#define GET_PORTPCTTYPE()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiPATHClassPATHClassType;  \
        buffer.paramLen  = 0;  \
	buffer.PORTINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.PORTPARAM8;\
}

#define GET_PORTPCNEIGHBOR()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiPORTPC_Neighbor;  \
        buffer.paramLen  = 0;  \
        buffer.PORTINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.PORTPARAM8;\
}

#define GET_PORTCONNECTIONPOLICIES()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiPORTConnectionPolicies;  \
        buffer.paramLen  = 0;  \
        buffer.PORTINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.PORTPARAM8;\
}

#define GET_PORTREMOTEMACINDIC()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiPORTRemoteMACIndicated;  \
        buffer.paramLen  = 0;  \
        buffer.PORTINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.PORTPARAM8;\
}

#define GET_PORTCESTATE()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiPORTCE_State;  \
        buffer.paramLen  = 0;  \
        buffer.PORTINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.PORTPARAM8;\
}

#define GET_PORTPATHSREQ()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiPORTPathsRequested;  \
        buffer.paramLen  = 0;  \
        buffer.PORTINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.PORTPARAM8;\
}

#define GET_PORTMACPLACEMENT()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiPORTMACPlacement;  \
        buffer.paramLen  = 0;  \
        buffer.PORTINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.PORTPARAM16;\
}

#define GET_PORTAVAILPATHS()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiPORTAvailablePaths;  \
        buffer.paramLen  = 0;  \
        buffer.PORTINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.PORTPARAM8;\
}

#define GET_PORTMACLOOPTIME()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiPORTMACLoop_Time;  \
        buffer.paramLen  = 0;  \
        buffer.PORTINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.PORTPARAM32;\
}

#define GET_PORTTBMAX()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiPORTTB_Max;  \
        buffer.paramLen  = 0;  \
        buffer.PORTINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.PORTPARAM32;\
}

#define GET_PORTBSFLAG()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiPORTBS_Flag;  \
        buffer.paramLen  = 0;  \
        buffer.PORTINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.PORTPARAM8;\
}

#define GET_PORTLCTFAILCTS()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiPORTLCTFail_Ct;  \
        buffer.paramLen  = 0;  \
        buffer.PORTINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.PORTPARAM32;\
}

#define GET_PORTLERESTIMATE()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiPORTLer_Estimate;  \
        buffer.paramLen  = 0;  \
        buffer.PORTINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.PORTPARAM8;\
}

#define GET_PORTLEMREJECTCTS()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiPORTLem_Reject_Ct;  \
        buffer.paramLen  = 0;  \
        buffer.PORTINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.PORTPARAM16;\
}

#define GET_PORTLEMCTS()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiPORTLem_Ct;  \
        buffer.paramLen  = 0;  \
        buffer.PORTINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.PORTPARAM32;\
}

#define GET_PORTLERCUTOFF()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiPORTLer_Cutoff;  \
        buffer.paramLen  = 0;  \
        buffer.PORTINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.PORTPARAM8;\
}

#define GET_PORTLERALARM()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiPORTLer_Alarm;  \
        buffer.paramLen  = 0;  \
        buffer.PORTINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.PORTPARAM8;\
}

#define GET_PORTCONNECTSTATE()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiPORTConnectState;  \
        buffer.paramLen  = 0;  \
        buffer.PORTINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.PORTPARAM16;\
}

#define GET_PORTPCMSTATE()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiPORTPCMState;  \
        buffer.paramLen  = 0;  \
        buffer.PORTINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.PORTPARAM8;\
}

#define GET_PORTPCWITHHOLD()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiPORTPC_Withhold;  \
        buffer.paramLen  = 0;  \
        buffer.PORTINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.PORTPARAM8;\
}

#define GET_PORTLERCONDITION()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiPORTLerCondition;  \
        buffer.paramLen  = 0;  \
        buffer.PORTINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.PORTPARAM8;\
}

#define GET_PORTACTION()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiPORTAction;  \
        buffer.paramLen  = 0;  \
        buffer.PORTINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.PORTPARAM16;\
}

#define GET_ATTACHMENTNUMBER()		*value = (UINT_32_T) MAX_ATTACH_COUNT

#define GET_ATTACHMENTCLASS()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiATTACHMENTClass;  \
        buffer.paramLen  = 0;  \
	buffer.ATTACHINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.ATTACHPARAM8;\
}

#define GET_OPTICALBYPASS()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiATTACHMENTOpticalBypassPresent;  \
        buffer.paramLen  = 0;  \
        buffer.ATTACHINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.ATTACHPARAM8;\
}

#define GET_ATTACHMENTMAXEXP()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiATTACHMENTI_MaxExpiration;  \
        buffer.paramLen  = 0;  \
        buffer.ATTACHINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.ATTACHPARAM32;\
}

#define GET_ATTACHMENTINSERTEDSTATUS()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiATTACHMENTInsertedStatus;  \
        buffer.paramLen  = 0;  \
        buffer.ATTACHINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.ATTACHPARAM8;\
}

#define GET_ATTACHMENTINSERTPOLICY()\
{       TLVParamType    buffer;\
        buffer.paramType = fddiATTACHMENTInsertPolicy;  \
        buffer.paramLen  = 0;  \
        buffer.ATTACHINDEX = *(compl + 1);\
        GetMIBAttr(sizeof(buffer), &buffer, (TLVSetCountType *) NULL); \
        *value = (UINT_32_T) buffer.ATTACHPARAM8;\
}

#define GET_MACCHIPSET() \
{	UINT_32_T  *tmp_ptr; \
	u_int      i;  \
	for (i = 0; i < 2; i++) \
		*value = chipset_objid[i]; \
	*lenp = 2; \
}	

#endif

#endif



 
