
/**
*	Program Name:	RAM TESTER
*
*	Filename:	main.c
*	Copyright (c) 1992 by Huges LAN Systems.
**/
#include <krnl.h>
#include <target.h>
#include <memory.h>
#include <eeprecs.h>
#include <nim960h.h>
#include <uart.h>
#include <dips.h>
#include <led.h>
#include <sys.h>
#include <sncvar.h>
#include <malloc.h>

SYS sys;

printf(){}
Ei(){}
Di(){}
int_nmi(){}

main()
{
	word i, j, thisTime, lastTime;

	*(short*)0x90000060 = 0;
	*(short*)0x90000040 = 0;
	ShowSLed(0, 0x10ffff);
	/*
	* Disable Bus watch dog timer
	* and Enable 4 LANs
	*/
	set_ctrl1(0xffff, DISABLE_BUS_WDT | 0xf);

	/*
	 * for now, we assume it's 1M DRAM
	 */
	set_ctrl1(0x400, 0x0000);

	ShowSLed(1, 0x10ffff);
	ShowSLed(2, 0x20ffff);
	ShowSLed(3, 0x10ffff);
	ShowSLed(4, 0x08ffff);
	ShowSLed(5, 0x00ffff);

	*(short*)0x90000040 = 0xaaaa;
	lastTime = 0;
	for(;;)
	{
		for(j=0; j<256; j++)
		{
			for(i=0xfffc0160; i< 0xfffc0860; i++)
			{
				thisTime = (*(byte*)i + j) & ~lastTime;
				*(short*)0x90000060 = thisTime;
				lastTime = thisTime;
				WasteTime(0x10000);
			}
		}
	}

}

WasteTime(delay)
int delay;
{
	volatile word i;

	for (i=0; i<delay; i++);
}


FlickerLeds()
	{
	}

tn_init()
	{
	return 0;
	}
tcp_init()
	{
	return 0;
	}
netio_init()
	{
	return 0;
	}
nmres_init()
	{
	return 0;
	}
icmp_pinged()
	{
	}	

IsSyscardIP()
	{
	return 0;
	}
IsAdminPort()
	{
	return 0;
	}


/****************************************************************
Test_InitKrnlTimers()
{
	extern TimeTicksInt();
	extern TimeSliceInt();

	prog_timers(1, TimeTicksInt, 1, 6);
	prog_timers(2, TimeSliceInt, 2, 6);
}

Test_TimeTicksInt()
{
	if (!turn0)
	{
		HW_SLed(1);
		turn0++;
	}
	else if (turn0 == 0xff)
	{
		HW_SLed(16);
		turn0++;
	}
	else if (turn0 >= 0x1ff)
		turn0 = 0;
	else
		turn0++;
}

Test_TimeSliceInt()
{
	if (!turn1)
	{
		HW_SLed(2);
		turn1++;
	}
	else if (turn1 == 0xfff)
	{
		HW_SLed(16);
		turn1++;
	}
	else if (turn1 >= 0x1fff)
		turn1 = 0;
	else
		turn1++;
}
****************************************************************/
