/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	prcpkt.c
*
*	$Log:   /b/gregs/bridge/proc/prcpkt.c_v  $
 * 
 *    Rev 1.25   06 Jul 1994 09:23:24   franks
 * 1. Disabled learning when a port state is set to disabled
 * 2. Fixed a packet size filtering bug, and optimized the packet size filter code.
 * 3. Made a performance enhancement, by adding a fourth loop which transmits fddi packets.
 * 4. Removed some debug code.
 * 
 *    Rev 1.24   07 Jun 1994 12:27:22   franks
 * Added a kluge fix for Cantor Fitzgerald so that ARP broadcast frames will not 
 * be duplicated when transmitted to ethernet.
 * Changed the processing routine so that 2 FDDI packets would be received at a time.
 * 
 *    Rev 1.23   01 Feb 1994 10:32:52   gregs
 * Undid previous learning bug fix, since it was not really a bug.
 * 
 *    Rev 1.22   24 Jan 1994 09:22:06   gregs
 * Fixed learning bug that prevented addresses with bit 0 of byte 1 of the source
 * address set from being learned and allowed broadcast addresses to be learned.
 * 
 *    Rev 1.21   10 Jan 1994 09:19:22   gregs
 * 1. Made changes to increase bridge performance.
 * 2. Fixed packet size filtering bug that caused the bridge to filter 1514 byte ethernet packets on 
 *    the fddi channel of the remote 836 bridge due to the increased packet size cause by translation.
 * 
 *    Rev 1.20   17 Nov 1993 12:44:56   gregs
 * Fixed packet size bug, now in extended mode frames  PKT+FCS < 20bytes are rejected.
 * 
 *    Rev 1.19   15 Nov 1993 14:08:24   franks
 * Fixed packet size bug
 * 
 *    Rev 1.18   28 Oct 1993 11:04:50   franks
 * Fixed bug in restrict outbound filtering, so that now enabling this feature
 * on the home port of the destination address will cause the filtering to occur.
 * 
 *    Rev 1.17   26 Oct 1993 15:07:40   franks
 * No change.
 * 
 *    Rev 1.16   25 Oct 1993 17:02:48   franks
 * Fixed SNAP translation bug
 * 
 *    Rev 1.15   21 Oct 1993 08:51:14   franks
 * Added code for IPX SNAP translation.
 * 
 *    Rev 1.14   20 Oct 1993 15:31:24   franks
 * Began adding changes to support IPX SNAP translation.
 * 
 *    Rev 1.13   12 Oct 1993 09:15:18   franks
 * No change.
 * 
 *    Rev 1.12   30 Sep 1993 09:51:52   franks
 * Fixed bug that prevented two bridges in the same hub from pinging each other across the ethernet backplanes.
 * 
 *    Rev 1.11   29 Sep 1993 09:31:28   franks
 * No change.
 * 
 *    Rev 1.10   28 Sep 1993 11:40:04   franks
 * 
 *    Rev 1.9   10 Sep 1993 15:09:24   franks
 * No change.
 * 
 *    Rev 1.8   08 Sep 1993 10:17:46   franks
 * Initial SIT Release
 * 
 *    Rev 1.7   03 Sep 1993 09:33:26   franks
 * Fixed IPX and cleaned up the code a little
 * 
 *    Rev 1.6   30 Aug 1993 08:38:40   franks
 * Upgraded to support the new pkt driver
 * 
 *    Rev 1.5   30 Jul 1993 13:10:36   franks
 * Internal engineering release
 * 
 *    Rev 1.4   20 Jul 1993 13:03:36   franks
 * Fixed protocol blocking for frames received from the FDDI interface.
 * 
 *    Rev 1.3   06 Jul 1993 15:44:14   franks
 * Added cam ageing
 * 
 *    Rev 1.2   03 Jun 1993 09:51:22   yan
 * use real fddi xmt instead of dummy
 * 
 *    Rev 1.1   19 May 1993 14:48:42   franks
 * 
 *    Rev 1.0   04 May 1993 15:50:24   franks
 * Initial revision.
 * 
 *    Rev 1.3   14 May 1992 11:08:20   suresh
 * Removed usage of fault_cnt.
 * 
 *    Rev 1.2   16 Apr 1992 09:50:18   suresh
 * SIT bug #78 fix, copy at most five packets to the protocol stack
 * for each entry into the packet processing routine.
 * 
 *    Rev 1.1   13 Apr 1992 17:45:46   suresh
 * SIT bug #76 fix, Prevent packets addressed to itself from
 * being forwarded to other ports.
 * 
 *    Rev 1.0   30 Mar 1992 17:34:20   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/*
 * BRIDGE PAKCET PROCESSOR receive packet processing
 */

#include <types.h>
#include <target.h>
#include <krnl.h>
#include <sncvar.h>
#include <bitmask.h>
#include <prcctl.h>
#include <prcadr.h>
#include "prcfrm.h"
#include <bridges.h>
#include <nvrecs.h>
#include <stp.h>
#include <pkt.h>
#include <error.h>
#include "/b/gregs/fddi/fddicon/drv/include/bsi.h"

extern word fddi_out_array[];  /** SPEED **/

extern PRCCTL prc;
extern word pkt_ptr_array[];
extern word prc_buf[];
extern ADR *FreeAdrHead;

extern MBOX ReceiveMbox;
extern NVR_BSTATUS *BridgeStatus;
extern byte *PFilTable;	
extern PRCCNT prccnt;
extern ADR **adr_hshs;
extern int rlog_cnt;
extern word snc_init;
PKT* Translate_eth_to_fddi();

unsigned fs_tmp_cnt = 0;
	
#define CANTOR		0
#define ET_ARP 		0x0608	/* ARP protocol type */
#define PID_RFC1042	0x0000
	
/* basic frame shape without the len field, which if the frame control */
/* byte where added to the beginning of the frame would be how the frame */
/* looked on FDDI.                                                       */
typedef struct xfrm
	{
	shrt dl;
	shrt dm;
	shrt dh;
	shrt sl;
	shrt sm;
	shrt sh;
	shrt _s;
	shrt _n;
	shrt _a;
	shrt _p;
	} XFRMHDR;


prc_init()
{
	rlog_init();
	memset(&prc, 0, sizeof(PRCCTL));
	memset(&prccnt, 0, sizeof(PRCCNT));
	memset(&pkt_ptr_array[0], 0, ((BATCH) * sizeof(word *)));

}

ntohs_prc_local(x)
int x;
{
	return ((x<<8 & 0xff00) | (x>>8 & 0xFF));
}



/* process storage fields for each packet */
#define br_xmt pktBridgeArea[0]		/* outgoing port list */
#define br_in  pktBridgeArea[1]		/* src addr flags */
#define br_out pktBridgeArea[2]		/* dst addr flags */
#define br_hom pktBridgeArea[3]		/* dst addr flags */


/*
 * Process a packet.
 *   Learn from the source.
 *   Decide where to send by destination.
 *   Do source and destination restriction filtering
 *   Do source and destination size filtering
 *   Do source and destination protocol filtering
 *   Do source and destination bit mask filtering
 */

prc_proc_pkt()
{

	register PRCCTL *cp = &prc;
	register word *ProcArrayPtr = &pkt_ptr_array[0];
	register int in = 0;
	register int out;
	register FRMHDR *fp;
	register PKT *pp;
	register word PortNum;
	register word PortBit;

	/* 
	 * process 1:
	 *   lookup destination address;
	 *   lookup source address;
	 *   learn if necessary.
	 */
	 if (!snc_init)
		return 0;


	ClearPortLedStatus();
	pre_proc_prcctl();
	rlog_cnt = 0;
    {
	register ADR *ap;
	register SDV *sdvp;
	register int fddiCount=0;
	register word Tmp_ActivePortList;
	register word Tmp_Hash;
	register word Tmp_BufPtr;
	register word Tmp_PacketSize = cp->Prc_PacketSize;
	register word Tmp_DontForward = cp->Prc_DontForward;
	register word Tmp_PktCnt = BATCH - 1;
	register word Tmp_DiscardBeforeLearn = cp->Prc_DiscardBeforeLearn;
	register word Tmp_Learning = cp->Prc_Learning;
	register word Tmp_LearnOrInFilter = Tmp_Learning | cp->Prc_InFilter;

	fp = (FRMHDR *)&prc_buf[0];

	/* Loop until we do the max no. of pkts per time slice, or there
		are no more pkts to process on any port */
	do			
	{
		register word NextPort;

		/* Cycle thru all 4 ports, doing several packets on the FDDI
			port and 1 pkt on each ethernet port, until there are no
			more packets to process on any port or we do the max. */
		for( Tmp_ActivePortList=0xf, PortNum=0, fddiCount=0;
			((PortNum < SV_NMBR_PORT) && Tmp_PktCnt); 
			PortNum = NextPort )
		{

/* ********************** FDDI DEFS ********************** */
#define	FDDI_PORT		3		/* port number of FDDI port */
#define	ETH_PORTS_M		0x07	/* bit mask for all 3 eth ports */
#define	FDDI_PORT_M		0x08	/* bit mask of FDDI port */
#define	FDDI_PKT_LIMIT	2		/* FDDI pkts per cycle thru all ports */
#define	FREE_IT			1		/* TRUE to free pkt in snc_transmit_pkt */

/* ********************** FDDI DEFS ********************** */

		PortBit = 1 << PortNum;		/* make port bit mask */
		if( PortNum == FDDI_PORT ) {
			
			/* Get a FDDI packet from the fddi driver. */
			pp = (PKT*)GetFddiPkt();  

			/* if no pkt OR we've done enough FDDI pkts this time around */
			/* if( !pp  || (++fddiCount > FDDI_PKT_LIMIT) )	 */
			/** JUST GET ONE FRAME PER PASS FOR NOW **/
			NextPort = PortNum+1;		/* go to next port next time */

            if(pp) {
               /* Inc the data ptr by one so that it points to the 
               ** destination address.
               */
		       pp->pktDataPtr++;   
            }
		}
		else {		/* one of the ethernet ports */
			sdvp = &sv_sdvs[PortNum];
			if( !((sdvp->sv_rcvhd)->sncr_nus) ) {
				pp = (PKT *)snc_receive(sdvp, PortNum, PortBit);
			}
			else  {
				pp = (PKT *)NULL;
			}
			NextPort = PortNum+1;			/* go on to next port */
		}	
		if( pp )		/* if there is a pkt to proc on this port */
		{
		Tmp_PktCnt--;
		{					/* begin 'check dest.' block */
			register word Tmp_Dnid_Word;

			Tmp_BufPtr = (word)pp->pktDataPtr;
			Tmp_Dnid_Word = *((word *)fp) = *((word *)Tmp_BufPtr);
			*(((word *)fp) + 1) = *(((word *)Tmp_BufPtr) + 1);

			/* get dest record and outbound port list */
			Tmp_Hash = ((fp->dl) ^ (fp->dm) ^ (fp->dh)) >> 1;

			for (ap = adr_hshs[Tmp_Hash]; ap; ap = ap->adr_nxt)
				if ((*((word *)&ap->adr_low) == Tmp_Dnid_Word)
				   && (ap->adr_high == fp->dh))
					break;

			/* decide outbound ports based on record */
			if (ap)
			{

				/* address record found */
				if (ap->adr_hom)
				{
					/* save the destination address record pointer */
					(ADR *)pp->pktXlateDA = ap;

					/* on segment filter */
					if (ap->adr_hom == PortBit)
						if (!(Tmp_Learning & PortBit)) {
							goto release_frame;
						}
					pp->br_xmt = ap->adr_hom;
					pp->br_out = ap->adr_out;
				}
				else
				{
					/* save the destination address record pointer */
					pp->pktXlateDA = 0;

					if (Tmp_Dnid_Word == 0xffffffff)
					{

						/************************** MYDEBUG ********
						if((pp->pktRcvPort == FDDI_PORT) && 
							(((XFRMHDR *)Tmp_BufPtr)->_p == 0x0008)) 
								fs_tmp_cnt++;
						*******************************************/

						if ((((FRMHDR *)Tmp_BufPtr)->ln == ET_ARP) || 
							(((FRMHDR *)Tmp_BufPtr)->_p == ET_ARP))
						{
							Tmp_PktCnt >>= 1;
							prc_send_local(pp);
						}
						else
						if((pp->pktRcvPort == FDDI_PORT) && 
							(((XFRMHDR *)Tmp_BufPtr)->_p == ET_ARP)) 
						{
							Tmp_PktCnt >>= 1;
							prc_send_local(pp);
						}
						pp->br_xmt = SV_VLD_PRTS & ~PortBit;
						pp->br_out = 0x8000;/*no filter info*/
					}
					else
					{
						Tmp_PktCnt >>= 1;
						prc_send_local(pp);
						if(Tmp_Learning & PortBit) {
							pp->br_xmt = PortBit;
						}
						else {
							goto release_frame;
						}
					}
				}
			}
			else
			{
				/* save the destination address record pointer */
				pp->pktXlateDA = 0;

				/* address record not found */
				pp->br_out = 0x8000;	/* no filter info */
				pp->br_xmt = SV_VLD_PRTS & ~PortBit;
			}
		}	/* end 'check dest.' block */


		if (Tmp_DiscardBeforeLearn & PortBit)
		{
			goto release_frame;
		}

		*(((word *)fp) + 2) = *(((word *)Tmp_BufPtr) + 2);


		/* get source record and filter info */
		Tmp_Hash = ((fp->sl) ^ (fp->sm) ^ (fp->sh)) >> 1;
		for (ap = adr_hshs[Tmp_Hash]; ap; ap = ap->adr_nxt)
			if ((ap->adr_low == fp->sl)
				&& (ap->adr_mid == fp->sm)
				&& (ap->adr_high == fp->sh))
					break;


		if (ap)		
		{
			/* save the source address record pointer */
			(ADR *)pp->pktXlateSA = ap;

			/* known source address */
			ap->adr_flg |= ADR_FLG_USD;	/* addr actv */
			pp->br_in = ap->adr_in;	/* inbnd rstr */
			if (!(PortBit & ap->adr_hom)) /* relearn check */
				if (Tmp_Learning & PortBit) /* learning enabled */
					if (!(ap->adr_flg & ADR_FLG_STC)) /* static flag */
						if (ap->adr_hom) /* if not my address */
						{
							/* relearning */
							rlog_cnt++;
							rlog_learn((NID *)&ap->adr_low,ap->adr_hom,PortBit);
							if(ap->adr_hom & FDDI_PORT_M) 
								CamDel((ushort *)&fp->sl);
							ap->adr_hom = PortBit;	/* new home port */
							ap->adr_in = 0;		/* no in filtering  */
							ap->adr_out = 0;	/* no out filtering  */
							if(ap->adr_hom & FDDI_PORT_M) 
								CamAdd((ushort *)&fp->sl);
						}
						else /* FS - Drop the frame if it is from me */
							goto release_frame;
		}
		else
		{
			/* decide on learning or not */
			pp->br_in = 0x8000;		/* inbnd rstr */

			/* if learning is enabled and source address is not */
			/* a multicast pkt, then learn */
			if ((Tmp_Learning & PortBit) && (!(fp->sl & 0x01)))
			{
				if (ap = FreeAdrHead)
				{
					FreeAdrHead = ap->adr_nxt;
					/* learn the new record */
					ap->adr_low = fp->sl;
					ap->adr_mid = fp->sm;
					ap->adr_high = fp->sh;
					ap->adr_hom = PortBit;/*no rcv filter*/
					ap->adr_in = 0;	/* no rcv filtering  */
					ap->adr_out = 0;/* no xmt filtering  */
					ap->adr_flg = ADR_FLG_NUS|ADR_FLG_USD;
					ap->adr_nxt = adr_hshs[Tmp_Hash];
					adr_hshs[Tmp_Hash] = ap;

					/* If Rx'd on Port 4 Add address to the FDDI CAM */
					if( PortBit & FDDI_PORT_M)
						CamAdd((ushort *)&fp->sl);

					/* save the source address record pointer */
					(ADR *)pp->pktXlateSA = ap;
				}
			}
		}

		/* on segment filter */
		if (pp->br_xmt == PortBit) {
			goto release_frame;
		}

		if (Tmp_DontForward & PortBit) {
			goto release_frame;
		}

		{
			register word Tmp_Size = pp->pktDataSize;

			if (!(Tmp_PacketSize & PortBit))
			{
				if( PortNum == FDDI_PORT ) {
					if(Tmp_Size > MAXPACSZSTD - 4 + 6) { /*4=crc, 7=xlate bytes*/
						prccnt.Cnt_TooBig[PortNum]++;
						goto release_frame;
					}
					else
					if( Tmp_Size < MINPACSZEXT ) {      /* YES, MINPACSZEXT */
						prccnt.Cnt_TooSmall[PortNum]++; /* FDDI packets are */
						goto release_frame;				/* allowed to get   */
					}									/* this small.      */
				}
				else
				if ( (Tmp_Size < (MINPACSZSTD - 4)) )
				{
					prccnt.Cnt_TooSmall[PortNum]++;
					goto release_frame;
				}
				else 
				if (Tmp_Size > (MAXPACSZSTD - 4))
				{
					prccnt.Cnt_TooBig[PortNum]++;
					goto release_frame;
				}
			}
			else
			{
				if( PortNum == FDDI_PORT ) {
					if(Tmp_Size > MAXPACSZEXT - 4 + 6) {/*4=crc, 7=xlate bytes*/
						prccnt.Cnt_TooBig[PortNum]++;
						goto release_frame;
					}
					else
					if( Tmp_Size < MINPACSZEXT ) {  /* YES, MINPACSZEXT */
						prccnt.Cnt_TooSmall[PortNum]++;
						goto release_frame;
					}
				}
				else
				if ( (Tmp_Size < (MINPACSZEXT/* - 4*/)) )
				{
					prccnt.Cnt_TooSmall[PortNum]++;
					goto release_frame;
				}
				else if (Tmp_Size > (MAXPACSZEXT - 4))
				{
					prccnt.Cnt_TooBig[PortNum]++;
					goto release_frame;
				}
			}
		}
		/* put it in next queue */
		pp->br_hom = PortNum;
		ProcArrayPtr[in++] = (word)pp;
		continue;

release_frame:
		(pp->pktFree)(pp);	 /* put back on free list */
		}	/* end 'if( pp )' */
		else
			Tmp_ActivePortList &= ~PortBit;
		}	/* end for... */
	} while (Tmp_PktCnt && Tmp_ActivePortList);

    }

	ProcArrayPtr[in] = (word)0;


	/* 
	 * process 2:
	 *   destination filtering
	 *     dst prt enabled
	 *     size
	 *     dst prt restriction
	 *     protocol
	 *     bit mask
	 */
	if (cp->Prc_Filter)
	{
		register int i;
		register word HomePort;
		register word Tmp_ProtPortMask;
		register word Tmp_PortXmtMask;
		register word Tmp_ProtFlt = cp->Prc_ProtFlt;
		register word Tmp_ProtFltMode = cp->Prc_ProtFltMode;
		register word Tmp_BitMskFlt = cp->Prc_BitMskFlt;
		register word Tmp_BitMskFltMode = cp->Prc_BitMskFltMode;

		in = 0;
		out = 0;
		while (pp = (PKT *)ProcArrayPtr[out++])
		{
			Tmp_PortXmtMask = (word)pp->br_xmt;
			fp = (FRMHDR *) pp->pktDataPtr;

			/* determine the protocol type */
			if (Tmp_ProtFlt)
			{
				register word Tmp_Type;

				/* 
				 * decipher the protocol type .  
				 *   This is a simplification that assumes that 
				 *   1) LLC values never collide with type values
				 *   2) LLC values of aa,aa are always SNAPS
				 *   3) SNAPs from all authorities have diff. types
				 */
				if(pp->pktRcvPort == FDDI_PORT)	{  /* Fddi Frame has no len field */
					if( (((XFRMHDR *)fp)->_s) == 0xaaaa ) 
						Tmp_Type = (((XFRMHDR *)fp)->_p);
					else
						Tmp_Type = (((XFRMHDR *)fp)->_s);
					
				}
				else
				if (ntohs_prc_local(Tmp_Type = fp->ln) <= 1518)/*if len,not type*/
					if ((Tmp_Type = fp->_s) == 0xaaaa)/* if SNAP */
						Tmp_Type = fp->_p; 	/* use SNAP */

				Tmp_ProtPortMask = PFilTable[Tmp_Type];
				/* note this protocol's filters flags */
			}


			PortNum = pp->br_hom;
			HomePort = 1 << PortNum;
			for ( i = 0; i != SV_NMBR_PORT; i++, PortNum++)
			{
				if (PortNum == SV_NMBR_PORT)
					PortNum = 0;

				PortBit = 1 << PortNum;

				if (PortBit == HomePort)
				{
					register word Tmp_InboundRestriction;

					/* check source filters */
					if (Tmp_InboundRestriction = /* it is not == */pp->br_in)
					{
						/* known source, inbound multicast filter */
						if ((Tmp_InboundRestriction & ADR_IN_MCS)
						&& (cp->Prc_RestInMcast & PortBit))
							if (fp->dl & 1)
							{
								goto restrict_discard;
							}
						/* known source, inbound unicast filter */
						if ((Tmp_InboundRestriction & ADR_IN_UCS)
						&& (cp->Prc_RestInUcast & PortBit))
							if (!(fp->dl & 1))
							{
								goto restrict_discard;
							}
					}
					/* known destination, outbound filter */
					if ((pp->br_out & PortBit) && (cp->Prc_RestOut & pp->br_xmt))
					{
						goto restrict_discard;
					}
				}
				else
				{
					if (!(Tmp_PortXmtMask & PortBit))
						continue;

						if (pp->br_out & 0x8000)
						{
						/* unknown destination, multicast filter */
							if ((cp->Prc_UnknMcast & PortBit)
							&&  (fp->dl & 1))
							{
								goto restrict_dontxmt;
							}
						/* unknown destination, unicast filter */
							if ((cp->Prc_UnknUcast & PortBit)
							&&  !(fp->dl & 1))
							{
								goto restrict_dontxmt;
							}
						}
				}

				if (Tmp_ProtFlt & PortBit)
				{
					if (Tmp_ProtFltMode & PortBit)
					{
						/* permit */
						if (!(Tmp_ProtPortMask & PortBit))
						{
							goto restrict_dontxmt;
						}
					}
					else
					{
						/* block */
						if (Tmp_ProtPortMask & PortBit)
						{
							goto restrict_dontxmt;
						}
					}
				}

				/* bit mask filtering */
				if (Tmp_BitMskFlt & PortBit)
				{
					if (Tmp_BitMskFltMode & PortBit)
					{
						/* permit */
						if (!eval_bmf(fp, PortNum))
						{
							goto restrict_dontxmt;
						}
					}
					else
					{
						/* block */
						if (eval_bmf(fp, PortNum))
						{
							goto restrict_dontxmt;
						}
					}
				}

				/* continue processing the packet */
				continue;


			restrict_discard:
			restrict_dontxmt:
				/* discard or continue processing the packet */
				if (PortBit == HomePort)
				{
					goto free_packet;
				}
				else
				{
					/* dont transmit on this port */
					Tmp_PortXmtMask ^= (shrt)PortBit;
				}

			}
		
			pp->br_xmt = Tmp_PortXmtMask;
			ProcArrayPtr[in++] = (word)pp;
			continue;
		free_packet:
			(pp->pktFree)(pp);	/* put back on free list */
		}
		ProcArrayPtr[in] = (word)0;
	}

    {
	register word Tmp_Size;
	register word Tmp_RcvPort;
	register word Tmp_PortXmtMask;
	register word Tmp_PacketSize = cp->Prc_PacketSize;
	register word Tmp_DontForward = cp->Prc_DontForward;
	register XFRMHDR* fp;		/* ptr to hdr of FDDI frame to be translated */
	register byte Tmp_xlt_flg;
	register word *fddi_out_ptr = &fddi_out_array[0];  /** SPEED **/
	PKT *xpp;
	PKT *pp1 = (PKT *)0;
	extern int fault_cnt;

	/* process 3 */
	out = 0;
	while (pp = (PKT *)ProcArrayPtr[out++])
	{
		Tmp_PortXmtMask = pp->br_xmt;
		Tmp_PortXmtMask &= ~Tmp_DontForward;
		Tmp_Size = pp->pktDataSize;
		Tmp_RcvPort = pp->pktRcvPort;

		if( Tmp_RcvPort != FDDI_PORT )	
		{
			if( Tmp_Size < MINPACSZSTD-4 )  {
				if( Tmp_PacketSize & Tmp_PortXmtMask ) { /* Does any port have */
														 /* Ext pacsize enabled */
					if( Tmp_Size < MINPACSZEXT-4 ) 
						Tmp_PortXmtMask = 0;
					else {
						if( !(Tmp_PacketSize & 0x1) )
							Tmp_PortXmtMask ^= (shrt) 0x1;
						if( !(Tmp_PacketSize & 0x2) )
							Tmp_PortXmtMask ^= (shrt) 0x2;
						if( !(Tmp_PacketSize & 0x4) )
							Tmp_PortXmtMask ^= (shrt) 0x4;
						if( !(Tmp_PacketSize & 0x8) )
							Tmp_PortXmtMask ^= (shrt) 0x8;
					}
				}
				else 
					Tmp_PortXmtMask = 0;
			}
			else
			if( Tmp_Size > MAXPACSZSTD-4 ) {
				if( Tmp_PacketSize & Tmp_PortXmtMask ) { /* Does any port have */
														 /* Ext pacsize enabled */
					if( Tmp_Size > MAXPACSZEXT-4 ) 
						Tmp_PortXmtMask = 0;
					else {
						if( !(Tmp_PacketSize & 0x1) )
							Tmp_PortXmtMask ^= (shrt) 0x1;
						if( !(Tmp_PacketSize & 0x2) )
							Tmp_PortXmtMask ^= (shrt) 0x2;
						if( !(Tmp_PacketSize & 0x4) )
							Tmp_PortXmtMask ^= (shrt) 0x4;
						if( !(Tmp_PacketSize & 0x8) )
							Tmp_PortXmtMask ^= (shrt) 0x8;
					}
				}
				else 
					Tmp_PortXmtMask = 0;
			}
		}

		/*
		** IF THE FRAME IS TO BE TX'd ON FDDI 
		*/
		if ((byte)Tmp_PortXmtMask & FDDI_PORT_M)
		{
			register PKT* fddi_pp;		/* PKT ptr for fddi frame */
			pp->pktXmtPort = Tmp_PortXmtMask;  /* FS ADD */

			/* Have to do the translation prior to transmitting on
			** either FDDI or Ethernet.
			*/
			if( (fddi_pp = Translate_eth_to_fddi(pp)) ){	/* if OK */


				/* if the frame is also to be tx'd on ethernet */
				if ((byte)Tmp_PortXmtMask & ETH_PORTS_M) {
					(pp->pktBufLink)->pktUseCount++; 
					snc_transmit_pkt(pp, FREE_IT);
				}
				else {
					pp->pktXmtPort = 0;
					(pp->pktFree)(pp);
				}

				*(fddi_out_ptr++) = fddi_pp;  /** SPEED **/

			}
			else  /* If it was also ment for ethernet send it */
			if ((byte)Tmp_PortXmtMask & ETH_PORTS_M) {
				snc_transmit_pkt(pp, FREE_IT);
			}
			else {
				pp->pktXmtPort = 0;
				(pp->pktFree)(pp);	/* put back on free list */
			}

		}
		/* else if the frame is to be tx'd on ethernet only */
		else
		if ((byte)Tmp_PortXmtMask & ETH_PORTS_M)
		{
		  pp->pktXmtPort = Tmp_PortXmtMask;  
		  xpp = pp;
		  if( pp->pktRcvPort == FDDI_PORT ) {	/* if frame is from fddi */

			fp = (XFRMHDR*)((xpp)->pktDataPtr );/* ptr to frame (after FC byte) */
			/* Check for RFC1042 Frame */
			if((fp->_s == 0xaaaa  &&  ((fp->_n) & 0x00ff) == 0x0003) &&
		 		(fp->_a == PID_RFC1042)) {

#if CANTOR
				/* Kluge Fix for Cantor-Fitzgerald, such that ip/arp packets
				** will only get transmitted as EthernetII type frames.
				*/
				if( fp->_p == 0x0008 || fp->_p == 0x0608 || fp->_p == 0x3580 )  {
					Translate_fddi_to_eth(&xpp,ADR_ETH2_TYPE);
				}
				/* Get some translation information from the destination address
				** address record translation flag if present.
				*/
				else
#endif
				if((xpp)->pktXlateDA) {
					Tmp_xlt_flg = ((ADR *)(xpp)->pktXlateDA)->xlt_flg;
					if( Tmp_xlt_flg == ADR_ETH2_TYPE)	 {
						Translate_fddi_to_eth(&xpp,ADR_ETH2_TYPE);
					}
					else
					if( Tmp_xlt_flg == ADR_SNAP_1042_TYPE) {
						Translate_fddi_to_eth(&xpp,ADR_SNAP_1042_TYPE);
					}
					else {
						Translate_fddi_to_eth(&xpp,0);
					}
				}
				else {  /* DA is not in address database ==> Sent 2 copies out */
					pp1 = (PKT *)PktShramCopy(xpp);
					if(pp1) {
						Translate_fddi_to_eth(&pp1,ADR_ETH2_TYPE);
						Tmp_Size = pp1->pktTotalSize;
						if( Tmp_Size > MAXPACSZSTD-4 ) {
							if( Tmp_PacketSize & Tmp_PortXmtMask ) { 
								if( Tmp_Size > MAXPACSZEXT-4 ) 
									Tmp_PortXmtMask = 0;
								else {
									if( !(Tmp_PacketSize & 0x1) )
										Tmp_PortXmtMask ^= (shrt) 0x1;
									if( !(Tmp_PacketSize & 0x2) )
										Tmp_PortXmtMask ^= (shrt) 0x2;
									if( !(Tmp_PacketSize & 0x4) )
										Tmp_PortXmtMask ^= (shrt) 0x4;
								}
							}
							else 
								Tmp_PortXmtMask = 0;
						}
						pp1->pktXmtPort = Tmp_PortXmtMask;
		      			snc_transmit_pkt(pp1, FREE_IT); 
					}
					Translate_fddi_to_eth(&xpp,ADR_SNAP_1042_TYPE);
				}
			}
			else  {/* Not RFC1042 Frame */
		    	Translate_fddi_to_eth(&xpp,0);
			}

			/* Perform PacketSize filtering for translated frames.  */
			/* Since frames will be padded out to at least 60 bytes */
			/* we do not need to filter on minimum frame size.      */
			Tmp_Size = xpp->pktTotalSize;
			if( Tmp_Size > MAXPACSZSTD-4 ) {
				if( Tmp_PacketSize & Tmp_PortXmtMask ) { /* Does any port have */
														 /* Ext pacsize enabled */
					if( Tmp_Size > MAXPACSZEXT-4 ) 
						Tmp_PortXmtMask = 0;
					else {
						if( !(Tmp_PacketSize & 0x1) )
							Tmp_PortXmtMask ^= (shrt) 0x1;
						if( !(Tmp_PacketSize & 0x2) )
							Tmp_PortXmtMask ^= (shrt) 0x2;
						if( !(Tmp_PacketSize & 0x4) )
							Tmp_PortXmtMask ^= (shrt) 0x4;
					}
				}
				else 
					Tmp_PortXmtMask = 0;
			}
		  }
			

		  if( xpp ) {
				xpp->pktXmtPort = Tmp_PortXmtMask;
				snc_transmit_pkt(xpp, FREE_IT); 
		  }
		  else {
				pp->pktXmtPort = 0;
			   (pp->pktFree)(pp);
		  }

		}
		else
		   (pp->pktFree)(pp);	/* put back on free list */

	}
	{
	/*** Transmit FDDI Frames all at once ****/
	PKT	*outpp;
	extern unsigned drv_init_flag;
	extern BSI_ADDR_TYPE bsi_dev[];
	extern ushort chnl_flk_tx_led;
    register BSI_REQCH_TYPE *ch_ptr;
	register uint32 ch_num;

	fddi_out_ptr = &fddi_out_array[0];	
	while( (outpp = (PKT *)*fddi_out_ptr) != (PKT *)NULL ) {

		/* fddi_transmit_pkt(*fddi_out_ptr, FREE_IT); */


		if(!drv_init_flag) {
	   
			/* Free chained pkt if it exists */
			if(outpp->pktBufLink)
				((outpp->pktBufLink)->pktFree)(outpp->pktBufLink);

			/* Now free the pkt */
			outpp->pktFree(outpp);
			continue;
		}

		outpp->pktXmtPort &= ~0x08;
		/*
		* send with mac 0, async
		*/
		chnl_flk_tx_led |= 0x08;
		 #define BR_MAC_NUM      0       /* fddi-eth bridge only has one MAC */

		 ch_ptr = bsi_dev->rch0;
		 if (ch_ptr->info_ptr->queued_cnt >= BSI_QUEUE_MAX_SLOT) {
			  ch_ptr = bsi_dev->rch1;
			 if (ch_ptr->info_ptr->queued_cnt >= BSI_QUEUE_MAX_SLOT) {
				FreePktBuf(outpp);
				continue;
						   /* both queues full */
			 }
		}  

		BSI_SendReq(8,BR_MAC_NUM,ch_ptr,outpp,TRUE);

		*(fddi_out_ptr++) = 0;
	}
	}
    }

    if (rlog_cnt)
 	rlog_date_time();
}


pre_proc_prcctl()
{
	register PRCCTL *cp = &prc;
	register word PortNum;
	register word PortBit;
	register word DiscardBeforeLearn = 0;
	register word DontForward = 0;
	register word Tmp_PortStpState;

	for(PortNum = 0, PortBit = 1; PortBit <= SV_MAX_PORT; PortBit <<= 1, PortNum++)
	{
		Tmp_PortStpState = cp->Prc_PortStpState[PortNum];
		if (cp->Prc_PortState & PortBit)
		{
			if (cp->Prc_StpMode)
			{
				if((Tmp_PortStpState == Blocking)||(Tmp_PortStpState == Listening))
					DiscardBeforeLearn |= PortBit;
				if(Tmp_PortStpState != Forwarding)
					DontForward |= PortBit;
			}
		}
		else {
			DiscardBeforeLearn |= PortBit;
			DontForward |= PortBit;
		}

	}

	cp->Prc_DiscardBeforeLearn = DiscardBeforeLearn;
	cp->Prc_DontForward = DontForward;


	cp->Prc_InFilter = cp->Prc_RestInMcast | cp->Prc_RestInUcast;
	cp->Prc_OutFilter = cp->Prc_UnknMcast | cp->Prc_UnknUcast | cp->Prc_RestOut;
	cp->Prc_Filter = cp->Prc_InFilter | cp->Prc_OutFilter | cp->Prc_ProtFlt | cp->Prc_BitMskFlt;

}



/* utility to get a local buffer and copy a frame into it */
prc_send_local(pp)
register PKT *pp;
{
	register PRCCTL *cp = &prc;
	register PKT *pp1;

	/* verify that frame is not too large */
	if ( pp->pktTotalSize > SV_SIZE_LFRM )
		{
		return;
		}

	if( pp->pktRcvPort == FDDI_PORT ) {
		pp->pktDataSize  += 4;
		pp->pktTotalSize += 4;
	}

	pp1 = (PKT *)PktCopy(pp);
	if(pp1)
		SendMessage((MSGHDR *)pp1, (MBOX *)&ReceiveMbox);
}


/* utility to decide the value of a bit mask filter */
eval_bmf(bufp, PortNum)
byte *bufp;	/* frame being filtered */
byte PortNum;	/* mask descriptor */
{
	register BMFE *bp;
	register PRCCTL *cp = &prc;
	word wkspc[BMFOLEN];
	register word index = -1;
	register word b;
	byte *fp;
	byte *mp = &cp->Prc_BitMskFltExp[PortNum][0];

	for (;; mp++)
	{
		switch (b = *mp)
		{
		case BMFO_EOL:
			return wkspc[index];
		case '&': 
			index--;
			wkspc[index] = wkspc[index+1] && wkspc[index];
			continue;
		case '|':  
			index--;
			wkspc[index] = wkspc[index+1] || wkspc[index];
			continue;
		case '!': 
			wkspc[index] = !wkspc[index]; 
			continue;
		default:
			break;
		}

		/* a filter spec */
		bp = &BridgeStatus->BMElement[b - 'a'].BitMask;
		fp = bufp + bp->bm_ofst;

		if (!((word)fp & 3))
		{	/* word alignment */
			wkspc[++index] = !(((*(word *)(fp))
					    & bp->bm_mask)
					    ^ bp->bm_mtch);
		}
		else if (!((word)fp & 1))
		{	/* shrt alignment */
			wkspc[++index] = !((((*(shrt *)(fp))
				            +(*(shrt *)(fp+2)<<16))
					    & bp->bm_mask)
				            ^ bp->bm_mtch);
		}
		else
		{	/* byte alignment */
			wkspc[++index] = !((((*(fp))
				            +(*(fp+1)<<8)
			                    +(*(fp+2)<<16)
				            +(*(fp+3)<<24))
					    & bp->bm_mask)
				            ^ bp->bm_mtch);
		}
	}
}

