#include <krnl.h>
#include <memory.h>
#include <eeprecs.h>
#include <nim960h.h>
#include <uart.h>
#include <dips.h>
#include <led.h>
#include <sys.h>
#include <malloc.h>
#include <nvrecs.h>
#include <sncvar.h>

extern	char 	*end;
extern NIM960_HDR Nim960Header;		/* My nim960 header	*/
extern void init();
extern int NmiInt();
extern int BasicNmiInt();
extern word snc_init;
extern int NumberOfSonicPort;


int fault_cnt;
NVR_SYS nvr_sys;

NVR_FDDI nvr_fddi_rec;
int reset_type;
word debg;

#define STK_LEN 4096
#ifdef FS_PERF
    #define	FDDI_SHRAM_AREA_START	ALIGN(0x50079000,2)
    #define	FDDI_SHRAM_AREA_SIZE	ALIGN(0x00007000,2)
#endif
#define	FDDI_SHRAM_AREA_START	ALIGN(0x500f0000,2)
#define	FDDI_SHRAM_AREA_SIZE	ALIGN(0x00007000,2)

main()
{

	register SYS   *sys_ptr = &sys;
	register char  *stk_ptr;
	word           shram_addr;
	word	       shram_size;

	ShowSLed(0, 0x8ffff);		/* zzz */

	NumberOfSonicPort = SV_NMBR_PORT-1;
	/* init internal data ram used for data variables */
	memset(0x80, 0, (1024 - (0x80 + (2 * 64 /* 4 sets for reg cache */))));

	/* init static ram used for data variables */
	memset(SRAM, 0, (Nim960Header.TextLoadAddress - SRAM));
	memset(sys_ptr, 0, sizeof(SYS));

	fault_cnt = 1;

	if (InitEeprom(EEPROM, EEPROM_SIZE) != EEPROM_AOK)
		printf("EEPROM error: cannot initialize EEPROM\n");

	LoadEeprom();

	if (InitNvram(NVRAM, eep_mfg_rec.eep_nvram_size) != NVRAM_AOK)
		printf("NVRAM error: cannot initialize NVRAM\n"); 

	if(GetFDDIRec(&nvr_fddi_rec))
	{
		printf("Cannot read NVR FDDI Rec.\n");
		PutFDDIRec(&nvr_fddi_rec);
	}

	if (Nvram_Load( NVR_SYS_ADDR, &nvr_sys, NVR_SYS_SIZE ))
	{
		nvr_sys.nvr_reset = 0;
		Nvram_Updt( NVR_SYS_ADDR, &nvr_sys, NVR_SYS_SIZE );
	}

	init_delay(0x100000);
	init_nmi(BasicNmiInt);
	set_leds(LED_BI, LED_BI_COLOR, LED_RDY_RED | LED_ACT_RED);
	set_leds(LED_MONO, LED_MONO_COLOR, 0x0);
#ifdef FSDEBUG
ShowSLed(1, 0x8ffff);		/* zzz */
#endif

	Dip_reset();

	/*
	 *	We bus watchdog timer and the nvram, eeprom lock.
	 *	We let the sonic driver to enable the lan controllers
	 */
	/* enable thin ethernet on port 4 */
	set_ctrl1(CTRL1_BUS_WDT | CTRL1_NVR | CTRL1_EEPROM, DISABLE_BUS_WDT | DISABLE_NVR | DISABLE_EEPROM);
	set_ctrl1(CTRL1_LR0 | CTRL1_LR1 | CTRL1_LR2 | CTRL1_LR3, ENABLE_LR0 | ENABLE_LR1 | ENABLE_LR2 | ENABLE_LR3);
	set_ctrl1(CTRL1_FDDIA_PT | CTRL1_FDDIB_PT, PEER_TREEA_OFF | PEER_TREEB_OFF);
	sys_ptr->sys_baud = GetDipBaud();
	ttyinit(sys_ptr->sys_baud);

	PrintHdr();

	/* init SRAM malloc/free */
	initsmalloc((SRAM + 0x2000), (Nim960Header.TextLoadAddress - (SRAM + 0x2000)));	
    /* init DRAM malloc/free */
	memset((char *)&end, 0, (int)((char *)(DRAM + eep_mfg_rec.eep_dram_size) - (char *)&end));
	initmalloc(&end, DRAM+eep_mfg_rec.eep_dram_size-(int)&end);	

	/*
	* init share ram heap space used by shmalloc
	*/
	memset((char *)SHRAM, 0, eep_mfg_rec.eep_shram_size);
	initshmalloc(FDDI_SHRAM_AREA_START, FDDI_SHRAM_AREA_SIZE);



#ifdef FSDEBUG
ShowSLed(2, 0x8ffff);		/* zzz */
#endif

/*	PostTestAdminBus(); */

	if ((stk_ptr = (char *)smalloc(STK_LEN)) == NULL)
	{
		printf("Abort: not enough static memory! [main()]\n");
		ErrorAbort();
	}
#ifdef FSDEBUG
ShowSLed(3, 0x8ffff);		/* zzz */
#endif
	init_delay(0x400000);
	set_leds(LED_BI, LED_BI_COLOR, LED_RDY_GRN | LED_ACT_OFF);
	init_nmi(NmiInt);
	snc_init = 0;
	disable_wdt();

	fault_cnt = 0; 

#ifdef FSDEBUG
ShowSLed(4, 0x8ffff);		/* zzz */
#endif


	StartKernel(init, (word *)stk_ptr, (int) STK_LEN, (word) 20, (int) 4);
	for(;;)
		ReSchedule();
}


init_delay(count)
int count;
{
	int 	i;
	volatile shrt	dip;

	for(i = 0; i != count; i++)
		dip = *(shrt *)DIPIO;
}

/*
 *	some tummies 
 */

v2_rcv(void *d)

	{
	/*
	 *	we do not handle v2 packet.
	 */
	snc_put_dbd(d);
	}

lat_rcv(void *d, int dummy)

	{
	/*
	 *	we do not handle lat packet
	 */
	snc_put_dbd(d);
	}
IsSlipPort()
	{
	/*
	 *	No, we do not handle slip port like the terminal server
	 */
	return 0;
	}

IsSlipIP()

	{
	/*
	 *	No, we do not support slip like the terminal server
	 */
	return 0;
	}
/*
 *	We do not support the icmp for the name server
 */
icmp_bad_dm(int srcport, int type, int code)
	{
	}	

BasicNmiInt_c()
{
	inc_reset_type();
	reset();
}

inc_reset_type()
{
	int RetCode;

	fault_cnt = 1;
	if (RetCode = Nvram_Load( NVR_SYS_ADDR, &nvr_sys, NVR_SYS_SIZE ))
	{
		printf("Error: (%d) Cannot load SYS REC from NVRAM..\n", RetCode);
	}
	else
	{

		nvr_sys.nvr_reset++;

		if (RetCode = Nvram_Updt( NVR_SYS_ADDR, &nvr_sys, NVR_SYS_SIZE ))
			printf("Error: (%d) Cannot save SYS REC to NVRAM..\n", RetCode);

	}
	fault_cnt = 0;
}

SetBPRingZero()
{
	eep_boot_rec.eep_ring_number = 0;	/* force to ring 0 */
}
