/******************************************************************/
/* 		Copyright (c) 1989, Intel Corporation

   Intel hereby grants you permission to copy, modify, and
   distribute this software and its documentation.  Intel grants
   this permission provided that the above copyright notice
   appears in all copies and that both the copyright notice and
   this permission notice appear in supporting documentation.  In
   addition, Intel grants this permission provided that you
   prominently mark as not part of the original any modifications
   made to this software or documentation, and that the name of
   Intel Corporation not be used in advertising or publicity
   pertaining to distribution of the software or the documentation
   without specific, written prior permission.

   Intel Corporation does not warrant, guarantee or make any
   representations regarding the use of, or the results of the use
   of, the software and documentation in terms of correctness,
   accuracy, reliability, currentness, or otherwise; and you rely
   on the software, documentation and results solely at your own
   risk.							  */
/******************************************************************/

struct fault_data {
	unsigned reserved;
	unsigned override[3];
	unsigned fdata[3];
	unsigned override_data;
	unsigned pc;
	unsigned ac;
	unsigned int	fsubtype:8,
			freserved:8,
			ftype:8,
			fflags:8;
	unsigned int *faddress;
};

void fault_handler();

/*****************************************/
/* Tell fault type			 */
/* 					 */
/*****************************************/
void
fault_handler(fault_ptr)
struct fault_data *fault_ptr;	/* pointer to fault record on stack */
{
	unsigned int type;
	static char *fault_names[] = {
		"Parallel",		/* Type 0 */
		"Trace",		/* Type 1 */
		"Operation",		/* Type 2 */
		"Arithmetic",		/* Type 3 */
		"Floating Point",	/* Type 4 */
		"Constraint",		/* Type 5 */
		"Virtual Memory",	/* Type 6 */
		"Protection",		/* Type 7 */
		"Machine",		/* Type 8 */
		"Structural",		/* Type 9 */
		"Type",			/* Type a */
		"Reserved (0xb)",	/* Type b */
		"Process",		/* Type c */
		"Descriptor",		/* Type d */
		"Event",		/* Type e */
		"Reserved (0xf)"	/* Type f */
	};

	type = fault_ptr->ftype;

	if ( (0 <= type) && (type <= 0x0f /*LAST_FAULT*/) ){
		printf( " %s fault at: ", fault_names[type] );
	} else {
		printf(" Unknown fault of type %X at: ", type );
	}

	printf( "%08X\n", fault_ptr->faddress );
	printf(" Fault record is on stack at %08X: \n", fault_ptr );
	printf(" fdata : %08X %08X %08X\n",
		fault_ptr->fdata[0], fault_ptr->fdata[1], fault_ptr->fdata[2] );
	printf(" fsubtype %02x:     fflags : %02x\n",
			fault_ptr->fsubtype, (unsigned int)fault_ptr->fflags );
	error();
}
