
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	target.h
*
*	$Log:   /b/gregs/bridge/include/target.h_v  $
 * 
 *    Rev 1.5   12 Oct 1993 09:12:50   franks
 * No change.
 * 
 *    Rev 1.4   29 Sep 1993 09:35:32   franks
 * No change.
 * 
 *    Rev 1.3   10 Sep 1993 15:19:50   franks
 * No change.
 * 
 *    Rev 1.2   08 Sep 1993 11:04:14   franks
 * No change.
 * 
 *    Rev 1.1   19 Aug 1993 08:05:44   franks
 * Changed the number of hidden addresses to seven.
 * 
 *    Rev 1.0   07 Jul 1993 09:06:06   franks
 * Initial revision.
 * 
 *    Rev 1.0   31 Mar 1992 18:08:46   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#ifndef __TARGET_H
#define	__TARGET_H

#define	MAX_PORTS	8	/* we can support up to this # of ports	*/

extern	int	NumberOfSonicPort; /* will be stored in here	*/

#define	SV_NMBR_PORT	4	/* number of sonic ports	*/
/* the last port (in port list)	*/
 
#define	STP_PORT_NUMBER	SV_NMBR_PORT	/* number of stp ports	*/

#define	PORT1		0x0001
#define	PORT2		0x0002
#define	PORT3		0x0004
#define	PORT4		0x0008
#define	PORT5		0x0010

#define NumberOfStpPorts	SV_NMBR_PORT
#define	STP_MODE_ENABLE		1
#define	STP_MODE_DISABLE	0

/*
 *	Program to be executed by the KERNEL
 */
#define APPL_KRNL	0
#define	APPL_BRIDGE	1
#define	APPL_CONFIG	2
#define	APPL_PACKET	3
#define	APPL_TFTP	4
#define	APPL_RESET	5

typedef struct appl
	{
	int	run_appl;
	int	inited[6];
	}APPL;

#define	ADR_REC_CNT	4007	/* how many addresses in the database	*/
				/* Seven of these are local i.e. hidden */
				/* addressed assigned to port 0 used to */
				/* identify addresses that the bridge   */
				/* should listen for and respond to.	*/
#define NVRADR_REC_CNT   800

#endif
