
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	prcadr.h
*
*	$Log:   /b/gregs/bridge/include/prcadr.h_v  $
 * 
 *    Rev 1.5   14 Oct 1993 10:54:02   gregs
 * Added a new field to the ADR structure to support fddi/ethernet translation.
 * 
 *    Rev 1.4   12 Oct 1993 09:12:40   franks
 * No change.
 * 
 *    Rev 1.3   29 Sep 1993 09:35:20   franks
 * No change.
 * 
 *    Rev 1.2   10 Sep 1993 15:19:38   franks
 * No change.
 * 
 *    Rev 1.1   08 Sep 1993 11:03:16   franks
 * No change.
 * 
 *    Rev 1.0   07 Jul 1993 09:05:54   franks
 * Initial revision.
 * 
 *    Rev 1.0   31 Mar 1992 18:08:36   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:	D.B.Suresh
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

/*
 * BRIDGE PAKCET PROCESSOR ADDRESS RECORD STRUCTURE
 */

#ifndef __PRCADR_H
#define __PRCADR_H  0x100a  /* V1.00a */

#ifndef __DBD_H
#include "dbd.h"
#endif

/* the learned address structure */
typedef struct adr_rec
	{
	struct adr_rec *adr_nxt;
	shrt	adr_low;
	shrt	adr_mid;
	shrt	adr_high;
	byte 	adr_hom;	/* port(s) where this address lives */
	byte	adr_out;	/* restrict frames out to these ports */
	byte 	adr_in; 	/* restrict frames in flags */
	byte 	adr_flg;	/* record in use flag; record used flag */
	byte 	xlt_flg; 	/* eth / fddi frame translation flag  */
	} ADR;

/* adr_in  bits */
#define ADR_IN_UCS	0x01	/* filter all records */
#define ADR_IN_MCS	0x02	/* filter only multicasts */

/* adr_flg bits */
#define ADR_FLG_NUS	0x01	/* record is in use */
#define ADR_FLG_USD	0x02	/* record has been used recently */
#define ADR_FLG_STC	0x04	/* record is static */

/* some special port locations (flagged by 0x80 bit being set */
#define ADR_HOM_FORME	0x80
#define ADR_HOM_SPT	ADR_HOM_FORME
#define ADR_HOM_ME	ADR_HOM_FORME
#define ADR_BCST_BIT	0x40
#define ADR_HOM_BCST  	0xCF

extern ADR *adr_recs;
#define ADR_HSH_CNT 0x8000
extern ADR **adr_hshs;

extern ADR *prc_get_addr();
extern prc_put_addr();

/* some defines to for the translation flag */
#define ADR_ETH2_TYPE	0x01
#define ADR_SNAP_1042_TYPE	0x02
#define ADR_8023_TYPE	0x04

#endif
