
#ifndef __NVRAM_H
#define __NVRAM_H

#ifndef __TYPES_H
#include <types.h>
#endif

#define MAX_NVRAM_RECS	128

/*	All the NVRAM reccords should start on a even boundary and */
/*	the size should also be even */
/* 	nvram_hdr structure contains information about all the     */
/* 	NVRAM records, the starting address and the size */

typedef struct nvram_hdr
	{
		struct nvr_recs 
		{
			byte	*start_addr;
			int	size;
		} nvr_recs[MAX_NVRAM_RECS];
		u_short nvhd_cksm;
	} NVRAM_HDR;


#define NVRAM_HDR_SIZE  ALIGN(sizeof(NVRAM_HDR),2)

/*	NVRAM error definitions 	*/

#define NVRAM_AOK	0	/* No error */
#define NVRAM_ALNERR	1	/* the offset or the size is odd */
#define NVRAM_NOSUCH	2	/* The block is not defined in the header */
#define NVRAM_CSERR	3	/* Checksum error */
#define NVRAM_NOSPACE	4
#define NVRAM_BADSIZE	5

extern  NVRAM_HDR	Nvram_header;
#endif
