
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	led.h
*
*	$Log:   /b/gregs/bridge/include/led.h_v  $
 * 
 *    Rev 1.8   12 Oct 1993 09:12:32   franks
 * No change.
 * 
 *    Rev 1.7   29 Sep 1993 09:35:04   franks
 * No change.
 * 
 *    Rev 1.6   10 Sep 1993 15:19:28   franks
 * No change.
 * 
 *    Rev 1.5   08 Sep 1993 11:02:50   franks
 * No change.
 * 
 *    Rev 1.4   03 Sep 1993 11:55:32   vinay
 * changed LED_TESTER to LED_ACT_GRN | LED_RDY_RED
 * 
 *    Rev 1.3   31 Aug 1993 09:47:18   gregs
 * changed the led sequence of LED_TESTER
 * 
 *    Rev 1.2   16 Jul 1993 08:29:38   gregs
 * Removed peer/tree LED defs (now in sys.h)
 * 
 *    Rev 1.1   15 Jul 1993 16:14:44   gregs
 * 
 *    Rev 1.0   07 Jul 1993 09:05:40   franks
 * Initial revision.
 * 
 *    Rev 1.0   31 Mar 1992 18:08:30   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#ifndef __LED_H
#define __LED_H

/* There are 2 h/w registers for driving LEDs */

/*
	Definitions for LED write register 1, which includes the following:
		d0, d1  -  ready (bi-color)
		d2, d3  -  active (bi-color)
		d4		-  FDDI port A rx
		d5		-  FDDI port A LE
		d6		-  FDDI port B rx
		d7		-  FDDI port B LE
*/

#define LED_RDY 0x0003
#define LED_ACT 0x000c

#define LED_OFF 0x00
#define LED_RED 0x01
#define LED_GRN 0x02

#define LED_RDY_OFF	LED_OFF
#define LED_RDY_RED	LED_RED
#define LED_RDY_GRN	LED_GRN

#define LED_ACT_OFF	(LED_OFF << 2)
#define LED_ACT_RED	(LED_RED << 2)
#define LED_ACT_GRN	(LED_GRN << 2)

#define	LED_RXA		0x10		/* FDDI port A rx */
#define	LED_RXB		0x40		/* FDDI port B rx */
#define	LED_LEA		0x20		/* FDDI port A LE */
#define	LED_LEB		0x80		/* FDDI port B LE */

/*
	Definitions for LED write register 2, which includes the following:
		d0	-  FDDI port A tx
		d1	-  ENET port 1 rx
		d2	-  ENET port 2 rx
		d3	-  ENET port 3 rx
		d4	-  FDDI port B tx
		d5	-  ENET port 1 tx
		d6	-  ENET port 2 tx
		d7	-  ENET port 3 tx
*/

#define LED_BI		0
#define LED_MONO	1

#define LED_TX1		0x0020
#define LED_TX2		0x0040
#define LED_TX3		0x0080
#ifdef notdef
#define LED_TX4		0x0008
#define LED_TX5		0x0010
#define LED_TX6		0x0020
#define LED_TX7		0x0040
#define LED_TX8		0x0080
#endif
#define LED_RX1		0x0002
#define LED_RX2		0x0004
#define LED_RX3		0x0008
#ifdef notdef
#define LED_RX4		0x0800
#define LED_RX5		0x1000
#define LED_RX6		0x2000
#define LED_RX7		0x4000
#define LED_RX8		0x8000
#endif

#define LED_TXA		0x0001		/* tx FDDI port A */
#define LED_TXB		0x0010		/* tx FDDI port B */

#define LED_BI_COLOR 	0x000f
#define LED_MONO_COLOR 	0xffff

#define LED_TX1_GRN 	0x0010
#define LED_TX4_GRN 	0x0080
#define LED_RX1_GRN 	0x0001
#define LED_RX4_GRN 	0x0008
#ifdef notdef
#define LED_TX1_GRN 	LED_TX1
#define LED_TX2_GRN 	LED_TX2
#define LED_TX3_GRN 	LED_TX3
#define LED_TX4_GRN 	LED_TX4
#define LED_TX5_GRN 	LED_TX5
#define LED_TX6_GRN 	LED_TX6
#define LED_TX7_GRN 	LED_TX7
#define LED_TX8_GRN 	LED_TX8
#define LED_RX1_GRN 	LED_RX1
#define LED_RX2_GRN 	LED_RX2
#define LED_RX3_GRN 	LED_RX3
#define LED_RX4_GRN 	LED_RX4
#define LED_RX5_GRN 	LED_RX5
#define LED_RX6_GRN 	LED_RX6
#define LED_RX7_GRN 	LED_RX7
#define LED_RX8_GRN 	LED_RX8

#define LED_TX1_OFF 	0000
#define LED_TX2_OFF 	0000
#define LED_TX3_OFF 	0000
#define LED_TX4_OFF 	0000
#define LED_TX5_OFF 	0000
#define LED_TX6_OFF 	0000
#define LED_TX7_OFF 	0000
#define LED_TX8_OFF 	0000
#define LED_RX1_OFF 	0000
#define LED_RX2_OFF 	0000
#define LED_RX3_OFF 	0000
#define LED_RX4_OFF 	0000
#define LED_RX5_OFF 	0000
#define LED_RX6_OFF 	0000
#define LED_RX7_OFF 	0000
#define LED_RX8_OFF 	0000
#endif

#define	SRAM_TEST	0x0010
#define	DRAM_TEST	0x0020
#define	FPROM_TEST	0x0030
#define	SHRAM_TEST	0x0040
#define	NVRAM_TEST	0x0050
#define	TMR_TEST	0x0060
#define	FLASH_TEST	0x0070
#define	EEPROM_TEST	0x0080
#define	UART_TEST	0x0090
#define	ETHERNET_TEST	0x00a0

/*
 *	BOOTER power on self test
 */
#define	LED_BPOST	(LED_ACT_RED | LED_RDY_OFF)
/*
 * 	KERNEL power on self test
 */
#define	LED_KPOST	(LED_ACT_RED | LED_RDY_RED)
/*
 *	ERROR on self test
 */
#define	LED_ERROR	(LED_ACT_RED | LED_RDY_RED)
/*
 *	BRIDGE initializing
 */
#define	LED_BRINI	(LED_ACT_GRN | LED_RDY_GRN)
/*
 *	BRIDGE bridging (normal operation)
 */
#define	LED_BRIDGE	(LED_ACT_GRN | LED_RDY_GRN)
/*
 *	TESTER program
 */
#define	LED_TESTER	(LED_ACT_GRN | LED_RDY_RED)
/*
 *	packet generator/monitor
 */
#define	LED_TPACKET	(LED_ACT_OFF | LED_RDY_GRN)
/*
 *	BOOTER - tftp
 */
#define	LED_BTFTP	(LED_ACT_RED | LED_RDY_GRN)
/*
 *	TFTP loader 
 */
#define	LED_TTFTP	(LED_ACT_RED | LED_RDY_GRN)

#endif
