/*****************************************************************************
*       Program Name:  nim960 bridge
*
*       Filename:      834util2.c
*
*       $Log:   /b/gregs/bridge/declike/util/834util2.c_v  $
 * 
 *    Rev 1.7   19 Nov 1993 08:56:10   gregs
 * Fixed date/time logging of power fail and button resets.
 * 
 *    Rev 1.6   15 Nov 1993 13:10:06   vinay
 * fixed the discrepency in the number of records actually displayed and the
 * number in Number of Records Displayed:
 * 
 *    Rev 1.5   15 Nov 1993 10:13:26   gregs
 * Fixed extended reset bug.
 * 
 *    Rev 1.4   11 Nov 1993 15:35:26   gregs
 * Reordered the way in which an extended push button reset is processed.
 * 
 *    Rev 1.3   25 Oct 1993 16:17:14   gregs
 * Added debug routine to display address record xlate info
 * 
 *    Rev 1.2   16 Sep 1993 17:19:02   vinay
 * fixed the show reset log function
 * 
 *    Rev 1.1   29 Jul 1993 16:39:16   vinay
 * 
 *    Rev 1.0   04 May 1993 16:04:16   franks
 * Initial revision.
 * 
 *    Rev 1.9   09 Jun 1992 09:21:08   franks
 * 1). Added new routine SetDefaultsAll(). A call to this routine will
 *     set all bridge parameters to their default values. IP-Addresses
 *     will not be affected.
 * 
 *    Rev 1.8   14 May 1992 12:38:52   franks
 * No change.
 * 
 *    Rev 1.7   13 May 1992 15:21:06   franks
 * 1). Removed debugging printf statement.
 * 
 *    Rev 1.6   13 May 1992 14:43:24   franks
 * 1). Changed the SetNidAttribute routines so that the options are not
 *     space sensitive. 
 * 2). Changed the AdrFlg2Octet routine so that it returns the proper 
 *     attribute flags. Buf was not being set to null completely.
 * 
 *    Rev 1.5   04 May 1992 12:52:20   franks
 * No change.
 * 
 *    Rev 1.4   17 Apr 1992 16:18:26   franks
 * No change.
 * 
 *    Rev 1.3   16 Apr 1992 14:47:26   franks
 * No change.
 * 
 *    Rev 1.2   16 Apr 1992 10:52:56   franks
 * 1). Changed SetNidAttribute routine, so that when the RO option is
 *     entered without a port list, a syntax error will occur.
 * 
 *    Rev 1.1   14 Apr 1992 13:16:14   franks
 * 1). Added new routine to get tranceiver module type.
 * 
 *    Rev 1.0   30 Mar 1992 17:51:54   pvcs
 * Initial revision.
*
*       Comments:      Developed for i960 platform.
*
*       (C) Copyright 1991 Hughes LAN Systems
*       
*	Listing of routines in this file:
*
*		
******************************************************************************/

#include <types.h>
#include <target.h>
#include <bridges.h>
#include <utility.h>
#include <krnl.h>
#include <stp.h>
#include <sncvar.h>
#include <nvrecs.h>
#include <prcadr.h> 
#include <prcctl.h>
#include <eeprecs.h>
#include <tcpip.h>
#include <time.h>
#include <sys.h>
#include <led.h>
#include <dips.h>
#include <log.h>
#include <rlog.h>
#include <cpb.h>
#include <priv_tbl.h>
#include <834error.h>
#include <param.h>
#include <ascii.h>
#include <834parser.h>

/*  Function Declarations */
char *PortBitSetOrNot();
char *PortPrcBitSetOrNot();

/*	External variables declaration  */
extern char          *APPLSOFTVERSION;
extern char          *HLSVersion;
extern NVR_BSTATUS   *BridgeStatus;
extern Port_data     port_info[];
extern Bridge_data   bridge_info;
extern PRCCTL        prc;
extern NID           LocalAddress[];
extern NVR_NID_RECS  *NvramNids;
extern NVR_PROTOCOLS nvr_udpd;
extern NVR_RESETLOG  *RstLog;
extern tcpip         *_initp;
extern SV            sv_var[];
extern TIMER         IntervalTimer;
extern TIMER         InactivityTimer;
extern int           ConsoleActive;
extern ADR           *StpNid;
extern NID           STPLAdr;

/* Global Variable Declarations */
struct SymbolicName
{
	char*  NamePtr;				/*	Pointer to symbolic name string  */
	unsigned char VendorID1;	/*	First byte of Ethernet address  */
	unsigned char VendorID2;	/*	Second byte of Ethernet address  */
	unsigned char VendorID3;	/*	Third byte of Ethernet address  */
};

struct SymbolicName Company[] =
{
	"Hughes", 0x00, 0x00, 0x10,
	"Hughes", 0x00, 0x80, 0xbb,
	"DECnet", 0xaa, 0x00, 0x04,
	"SUNmic", 0x08, 0x00, 0x20,
	"HewPac", 0x08, 0x00, 0x09,
	"UBass ", 0x00, 0xdd, 0x00,

	"Novell", 0x00, 0x009, 0x1b,
	"Univtn", 0x08, 0x04, 0x90,
	"Intrln", 0x02, 0x07, 0x01,
	"Kinetx", 0x08, 0x00, 0x89,
	"Exceln", 0x08, 0x00, 0x14,

	"Encore", 0x08, 0x00, 0x4c,
	"WstDig", 0x00, 0x00, 0xc0,
	"VisTec", 0x00, 0x00, 0x22,
	"3Com  ", 0x02, 0x60, 0x8c,
	"DEC   ", 0x08, 0x00, 0x2b,

	"Bridge", 0x08, 0x00, 0x2c,
	"Xerox ", 0x00, 0x00, 0xaa,
	"Cisco ", 0x00, 0x00, 0x0c,
	"UBass ", 0x00, 0xdd, 0x01,
	"Apollo", 0x08, 0x00, 0x1e,

	"CDC   ", 0x08, 0x00, 0x25,
	"Prteon", 0x00, 0x00, 0x93,
	"TRW   ", 0x00, 0x00, 0x2a,
	"CMC   ", 0x02, 0xcf, 0x1f,
	"TI    ", 0x08, 0x00, 0x28,

	"NwkGnl", 0x00, 0x00, 0x65,
	"WllFlt", 0x00, 0x00, 0xa2,
	"NCD   ", 0x00, 0x00, 0xa7,
	"AT+T  ", 0x08, 0x00, 0x10,
	"AmTech", 0x00, 0x00, 0x9f,

	"Tektro", 0x00, 0x00, 0x11,
	"SynOpt", 0x00, 0x00, 0x81,
	"Atltec", 0x00, 0x00, 0xef,
	"Intel ", 0x00, 0xaa, 0x00,
	"ACC   ", 0x08, 0x00, 0x03,

	"ItGrph", 0x08, 0x00, 0x36,
	"Seqnt ", 0x08, 0x00, 0x47,
	"IBM   ", 0x08, 0x00, 0x5a,
	"SilGph", 0x08, 0x00, 0x69,
	"VitaLk", 0x08, 0x00, 0x7c,

	"Xyplex", 0x08, 0x00, 0x87,
	"Pyrd  ", 0x08, 0x00, 0x8b,
	"Ridge ", 0x08, 0x00, 0x68,
	"ComDsg", 0x08, 0x00, 0x67,
	"Unisys", 0x08, 0x00, 0x0b,
};

#define VendorElements (sizeof(Company) / sizeof(struct SymbolicName))

/******************************************************************************/
					/* Start PortStatusScreen() */
PortStatusScreen() {

	PRCCTL *prcctl = &prc;
	int i;
	char Buffer[20];
	NID *PortNid;
	uint mode;
	uint state;
	uint port_no;
	extern char *PortState2Name[]; /* defined in 834stpcmd.c */
	
	printf("\t\t\t\t\t\t\t\t    PORT STATUS \n\n\n");

	printf ("\t\t\t\t    %s 1       %s 2       %s 3       %s 4\n", 
	PORT, PORT, PORT, PORT);

	printf("%-14s", "Physical Addr\t\t");
	for( i = 0; i < ACTUALMAXPORT; i++) {
		PortNid = (NID *) MyNid( i ); 
		PrintSymAdr( (char *)PortNid );
		putchar(' ');
	}
	putchar('\n');
	
	printf("%-14s", "Learning\t\t");
	for (i = 1; i <= MAXPORTBIT; i <<= 1) 
		printf("%-13s", 
		PortBitSetOrNot(&BridgeStatus->Learning, i,ENABLESTRING, DISABLESTRING));
	putchar('\n');
	
	printf("%-14s", "Packet Size\t\t");
	printf("   ");
	for (i = 1; i <= MAXPORTBIT; i <<= 1)  {
		printf("%-13s",
		PortBitSetOrNot(&BridgeStatus->PacketSize,i,EXTENDSTRING, STANDARDSTRING));
	}
	putchar('\n');
	
	printf("%-14s", "Port State\t\t");
	printf("  ");


	for (port_no = 0, i=1; port_no < NumberOfStpPorts; port_no++, i <<= 1) {
			
		mode = (uint)prcctl->Prc_StpMode; 
		if( mode == STP_MODE_ENABLE ) {
			state = (uint)prcctl->Prc_PortStpState[port_no];
			printf("%-13s", PortState2Name[state]);	
		}
		else {
		printf("%-13s",
		PortPrcBitSetOrNot(&BridgeStatus->PortState,i,"FORWARD",DISABLESTRING));
		}
	}
    Scroll(2);

#ifdef THRESHHOLD
	printf("%-14s\t", "Receive Threshold");
	for (i = 1; i <= MAXPORTBIT; i <<= 1)  
	    printf("%-13s",
	    PortBitSetOrNot(&BridgeStatus->RxThreshhold,i,"ENABLED",DISABLESTRING));
	putchar('\n');
#endif

	printf("%-14s\n", "Restrict");
	printf("%-14s", "  Unknown M-cast\t");
	for (i = 1; i <= MAXPORTBIT; i <<= 1)  
		printf("%-13s",
		PortBitSetOrNot(&BridgeStatus->UnkMCast, i,FILTERSTRING,FORWARDSTRING));
	putchar('\n');
	
	printf("%-14s", "  Unknown U-cast\t");
	for (i = 1; i <= MAXPORTBIT; i <<= 1)  
		printf("%-13s",
		PortBitSetOrNot(&BridgeStatus->UnkUCast, i,FILTERSTRING,FORWARDSTRING));
    
	Scroll(2);

	printf("%-14s\n", "Restrict");
	printf("%-14s", "  Inbound U-cast\t");
	for (i = 1; i <= MAXPORTBIT; i <<= 1)  
		printf("%-13s",
		PortBitSetOrNot(&BridgeStatus->RestrictInUCast,i, ENABLESTRING, 
						 DISABLESTRING));
	putchar('\n');

	printf("%-14s", "  Inbound M-cast\t");
	for (i = 1; i <= MAXPORTBIT; i <<= 1)  
		printf("%-13s",
		PortBitSetOrNot(&BridgeStatus->RestrictInMCast,i, ENABLESTRING, 
						 DISABLESTRING));
	putchar('\n');

	printf("%-14s", "  Outbound\t\t");
	printf("  ");
	for (i = 1; i <= MAXPORTBIT; i <<= 1)  
		printf("%-13s",
		PortBitSetOrNot(&BridgeStatus->RestrictOutbound,i, ENABLESTRING, 
						 DISABLESTRING));
		
	Scroll(2);

	printf("%-14s", "Protocol Filter\t\t");
	for (i = 1; i <= MAXPORTBIT; i <<= 1)  
		if(BridgeStatus->ProtFilter & i)
			printf("%-13s",
			PortBitSetOrNot(&BridgeStatus->FilterMode,i,"PERMIT","BLOCK"));
		else
			printf("%-13s", "NONE");
	putchar('\n');

	printf("%-14s", "BitMask Filter\t\t");
	for (i = 1; i <= MAXPORTBIT; i <<= 1)  
		if(prcctl->Prc_BitMskFlt & (byte)i)
			printf("%-13s",
			PortPrcBitSetOrNot(&prcctl->Prc_BitMskFltMode,(byte)i,
							 "PERMIT","BLOCK"));
		else
			printf("%-13s", "NONE");
}
/******************************************************************************/
							/*	Start PrintEachPort	*/
void PrintEachPort(BitPort)
unsigned int BitPort;
{
	PRCCTL *prcctl = &prc;
	unsigned int Number;
	NID       *PortAdr;
	uint MyMode;
	uint *BModeAddr;
	uint Size;
	uint i;
	uint StpMode = (uint)prcctl->Prc_StpMode;
	char Buffer[PROTNUM+MAXUSRTYPE][9];
	extern char *PortState2Name[]; /* defined in 834stpcmd.c */

	switch (BitPort)
	{
		case PORT1:
			Number = NUMBERIC_ONE;
			break;

		case PORT2:
			Number = NUMBERIC_TWO;
			break;

		case PORT3:
			Number = NUMBERIC_THREE;
			break;

		case PORT4:
			Number = NUMBERIC_FOUR;
			break;

		/* 5PORT - Uncomment when using 5 ports
		case PORT5:
			Number = NUMBERIC_FIVE;
			break;
		*/
	}

	Header();
	printf ("\t\t   P O R T    %d    S T A T U S    I N F O R M A T I O N\n\n\n",             Number);
	printf ("%-39s%-39s\n","C O N T R O L", "A D D R E S S    F I L T E R I N G            ");

	if( StpMode ) {
	    printf ("%-22s %-15s %-22s %-15s\n", "PortState",
	    		PortBitSetOrNot(&prcctl->Prc_PortState, BitPort, "ENABLED",
	    		DISABLESTRING),
	    		UNKMCAST, PortBitSetOrNot(&BridgeStatus->UnkMCast, BitPort, 
	    		FILTERSTRING, FORWARDSTRING));
	}
	else {
	    printf ("%-22s %-15s %-22s %-15s\n", "PortState",
	    		PortBitSetOrNot(&prcctl->Prc_PortState, BitPort, "FORWARD",
	    		DISABLESTRING),
	    		UNKMCAST, PortBitSetOrNot(&BridgeStatus->UnkMCast, BitPort, 
	    		FILTERSTRING, FORWARDSTRING));
	}

	printf ("%-22s %-15s %-22s %-15s\n",
			LEARNING, PortBitSetOrNot(&BridgeStatus->Learning, BitPort, ENABLESTRING, DISABLESTRING),
			UNKUCAST, PortBitSetOrNot(&BridgeStatus->UnkUCast, BitPort, FILTERSTRING, FORWARDSTRING));

	printf ("%-22s %-15s %-22s\n",
			PACKETSIZE, PortBitSetOrNot(&BridgeStatus->PacketSize, BitPort, EXTENDSTRING, STANDARDSTRING),
			RESTRICT);

	PortAdr = (NID *)MyNid( Number-1 );	
	printf("%-22s ", "Physical Address");
    PrintSymAdr( (char *) PortAdr);

	printf ("      %-20s %-15s\n",
			RESTRICTINMCAST, PortBitSetOrNot(&BridgeStatus->RestrictInMCast, BitPort, ENABLESTRING, DISABLESTRING));
	

/*	
	if (BridgeStatus->RxThreshhold[Number] == 0)
	{
		printf ("%-22s %-15s   %-20s %-15s\n",
				RXTHRESHHOLD, DISABLESTRING,
				RESTRICTINUCAST, PortBitSetOrNot(&BridgeStatus->RestrictInUCast, BitPort, ENABLESTRING, DISABLESTRING));
	}
	else
	{
		printf ("%-22s %-15d   %-20s %-15s\n",
				RXTHRESHHOLD, BridgeStatus->RxThreshhold[Number],
				RESTRICTINUCAST, PortBitSetOrNot(&BridgeStatus->RestrictInUCast, BitPort, ENABLESTRING, DISABLESTRING));
	}
*/   
		printf("                                         ");
		printf ("%-20s %-15s\n",
				RESTRICTINUCAST, PortBitSetOrNot(&BridgeStatus->RestrictInUCast,
				BitPort, ENABLESTRING, DISABLESTRING));


    printf("                                   ");
	printf ("      %-19s  %-15s\n",
			RESTRICTOUTBOUND, PortBitSetOrNot(&BridgeStatus->RestrictOutbound, BitPort, ENABLESTRING, DISABLESTRING));

	putchar ('\n');

	printf("%-39s", "S P A N N I N G    T R E E");
	printf("%-39s\n", "P R O T O C O L    F I L T E R I N G");

	if( StpMode )
		printf ("%-22s %-15s",
				STATE, STPState(port_info[Number].state));
	else
		printf ("%-22s %-15s",
				STATE, NA);

	printf(" %-22s", "Filtering Mode");

	/* If protocol filtering is enabled for port, then get the mode */
	if( BridgeStatus->ProtFilter & BitPort ) { 

        if( BridgeStatus->FilterMode & BitPort )
            printf(" %-15s\n", PERMITSTR);
        else
            printf(" %-15s\n", BLOCKSTR);
	}
	else
        printf(" %-15s\n","NONE");

	printf("%-22s %-15d", PATHCOST, port_info[Number].path_cost);

	printf(" %-22s \n", "Protocol(s):");
	BuildProtList(Buffer, &Size, BitPort);

	printf ("%-22s %-16d",
			PORTPRIORITY, port_info[Number].port_id >> 8);

	for( i=0; (i < Size) && (i < 4); i++ )
		printf("%-9s", &Buffer[i]);
	putchar('\n');

	printf ("%-39s","Designated");
	
	for( ; (i < Size) && (i < 8); i++ )
		printf("%-9s", &Buffer[i]);
	putchar('\n');

	printf ("%-22s ", "  Bridge");

	if( StpMode ) {
		printf ("%02x%02x%02x%02x%02x%02x ",
				port_info[Number].designated_bridge.stp_address[0],
				port_info[Number].designated_bridge.stp_address[1],
				port_info[Number].designated_bridge.stp_address[2],
				port_info[Number].designated_bridge.stp_address[3],
				port_info[Number].designated_bridge.stp_address[4],
				port_info[Number].designated_bridge.stp_address[5]);

		printf("    ");
	    for( ; (i < Size) && (i < 12); i++ )
	    	printf("%-9s", &Buffer[i]);
	    putchar('\n');

		printf ("%-22s %-16d",
				"  Priority",
				port_info[Number].designated_bridge.priority);

	    for( ; (i < Size) && (i < 16); i++ )
	    	printf("%-9s", &Buffer[i]);
	    putchar('\n');
	}
	else  {
		printf ("%-16s",NA);

	    for( ; (i < Size) && (i < 12); i++ )
	    	printf("%-9s", &Buffer[i]);
	    putchar('\n');

		printf ("%-22s %-16s",
				"  Priority",
				NA);

	    for( ; (i < Size) && (i < 16); i++ )
	    	printf("%-9s", &Buffer[i]);
	    putchar('\n');
	}
		printf("                                       ");
	    for( ; (i < Size) && (i < 20); i++ )
	    	printf("%-9s", &Buffer[i]);
	    putchar('\n');

		printf("                                       ");
	    for( ; (i < Size) && (i < 22); i++ )
	    	printf("%-9s", &Buffer[i]);
}
/*	End PrintEachPort	*/


/******************************************************************************/
/*	Start PortInfo()	*/
PortInfo(Port)
unsigned int *Port;
{
	unsigned int i;

	for (i = 1; i <= MAXPORTBIT; i <<= 1)
	{
		if (i & *Port)  {
			PrintEachPort(i); 
		    if( i <= ((*Port)/2) ) { /* prevent pageinate after last screen */
				if ( Pageinate() )
	  	        return (1);
			}
			else
				printf("\n\n");
        }
	}

	return (0);
}
/*	End PortInfo()	*/

/******************************************************************************/
/*	Start PortBitSetOrNot()  */
char *PortBitSetOrNot(Value, Mask, BitOnString, BitOffString)
unsigned int *Value;
unsigned int Mask;
char *BitOnString, *BitOffString;
{
	if (*Value & Mask)
		return (BitOnString);
	else
		return (BitOffString);
}
/*	End PortBitSetOrNot()  */


/******************************************************************************/
/*	Start PortPrcBitSetOrNot()  */
char *PortPrcBitSetOrNot(Value, Mask, BitOnString, BitOffString)
byte *Value;
byte Mask;
char *BitOnString, *BitOffString;
{
	if (*Value & Mask)
		return (BitOnString);
	else
		return (BitOffString);
}
/*	End PortBitSetOrNot()  */


/******************************************************************************/
/*	Start AddressStatusScreen()  */
void AddressStatusScreen()
{
	PRCCTL *prcctl = &prc;

	PortHeader();

	printf ("%-22s", UNKMCAST);
	PrintPrcBitSetOrNot(&prcctl->Prc_UnknMcast,  FILTERSTRING,FORWARDSTRING);
	putchar ('\n');

	printf ("%-22s", UNKUCAST);
	PrintPrcBitSetOrNot(&prcctl->Prc_UnknUcast, FILTERSTRING,FORWARDSTRING );
	putchar ('\n');

	printf ("%-22s\n", RESTRICT);

	printf ("%-22s", "  Inbound Multi-cast");
	PrintPrcBitSetOrNot(&prcctl->Prc_RestInMcast, ENABLESTRING, DISABLESTRING);
	putchar ('\n');

	printf ("%-22s", "  Inbound Uni-cast");
	PrintPrcBitSetOrNot(&prcctl->Prc_RestInUcast, ENABLESTRING, DISABLESTRING);
	putchar ('\n');

	printf ("%-22s", "  Outbound");
	PrintPrcBitSetOrNot(&prcctl->Prc_RestOut, ENABLESTRING, DISABLESTRING);
	putchar ('\n');
}
/*	End AddressStatusScreen()  */

/******************************************************************************/
						/* Start SetThreshhold() */
SetThreshhold(Vector2, String1, String2, PortMask)
char *Vector2;
char *String1, *String2;
uint PortMask;
{
	unsigned long Value;
	int Threshhold;
	int ReturnCode;


	Value = 0L;

	if (strncmp(String1, Vector2, strlen(String1)) == 0)
	{
		Vector2 += strlen(String1);

		/*	Increment until next non blank character	*/
		while (*Vector2 == ' ' || *Vector2 == '=')
			Vector2++;

		sscanf (Vector2, "%ld", &Value);
		if (Value < MINTHRESH || Value > MAXTHRESH)
			return (ERR_TX_ARG);

		if (Value == MINTHRESH)
			printf ("\n%s\n", DISABLETHRESH);

		Threshhold = TRANSMIT;
		PortThreshhold(&PortMask, (unsigned int)Value, Threshhold);
	}
	else
	if (strncmp(String2, Vector2, strlen(String2)) == 0)
	{
		Vector2 += strlen(String2);

		/*	Increment until next non blank character	*/
		while (*Vector2 == ' ' || *Vector2 == '=')
			Vector2++;

		/*
		sscanf (Vector2, "%ld", &Value);
		if (Value < MINTHRESH || Value > MAXTHRESH)
			return (ERR_TX_ARG);

		if (Value == MINTHRESH)
			printf ("\n%s\n", DISABLETHRESH);
		*/

		Threshhold = RECEIVE;
		PortThreshhold(&PortMask, (unsigned int)Value, Threshhold);
	}
	else
		return (CMD_SYNTAX_ERR);

	return (0);
}
/*	End SetThreshhold()	*/

/******************************************************************************/
                            /* Start SetRxThreshhold() */

SetRxThreshhold( uint PortMask ) {

	uint i;
	uint Port;

	for (i = 1, Port=0; i <= MAXPORTBIT; i <<= 1, Port++)
	{
		if (i & PortMask)
		{
		 sv_vars[Port].sv_rcvwdt = (shrt) 1;
		}
	}
}

/******************************************************************************/
                            /* Start SetRxThreshhold() */

ClearRxThreshhold( uint PortMask ) {

	uint i;
	uint Port;

	for (i = 1, Port=0; i <= MAXPORTBIT; i <<= 1, Port++)
	{
		if (i & PortMask)
		{
		 sv_vars[Port].sv_rcvwdt = (shrt) 0;
		}
	}
}

/******************************************************************************/
					/*	Start PortThreshhold()	*/
PortThreshhold(Port, Value2, TxOrRx)
unsigned int *Port;
unsigned int Value2;
unsigned int TxOrRx;
{
	unsigned int i;

	for (i = 1; i <= MAXPORTBIT; i <<= 1)
	{
		if (i & *Port)
		{
			switch (i)
			{
				case PORT1:
					if (TxOrRx == 1)
						BridgeStatus->TxThreshhold[1] = Value2;
					break;

				case PORT2:
					if (TxOrRx == 1)
						BridgeStatus->TxThreshhold[2] = Value2;
					break;

				case PORT3:
					if (TxOrRx == 1)
						BridgeStatus->TxThreshhold[3] = Value2;
					break;

				case PORT4:
					if (TxOrRx == 1)
						BridgeStatus->TxThreshhold[4] = Value2;
					break;

				case PORT5:
					if (TxOrRx == 1)
						BridgeStatus->TxThreshhold[5] = Value2;
					break;
			}
		}
	}

	return (0);
}
/*	End PortThreshhold()	*/

/******************************************************************************/
/*	Start PortArgument()  */
PortArgument(InputPtr, Which1, Length)
unsigned char *InputPtr;
unsigned int *Which1;
unsigned int *Length;
{
	*Length = 0;
	/*	If the first argument is a '*', set all the bits and return  */
	/*	This does not check any further trailing characters  */
	if (*InputPtr == CHARACTER_ALL)
	{
		SetPortBit(Which1, ALLPORT);
		*Length += 2;
		return(0);
	}

	while (*InputPtr   != NULL &&
		   ((*InputPtr == CHARACTER_ONE)   ||
			(*InputPtr == CHARACTER_TWO)   ||
			(*InputPtr == CHARACTER_THREE) ||
			(*InputPtr == CHARACTER_FOUR)  ||
			(*InputPtr == CHARACTER_FIVE)  || 
			(*InputPtr == SPACE)
		   )
		  )
	{
		switch (*InputPtr)
		{
			case CHARACTER_ONE:
				SetPortBit(Which1, PORT1);
				break;

			case CHARACTER_TWO:
				SetPortBit(Which1, PORT2);
				break;

			case CHARACTER_THREE:
				SetPortBit(Which1, PORT3);
				break;

			case CHARACTER_FOUR:
				SetPortBit(Which1, PORT4);
				break;

			case CHARACTER_FIVE:
				return( CMD_SYNTAX_ERR );	  /* 5PORT -- Delete this line */
				/* SetPortBit(Which1, PORT5); 5PORT -- Uncomment */
				break;

			case ' ':
				while (*InputPtr == SPACE) {
					Length++;
					InputPtr++;
				}
				InputPtr--;
				break;
			
		}
		InputPtr++;
		(*Length)++;
	}
	return (0);
}
/*	End PortArgument()  */

/******************************************************************************/
/*	Start GetWord()  */
GetWord(Buffer1, Vector2)
char *Buffer1;
char *Vector2;
{
	uint cnt = 0;
    
    /* Find start of the word string */
    while( *Vector2 == SPACE )
        Vector2++;

	/*	Get the word by scanning to the next space or null character  */
	/*	The result is store in Buffer1  */
	while ((*Vector2 != SPACE) && (*Vector2 != NULL))
	{
		*Buffer1 = *Vector2;
		Buffer1++;
		Vector2++;
		cnt++;
	}

	return(cnt);
}
/*	End GetWord()  */


/******************************************************************************/
/*	Start PrintXlateRecord()  */
PrintXlateRecord(AddressPtr1, MatchCounter1, FirstTime1, RamOrNot)
ADR *AddressPtr1;
unsigned int *MatchCounter1;
unsigned int *FirstTime1;
uint RamOrNot;
{
	unsigned int SymbolicCounter, SymbolicMatch;
	unsigned char *Address;
	unsigned char Buffer[50];
	struct SymbolicName *Name;

	if ((*MatchCounter1 % RECORDPAGE) == 0)
	{
	    if (*FirstTime1)
		if (Pageinate())
	  	    return (1);

	    *FirstTime1 = TRUE;
		if( RamOrNot == RAM ) 
	    	printf ("\t\t\t\t\t\t       %s\n\n", RAMDatabase);
		else
	    	printf ("\t\t\t\t\t\t       %s\n\n", NVRAMDatabase);
	    PrintAddressHeader();
	}

	(*MatchCounter1)++;

	printf ("%-8d", *MatchCounter1);

	if (BridgeStatus->Miscellaneous & SYMBOLIC)
	{
	    SymbolicMatch = FALSE;

	/*  Linear search, should be O.K. if table is small < 100  */
	    for (SymbolicCounter = 0; SymbolicCounter < VendorElements;
		SymbolicCounter++)  {

		   Name = &Company[SymbolicCounter];
		   if (memcmp(&AddressPtr1->adr_low, &Name->VendorID1, 3) == 0)
		    {
			SymbolicMatch = TRUE;
			break;
		    }
	    }

	    Name = &Company[SymbolicCounter];

	    Address = (unsigned char *)&AddressPtr1->adr_low;

	    if (SymbolicMatch)  {

		Address += 3;
		printf ("    ");
		printf ("%-7s", Name->NamePtr);
		printf ("%02x", *(Address++));
		printf ("%02x", *(Address++));
		printf ("%02x", *Address);
	    }
	    else  {

		printf ("     ");
		printf ("%02x", *(Address++));
		printf ("%02x", *(Address++));
		printf ("%02x", *(Address++));
		printf ("%02x", *(Address++));
		printf ("%02x", *(Address++));
		printf ("%02x", *Address);
  	    }
	}
	else  {
	
	    Address = (unsigned char *)&AddressPtr1->adr_low;
	    printf ("     ");
	    printf ("%02x", *(Address++));
	    printf ("%02x", *(Address++));
	    printf ("%02x", *(Address++));
	    printf ("%02x", *(Address++));
	    printf ("%02x", *(Address++));
	    printf ("%02x", *Address);
	}

	printf ("        ");

	switch (AddressPtr1->adr_hom & ALLPORT)
	{
		case PORT1:
			printf ("1");
			break;

		case PORT2:
			printf ("2");
			break;

		case PORT3:
			printf ("3");
			break;

		case PORT4:
			printf ("4");
			break;

		case PORT5:
			printf ("5");
			break;

		case ALLPORT:
			printf ("*");
			break;
		default: /* DEBUG */
			printf("%d", (AddressPtr1->adr_hom & ALLPORT) );
			break;
	}

	printf ("       ");

	sprintf (Buffer, "%-2s",
			 AddressPtr1->adr_flg & ADR_FLG_STC ? "S" : "  ");

        if( AddressPtr1->adr_in == ADR_FLG_RST )
            sprintf( Buffer+2, "%-3s", "RI");
        else
        if( AddressPtr1->adr_in == ADR_FLG_URST )
            sprintf( Buffer+2, "%-3s", "RIU");
        else
        if( AddressPtr1->adr_in == ADR_FLG_MRST )
            sprintf( Buffer+2, "%-3s", "RIM");
        else
            sprintf( Buffer+2, "%-3s", "   ");


	printf ("%-20s", Buffer);

	if(AddressPtr1->xlt_flg == ADR_ETH2_TYPE)
		printf("Ether Type");
	else
	if(AddressPtr1->xlt_flg == ADR_SNAP_1042_TYPE)
		printf("SNAP Type");
	else
	if(AddressPtr1->xlt_flg == ADR_8023_TYPE)
		printf("8023 Type");
	else
		printf("Empty Type");


	putchar ('\n');

	return (0);
}
/*	End PrintXlateRecord()  */


/******************************************************************************/
/******************************************************************************/
/*	Start PrintRecord()  */
PrintRecord(AddressPtr1, MatchCounter1, FirstTime1, RamOrNot)
ADR *AddressPtr1;
unsigned int *MatchCounter1;
unsigned int *FirstTime1;
uint RamOrNot;
{
	unsigned int SymbolicCounter, SymbolicMatch;
	unsigned char *Address;
	unsigned char Buffer[50];
	struct SymbolicName *Name;

	if ((*MatchCounter1 % RECORDPAGE) == 0)
	{
	    if (*FirstTime1)
		if (Pageinate())
	  	    return (1);

	    *FirstTime1 = TRUE;
		if( RamOrNot == RAM ) 
	    	printf ("\t\t\t\t\t\t       %s\n\n", RAMDatabase);
		else
	    	printf ("\t\t\t\t\t\t       %s\n\n", NVRAMDatabase);
	    PrintAddressHeader();
	}

	(*MatchCounter1)++;

	printf ("%-8d", *MatchCounter1);

	if (BridgeStatus->Miscellaneous & SYMBOLIC)
	{
	    SymbolicMatch = FALSE;

	/*  Linear search, should be O.K. if table is small < 100  */
	    for (SymbolicCounter = 0; SymbolicCounter < VendorElements;
		SymbolicCounter++)  {

		   Name = &Company[SymbolicCounter];
		   if (memcmp(&AddressPtr1->adr_low, &Name->VendorID1, 3) == 0)
		    {
			SymbolicMatch = TRUE;
			break;
		    }
	    }

	    Name = &Company[SymbolicCounter];

	    Address = (unsigned char *)&AddressPtr1->adr_low;

	    if (SymbolicMatch)  {

		Address += 3;
		printf ("    ");
		printf ("%-7s", Name->NamePtr);
		printf ("%02x", *(Address++));
		printf ("%02x", *(Address++));
		printf ("%02x", *Address);
	    }
	    else  {

		printf ("     ");
		printf ("%02x", *(Address++));
		printf ("%02x", *(Address++));
		printf ("%02x", *(Address++));
		printf ("%02x", *(Address++));
		printf ("%02x", *(Address++));
		printf ("%02x", *Address);
  	    }
	}
	else  {
	
	    Address = (unsigned char *)&AddressPtr1->adr_low;
	    printf ("     ");
	    printf ("%02x", *(Address++));
	    printf ("%02x", *(Address++));
	    printf ("%02x", *(Address++));
	    printf ("%02x", *(Address++));
	    printf ("%02x", *(Address++));
	    printf ("%02x", *Address);
	}

	printf ("        ");

	switch (AddressPtr1->adr_hom & ALLPORT)
	{
		case PORT1:
			printf ("1");
			break;

		case PORT2:
			printf ("2");
			break;

		case PORT3:
			printf ("3");
			break;

		case PORT4:
			printf ("4");
			break;

		case PORT5:
			printf ("5");
			break;

		case ALLPORT:
			printf ("*");
			break;
		default: /* DEBUG */
			printf("%d", (AddressPtr1->adr_hom & ALLPORT) );
			break;
	}

	printf ("       ");

	sprintf (Buffer, "%-2s",
			 AddressPtr1->adr_flg & ADR_FLG_STC ? "S" : "  ");

        if( AddressPtr1->adr_in == ADR_FLG_RST )
            sprintf( Buffer+2, "%-3s", "RI");
        else
        if( AddressPtr1->adr_in == ADR_FLG_URST )
            sprintf( Buffer+2, "%-3s", "RIU");
        else
        if( AddressPtr1->adr_in == ADR_FLG_MRST )
            sprintf( Buffer+2, "%-3s", "RIM");
        else
            sprintf( Buffer+2, "%-3s", "   ");


	printf ("%-20s", Buffer);

	if ((AddressPtr1->adr_out & ALLPORT) == ALLPORT)
	    printf ("%6s", "ALL");
	else
	    PrintPortList(AddressPtr1->adr_out);

	putchar ('\n');

	return (0);
}
/*	End PrintRecord()  */


/******************************************************************************/
/*	Start DisplayNid()  */
DisplayNid(ValueMask1, RamOrNvram)
RECORDMASK *ValueMask1;
uint RamOrNvram;
{
	unsigned int i, MatchCounter, FirstTime;
	uint NumRec;
	uint RecCnt = 0;
	uint RecDisp = 0;
	uint flag = 0;
	ADR *AddressPtr;
	unsigned char Temp[6];

	MatchCounter = 0;
	FirstTime = FALSE;

	switch( RamOrNvram )  {

		case RAM: 	AddressPtr = &adr_recs[0];
					NumRec     = ADR_REC_CNT;
					break;

		case NVRam: AddressPtr  = &NvramNids->nvr_nids[0];
					NumRec 		= NVRADR_REC_CNT;
					break;
	}

	for (i = 0; i < NumRec; i++, AddressPtr++)
	{
		Mask(&AddressPtr->adr_low, ValueMask1->AddressMask, Temp);

		/*	Find match for address mask with one or more attributes set   */
		if ((memcmp(Temp, ValueMask1->AddressValue, 6) == 0) &&
			(AddressPtr->adr_hom != 0) &&
			(((ValueMask1->FlagMask & ADR_FLG_STC) == (AddressPtr->adr_flg & ADR_FLG_STC))   &&
             ((ValueMask1->InMask & ADR_FLG_URST)  == (AddressPtr->adr_in & ADR_FLG_URST))   &&
             ((ValueMask1->InMask & ADR_FLG_MRST)  == (AddressPtr->adr_in & ADR_FLG_MRST))   &&
             ((ValueMask1->OutMask & ADR_FLG_ORST_ALL) == (AddressPtr->adr_out & ADR_FLG_ORST_ALL)))
		   ) {
			RecDisp = RecCnt++;
			if ((flag = PrintRecord(AddressPtr,&MatchCounter,&FirstTime,RamOrNvram))) {
				printf("\nNumber of Records Displayed: %d\n", RecDisp);
				return (0);
			}
		}
	}
	printf("\nNumber of Records Displayed: %d\n",flag? RecDisp:RecCnt);
	return (0);
}
/*	End DisplayNid()  */


/******************************************************************************/
/*	Start DisplayNidPort()  */
DisplayNidPort( ValueMask1, RamOrNvram )
RECORDMASK *ValueMask1;
uint RamOrNvram;
{
	unsigned int i, MatchCounter, FirstTime;
	uint NumRec;
	uint RecCnt = 0;
	uint RecDisp = 0;
	uint flag = 0;
	ADR *AddressPtr;

	MatchCounter = 0;
	FirstTime = FALSE;

	switch( RamOrNvram )  {

		case RAM: 	AddressPtr = &adr_recs[0];
					NumRec     = ADR_REC_CNT;
					break;

		case NVRam: AddressPtr  = &NvramNids->nvr_nids[0];
					NumRec		= 800;
					break;
	}

	for (i = 0; i < NumRec; i++, AddressPtr++)
	{

		/*	Find match for port list with one or more attributes set   */
		if ((ValueMask1->PortMask & AddressPtr->adr_hom) &&
			(AddressPtr->adr_hom != 0) &&
			(((ValueMask1->FlagMask & ADR_FLG_STC) == (AddressPtr->adr_flg & ADR_FLG_STC))  &&
			 ((ValueMask1->InMask & ADR_FLG_URST)  == (AddressPtr->adr_in & ADR_FLG_URST))  &&
             ((ValueMask1->InMask & ADR_FLG_MRST)  == (AddressPtr->adr_in & ADR_FLG_MRST))  &&
             ((ValueMask1->OutMask & ADR_FLG_ORST_ALL) == (AddressPtr->adr_out & ADR_FLG_ORST_ALL)))
		   ) {
				RecDisp = RecCnt++;
				if((flag = PrintRecord(AddressPtr,&MatchCounter,&FirstTime,RamOrNvram)))
				{
					printf("\nNumber of Records Displayed: %d\n", RecDisp);
					return (0);
				}
		}
	}
	printf("\nNumber of Records Displayed: %d\n", flag ? RecDisp : RecCnt);
	return (0);
}
/*	End DisplayNidPort()  */


/******************************************************************************/
/*	Start DisplayAddrCnt( RamOrNvram )  */
DisplayAddrCnt( RamOrNvram )
uint RamOrNvram;
{
	unsigned int i;
	uint RecCnt = 0;
	uint RecDisp = 0;
	uint flag = 0;
	uint NumRec;
	ADR *AddressPtr;

	switch( RamOrNvram )  {

		case RAM: 	AddressPtr = &adr_recs[0];
					NumRec     = ADR_REC_CNT;
					break;

		case NVRam: AddressPtr  = &NvramNids->nvr_nids[0];
					NumRec		= 800;
					break;
	}
	for (i = 0; i < NumRec; i++, AddressPtr++) {
		if ( AddressPtr->adr_flg & ADR_FLG_NUS &&
			 AddressPtr->adr_hom != 0 ) 
			RecDisp = RecCnt++;
	}
	if( RamOrNvram == RAM )
		printf("\nAddress Records In Working Database: %d\n\n", RecCnt);
	else
		printf("\nAddress Records In Saved  Database: %d\n\n", RecCnt);
	return (0);
}

/******************************************************************************/
/*	Start DisplayAddressOrPort()  */
DisplayAddressOrPort(ValueMask1, RamOrNvram)
RECORDMASK *ValueMask1;
uint RamOrNvram;
{
	unsigned int i, MatchCounter, FirstTime;
	uint RecCnt = 0;
	uint RecDisp = 0;
	uint flag = 0;
	uint NumRec;
	ADR *AddressPtr;
	unsigned char Temp[6];

	MatchCounter = 0;
	FirstTime = FALSE;

	switch( RamOrNvram )  {

		case RAM: 	AddressPtr = &adr_recs[0];
					NumRec     = ADR_REC_CNT;
					break;

		case NVRam: AddressPtr  = &NvramNids->nvr_nids[0];
					NumRec		= 800;
					break;
	}

	for (i = 0; i < NumRec; i++, AddressPtr++)
	{
		Mask(&AddressPtr->adr_low, ValueMask1->AddressMask, Temp);

		/* If port is specified */
		if (ValueMask1->PortMask != 0)
		{
			if ((ValueMask1->PortMask & AddressPtr->adr_hom) &&
				(AddressPtr->adr_flg & ADR_FLG_NUS) ) {
				RecDisp = RecCnt++;
				if((flag = PrintRecord(AddressPtr,&MatchCounter,&FirstTime,RamOrNvram)))
				{
					printf("\nNumber of Records Displayed: %d\n", RecDisp);
					return (0);
				}
			}
		}

		/* No port specified, list all addresses */
		else
		{
			if ((memcmp(Temp, ValueMask1->AddressValue, 6) == 0) &&
				(AddressPtr->adr_hom != 0) &&
				(AddressPtr->adr_flg & ADR_FLG_NUS) )   {
				RecDisp = RecCnt++;
				if ((flag = PrintRecord(AddressPtr,&MatchCounter,&FirstTime,RamOrNvram)))
				{
					printf("\nNumber of Records Displayed: %d\n", RecDisp);
					return (0);
				}
			}
		}
	}

	printf("\nNumber of Records Displayed: %d\n",flag? RecDisp : RecCnt);
	return (0);
}
/*	End DisplayAddressOrPort()  */


/******************************************************************************/
/*	Start DisplayAddressAndPort()  */
DisplayAddressAndPort(ValueMask1, RamOrNvram)
RECORDMASK *ValueMask1;
uint RamOrNvram;
{
	unsigned int i, MatchCounter, FirstTime;
	ADR *AddressPtr;
	unsigned char Temp[6];
	uint RecCnt = 0;
	uint RecDisp = 0;
	uint flag = 0;

	MatchCounter = 0;
	FirstTime = FALSE;

	for (i = 0; i < ADR_REC_CNT; i++)
	{
		AddressPtr = &adr_recs[i];
		Mask(&AddressPtr->adr_low, ValueMask1->AddressMask, Temp);

        if((memcmp(Temp, ValueMask1->AddressValue, 6) == 0) &&
           (ValueMask1->PortMask & AddressPtr->adr_hom)) {
		   RecDisp = RecCnt++;
           if((flag = PrintRecord(AddressPtr,&MatchCounter,&FirstTime,RamOrNvram )))  {
			  printf("\nNumber of Records Displayed: %d\n", RecDisp);
              return(0);
		   }
		}
	}
	printf("\nNumber of Records Displayed: %d\n",flag ? RecDisp : RecCnt);
	return (0);
}
/*	End DisplayAddressAndPort()  */


/******************************************************************************/
/*	Start SetAttribute()  */
SetAttribute(CharPtr, Value, Len)
register char *CharPtr;		/*	Pointer to input string  */
RECORDMASK *Value;			/*	Store all filter mask values  */
uint *Len;
{

    uint PortMask;
    char *PortL;

	strupr(CharPtr);

	/*	Control settings are optional & can be in any arbitary order  */
	while (*CharPtr != NULL)
	{
		switch (*(CharPtr++))
		{
			case 'S':
				if (Value->FlagMask & ADR_FLG_STC)	/* Duplicate options? */
					return (FAIL);
				else
					Value->FlagMask |= ADR_FLG_STC;
				break;

			case 'R':       /*  Both in and outbound rest */

                if( *(CharPtr) == 'I' ) {

                  if( *(CharPtr+1) == 'M' ) {  
   
					  /* restrict inbound multi-cast only */
                      CharPtr+=2;
                      Value->InMask |= ADR_FLG_MRST;
                  }

                  else           /* restrict inbound uni-cast only */
                  if( *(CharPtr+1) == 'U' ) {

		             /* Duplicate options?  */
				     if (Value->InMask & ADR_FLG_URST)
					    return (FAIL);
				     else {
                        CharPtr+=2;
					    Value->InMask |= ADR_FLG_URST;
                     }
                  }
                  else  {
       
					/* both uni-cast and multi-cast restrict inbound */
                     Value->InMask |= ADR_FLG_RST;
                     CharPtr++;
                  }
                }

                else
                if( *(CharPtr) == 'O' ) {    /* restrict outbound only */
                    CharPtr++;               /* must have a port list  */

                    /* Find start of port list */
                    while( *CharPtr == SPACE || *CharPtr == TAB )
                           CharPtr++;

                    /* Build Port List Mask */
                    PortL = CharPtr;
                    PortList( &PortL, &PortMask, Len );
                    CharPtr = PortL;

                    Value->OutMask |= PortMask;
                }

                else  {

                    Value->InMask |=  ADR_FLG_RST;
                    Value->OutMask |= ADR_FLG_ORST_ALL;
                }

				break;

			case ' ':
				break;

			default:
				return (FAIL);
		}
	}	/* end while */

	return (SUCCEED);
}
/*	End SetAttribute()  */


/******************************************************************************/
					/*	Start SetNidAttribute()  */
SetNidAttribute(CharPtr, Value, Length)
register char *CharPtr;		/* Pointer to input string       */
ADR           *Value;       /* Store all filter mask values  */
uint          *Length;
{

    uint PortMask;
    char *PortL;

	/*	Control settings are optional & can be in any arbitary order  */
	for(; *CharPtr != NULL ;) {
	
		strupr(CharPtr);
		switch (*(CharPtr++)) {
		
			case 'S':   
                /*  Duplicate options?  */
				if (Value->adr_flg & ADR_FLG_STC)		
					return (FAIL);
				else
					Value->adr_flg |= ADR_FLG_STC;
				break;

			case 'R':       /*  Both in and outbound rest */

                if( *(CharPtr) == 'I' ) {

                  /* restrict inbound multi-cast only */
                  if( *(CharPtr+1) == 'M' ) { 
                      CharPtr+=2;
                      Value->adr_in |= ADR_FLG_MRST;
                  }

                  else           /* restrict inbound uni-cast only */
                  if( *(CharPtr+1) == 'U' ) {

				     if (Value->adr_in & ADR_FLG_URST)/* Duplicate options? */
					    return (FAIL);
				     else {
                        CharPtr+=2;
					    Value->adr_in |= ADR_FLG_URST;
                     }
                  }
                  else  {   /* both uni-cast and multi-cast restrict inbound */

                     Value->adr_in |= ADR_FLG_RST;
                     CharPtr++;
                  }
                }
                else
                if( *(CharPtr) == 'O' ) {    /* restrict outbound only */
                    CharPtr+=2;               /* must have a port list  */

                    /* Find start of port list */
                    while( *CharPtr == SPACE || *CharPtr == TAB ) {
                           CharPtr++;
					}

                    /* Build Port List Mask */
                    PortL = CharPtr;
                    PortList( &PortL, &PortMask, Length );
                    CharPtr = PortL;

                    if( PortMask == 0 )  /* Must have a port list */
                        return(FAIL);
                    else
                        Value->adr_out |= PortMask;
                }
                else  {

                    Value->adr_in |=  ADR_FLG_RST;
                    Value->adr_out |= ADR_FLG_ORST_ALL;
                }
				break;

			case ' ':
				break;

			default:
				return (FAIL);
		}
	}	/* end while */
	return (SUCCEED);
}
/*	End SetNidAttribute()  */


/******************************************************************************/
/*  Start ClrNidAttribute()  */

ClrNidAttribute( ADR *AdrNode )  {

    AdrNode->adr_out = 0;
    AdrNode->adr_in  = 0;
    AdrNode->adr_flg = 0;
}
/*	End ClrNidAttribute()  */



/******************************************************************************/
/*	Start PrintPortList()	*/
PrintPortList(Value)
unsigned char Value;
{
	unsigned int i;

	/*	Convert bit value into numeric numbers  */
	for (i = 1; i <= MAXPORTBIT; i <<= 1)
	{
		switch (Value & i)
		{
			case PORT1:
				printf ("1 ");
				break;

			case PORT2:
				printf ("2 ");
				break;

			case PORT3:
				printf ("3 ");
				break;

			case PORT4:
				printf ("4 ");
				break;

			case PORT5:
				printf ("5 ");
				break;

			case ALLPORT:
				printf ("* ");
				break;
		}
	}
}
/*	End PrintPortList()	*/


/******************************************************************************/
/*	Start PrintAddressHeader()  */
PrintAddressHeader()
{
	putchar ('\n');
	printf ("Match Count  Node Address  Live On Port  Attribute  Restrict Outbound Port List\n");
	printf ("-----------  ------------  ------------  ---------  ---------------------------\n");
}
/*	End PrintAddressHeader()  */


/******************************************************************************/
/*	Start Mask()  */
Mask(Address1, Mask1, Temp1)
unsigned char *Address1;
unsigned char *Mask1;
unsigned char *Temp1;
{
	unsigned int i;

	for (i = 0; i < 6; Mask1++, Temp1++, Address1++, i++)
		*Temp1 = *Address1 & *Mask1;

	return (0);
}
/*	End Mask()  */

/******************************************************************************/
/*	Start HexToNid()  */
HexToNid(px, ValueNid, NumBytes1)
register unsigned char *px;			/* pointer to hex string */
ADR *ValueNid;
unsigned int NumBytes1;
{
	char ptr;		                 /* Dummy variable to satisfy, HexValue() */
	unsigned char HighByte, LowByte; /*	Temp for result of HexValue() */
	int i;
	unsigned char *pb, *pc;

    pb = pc = px;

   /* -----------------------------------------------------
    * convert a 12 digit hex-ASCII string to 6 bytes binary
    * , and put the converted string back on top of the first
    * bytes of the input string
    * ----------------------------------------------------- */

	for (i = 0; i < NumBytes1; i++)		/* for each of 6 pairs of digits */
	{
		/* convert hi digit of pair */
		if ((HighByte = HexValue(*px++, &ptr, HIGH)) == BADHEX)	
			return (FAIL);

		/* convert lo digit of pair */
		if ((LowByte = HexValue(*px++, &ptr, LOW)) == BADHEX)		
			return (FAIL);		

		/* store bin val of the 2 hex digits */
		*pb++ = (HighByte << 4) + LowByte;
	}
    memcpy( &ValueNid->adr_low, pc, 6 );
	return (SUCCEED);
}
/*	End HexToNid()  */

/******************************************************************************/
FindNid( adr, np )
ADR *adr;     /* Value of NID to find */
ADR **np;     /* Used to return pointer to nid node */
{
    uint hash;
    unsigned short *fnid = &adr->adr_low;

    hash = HashNid( (NID *)&(adr->adr_low) );
 
    /* Find NID Record In Hash Table */

	/* PrintNid((NID *)&(adr->adr_low) ); */

    for( *np = (ADR *)adr_hshs[hash];
		 (*np != 0) &&
         (memcmp( &((*np)->adr_low), fnid, 6 ) != 0) &&
		 ((*np)->adr_nxt != 0);
         (*np = (*np)->adr_nxt)
       );
	
    if( (memcmp( &(*np)->adr_low, fnid, 6 )) == 0) { 
        return( 0 );
	}
	else
        return( ADR_NOT_FOUND );
}

/******************************************************************************/
/* Start isletter() */
isletter(char ch) {

	if( ch < 'A' )
		return( 0 );
	else
	if( ch > 'Z' && ch < 'a' )
		return( 0 );
	else
	if( ch > 'z' )
		return( 0 );
	else
		return(1);
}
/* End isletter() */

/******************************************************************************/
/*  Start GetPortLst() */
GetPortLst(Buffer1, Vector2)
char *Buffer1;
char *Vector2;
{
   int PortCnt = 0;

   while ((*Vector2 != NULL) && (isletter(*Vector2) == FALSE)) {

      if( *Vector2 != SPACE )  {
          *Buffer1 = *Vector2;
          Buffer1++;
          PortCnt++;
      }
      Vector2++;
   }
   return( PortCnt );
}

/*  End GetPortLst()  */



/******************************************************************************/
/*  Start ModPort()  */
ModPort( uint PortMask, char *Attrib, uint Clear, uint *Len )  {

   unsigned cnt;
   ADR *AddrPtr;
   uint MatchCntr;
   uint RetCode = 0;

   AddrPtr = &adr_recs[0];

   for( cnt = 0; cnt < ADR_REC_CNT; AddrPtr++, cnt++ )  {

       if( (PortMask & AddrPtr->adr_hom) ) {

            ClrNidAttribute( AddrPtr );
            SetInUse( AddrPtr );        /* because it was cleared above */

	        if( Clear == FALSE ) {
		    *Len = 0;
                RetCode = SetNidAttribute(Attrib, AddrPtr, Len);
	        }
       }
   }
   return(RetCode);
}
/* End ModPort() */

/******************************************************************************/
/* DELETE ADDRESS RECORD FROM THE WORKING DATABASE */

DeleteNid( ADR *ap, uint *MatchCnt )  {

    ADR *ap2;
    uint hash;

	*MatchCnt = 0;

	/* If this is an FDDI address then try to remove it from the CAM */
	if( ap->adr_hom & PORT4 ) 
		CamDel((ushort *)&ap->adr_low);


    /* Get Hash Index */
    hash = HashNid( (NID *)&(ap->adr_low) );

	StopLearning();

    /* Find Records Previous Entry In Hash Table */
    for( ap2 = (ADR *)&adr_hshs[hash];
         ap2->adr_nxt != ap && ap2->adr_nxt != 0;
         ap2 = ap2->adr_nxt )
         ;

    if( ap2->adr_nxt !=  ap )  {           /* This Should Never Happen */
		 StartLearning();
         return( ADR_NOT_FOUND );
	}
        /* Detach Record From Hash Table And Free It */
   else   {
        ap2->adr_nxt = ap->adr_nxt;
        prc_put_addr(ap); 
		*MatchCnt = 1;
    } 
	StartLearning();
    return(0);
}


/******************************************************************************/
/* Start DelMultiNids() */
DelMultiNids( RECORDMASK *Mask, uint *MatchCnt )  {

   /* BASED ON THE SELECTION CRITERIA IN VALUEMASK */
   /* SEARCH adr_recs[] FOR MATCHING RECORDS.      */
   /* PASS THE ADDRESS OF THE MATCHING RECORD TO   */
   /* DELETENID() TO REMOVE THE ADDR RECORD FROM   */
   /* THE DATABASE.                                */

   uint cnt;
   uint dummy;     /* dummy variable to satisfy function call */
   ADR *AddrPtr;

   *MatchCnt = 0;
   AddrPtr = &adr_recs[0];

   for( cnt = 0; cnt < ADR_REC_CNT; AddrPtr++, cnt++ )  {

       if( (Mask->PortMask & AddrPtr->adr_hom) &&
		   (AddrPtr->adr_hom != 0) &&
         (((Mask->FlagMask & ADR_FLG_STC) ==
		   (AddrPtr->adr_flg & ADR_FLG_STC))  &&
          ((Mask->InMask & ADR_FLG_URST) ==
		   (AddrPtr->adr_in & ADR_FLG_URST))   &&
          ((Mask->InMask & ADR_FLG_MRST) ==
		   (AddrPtr->adr_in & ADR_FLG_MRST))   &&
          ((Mask->OutMask & ADR_FLG_ORST_ALL) ==
		   (AddrPtr->adr_out & ADR_FLG_ORST_ALL)))
           ) {
               DeleteNid(AddrPtr, &dummy);
			   (*MatchCnt)++;
		}	
   }
   return( 0 );
}
/* End DelMultiNids() */

/*****************************************************************************/
/* Start StopLearning() */
StopLearning() {

	PRCCTL *prcctl = &prc;

	prcctl->Prc_Learning = (byte) 0;
	return(0);
}

/*****************************************************************************/
/* Start StartLearning() */
StartLearning() {

	PRCCTL *prcctl = &prc;

	prcctl->Prc_Learning = (byte)BridgeStatus->Learning;
	return(0);
}

/*****************************************************************************/
	/* Start PrintSymAdr() */
PrintSymAdr( char *Adr ) {

	uint   SymbolicCounter, SymbolicMatch;
	char   *Address;
	struct SymbolicName *Name;

	if (BridgeStatus->Miscellaneous & SYMBOLIC)
	{
	    SymbolicMatch = FALSE;

	/*  Linear search, should be O.K. if table is small < 100  */
	    for (SymbolicCounter = 0; SymbolicCounter < VendorElements;
		SymbolicCounter++)  {

		   Name = &Company[SymbolicCounter];
		   if (memcmp(Adr, &Name->VendorID1, 3) == 0)
		    {
			SymbolicMatch = TRUE;
			break;
		    }
	    }

	    Name = &Company[SymbolicCounter];

	    Address = Adr;

	    if (SymbolicMatch)  {

		Address += 3;
		printf ("%-6s", Name->NamePtr);
		printf ("%02x", *(Address++));
		printf ("%02x", *(Address++));
		printf ("%02x", *Address);
	    }
	    else  {

		printf ("%02x", *(Address++));
		printf ("%02x", *(Address++));
		printf ("%02x", *(Address++));
		printf ("%02x", *(Address++));
		printf ("%02x", *(Address++));
		printf ("%02x", *Address);
  	    }
	}
	else  {
	
	    Address = Adr;
	    printf ("%02x", *(Address++));
	    printf ("%02x", *(Address++));
	    printf ("%02x", *(Address++));
	    printf ("%02x", *(Address++));
	    printf ("%02x", *(Address++));
	    printf ("%02x", *Address);
	}
}


/*****************************************************************************/

/* Define Reset Log Messages */
char *RstMsg[] = {
                   "Power Failure",
                   "Button Reset",
                   "SNMP Reset",
                   "Software Crash",
                   "Self Test Failure",
                   "Software Reset Level 0",
                   "Software Reset Level 1",
                   "Software Reset Level 3",
                   "Software Reset Level 4",
		           "Extended Button Reset",
				   "Software Update"
};

/*****************************************************************************/
ShowRstLog() 
{

	register uint index;
	register RST_ENTRY *rstl;
	register uint count = 0;
	register uint LogNum = 1;
	register RESETLOG *resetlog = &RstLog->nvr_resetlog;
	uint wrap;
	int i;

	if(resetlog->rstlog_count >= RSTLOG_COUNT)
		wrap = TRUE;
	count = resetlog->rstlog_count % RSTLOG_COUNT;

	/* if wrapping occured, print oldest record first, and then wrap to */
	/* the beginning of the log */
	if( wrap ) 
	{
		for(i = 0,index = count; i < RSTLOG_COUNT; i++,index++) 
		{
			if((index % RSTLOG_COUNT) == 0)
				index = 0;
	        	rstl = &resetlog->rstlog[index];

		    	PrintLogRec( rstl, LogNum );
			LogNum++;
		}
	}
	else
	/* if no wrapping, just start printing from the beginning or the log */
		for(index=0; index < count ; index++) 
		{
	        	rstl = &resetlog->rstlog[index];
		    	PrintLogRec( rstl, LogNum );
		    	LogNum++;
		}
    return(0);
}

/*****************************************************************************/
/* Start PrintLogRec() */
PrintLogRec( register RST_ENTRY *rstl, register uint LogNum ) {

	char *space = "   ";
	
    printf("%-5d %02d-%02d-%-6d %02d:%02d:%02d%4s", 
		  LogNum,
          rstl->rstlog_tm_mon,
          (uint) rstl->rstlog_tm_mday,
          (uint) rstl->rstlog_tm_year, (uint) rstl->rstlog_tm_hour, 
          (uint) rstl->rstlog_tm_min, (uint) rstl->rstlog_tm_sec,
		  space); 

    printf(" %-24s %3d %s %2d %s\n",
          RstMsg[rstl->rstlog_msg_no], (uint) rstl->rstlog_up_hour,
          " hrs, ", (uint) rstl->rstlog_up_min, " min" );

	return(0);
}
/*****************************************************************************/
                        /* Start RecordRst() */
RecordRst( uint msg ) {

    uint hours, min;
	uint days, hr, mn, sec;
	uint day, mon, yr;
	uint count;
	register RST_ENTRY *rstl;
	RESETLOG *resetlog = &RstLog->nvr_resetlog;

	count = resetlog->rstlog_count;
	if( count >= RSTLOG_COUNT ) {

		count = resetlog->rstlog_count % RSTLOG_COUNT;
	}

	resetlog->rstlog_count++;
	rstl = &resetlog->rstlog[count];

    GetDate(&day, &mon, &yr);
    GetTime(&hr, &mn, &sec);
    GetUpTime(&days, &hours, &min);

	rstl->rstlog_no      = (shrt) count;
	rstl->rstlog_msg_no  = (shrt) msg;
	rstl->rstlog_up_hour = (shrt) hours;
	rstl->rstlog_up_min  = (shrt) min;
	rstl->rstlog_tm_sec  = (byte) sec;
	rstl->rstlog_tm_min  = (byte) mn;
	rstl->rstlog_tm_hour = (byte) hr;
	rstl->rstlog_tm_mday = (byte) day;
	rstl->rstlog_tm_mon  = (byte) mon;
	rstl->rstlog_tm_year = (shrt) yr;

	/* record in NVRam */
	SaveRstLog();
	return(0);
}

/*****************************************************************************/
ServiceHardWareReset(int reason) {
  
        int retcode;

	switch( reason ) {

		case 0: /* RecordRst(RSTMSG0);  Power Fail */
			retcode=1;
                	break;
                 
		case 1: /* RecordRst(RSTMSG1);  Button Reset */
                        retcode=2;
                        break;

		default:  {

		

				 /* Imitate a level 3 software reset */
				 memset( &Nvram_header, NULL, NVRAM_HDR_SIZE );
	             Nvram_Updt( NVRAM_HDR_ADDR, &Nvram_header, NVRAM_HDR_SIZE );
				 InitNvram(NVRAM, eep_mfg_rec.eep_nvram_size);
                 SetDefaultAll();
	         retcode=3;
#ifdef FSFIX
#endif
			     break; 
		}
	}
    return(retcode);
}

/*****************************************************************************/
ShowRelearnLog() {

	register uint index;
	register uint count;
	register uint LogNum      = 1;
	register RLOG       *rlog = &relearnlog;
	register RLOG_ENTRY *rgl;

	/* Find the latest entry in the reset log */
	count = rlog->rlog_count;

	/* if the relearn log has wrapped */
	if(  rlog->rlog_full) {
		/* position index to the oldest entry in the reset log */
        index = count;
	}
	/* no wrapping has occured, so first entry is the oldest */
    else {
		index = 0;
	}

	/* if wrapping occured, print oldest record first, and then wrap to */
	/* the beginning of the log */
	if( rlog->rlog_full > 0 ) {
		for(; index < RLOG_COUNT; index++) {
	        rgl = &rlog->rlog[index];
		    PrintRLogRec( rgl, LogNum );
			LogNum++;
		}
	}

	/* if no wrapping, just start printing from the beginning or the log */
	for(index=0; index < count && index < RLOG_COUNT; index++) {
        rgl = &rlog->rlog[index];
        PrintRLogRec( rgl, LogNum );
        LogNum++;
    }
    return(0);
}

/******************************************************************************/
                        /* Start PrintRLogRec() */
PrintRLogRec( register RLOG_ENTRY *rgl, register uint LogNum ) {

	char *space = "   ";
	uint to, from;

    printf("%-5d %02d-%02d-%-6d %02d:%02d:%02d%5s", 
		  LogNum,
          rgl->rlog_tm_mon,
          (uint) rgl->rlog_tm_mday,
          (uint) rgl->rlog_tm_year+1900, (uint) rgl->rlog_tm_hour, 
          (uint) rgl->rlog_tm_min, (uint) rgl->rlog_tm_sec,
		  space); 

    PrintNid( &rgl->rlog_nid_lo );
	printf("      Moved from port ");
    from = PortMask2PortNum(rgl->rlog_from_port);
	to   = PortMask2PortNum(rgl->rlog_to_port);
	printf("%d%s%d\n", from," to port ", to);
	return(0);
}

/******************************************************************************/
PortMask2PortNum( uint Mask )  {

	uint i;

	/*	Convert bit value into numeric numbers  */
	for (i = 1; i <= MAXPORTBIT; i <<= 1)
	{
		switch (Mask & i)
		{
			case PORT1:
				return(1);
				
			case PORT2:
				return(2);
			
			case PORT3:
				return(3);
		
			case PORT4:
				return(4);
	
			case PORT5:
				return(5);
		}
	}
    return(0);
}
/******************************************************************************/
/* Start PrintNid() */
PrintNid( NID *nid )  {

	printf("%s",NidToString( nid ));
}
/* End PrintNid() */

/******************************************************************************/
                             /* TimedOut() */
TimedOut(RAM_PIT *pram) {
    printf("\n\nNo activity for %d mins. Console session timed out.\n", 
	   BridgeStatus->TimeOut);
    StopTimer(&InactivityTimer);
    clear_cmd();
    ConsoleActive = FALSE;
    pram->mode = PASSWORDMODE;
    InactiveClose();
    Scroll(21);
}

/******************************************************************************/
                             /* DelStpAddr() */
DelStpAddr() {

    ADR *ap2;
	ADR AdrNode, *ap;
    uint hash;


    memcpy( &(AdrNode.adr_low), &STPLAdr, 6 );

	/* Find the address node */
	if( FindNid( &AdrNode, &ap ) ) 
		return(0);

    /* Get Hash Index */
    hash = HashNid( (NID *)&(ap->adr_low) );

	StopLearning();

    /* Find Records Previous Entry In Hash Table */
    for( ap2 = (ADR *)&adr_hshs[hash];
         ap2->adr_nxt != ap && ap2->adr_nxt != 0;
         ap2 = ap2->adr_nxt )
         ;

    /* Detach Record From Hash Table And Save It */
  
    if( ap2->adr_nxt !=  ap )  {           /* This Should Never Happen */
		 StartLearning();
         return( ADR_NOT_FOUND );
	}
    else {
        ap2->adr_nxt = ap->adr_nxt;
        StpNid = ap;
	}
  
	StartLearning();
    return(0);
}

/******************************************************************************/
                               /* AddStpAddr() */
AddStpAddr() {

	uint i;
	uint hash;
	ADR  *NewAdrNode;

    hash = HashNid( (NID *)&(StpNid->adr_low) );
    NewAdrNode = StpNid;
    NewAdrNode->adr_hom = 0;
    SetInUse( NewAdrNode );
	StopLearning();
    AddToHashTbl( hash, NewAdrNode );
    StartLearning(); 
	return(0);
}

/******************************************************************************/
                               /* Start DisplayNid()  */
DisplayLocalNid() {

	unsigned int i, MatchCounter, FirstTime;
	uint NumRec;
	uint RecCnt = 0;
	uint RecDisp = 0;
	uint flag = 0;
	ADR *AddressPtr;
	unsigned char Temp[6];

	MatchCounter = 0;
	FirstTime = FALSE;


 	AddressPtr = &adr_recs[0];
    NumRec     = ADR_REC_CNT;

	for (i = 0; i < NumRec; i++, AddressPtr++)
	{

		/*	Find match for address mask with one or more attributes set   */
		if ( (AddressPtr->adr_hom == 0)          &&
	         (AddressPtr->adr_flg & ADR_FLG_NUS) ){
			RecDisp = RecCnt++;
			if ((flag = PrintRecord(AddressPtr,&MatchCounter,&FirstTime,RAM))) {
				printf("\nNumber of Records Displayed: %d\n", RecDisp);
				return (0);
			}
		}
	}
	printf("\nNumber of Records Displayed: %d\n",flag ? RecDisp : RecCnt);
	return (0);
}
/*	End DisplayNid()  */

/******************************************************************************/
                               /* Start DisplayXlateNid()  */
DisplayXlateNid() {

	unsigned int i, MatchCounter, FirstTime;
	uint NumRec;
	uint RecCnt = 0;
	uint RecDisp = 0;
	uint flag = 0;
	ADR *AddressPtr;
	unsigned char Temp[6];

	MatchCounter = 0;
	FirstTime = FALSE;


 	AddressPtr = &adr_recs[0];
    NumRec     = ADR_REC_CNT;

	for (i = 0; i < NumRec; i++, AddressPtr++)
	{

		/*	Find match for address mask with one or more attributes set   */
		if ( (AddressPtr->adr_flg & ADR_FLG_NUS) ){
			RecDisp = RecCnt++;
			if ((flag = PrintXlateRecord(AddressPtr,&MatchCounter,&FirstTime,RAM))) {
				printf("\nNumber of Records Displayed: %d\n", RecDisp);
				return (0);
			}
		}
	}
	printf("\nNumber of Records Displayed: %d\n",flag ? RecDisp : RecCnt);
	return (0);
}
/*	End DisplayNid()  */

/******************************************************************************/
                               /* Start LedsOn()  */
LedsOn( uint PortMask ) {

	uint i;

	/*	Convert bit value into numeric numbers  */
	for (i = 1; i <= MAXPORTBIT; i <<= 1)
	{
		switch (PortMask & i)
		{
			case PORT1:
				set_leds(LED_MONO, (LED_TX1 | LED_RX1), (LED_TX1 | LED_RX1));
                break;

			case PORT2:
				set_leds(LED_MONO, (LED_TX2 | LED_RX2), (LED_TX2 | LED_RX2));
                break;
			
			case PORT3:
				set_leds(LED_MONO, (LED_TX3 | LED_RX3), (LED_TX3 | LED_RX3));
				break;
		
			case PORT4:
/****
				set_leds(LED_MONO, (LED_TX4 | LED_RX4), (LED_TX4 | LED_RX4));
****/
				FddiLedsOn();
			    break;
	
			case PORT5: 
				;
		}
	}
    return(0);
}

/******************************************************************************/
                               /* Start LedsOff()  */
LedsOff( uint PortMask ) {

	uint i;

	/*	Convert bit value into numeric numbers  */
	for (i = 1; i <= MAXPORTBIT; i <<= 1)
	{
		switch (PortMask & i)
		{
			case PORT1:
				set_leds(LED_MONO, (LED_TX1 | LED_RX1), (LED_RX1));
				break;
 
			case PORT2:
				set_leds(LED_MONO, (LED_TX2 | LED_RX2), (LED_RX2));
                break;

			case PORT3:
				set_leds(LED_MONO, (LED_TX3 | LED_RX3), (LED_RX3));
                break;

			case PORT4:
/**
				set_leds(LED_MONO, (LED_TX4 | LED_RX4), (LED_RX4));
***/
				FddiTxLedsOff();
                break;

			case PORT5: 
				;
		}
	}
    return(0);
}

/*****************************************************************************/
/*                          Start AdrFlg2Octet()                             */
/* Convert address record flag information into an encoded octet string, for */
/* transmission back to a network manager.                                   */

AdrFlg2Octet(ADR *Rec, char *buf) {

    memset(buf, NULL, 8);

	/* If Static Flag Is Set */
	if( Rec->adr_flg & ADR_FLG_STC )
		buf[0] = 1;

	/* If Restrict OutBound Flag Is Set For Any Port */ 
    if( Rec->adr_out & PORT1 )
		buf[1] = 1;

    if( Rec->adr_out & PORT2 )
		buf[2] = 1;

    if( Rec->adr_out & PORT3 )
		buf[3] = 1;

    if( Rec->adr_out & PORT4 )
		buf[4] = 1;

	/* If Restrict InBound Uni-Cast Flag Is Set */
	if( Rec->adr_in & ADR_FLG_URST )
		buf[5] = 1;

	/* If Restrict InBound Multi-Cast Flag Is Set */
	if( Rec->adr_in & ADR_FLG_MRST )
		buf[6] = 1;

	/* What Port Is This Address On */
    buf[7] = PortMask2PortNum(Rec->adr_hom);    

	return(0);
}

/******************************************************************************/
/*                          Start Filter2Octet()                              */
/* Convert address record flag information into an encoded octet string, for  */
/* transmission back to a network manager.                                    */

Filter2Octet(FILTERREC *Rec, char *buf) {

    memset(buf, NULL, 11); 

	/* If Static Flag Is Set */
    buf[0] = Rec->sflag;

	/* If Restrict OutBound Flag Is Set For Any Port */ 
	buf[1] = Rec->ro1;

	buf[2] = Rec->ro2;

	buf[3] = Rec->ro3;

	buf[4] = Rec->ro4;

	/* If Restrict InBound Uni-Cast Flag Is Set  */
	buf[5] = Rec->riu;

	/* If Restrict InBound Multi-Cast Flag Is Set */
	buf[6] = Rec->rim;

	/* Select Port 1 */
    buf[7]  = Rec->port1;    

	/* Select Port 2 */
    buf[8]  = Rec->port2; 

	/* Select Port 3 */
    buf[9]  = Rec->port3;

	/* Select Port 4 */
    buf[10] = Rec->port4;

	return(0);
}

/*****************************************************************************/
/*                          Start Octet2Filter()                             */
/* Convert an encoded octet string into an useful flag information, for      */
/* storage purposes and to select qualified records for the addr filter table*/

Octet2Filter(FILTERREC *Rec, char *buf, RECORDMASK *Mask ) {


	int val;

	memset(Mask, NULL, sizeof(RECORDMASK));
	
	/* Set Static Flag */
	val = (buf[0] - 0x30);
	if( val < 0 || val > 1 )
		return(1);
	else {
        Rec->sflag = buf[0]; 
		if( val == 1 )
		    Mask->FlagMask |= ADR_FLG_STC;
    }

	/* Set Restrict OutBound Flag  */ 
	val = buf[1] - 0x30;
	if( val < 0 || val > 1 )
		return(1);
	else {
    	Rec->ro1 = buf[1];
		if( val == 1 )
		    Mask->OutMask |= PORT1;
    }

	val = buf[2] - 0x30;
	if( val < 0 || val > 1 )
		return(1);
	else {
    	Rec->ro2 = buf[2];
		if( val == 1 )
		    Mask->OutMask |= PORT2;
    }

	val = buf[3] - 0x30 ;
	if( val < 0 ||val > 1 )
		return(1);
	else {
        Rec->ro3 = buf[3];
		if( val == 1 )
		    Mask->OutMask |= PORT3;
    }

	val = buf[4] - 0x30;
	if( val < 0 || val > 1 )
		return(1);
	else {
    	Rec->ro4 = buf[4];
		if( val == 1 )
		    Mask->OutMask |= PORT4;
    }

	/* Set Restrict InBound Uni-Cast Flag */
	val = buf[5] - 0x30;
	if( val < 0 || val > 1 )
		return(1);
	else {
        Rec->riu = buf[5];
		if( val == 1 )
		    Mask->InMask |= ADR_FLG_URST;
    }

	/* Set Restrict InBound Multi-Cast Flag  */
	val = buf[6] - 0x30;
	if( val < 0 || val > 1 )
		return(1);
	else {
    	Rec->rim = buf[6];
		if( val == 1 )
		    Mask->InMask |= ADR_FLG_MRST;
    }

	/* Select Port 1 */
	val =  buf[7] - 0x30;
	if( val < 0 || val > 1 )
		return(1);
	else {
        Rec->port1 = buf[7];
		if( val == 0 )
		    Mask->PortMask |= PORT1;
    }

	/* Select Port 2 */
	val = buf[8] - 0x30;
	if( val < 0 || val > 1 )
		return(1);
	else {
        Rec->port2 = buf[8];
		if( val == 0 )
		    Mask->PortMask |= PORT2;
    }

	/* Select Port 3 */
	val = buf[9] - 0x30;
	if( val < 0 || val > 1 )
		return(1);
	else {
        Rec->port3 = buf[9];
		if( val == 0 )
		    Mask->PortMask |= PORT3;
    }

	/* Select Port 4 */
	val = buf[10] - 0x30;
	if( val < 0 || val > 1 )
		return(1);
	else {
        Rec->port4 = buf[10];
		if( val == 0 )
		    Mask->PortMask |= PORT4;
    }

	return(0);
}

/*****************************************************************************/
/*                          Start DecodeOctet()                             */
/* Convert an encoded octet string into an useful flag information, for      */
/* setting or modifing database records, ramAddrTab834Entry snmp object*/

DecodeOctet(FILTERREC *Rec, char *buf, RECORDMASK *Mask ) {

	int val;

	memset(Mask, NULL, sizeof(RECORDMASK));
	
	/* Set Static Flag */
	val = (buf[0] - 0x30);
	if( val < 0 || val > 1 )
		return(1);
	else {
        Rec->sflag = buf[0]; 
		if( val == 1 )
		    Mask->FlagMask |= ADR_FLG_STC;
    }

	/* Set Restrict OutBound Flag  */ 
	val = buf[1] - 0x30;
	if( val < 0 || val > 1 )
		return(1);
	else {
    	Rec->ro1 = buf[1];
		if( val == 1 )
		    Mask->OutMask |= PORT1;
    }

	val = buf[2] - 0x30;
	if( val < 0 || val > 1 )
		return(1);
	else {
    	Rec->ro2 = buf[2];
		if( val == 1 )
		    Mask->OutMask |= PORT2;
    }

	val = buf[3] - 0x30 ;
	if( val < 0 ||val > 1 )
		return(1);
	else {
        Rec->ro3 = buf[3];
		if( val == 1 )
		    Mask->OutMask |= PORT3;
    }

	val = buf[4] - 0x30;
	if( val < 0 || val > 1 )
		return(1);
	else {
    	Rec->ro4 = buf[4];
		if( val == 1 )
		    Mask->OutMask |= PORT4;
    }

	/* Set Restrict InBound Uni-Cast Flag */
	val = buf[5] - 0x30;
	if( val < 0 || val > 1 )
		return(1);
	else {
        Rec->riu = buf[5];
		if( val == 1 )
		    Mask->InMask |= ADR_FLG_URST;
    }

	/* Set Restrict InBound Multi-Cast Flag  */
	val = buf[6] - 0x30;
	if( val < 0 || val > 1 )
		return(1);
	else {
    	Rec->rim = buf[6];
		if( val == 1 )
		    Mask->InMask |= ADR_FLG_MRST;
    }

	/* Select Port  */
	val =  buf[7] - 0x30;
	if( val < 1 || val > 4 )
		return(1);
	else {
        /* Rec->port1 = buf[7]; */
		if( val == 1 )
		    Mask->PortMask |= PORT1;
		else
		if( val == 2 )
		    Mask->PortMask |= PORT2;
		else
		if( val == 3 )
		    Mask->PortMask |= PORT3;
		else
		if( val == 4 )
		    Mask->PortMask |= PORT4;
    }

	return(0);
}

/*****************************************************************************/
/*                           Start BuildFilterTbl()                          */
BuildFilterTbl( register ADR *NidTbl[] , RECORDMASK *Mask) {

    register uint num;
    register uint cnt;
    register ADR *AddressPtr;

	memset(&NidTbl[0], NULL, (sizeof(NID *) * ADR_REC_CNT));
    AddressPtr = &adr_recs[0];
    for( cnt=0, num=0; cnt < ADR_REC_CNT; cnt++, AddressPtr++ ) {
        /* Check for rec in-use bit */
        if( (AddressPtr->adr_flg & ADR_FLG_NUS)   &&
			(((Mask->FlagMask & ADR_FLG_STC) == 
			  (AddressPtr->adr_flg & ADR_FLG_STC))   &&
             ((Mask->InMask & ADR_FLG_URST)  == 
			  (AddressPtr->adr_in & ADR_FLG_URST))   &&
             ((Mask->InMask & ADR_FLG_MRST)  == 
			  (AddressPtr->adr_in & ADR_FLG_MRST))   &&
             ((Mask->OutMask & ADR_FLG_ORST_ALL) == 
			  (AddressPtr->adr_out & ADR_FLG_ORST_ALL))) &&
			  (Mask->PortMask & AddressPtr->adr_hom )) {
			
            NidTbl[num] = AddressPtr;
            num++;	
        }
    }
    return(num);
}

/******************************************************************************/
/*                            Start BuildNidTbl()                             */
BuildNidTbl( register ADR *NidTbl[] , char *RefAddr, int RamOrNvram) {

    register uint num;
	register uint RecordCount;
    register uint cnt;
    register ADR *AddressPtr;


	if( RamOrNvram == RAM ) {
        AddressPtr = &adr_recs[0];
	    memset(&NidTbl[0], NULL, (sizeof(NID *) * ADR_REC_CNT));
		RecordCount = ADR_REC_CNT;
	}
	else {
		AddressPtr = &NvramNids->nvr_nids[0];
	    memset(&NidTbl[0], NULL, (sizeof(NID *) * NVRADR_REC_CNT));
		RecordCount = NVRADR_REC_CNT;
	}

    for( cnt=0, num=0; cnt < RecordCount; cnt++, AddressPtr++ ) {
        /* Check for rec in-use bit */
        if( (AddressPtr->adr_flg & ADR_FLG_NUS) && 
			(memcmp(&(AddressPtr->adr_low), RefAddr, 6) >= 0)) {

            NidTbl[num] = AddressPtr;
            num++;	
        }
    }
    return(num);
}

/*****************************************************************************/
/*                           Start BuildNvFilterTbl()                        */
BuildNvFilterTbl( register ADR *NidTbl[] , RECORDMASK *Mask) {

    register uint num;
    register uint cnt;
    register ADR *AddressPtr;

	memset(&NidTbl[0], NULL, (sizeof(NID *) * NVRADR_REC_CNT));
    AddressPtr = &NvramNids->nvr_nids[0];
    for( cnt=0, num=0; cnt < NVRADR_REC_CNT; cnt++, AddressPtr++ ) {
        /* Check for rec in-use bit */
        if( (((Mask->FlagMask & ADR_FLG_STC) == 
			  (AddressPtr->adr_flg & ADR_FLG_STC))   &&
             ((Mask->InMask & ADR_FLG_URST)  == 
			  (AddressPtr->adr_in & ADR_FLG_URST))   &&
             ((Mask->InMask & ADR_FLG_MRST)  == 
			  (AddressPtr->adr_in & ADR_FLG_MRST))   &&
             ((Mask->OutMask & ADR_FLG_ORST_ALL) == 
			  (AddressPtr->adr_out & ADR_FLG_ORST_ALL))) &&
			  (Mask->PortMask & AddressPtr->adr_hom )) {
			
            NidTbl[num] = AddressPtr;
            num++;	
        }
    }
    return(num);
}
/******************************************************************************/
/*                             Start SortNidTbl()                             */
/* Sort the table of address pointers using the QuickSort algorithm           */
SortNidTbl( ADR *NidTbl[], register int left, register int right ) 
{
	register int l, r;
    register ADR *pivot;
    register ADR *AdrBuf;


    l = left;
	r = right;

    pivot = NidTbl[(left + right)/2];

	ReSchedule();
    do {
		while( (memcmp( &(NidTbl[l]->adr_low), &((*pivot).adr_low), 6) < 0) && 
			   (l < right) ) l++; 
        while( (memcmp( &(NidTbl[r]->adr_low), &((*pivot).adr_low), 6) > 0) &&
			   (r > left) ) r--;
		if( l <= r ) {
            AdrBuf = NidTbl[l];
			NidTbl[l] = NidTbl[r];
			NidTbl[r] = AdrBuf;
			l++; 
			r--;
        }
	}  while( l <= r ); 
	
	if(left < r)  SortNidTbl(NidTbl, left, r);
	if(l < right) SortNidTbl(NidTbl, l, right);
}
/******************************************************************************/

GetEntry( ADR *NidTbl[], char *snmpbuf, uint *nextadr, int *entry , int MaxEnt)
{

	char *adr;
	int i;
	uint which;

	/* access the requested entry and make sure it's still a */
	/* valid address. (i.e. not aged or deleted) since the   */
	/* pointer to that record will still exist in the sorted */
	/* array, created when the get-next was first issued .   */
    
	while( !(NidTbl[*entry]->adr_flg & ADR_FLG_NUS) ) {
		*entry++;
		if( *entry > MaxEnt )
			return(1);
	}
        
	/* Build an octet string that contains addr flag information */
    AdrFlg2Octet(NidTbl[*entry], snmpbuf);

	/* Set instance to the next address */
	adr = (char *)&(NidTbl[*entry]->adr_low);
	
	/*
	PrintNid((NID *) adr);
    putchar('\n');
   */ 
	
    for( i=0; i < 6; i++ ) {
		which    = adr[i];
		*nextadr = (which & 0x00ff);
		nextadr++;
	}
	return(0);
}

/******************************************************************************/

GetFilterEntry( ADR *NidTbl[], char *snmpbuf, int *entry , int MaxEnt)
{
	int i;
	uint which;

	/* access the requested entry and make sure it's still a */
	/* valid address. (i.e. not aged or deleted) since the   */
	/* pointer to that record will still exist in the sorted */
	/* array, created when the get-next was first created.   */
    
	while( !(NidTbl[*entry]->adr_flg & ADR_FLG_NUS) ) {
		(*entry)++;
		if( *entry > MaxEnt )
			return(1);
	}
        
	/* Build an octet string that contains addr flag information */
	/* and the mac address.                                      */

	memcpy(snmpbuf, (char *)&(NidTbl[*entry]->adr_low), 6);
    AdrFlg2Octet(NidTbl[*entry], &snmpbuf[6]);

	/* 
	 Set instance to the next address 
	adr = (char *)&(NidTbl[*entry]->adr_low);
	
	PrintNid((NID *) snmpbuf);
    putchar('\n');
	
    for( i=0; i < 6; i++ ) {
		which    = adr[i];
		*nextadr = (which & 0x00ff);
		nextadr++;
	}
	*/
	return(0);
}

/******************************************************************************/

GetSingleFilterEntry( ADR *NidTbl[], char *snmpbuf, int *entry )
{

	/* Build an octet string that contains addr flag information */
	/* and the mac address.                                      */
    memset(snmpbuf, NULL, 14);

	memcpy(snmpbuf, (char *)&(NidTbl[*entry]->adr_low), 6);
    AdrFlg2Octet(NidTbl[*entry], &snmpbuf[6]);

	return(0);
}

/******************************************************************************/
PrintTbl(ADR *NidTbl[], uint NumRec) {

	uint i;
	uint MatchCounter = 0;
	uint FirstTime = FALSE;

	for (i = 0; i < NumRec; i++)
	{
		if (PrintRecord(NidTbl[i],&MatchCounter,&FirstTime,RAM)) {
			printf("\nNumber of Records Displayed: %d\n", i);
			return (0);
		}
	}
}
/******************************************************************************/
InvalidTbl( uint *flag ) {

	*flag = TRUE;
}

/******************************************************************************/
SNMPSetAdrFlags(ADR *rec, RECORDMASK *mask) {

	rec->adr_in   = mask->InMask;
	rec->adr_hom  = mask->PortMask;
	rec->adr_out  = mask->OutMask;
	rec->adr_flg  = mask->FlagMask;
	rec->adr_flg |= ADR_FLG_NUS;
    return(0);
}


/******************************************************************************/
/* Convert snmp instance to a reset log entry */
Instance2Indx( uint inst ) {

	uint LastEntry;
	register RST_ENTRY *rstl;
	RESETLOG *resetlog = &RstLog->nvr_resetlog;

	if( resetlog->rstlog_count >= RSTLOG_COUNT )
	    LastEntry = (resetlog->rstlog_count % RSTLOG_COUNT);
    else
	    LastEntry = (resetlog->rstlog_count);
   
    for(; inst > 0; inst-- ) {

		if( LastEntry == 0 )
		    LastEntry = 7;
        else
            LastEntry--;
	}
    return(LastEntry);
}

/******************************************************************************/
#ifdef notused
char *PrintTransType() {

	char	*s;

	switch( TransceiverType() ) {
		
		case TRANSCEIVER_AUI:
			s = "AUI";
			break;
			
		case TRANSCEIVER_THIN_NET:
			s = "ThinNet";
			break;

		case TRANSCEIVER_10BASET:
			s = "10BASE-T";
			break;

		case TRANSCEIVER_FOIRL:
			s = "FOIRL";
			break;

		case TRANSCEIVER_BLANK:
			s = "NONE";
			break;

		default:
			s = "UNKNOWN";
			break;
	}
	return s;
}
#endif

/*****************************************************************************/
/* This function consists of calls to other functions such that all of the   */
/* bridge parameters are set to default. IP address will not be affected.    */

SetDefaultAll() {

  /* Spanning tree parameters are initialized in SetBridgeDefault() */
  SetBridgeDefault();
  SaveBStatus(); 
  UserProtsToDefault();
 

  /* This call should be made last, so that default parameters  will
   * take effect.
  */
  InitPrcctl();
  
  return 0;
}


/***** clearconnection() Vinay 5.4.93 for ClearSmtConn() *****/
/******
clearconnection(int index)
{
        return 0;
}
********/





