/*****************************************************************************
*       Program Name:  nim960 bridge
*
*       Filename:      834parser.c
*
*       $Log:   /b/gregs/bridge/declike/main/834parser.c_v  $
 * 
 *    Rev 1.4   08 Sep 1993 10:21:50   vinay
 * fixed the pick_a_kw()
 * 
 *    Rev 1.3   29 Jul 1993 16:33:18   vinay
 * 
 *    Rev 1.2   11 Jun 1993 12:05:02   vinay
 * fixed a minor problem
 * 
 *    Rev 1.1   10 May 1993 17:53:40   vinay
 * commented out the ifdef for PREFIX optional kw handling and added the
 * check for strlen of the optional kw and deleted unwanted printf's
 * 
 *    Rev 1.0   04 May 1993 16:03:26   franks
 * Initial revision.
 * 
 *    Rev 1.3   13 May 1992 15:00:32   franks
 * 1). Provided support for command with two keywords.
 * 
 *    Rev 1.2   04 May 1992 12:19:04   franks
 * No change.
 * 
 *    Rev 1.1   14 Apr 1992 13:09:12   franks
 * 1). Fixed bug in find_node routine which caused a type 3 operation fault.
 *     The fault occured when jibberish was entered as part of a help command
 *     line.
 * 
 *    Rev 1.0   30 Mar 1992 17:49:34   pvcs
 * Initial revision.
*
*       Comments:      Developed for i960 platform.
*                       	
*
*       (C) Copyright 1991 Hughes LAN Systems
*       
*	Listing of routines in this file:
*
*		
******************************************************************************/

#include <types.h>
#include <krnl.h>
#include <bridges.h>
#include <dbd.h>
#include <tcpip.h>
#include <param.h>
#include <ascii.h>
#include <834parser.h>
#include <cpb.h>
#include <834error.h>
#include <sys.h>


/* EXTERNAL DEFINITIONS */
extern char      *errmsg[];
extern CMDNODE_T root_node;
extern RAM_PIT rampit;


/**********************************************************/
executecmd(pcpb)
CPB_P pcpb;
{
	int i,retcode;

	if(pcpb->node == 0L)
		pcpb->node=(CMDNODE_P)&root_node;

	remove_tail(pcpb);	 /* remove trailing blanks */
	/* handle the entire command line */
	retcode = parse_cmd_line(pcpb); 
	return( retcode );
}

/**********************************************************/

remove_tail(pcpb)
CPB_P pcpb;
{
	int i;
	
	/* remove trailing blanks */
	for(i=pcpb->cmdlen - 1; (i >= 0) && (pcpb->cmd[i] == BLANK); i--)
		pcpb->cmd[i] = 0;
	pcpb->cmdlen = i + 1;/* adjust the end of command line index */
}

/***********************************************************
**
**     parse_cmd_line
**
**	   function:
**     parse the entire command line
**     input parameters:
**         input port number 
**     output parameters:
**         <> 0   No first-level command keyword is matched
**		   =  0   Done
**
***********************************************************/

parse_cmd_line(pcpb)
CPB_P pcpb;
{
	CMDNODE_P sp; 		/* temporary branch array pointer */
	int retcode=0;					/* return code */
	int length;

	for(; (retcode == 0) && (pcpb->cl_idx < pcpb->cmdlen);)
	{
		if((retcode=find_node(pcpb)) != 0)
			return retcode;

		sp=pcpb->node;
	
		 
		if((pcpb->flags & MULTI_CHAR) && (sp->flag1 & NON_CHAR))
		{ 
		/* if there are char been executed before, then we don't allow
		user to execute service routine for non-characteristic node */

			memset(&pcpb->cmd[pcpb->cl_idx], NULL, strlen(sp->kw)+1);
			memcpy((char *)&pcpb->cmd[pcpb->cl_idx], sp->kw, strlen(sp->kw));
			pcpb->flags |= NO_KW;
			retcode=CMD_SYNTAX_ERR;
			break;
		}
		
		if((pcpb->operation == FSET) && (sp->flag1 & NO_SET))
		{
			memset(&pcpb->cmd[pcpb->cl_idx], NULL, strlen(sp->kw)+1);
			memcpy((char *)&pcpb->cmd[pcpb->cl_idx],sp->kw,strlen(sp->kw));
			pcpb->flags |= NO_KW;
			retcode=CAN_NOT_SET;
			break;
		}

		if(sp->flag1 & NEED_NO_PARM)
		{
			if(pcpb->cl_idx < pcpb->cmdlen)
			{	/* this node should be the last in the command string */
				pcpb->flags |= NO_KW;
				retcode=CMD_SYNTAX_ERR;
				break;
			}
		}
		else 
		if(!(sp->flag1 & PARM_OPT) ) { /* parameter is required */
			
			if (pcpb->cl_idx >= pcpb->cmdlen)
			{	/* but its the end of cmd line */
				retcode=CMD_SYNTAX_ERR;
				pcpb->flags |= NO_KW;
				break;
			}
		}

		/* call service routine */
		if(sp->kw_proc != 0L) 
			retcode = (*sp->kw_proc) (pcpb);

		/* Intercept return code, Do we switch programs? */
		switch( retcode )  {

			case TESTER_PROG:  return( TESTER_PROG );
			
			case PACMON_PROG:  return( PACMON_PROG );

			case TFTP_LOADER:  return( TFTP_LOADER );

			case RESET:		   return( RESET );
		}


		if(retcode == 0)
			if(sp->flag1 & MORE)
			{

				pcpb->flags |= MULTI_CHAR;	/* to indicate there has been at */
			                            	/* least one char executed  */
				pcpb->node = (CMDNODE_P)sp->asc_node;
			}
			else if((sp->branches == 0L) && (pcpb->cl_idx < pcpb->cmdlen))
			{
				pcpb->flags &= ~NO_KW;
				retcode=KW_UNKNOWN;
				break;
			}
			else if((sp->branches != 0L) && (pcpb->cl_idx >= pcpb->cmdlen) &&
			    (sp->flag1 & MORE_TO_COME))
			{
				pcpb->flags |= NO_KW;
				retcode=CMD_SYNTAX_ERR;
				break;
			}
	}
	return(retcode);		/* the command line is done */
}


/***********************************************************
**
**    search_kw
**
**     This routine will search the kw from the command tree,
**
**     The cl_idx will be updated when it returns to caller
**
**********************************************************/

search_kw(pcpb,kw,length)
CPB_P pcpb;
char *kw;
int length;
{
	CMDNODE_P ap;
	int j;
	char *nodekw2;
	int kw2_len;
	char *kw2;
	char kw2_flag=0;
	int kwl;
	int ttl;
	int found=0;
    RAM_PIT *pram = &rampit;
	ttl=length;


	/* Make sure that there is a decendent branch */
	if( pcpb->node->branches == (char *)0 ) {
		return( KW_UNKNOWN );
	}

	for(ap=(CMDNODE_P)pcpb->node->branches;
	    (ap->kw != 0) && (*kw != 0/*>= *ap->kw*/);ap++)  {

        /* 
        getchar();
		printf("KW: %x %s\n",ap->kw, ap->kw);
       */
 
	    /* search for the input kw up to the next alphabet of the 1st char */

		kw2_len=0;

		/* check the min. length of node keyword, if there is one, then  */
		/* the length of the input keyword must be greater than or equal */
		/* to the minlength of node kw                                   */

/*
#ifdef NOTIMPLEMENTED
*/
		if(ap->flag1 & PREFIX)
		{

			/* if this node has optional prefix, try to see if this
			** is a prefix word */
			if(strcmpi(kw,ap->suffix) == 0)
			{


				kw2_len = pick_a_kw(&pcpb->cmd[pcpb->cl_idx+length],&kw2,
				    CASE_SENSITIVE);
				if(*kw2 != 0)
				{
					if(strcmpi(kw2,ap->kw) == 0 &&
					strlen(kw2) >= ap->flag2)
					{
						/* Bingo, found it */
						ttl += kw2_len;
						found = 1;
						break;
					}
					else
					/* if not put the blank back */
					{
						int len=pcpb->cl_idx+length+kw2_len;
						if(len < pcpb->cmdlen)

							pcpb->cmd[len-1] = ' ';
					}

				}

			}

		}
/**
#endif
**/
		/* are there enough characters to recoqnize the command? */
		if((ap->minlen != 0) && (strlen(kw) < ap->minlen))
			continue;

		if(strcmpi(kw,ap->kw) == 0)
		{

			if(ap->flag1 & MKW)
			{

				kw2_len = pick_a_kw(&pcpb->cmd[pcpb->cl_idx+length],&kw2,
				    CASE_SENSITIVE);
				if(*kw2 != 0)
				{
					kw2_flag=1;
					/* if the second key word is required */
					if((j=ap->flag2 & MINLEN_2NDKW) != 0)
					/* if the kw length is less than min required,
					** definitely this is not the one , go to look
					* for the right one again 
					**/
						if((kwl=strlen(kw2)) < j)
							continue;
					/* the kw either optional or have min length required */
					nodekw2=ap->kw+strlen(ap->kw)+1;	/* point to 2nd kw */
					if(strcmpi(kw2,nodekw2) != 0)
					{
						if(j != 0)
						/*   if 2nd kw is required, keep on looking */
							continue;
						else
						/* since is optional, may be 2nd kw is omitted
					   ** it may be a parameter
					   **/
						{
							/* put the blank back, so code can be continue */
							pcpb->cmd[pcpb->cl_idx+length+kw2_len-1]=' ';
							if(kwl < kw2_len)
							{
								/* there must have some leading blank
						  ** update the index
						  **/
								ttl += (kw2_len-kwl);
								found = 1;
							}

							kw2_flag=0;
							break;
						}

					}
					else
					/* match 2nd kw */
					{
						ttl += kw2_len;
						found =1 ;
						break;
					}

				}
				else /**** NO MORE CHARACTERS in the COMMAND LINE *****/
				{
					if((j=ap->flag2 & MINLEN_2NDKW) != 0)
						/* this node required 2nd kw, keep
					 ** on looking to find one which
					 ** 2nd kw is optional
					 **/
						continue;
					else
					/* the 2nd kw of this node is optional,
				   ** this is the one 
				   **/
					{
						found = 1;
						break;
					}
				}
			}
			else
			/* signal kw and matched */
			{
				found = 1;
				break;
			}

		}	/* strcmpi OK */
	}	/* for */

	if(found == 1)
	{
		/* if found the node */
		if((pcpb->operation == FSET && ap->flag1  & NO_SET) ||
		    (pcpb->operation == FDEFINE &&  ap->flag1 & NO_DEFINE))
			return KW_UNKNOWN;
		else    /* don't display hidden commands */
		if((strcmpi("HLS",ap->kw) == 0) && pram->mode == HELPMODE )
			return KW_UNKNOWN;
		else {
		    pcpb->cl_idx += ttl;
		    pcpb->node = ap;
		    return 0;	/* found match */
		}
	}
	if(kw2_flag==1)
		pcpb->cl_idx += length;
	return KW_UNKNOWN;
}

/*****************************************************************************/

find_node(pcpb)
CPB_P pcpb;
{
	CMDNODE_P ap,sp;
	int retcode=0;		/* return status */
	char *kw;
	int l;
	int length;

	/* will just get a word at a time from the command line */
	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_SENSITIVE);

	retcode=search_kw(pcpb,kw,length);

	if(retcode != 0)
	{ /* did not find the kw node, check if any node can be skipped */
		for(ap=(CMDNODE_P)pcpb->node->branches;(ap != 0)&&(ap->kw != 0L); ap++)
		{
			sp = pcpb->node;	/* save the original node */

			if(((ap->flag1 & SKIP) && !(ap->flag1 & ADM_REQ_PARM)) || 
			    (ap->flag1 & SKIP_ALL))
			{
				/* printf("Skipping!\n"); */
				pcpb->node = ap;	/* the skipped node becomes the root now */
				retcode=search_kw(pcpb,kw,length);
				if( retcode == 0 )
					break;
				else
					pcpb->node = sp;
			}
		}
	}

	if(retcode == 0) {
		/* check the optional command suffix */
		if(pcpb->node->suffix != 0L && !(pcpb->node->flag1 & PREFIX))
		{
			l = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_SENSITIVE);
			if(*kw != 0)
			{
				if(strcmpi(kw,pcpb->node->suffix) == 0 &&
					strlen(kw) >= pcpb->node->flag2)
					pcpb->cl_idx += l;
				else
				/* put blank back */
				{
					int xl= pcpb->cl_idx+l;
					if(xl < pcpb->cmdlen)
						pcpb->cmd[xl-1]=' ';
				}

			}
		}
    }
	return retcode;
}

/****************************************************
**
**    pick a word from the command line, the pointer to 
**    the beginning of the word will be returned and number of
**    bytes traveled will be returned
**   
**    This routine will replace the get_a_kw routine later
****************************************************/
int pick_a_kw(cmd,kw,flag)
char *cmd;
char **kw;			/* contains new keyword on return */
int flag;			/* 1 = convert to uppercase, 0 = case sensitive */
{
	int i;
	char *cl;

	cl=cmd;
	for(i=0; *cl == BLANK; cl++, i++)
		;     	/* ignore leading blanks instead of removing them */
	*kw = cl;
	for (; (*cl != BLANK) && (*cl != 0) ; i++,cl++)
		if(flag == CASE_INSENSITIVE)	/* convert keyword string to uppercase */
			*cl = toupper(*cl);
	*cl = 0;
	return i+1;
}

/************************************************************
**
**    usererr 
**
**    print user error routine
**
**     input:
**			output port number
**			error code
**			variable string
**
**************************************************************/

usererr(code,s)
int  code;
CPB_P s;
{
	int i,j;
	char c;
	char *str;

	printf("- %d - ",code);
	code -= 1;
	printf("%s",errmsg[code]);
	if(!(s->flags & NO_KW))
	{
		j=strlen(&s->cmd[s->cl_idx]);
		printf("%s"," <");
		for (i=0,str=&s->cmd[s->cl_idx]; (i < j) && (i < 60); i++)
		{
			if((c=*str++) < 0x20)
				printf("^%1c", c + ('A' - 1));
			else
				if(c == 0x7f)
					printf("%s","del");
				else
					printf("%c",c);
		}
		printf("%s",">");
	}
	printf("\n");
}
