/*

	(C) Copyright 1991 Hughes LAN Systems

	Title:
		helpvar.c: Contains help text strings.	

	Development Date:
		November 26, 1991

	Develop By:
		Frank Salzmann

	Modified By:

*/


char *HLSVersion = "HLS Version";

/*****************************************************************************/
                         /* THE ROOT BRANCH */ 


char TROOT_HELP[] = 

"\n\n\n"
"Online HELP allows you to access information about the Hughes FDDI-Ethernet\n"
"Bridge.\n\n* "
"Choose a HELP topic from the following list:\n\n\n\n\n\n";


char TCLEAR[]  = 

"\n\n" 
"This command deletes configuration information.\n";


char TDATE[]   = 

"{month}-{day}-{year}"
"\n\n" 
"This command sets the current bridge date. Enter the following information\n"
"in the command line:\n\n"
"        month =  Enter a number from 1 to 12.\n"
"        day   =  Enter a number from 1 to 31.\n"
"        year  =  Enter the current year (i.e. 1992).\n\n"
"Example: def mod da 02-12-1992\n\n";


char TDEFINE[] = 

"\n\n"
"This command changes operational chacteristics of the FDDI-Ethernet\n"
"Bridge\n\n";


char TEXIT[]   = 

"\n\n"
"This command exits the command interpreter and avoids unauthorized access\n"
"to the bridge configuration controls.  If issued via a telnet connection, \n"
"the connection is terminated. To re-enter the command interpreter, enter the\n"
"password at the prompt.\n\n";



char TDIAG[]   = 
"\n\n"
"This command stops the bridge application and starts the bridge Test and\n"
" Configuration program. The tester program tests most of the bridge hardware\n"
"components.\n\n"
"Example: This command starts the tester program: te\n";



char THELP[]   = 

"\n\n"
"The HElp command gives you online information about the Hughes FDDI-Ethernet\n"
"Bridge commands. For additional information about these commands,\n"
"look at the FDDI-Ethernet Bridge User Guide.\n\n"
"HElp lets you progress through a series of menus or request specific HElp"
" topics.\n\n"
"HElp [topic] [subtopic]\n\n"
"Specify a topic or subtopic when you need information about specific\n"
"parts of commands (for example, HElp SHow POrt STATUS).\n\n"
"The following conventions are used in the HElp descriptions:\n\n"
"* Lowercase words in command syntax (for example, portlist) mean that\n"
"  you enter a value.\n\n"
"* Uppercase keywords in command syntax (for example, SHow DAtabase WOrking)\n" 
"  mean you enter these keywords as shown.\n\n"
"* Brackets around a keyword or value, for example, [S], indicate optional\n"
"  values.  Choose one or none of the options.\n\n"
"* Braces around keywords or values, for example, { port | clear }, mean you\n" 
"  must choose one and only one of the included words, which are separated.\n"
"  by a | .\n\n"
"* The word MODule can be substituted for BRidge in the CLear, DEFine,\n"
"  INitialize, and SHow commands.  For example, SHow BRidge = SHow MODule.\n\n"
"* Minimum abbreviations are the minimum letters recognized by the command\n"
"  interpreter.  For example,to execute the SHow DEFine MODule command, you\n"
"  can enter instead the minimum abbreviation: sh def mod.\n\n"
"You may perform any of the following actions while using online HElp:\n\n"
"* Type a question mark (?) to redisplay the help text\n"
"  associated with that prompt.\n\n"
"* Press the RETURN key to return to the previous (sub)topic level.  If you\n"
"  are at the Topic? prompt level, you return to the command prompt.\n\n"
"* Enter Control-Z to exit HElp.\n\n";


char TINIT[]   = 

"{ BRidge | MODule } { 1 | 2 | 3 | 4 } [Download] [Save]\n\n"
"This command resets the bridge to one of the following initialization\n"
"levels:\n\n"
"Level 1: Reboots the bridge without changing parameters.\n\n"
"Level 2: Same as level 1.\n\n"
"Level 3: Reboots the bridge and restores all default parameters, except\n"
"         IP Address, NetMask, TFTPServer, and BootP file name. \n" 
"Level 4: Reboots the bridge and restores all factory default parameters.\n"
"Example:\n"
"in mod 1\n" 
"This command will reboot the bridge without changing any parameters:\n" 
"in mod 3 s\n"
"This command will do a level 3 reset and load the application from the\n"
"network and burn it into flash.  If Download(d) is used instead of Save(s)\n"
"the application will be loaded from the network and the user has the option\n"
"of burning the image into flash.  If (s) or (d) is not specified, application\n"
"will be loaded from FLASH.\n\n";


char TLOGOUT[] = 

"\n\n"
"This command logs you out of the command interpreter and avoids unauthorized\n"
"access to the bridge configuration controls. If issued by a telnet\n" 
"connection, the connection is terminated. To re-enter the command\n" 
"interpreter, enter the password at the prompt.\n\n"; 


char TMODIFY[] = 

"\n\n"
"MOdify DAtabase {address} [S | R | RI | RIM | RIU | RO{portlist}|CLEAR}]\n\n"
"MOdify DAtabase {port} [{S | R | RI | RIM | RIU | RO{portlist} | CLEAR}]\n\n"
"This command modifies address records in the working address database.\n"
"An address record can be modified based on either the MAC address and\n"
"optional flags or by port and optional flags.\n\n"
"Specify one of the options listed below:\n"
"\t\t port -- Port to which the address is to be moved to, or the port\n"
"\t\t         on which all of the addresses are to be modified.\n"
"\t\t S    -- The static flag, which retains the database entry during aging.\n"
"\t\t R    -- All of the restrict flags, riu, rim, ro <all ports>.\n"
"\t\t RI   -- Both restrict inbound (riu and rim) flags.\n"
"\t\t RIM  -- The restrict inbound multi-cast flag.\n"
"\t\t RIU  -- The restrict inbound uni-cast flag.\n"
"\t\t RO   -- The restrict outbound flag, where {portlist} is the list of\n"
"\t\t         ports affected.\n\n"
"Example 1:\n"
"mo da 0080bbabcdef s ri\n\n"
"Example 2:\n"
"mo da po 3 clear\n\n";



char TPASSWD[] = 

"\n\n"
"This command changes the bridge console password. The default password of\n"
"the bridge is NULL. Press RETURN at the prompt.\n\n";  


char TPING[]   = 
"{ip-address} [SIZE {size}] [COUNT {count}] [TIMEOUT {timeout}]\n\n"
"This command pings the specified IP device.  Options are listed below:\n"

"         size -- Data size of the ping packet. The range is  64 to 1470.\n"
"                 Default is 64.\n"
"        count -- Repeat count. The range is 1 to 10000. If '*' is entered,\n"
"                 ping continues indefinitely. Default is 1.\n"
"      timeout -- Timeout period in seconds. The range is 5 to 100.\n"
"                 Default is 5.\n\n"
"*To stop execution, enter Control-C\n\n";


char TSAVE[]   = 
"\n\n"
"This command stores information in non-volatile RAM.\n\n";


char TSHOW[]   = 
"\n\n"
"This command displays information about the bridge.\n\n";


char TTFTP[]   = 
"\n\n"
"This command stops the bridge software application and starts the embedded\n"
"tftp loader program. This program allows the bridge application to update\n" 
"the bridge software from a server, and burn the new image into the flash\n"
"eprom.\n\n"
"Example: Enter this command to start the load program: loa\n\n"; 

char TTIME[]   = 

"{hours}:{minutes}:{seconds}"
"\n\n"
"This command sets the current bridge time. Enter the following values:\n"
"        hours   -- Enter a number from 0 to 24.\n"
"        minutes -- Enter a number from 0 to 60.\n"
"        seconds -- Enter a number from 0 to 60.\n\n"
"Example: def mod time 14:34:22\n\n";


/******************************************************************************/
/* THE SAVE DATABASE BRANCH */

char TSDB[]   = 
"\n\n"
"This command saves up to 800 static address records in non-volatile RAM.\n\n";


/******************************************************************************/
                             /* THE SHOW BRANCH */

char TSBRIDGE[]   = 
"\n\n"     
"This command displays additional information about the bridge.\n\n";


char TSDATABASE[] = 
"\n\n"
"This command displays address record information\n\n";


char TSPORT[]     = 
"\n\n"
"This command displays additional information about the bridge ports.\n\n";


char TSTP[]       = 
"\n\n"
"This command displays information about the bridge spanning tree configuration.\n\n";

/******************************************************************************/
                         /* THE SHOW BRIDGE BRANCH */
char TACTIVITY[]  = 
"\n\n"
"This command displays dynamic activities of the bridge.\n\n";

char TALARMMGR[]  = 
"\n\n"
"This command displays the ip addresses of the devices to which the bridge\n"
"sends its alarms.\n\n";

char TBITMASK[]   = 
"\n\n"
"This command displays bitmask filtering information.\n\n";

char TCONTACT[]   = 
"\n\n"
"This command displays the person to contact for bridge information or\n"
"maintenance.\n\n";

char TIP[]        = 
"\n\n"
"This command displays a summary of bridge IP Address, IP Mask and IP Router\n"
"information.\n\n";

char TLOCATION[]  = 
"\n\n"
"This command displays bridge location information.\n\n";

char TLOG[]       = 
"\n\n"
"This command displays a list of the last bridge resets.\n\n";

char TMSGLOG[]    = "MessageLog ";

char TNAME[]      =
"\n\n"
"This command displays the bridge name.\n\n";

char TRLOG[]      = 
"\n\n"
"This command displays a list of addresses which have been re-learned from\n"
"one port to another.\n\n";

char TSNMP[]      = 
"\n\n"
"This command displays bridge parameters which affect the operation of SNMP.\n\n";

char TSTATUS[]    = 
"\n\n"
"This command displays general bridge status information.\n\n";

char TSTFTP[]     = 
"\n\n"
"This command displays tftp boot file and tftp server address.\n\n";

char TCSMTCONN[] =
"{A_A|A_B|A_S|A_M|B_A|B_B|B_S|B_M|S_A|S_B|S_S|S_M|M_A|M_B|M_S|M_M}"
"\n\n"
"This command clears the connection for the specified FDDI port.\n";

char TTRAFFIC[]   =

"[{interval}]\n\n"
"This command displays bridge traffic counters.Specify an optional interval\n"
"as described below:\n\n"
"       interval  -- Enter a value from 1 to 6000 seconds. The traffic\n"
"                    screen updated at intervals determined by the value of\n"
"                    this parameter. If the VT100 mode is enabled and the \n"
"                    local or remote console is VT100-compatible, the screen \n"
"                    remains stationary while the counters are being updated.\n\n";

char TUDPDIR[]    =
"\n\n"
"This command displays the list of user defined protocols.\n\n";

/******************************************************************************/
                           /* THE SHOW DATABASE BRANCH */
char TDSAVED[]  =

"{address | port | S | R | RI | RIM | RIU | RO{portlist}}\n\n"
"The command SHow DAtabase SAved displays the contents of the address database.\n"
"Inclusion of the node address causes that address record to be displayed.\n"
"Inclusion of the port number and optional flags, causes the indicated\n" 
"records to be displayed. Selectable options are listed below: \n\n"
"\t\t portlist  -- Ports on which addresses are to be displayed.\n"
"\t\t s         -- The static flag.\n" 
"\t\t r         -- All of the restrict flags (riu, rim, ro) <all ports>.\n"
"\t\t ri        -- Both restrict inbound (riu and rim) flags.\n"
"\t\t rim       -- The restrict inbound multi-cast flag.\n"
"\t\t riu       -- The restrict inbound uni-cast flag.\n"
"\t\t ro        -- The restrict outbound flag, where <portlist> is the\n"
"\t\t              list of ports affected.\n\n";

char TDSTATUS[] = 

"\n\n"
"This command displays the number of address records in the RAM and \n"
"non-volatile RAM address databases.\n\n";

char TDWORK[]   = 

"{address | port | S | R | RI | RIM | RIU | RO{portlist}}\n\n"
"This command displays addresses in the RAM\n"
"address database. Selectable options are listed below: \n\n"
"\t\t port list -- Ports on which addresses are to be displayed.\n"
"\t\t s         -- The static flag.\n" 
"\t\t r         -- All of the restrict flags (riu, rim, ro) <all ports>.\n"
"\t\t ri        -- Both restrict inbound (riu and rim) flags.\n"
"\t\t rim       -- The restrict inbound multi-cast flag.\n"
"\t\t riu       -- The restrict inbound uni-cast flag.\n"
"\t\t ro        -- The restrict outbound flag, where <port list> is the\n"
"\t\t              list of ports affected.\n\n";
/******************************************************************************/
                        /* THE SHOW PORT BRANCH */

char TPFILTER[]    = 

"\n\n"
"This command displays port filtering information.\n\n";


char TPLEARN[]     = 

"\n\n"
"This command displays the status of the learning parameter for each port.\n\n";


char TPPACSIZE[]   =

"\n\n"
"This command displays the packet size parameter setting for each port.\n"
"Packet sizes can be set to either extended or standard.\n\n";

char TPSTATE[]     = 

"\n\n"
"This command displays whether each port is enabled or disabled.\n\n";


char TPSTATUS[]    = 

"[port-list]\n\n"
"This command displays filtering and configuration information for bridge \n"
"ports.\n\n";


/******************************************************************************/
                       /* THE SHOW PORT FILTER BRANCH */
char TPFADDRESS[]  = 

"\n\n"
"This command displays port address filtering information.\n\n";


char TPFPROTOCOL[] = 

"\n\n"
"This command displays port protocol filtering information.\n\n";


char TPFBITMASK[]  =

"\n\n"
"This command displays port bitmask filtering information.\n\n";

/******************************************************************************/
                          /* THE DEFINE BRANCH */

char TDALARMMGR[]  = 

"{manager number}{ip-address | NONE}"
"\n\n"
"Where:\n\t\t- manager number is between 1 - 2. \n\n"
"Used to set SNMP Manager ip-addresses.  NONE will clear the IP address.\n\n"; 

char TDBRIDGE[]   = 
"\n\n"
"This command configures bridge parameters.\n\n";


char TDDATABASE[] =

"{address}{port}[S | R | RI | RIM | RIU | RO{portlist}]\n\n"
"This command adds an address to the working address\n"
"database. The address can be added with the options listed below:\n\n"
"\t\t port -- Port to which the address is to be added.\n"
"\t\t s    -- The static flag.\n" 
"\t\t r    -- All of the restrict flags (riu, rim, ro) <all ports>.\n"
"\t\t ri   -- Both restrict inbound (riu and rim) flags.\n"
"\t\t rim  -- The restrict inbound multicast flag.\n"
"\t\t riu  -- The restrict inbound unicast flag.\n"
"\t\t ro   -- The restrict outbound flag, where portlist is the list of\n"
"\t\t         ports affected.\n\n";


char TDPORT[]     = 

"\n\n"
"This command configures port parameters.\n\n";

char TDSMT[] =

"\n\n"
"This command defines the run-time configuration of the module. \n\n";

char TDSTP[]	  = 

"\n\n"
"This command configures bridge spanning tree algorithm and protocol parameters.\n\n";

/******************************************************************************/
                           /* THE DEFINE BRIDGE BRANCH */

char TDIPADDRESS[] = 
"{ip-address | NONE}\n\n"
"This command sets a new bridge IP Address. The bridge's IP address is used\n"
"by SNMP to address packets between the bridge and another IP device. \n"
"Entering NONE for the ip address will clear the entry.\n\n";

char TDAUI[] =

"{AUI | TRNSCVR}\n\n"
"Allows the selection of either the AUI or transceiver module as the\n"
"interface for port 4 of the bridge. The transceiver can be ThinNet, \n"
"10Base-T, or FOIRL. \n\n";

char TDBOOTPREQ[] =
"{enable | disable}\n\n"
"This command determines whether the bridge obtains its configuration from a \n"
"bootp server.\n\n";


char TBMASK[] =
"{index}{offset}{value}\n\n"
"This command defines a bridge bitmask, which is used as part of a bitmask\n"
"filtering expression. Specify the following in the command line:\n\n"
"\t\t index  --  Enter a letter from A through J\n"
"\t\t offset --  Enter a decimal number from 0 through  256\n"
"\t\t value  --  Enter 8 hexadecimal digits. Entering 'X' in\n"
"\t\t            place of a valid hex digit is considered a\n"
"\t\t            wild card character.\n\n";

char TDCONTACT[] = 
"{text}\n\n"
"This command permits you to enter a text string, of up to 20 characters, \n"
"which contains the contact person's name and other information for \n"
"this bridge.\n\n";


char TDCFGFILE[]   =
"{file name}\n\n"
"This command sets the name of the configuration file (including the full\n"
"pathname) to be downloaded to the bridge. A maximum of 63 characters\n"
"is allowed.\n\n";


char TDPRIROUTER[]  = 
"{ip-address |  NONE}\n\n"
"This command sets the primary IP Router ip-address. Whenever the bridge\n"
"determines that an address lies outside the local subnet, it passes\n"
"the traffic to the IP Router. Entering a None will clear the entry. \n\n\n";

char TDSECROUTER[]  = 
"{ip-address |  NONE}\n\n"
"This command sets the secondary IP Router ip-address. Whenever the bridge\n"
"determines that an address lies outside the local subnet, it passes\n"
"the traffic to the IP Router. Entering a None will clear the entry. \n\n\n";

char TDLOCATION[] = 
"{text}\n\n"
"This command enters a text string of up to 20 characters, which contains\n"
"location information for this bridge.\n\n";

char TDNAME[] = 
"{text}\n\n"
"This command enters a text string of up to 20 characters, which contains the\n"
"bridge name.\n\n";


char TDNETMASK[]   = 
"{ip-mask | NONE}\n\n"
"This command sets a new bridge IP Mask. The Net Mask is an internal bridge \n"
"function that signifies to the bridge which of the 32 bits of an IP Address\n"
"define the address as belonging to the bridge's subnet.\n\n";


char TDPASSWORD[]  = 
"\n\n"
"This command sets a new bridge console password.\n\n";


char TDRQSTFILE[]  = 
"{file name}\n\n"
"This command creates a file name which the bridge uses to send a request to\n"
"a server for a customized configuration file. The default file name is \n"
"eebridge.\n\n";

char TDRING[] = 
"{0|1|2|3|4|5|6|7|8|9|10|11|12|13|14|15|NONE}\n\n"
"This command defines the FDDI back plane ring that the unit connects to.\n"
"There are 15 backplane dual rings and they are numbered from 1 - 15.  If\n"
"0 is entered, the bridge will connect to the external ring.\n";


char TDSRVRIP[]  = 
"{ip-address | NONE}\n\n"
"This command sets the IP address of the bootp/tftp server. \n\n";


char TDSTPMODE[]   = 
"{ENABLE | DISABLE}\n\n"
"This command enables or disables the bridge spanning tree mode.\n\n";


char TDSYMBOLIC[]  = 
"{ENABLE | DISABLE}\n\n"
"This command enables or disables the symbolic address mode.\n\n";


char TDTERM[]      = 

"{ENABLE | DISABLE}"
"\n\n"
"Used to enable/disable the VT100 mode. \n\n";

char TTIMEOUT[]  =
"{value}\n\n"
"This command sets the console timeout value. Range is 0 to 60 minutes. A\n"
"value of 0 will disable the timeout feature.\n\n";


char TDUDPFILTER[] = 
"{index}{type}{name}\n\n"
"This command sets a user defined protocol which can be used to block or\n" 
"forward traffic.  You can define up to 10 protocol types. Protocol types\n" 
"must be defined in this table before they can be used as a protocol\n"
"filter. Enter the following selection criteria in the command line:\n\n"  
"\t\t - index:  1 - 10 \n"
"\t\t - type:  4 digit hex number representing the protocol type\n" 
"\t\t - name:  symbolic name of protocol type, may be up to 8 chararacters\n"
"\t\t          long\n\n"; 


/******************************************************************************/
                        /* THE DEFINE PORT BRANCH */

char TDBLOCK[]    =
"\n\n"
"Configure the port to filter packets based on bitmask or protocol.\n\n";


char TDLEARN[]    =
"{ENABLE | DISABLE}\n\n"
"This command enables or disables learning on the ports specified in the\n"
"port list parameter.\n\n";


char TDPACSIZE[]  = 
"{STANdard | EXTEnded}\n\n"
"This command sets packet size to standard or extended on the ports specified\n""in the port list parameter.\n\n";


char TDPERMIT[]   = 
"\n\n"
"This command configures the port to forward packets based on bitmask or \n"
"protocol.\n\n";


char TDRESTRICT[] =
"{ENABLE | DISABLE}{R | RI | RIU | RIM | RO}\n\n"
"This command can be used to limit traffic into or out of a port.\n"
"Where:\n\n"
"\t\t r    -- Indicates all of the restrict flags, riu, rim, ro.\n"
"\t\t ri   -- Indicates both restrict inbound, riu and rim flags.\n"
"\t\t rim  -- The restrict inbound multicast flag.\n"
"\t\t riu  -- The restrict inbound unicast flag.\n"
"\t\t ro   -- The restrict outbound flag\n\n";


char TDSTATE[]    = 
"{ENABLE | DISABLE}\n\n"
"This command enables or disables the ports specified in the port list \n"
"parameter.\n\n";



char TDUNKMCAST[] =
"{FORWARD | FILTER}\n\n"
"This command can be used to limit multicast traffic into or out of a\n"
"sub-network. If unknown multicast is set to forward for a particular\n"
"port, then unknown multicast packets are forwarded.\n\n";

char TDUNKUCAST[] = 
"{FORWARD | FILTER}\n\n"
"This command can be used to limit unicast traffic into or out of a\n"
"sub-network. If unknown unicast is set to forward for a particular\n"
"port, then unknown unicast packets are forwarded.\n\n";


char TDPROTOCOL[] = 
"{protocol type}\n\n"
"This command adds packet types to the list of those being blocked by the\n"
"FDDI-Ethernet bridge. User-defined protocol types must be defined in\n"
"in the user-defined protocol directory. To block packets based on a \n"
"user-defined protocol type, the protocol NAME must be specified on the \n"
"command line.\n\n"
"\t\t PRE-DEFINED TYPES: \n\n"
"\t\t NAME:          VALUE:\n"
"\t\t IP         --  0800\n"
"\t\t V2         --  0001 (lsap)\n" 
"\t\t Arp        --  0806\n"
"\t\t Dec        --  6000, 6001, 6002, 6003, 6005, 6006, 8038, 803F\n"
"\t\t Top        --  FEFE (lsap)\n"
"\t\t Lat        --  6004, 6007\n"
"\t\t Xns        --  0600, 0A00, 0807\n"
"\t\t Apple      --  809B, 80F3, 80F4, 80F5\n"
"\t\t Novell     --  8137, FFFF (lsap)\n"
"\t\t RevArp     --  8035\n"
"\t\t Bridge  	 --  9001, 9002\n\n";


char TDBITMASK[]  =
"{boolean bitmask expression}\n\n"
"This command can be used to build a boolean expression, using\n"
"the letters of the individual bitmasks and expression operators.\n"
"Packets will then be filtered based on the resulting boolean\n"
"expression (other filters still apply). The maximum expression length \n"
"is 15 characters, including expression operators.\n\n"
"\t\tEXPRESSION OPERATORS:\n\n"
"\t\tOR             |\n"
"\t\tAND            &\n"
"\t\tNOT            !\n"
"\t\tPARENTHESIS   ()\n\n";


char TPPROTOCOL[] = 
"{protocol type}\n\n"

"This command will allow the user to add packet types to the list of \n"
"those being forwarded by the FDDI-Ethernet bridge. User-defined\n"
"protocol types must be defined in the user-defined protocol directory. \n"
"To forward packets based on a user-defined protocol type, the \n"
"protocol NAME must be specified on the command line.\n\n"
"\t\t PRE-DEFINED TYPES: \n\n"
"\t\t NAME:          VALUE:\n"
"\t\t IP         --  0800\n"
"\t\t V2         --  0001 (lsap)\n" 
"\t\t Arp        --  0806\n"
"\t\t Dec        --  6000, 6001, 6002, 6003, 6005, 6006, 8038, 803F\n"
"\t\t Top        --  FEFE (lsap)\n"
"\t\t Lat        --  6004, 6007\n"
"\t\t Xns        --  0600, 0A00, 0807\n"
"\t\t Apple      --  809B, 80F3, 80F4, 80F5\n"
"\t\t Novell     --  8137, FFFF (lsap)\n"
"\t\t RevArp     --  8035\n"
"\t\t Bridge_Id  --  9001, 9002\n\n";


char TPBITMASK[]  =
"{boolean bitmask expression}\n\n"

"This command can be used to build a boolean expression, using\n"
"the letters of the individual bitmasks and expression operators.\n"
"Packets will then be forwarded based on the resulting boolean\n"
"expression (other filters still apply). The maximum expression length \n"
"is 16 characters, including expression operators.\n\n"
"\t\tEXPRESSION OPERATORS:\n\n"
"\t\tOR             |\n"
"\t\tAND            &\n"
"\t\tNOT            !\n"
"\t\tPARENTHESIS   ()\n\n";



/******************************************************************************/
                        /* THE DEFINE STP BRANCH */

char TDSBRGPRI[]   = 
"{value}\n\n"
"This command sets the bridge priority value. Range is 0-65535.\n\n";


char TDSDEFAULT[]  = 
"\n\n"
"This command returns all bridge spanning tree parameters to their default\n"
"values.\n\n";


char TDSFORW[]     =
"{value}\n\n"
"This command sets the forward delay timer value. Range is 4-30 seconds.\n\n";


char TDSHELLO[]    = 
"{value}\n\n"
"This command sets the hello timer value. Range is 1-10 seconds.\n\n";


char TDSLIFE[]     = 
"{value}\n\n"
"This command sets the life time timer value. Range is 6-40 seconds.\n\n";


char TDSPATHCOST[] = 
"{value} PORT {port-list}\n\n"
"This command sets the port pathcost value. Range is 1-65535.\n\n";


char TDSPORTPRI[]  =
"{value} PORT {port-list}\n\n"
"This command sets the port priority value. Range is 0-255.\n\n";

/******************************************************************************/
                        /* THE CLEAR BRANCH */

char TCBRIDGE[]   = 
"\n\n"
"This command clears the bridge parameters.\n\n";

char TCDATABASE[] = 
"{{address} | {port-list} [S | R | RI | RIM | RIU | RO{portlist}]}\n\n"
"This command deletes the address records from the ram address database.\n"
"The addresses are deleted according to various selection criteria.\n"
"The selection criteria must match the actual address record exactly\n"
"in order for the address to be deleted.\n\n"
"\t\t port list -- Ports from which addresses are to be deleted.\n"
"\t\t s         -- The static flag.\n" 
"\t\t r         -- Indicates all of the restrict flags, riu, rim,\n"
"\t\t              ro {all ports}.\n"
"\t\t ri        -- Indicates both restrict inbound, riu and rim flags.\n"
"\t\t rim       -- The restrict inbound multi-cast flag.\n"
"\t\t riu       -- The restrict inbound uni-cast flag.\n"
"\t\t ro        -- The restrict outbound flag, where {port list} is the\n"
"\t\t              list of ports that the outbound restriction applies to.\n\n";


char TCPORT[] =
"\n\n"
"This command clears port parameters.\n\n";

/******************************************************************************/
                      /* THE CLEAR BRIDGE BRANCH */

char TCBITMASK[]   =
"{index}\n\n"
"This command deletes a bitmask definition. A bitmask definition cannot be\n"
"deleted if it is in use. Index range is A to J.\n\n";


char TCCONTACT[]   = 
"\n\n"
"This command deletes the bridge contact information.\n\n";


char TCIPADDRESS[] = 
"\n\n"
"This command deletes the bridge IP Address.\n\n";


char TCIPROUTER[]  = 
"\n\n"
" ";

char TCNETMASK[]   = "\n\nNetMask ";


char TCLOCATION[]  = 
"\n\n"
"This command deletes the bridge location information.\n\n";


char TCLOG[]       = 
"\n\n"
"This command deletes all entries from the bridge reset log.\n\n";


char TCMSGLOG[]    = "\n\nMessageLog ";


char TCNAME[]      = 
"\n\n"
"This command deletes the bridge name information.\n\n";


char TCRLOG[]      = 
"\n\n"  
"This command deletes all entries from the bridge relearn log.\n\n";


char TCTRAFFIC[]   = 
"\n\n"
"This command resets the bridge traffic counters to zero.\n\n";


char TCUDP[]       = 
"{index}\n\n"
"This command deletes a user-defined protocol definition. A definition \n"
"cannot be deleted if it is in use. Index range is 1 to 10.\n\n";


/******************************************************************************/
                        /* THE CLEAR PORT BRANCH */

char TCPROTOCOL[]  = 
"{protocol list | ALL}"
"\n\n"
"This command removes a list of protocols or all protocols if ALL is entered\n"
"in the command line.\n"
"Where:\n\n"
"\t\tProtocol List   -- List of protocols to clear. Entering ALL \n"
"\t\t                   instead of a protocol will clear all protocols.\n\n"; 


char TCBMEXPR[]    = 
"\n\n"
"This command deletes the bitmask expression assigned to a port.\n\n";


/******************************************************************************
	DEFINE FDDI PORT, INTERFACE, MAC, PATH Vinay
******************************************************************************/
char TDSACTION[] =
"{Maint | Enabled | Disabled | STArt | STOp}"
"\n\n"
"This command Generates an SM_CM_CONTROL.request with the specified control\n"
"action of 'Signal' and the 'variable' parameter set with the appropriate value\n"
"(i.e., PC_Maint, PC_Enable, PC_Disable, PC_Start, PC_Stop).\n";

char TDSATTACHMENT[] = 
"{Insert | Deinsert}"
"\n\n"
"Defines the insert policy for the external optical bypass.\n";

char TDSCONNECTION[] =
"{LCT | LOop | PLAce}"
"\n\n"
"Defines FDDI PORT connection policies.  Pc-MAC-LCT, Pc-MAC-LOOP and \n"
"Pc-MAC-Placement indicate how the respective PC Signalling Capability flags\n"
"should be set\n";

char TDSFDDIPORT[] =
"{FRONT | BACK}"
"\n\n"
"The module includes two FDDI MIC ports on the front and back of the\n"
"module. The ports can be switched from the back to the front or viceversa.\n"
"For example, the port A can be switched from front to back and as a result\n"
"the front A port gets disabled. \n";

char TDSMACPORT[] = 
"timer value"
"\n\n"
"Define the time - T_Next(9) - for the optional MAC Local Loop to prevent \n"
"deadlock.  This allows sufficient time for MAC recovery process completion \n"
"and the exchange of neighbour information frames.\n"
"\nDefault:2500000 (i.e., 200ms). Range >= 200ms\n";


char TDSLERALARM[] = 
"integer"
"\n\n"
"The link error rate estimate at which a link connection will generate an\n"
"alarm.  It ranges from 1exp-4 to exp-15."
"Default value of integer is 8: Range 4 to 15\n";

char TDSLERCUTOFF[] =
"integer"
"\n\n"
"The link error rate estimate at which a link connection will generate an \n"
"alarm.  It ranges from 1exp-4 to 1exp-15."
"Default value of integer is 7: Range 4 to 15\n";


char TDSMAINTLINESTATE[] =
"{Quiet | Idle | Master | Halt | Active}"
"\n\n"
"This command defines the symbol to be transmitted when a PC_Maint signal is\n"
"sent to control CMT from the SMT\n";

char TDSTB_MAX[] = 
"timer value"
"\n\n"
"Defines the Break time before the BS_Flag is set.  TB_Max must be sufficiently\n"
"large so that it will not be inadvertently by noise by an optical bypass switch\n";

char TDSFRAMEERRTH[] =
"integer"
"\n\n"
"It is used to determine when a situation has an unacceptable frame error\n"
"threshold.  The FRAME ERROR THRESHOLD is an integer value that can be set \n"
"from 1 to 65535\n";

char TDSFRAMESTATUS[] = 
"{None | COPied}"
"\n\n"
"Defines the MAC's operational frame status setting for bridged frames.  If \n"
"NONE is specified, the MAC repeats the A/C indicators as received.  If \n"
"COPIED is specifed the MAC sets C but not A on copying for forwarding. \n";

char TDSFDDIMACACTION[] =
"{EnableLLC | DisableLLC | CONNECTMAC | DISCONNECTMAC}"
"\n\n"
"Enables or disables the MAC service to highes levels.  If the MAC service \n"
"is disabled the bridge will loose manageability from SNMP Managers.\n";

char TDSNOTCOPIED[] =
"integer"
"\n\n"
"It is used to determine when a station has an unacceptable count of frames \n"
"'not copied'.  It could be used as an indication of buffer congestion on this \n"
"MAC.  The NOTCOPIED is an integer value that can be set from 1 to 65535\n";

char TDSMACPATHREQ[] = 
"{PRImary | SECondary | ISOlated}"
"\n\n"
"Defines the preferred path for this interface.  The precedence order is \n"
"PRIMARY, SECONDARY, LOCAL, and ISOLATED.  The bridge does not support local\n"
"paths defined in the ANSI standard\n";

char TDSMACSTATE[] = 
"{COnnect | DISconnect}"
"\n\n"
"Connects or disconnects this interface (i.e., MAC) in station. \n";

char TDSMACSTRIPPING[] =
"{Enable | Disable}"
"\n\n"
"Enables or disables stripping of frames which its SA does not match the \n"
"bridge MAC address.  \n";

char TDSMACT_MAX[] =
"timer value"
"\n\n"
"Defines the maximum Target Token Rotation Time (TTRT).  The selected value \n"
"should be several times the maximum ring initialization time to permit stable\n"
"ring recovery.  The T_Max value should be between 206300(165ms) and \n"
"507300 (40.58ms). Default is 206300 (165ms). \n";

char TDSMACT_MIN[] =
"timer"
"\n\n"
"Defines the minimum Target Token Rotation Time (TTRT) to be supported by \n"
"the bridge. Default is 50000 (4ms). \n";

char TDSMACT_PRI[] = 
"{1 | 2 | 3 | 4 | 5 | 6 } timer value"
"\n\n"
"Defines the set of priority Token Rotation time thresholds. \n"
"Default value is 100000 (8ms). \n";

char TDSMACT_REQ[] =
"timer value"
"\n\n"
"Defines the requested TTRT for asynchronous traffic.  The T_req timer value \n"
"is a value between T_Min and T_Max.\n"
"Default value is 100000 (8ms).\n";

char TDSMACTVX[] =
"timer value"
"\n\n"
"Defines the value of TVX (Valid_Transmission Timer) to be used.\n"
"Default value for the TVX timer is 2.5 ms.  \n";


char TDSTRACE_MAX[] =
"timer value"
"\n\n"
"Defines the expiration propogation time for a Trace on the FDDI topology.\n"
"Default Value is 7sec.\n";

char TDST_MAX[] =
"timer value"
"\n\n"
"Defines the lower bound of T_Max supported for this Path class.\n";

char TDSTVX[] =
"timer value"
"\n\n"
"Defines the lower bound of TVX supported for this path.\n"
"Default value is 31250 (2.5ms). \n";

char TDSLATENCY[] =
"timer value"
"\n\n"
"Defines the new ring latency.  Gives the total accumulated latency of the \n"
"ring associated with this path.";

char TDSRMODE[] = 
"timer value"
"\n\n"
"Defines the time limit for restricted dialogs on a path. \n";

char TDSSMTCONFIG[]=
"{CF_wrap_ab | None}"
"\n\n"
"Defines the configuration policies currently in effect in the bridge. \n"
"CF-Wrap-AB defines the CF_Wrap_AB flag that is described in the SMT standard.\n";

char TDSSMTCONN[] =
"{A_A|A_B|A_S|A_M|B_A|B_B|B_S|B_M|S_A|S_B|S_S|S_M}"
"\n\n"
"A bitmap representing the connection policies in effect in the bridge.  The \n"
"user defines each of the connection types that is rejects.  The letter \n"
"designations, X and Y, in 'X_Y' argument labels have the following \n"
"significance: X represents the PC-Type of the bridge local PORT and Y the \n"
"PC_Type of the adjacent PORT (PC-Neighbor).\n";

char TDSSMTOPVER[] =
"value"
"\n\n"
"The version this bridge must use for its operation.\n";

char TDSSMTREPORT[] =
"integer"
"\n\n"
"Defines the limit on the number of Status Report Frames that shall be queued \n"
"for transmission after supported condition becomes inactive of after supported\n"
"event has been detected.\n";

char  TDSSMTT_NOTIFY[] =
"timer value"
"\n\n"
"Defines the timer value in seconds used in the Neighbor Notification protocol\n"
"The timer can be defined between 2 and 30 seconds. Default value is 30 secs.\n";

char TDSSMTUSERDATA[] =
"\"string\""
"\n\n"
"Defines 32 octets of user defined information.\n";

char TECHO[] =
"fddiMAC-address"
"\n\n"
"This command sends an echo request frame to the device with the given \n"
"fddiMAC-address. \n";

char TDEFINTERFACE[] =

"\n\n"
"Defines the FDDI interface characteristic(s) of the bridge. \n\n";


char TDEFPORT[] = 

"\n\n"
"This command allows network administrative user to change the state and \n"
"description of the bridge's FDDI port. \n\n";

char TSMT[] =

"\n\n"
"This command displays the SMT parameters. \n\n";

char TSFDDIMAC[] = 
"\n\n"
"This command displays the FDDI MAC status. \n\n";

char TSFDDIPATH[] = 
"\n\n"
"This command displays the FDDI path status. \n\n";

char TSFDDI[] =

"\n\n"
"This command defines the FDDI related characteristics. \n";

char TSFDDIPORTS[] =

"\n\n"
"This command displays the FDDI ports status.  \n";

char TDFDDI[] =

"\n\n"
"This command allows the network administrator to change and state the \n"
"FDDI related parameters. \n";

char TFDDI[] =

"\n\n"
"This command allows the network administrator to change and state the \n"
"FDDI related parameters. \n";

char TDSPORTMAC[] =

"\n\n"
"This command allows the network administrator to change and state the \n"
"FDDI port MAC related parameters. \n";

char TCFDDITRAFFIC[] =
"TRaffic\n\n"
"This command clears the traffic counters.\n";
/***************/
