
#define MAX_CL 132

/*********************************************************
**
**    for 50 pin connector 
**
**********************************************************/
#define    DSR_50_CHNG      1
#define    DTR_50_CHNG      2
#define    FLOWIN_50_CHNG     3
#define    FLOWOUT_50_CHNG     4


/*********************************************************
**
**    definition user profile for Password and directory 
**
**********************************************************/

#define MAXENTRY    20		/* max. directory number for each user */
#define ADDRMAX     40            /* address max. length */
#define PORTMAX      8            /* port max. length */




#define DOMAIN   1               /* address type */

/**********************************************************
**
**    bit position in the dflag field
**
***********************************************************/
#define SVRDIR      01          /* indicate SERVER dir */
#define     WAIT_CMD         0x2    /* waiting to be cmdmode */
#define     EFLOWED           0x4    /* flow control is on */
#define    WAIT_CTLC          0x8   /* rotary call wait for control C*/
#define    ASK_ONCE           0x10   /* ask password once already */
#define    V2_SEQ           0x10   /* used in multiple callby V2 */
#define    SVR_TN             0x20   /* telnet server session */
#define     SEND_FLOW         0x40   /* send flow control */
#define		SEQ_CALL	0x80	/* v2 sequencial rotary call */


#define  PSWD_ACC    1           /* PASSWORD access mode */
#define  PFX_ACC     2           /* PFX access mode */

#define  MORE_AYT    0x1           /* AYT event */
#define  MORE_AO     0x2           /* AO EVENT */
#define  MORE_INTP   0x4         /* INTP event */
#define  MORE_BREAK  0x8         /* BREAK event */
#define  MORE_DATA   0x10
#define  MORE_EVENT MORE_AYT+MORE_AO+MORE_INTP+MORE_BREAK+MORE_DATA

#define   CALL_DONE      1   /* call completed  */
#define   MORE_OPTION    3   /* message type C */
#define   MORE_SYTEK     4   /* message type D */
#define   MORE_CLOSED    5   /* session closed confirmation */
#define   MORE_FCLOSED   6   /* close session request */ 
#define  LISTEN_DONE     8   /* listening opened */
#define  NO_ACT          9   /* no activity for period of time */
#define  MORE_FAULTED   10   /* faulted */
#define  MORE_AB        11   /* waiting for AB setting */
#define MORE_PAUTO		12	/* PCALL AUTO timer expire */
#define    OFF        0
#define    ON         1
#define	 RECEIVED	2	/* accept calls even dtr is deasserted */
				/* but to clear session if dtr drop */

#define	NONE	0

/*************************************************************
**
**	Definitions for the reason for terminating the session
**
**************************************************************/
#define	UDISCON		1	/* user disconnect */
#define DTRDROP		2	/* DTR drop */
#define INACTIVETIME	3	/* Inactivity timer */
#define REMOTECLOSE	4	/* remote close */
#define REMOTEREST	5	/* remote reset */
#define NETWORKTIMEOUT	6	/* Network timeout */
#define OTHERS		7	/* Unknown */

/*******************************************************
**
**    parity 
**
*********************************************************/
#define  ODD     1
#define EVEN     2

/*******************************************************
**
**   command sequence mode 
**
**
*******************************************************/

#define  NOCMD      0
#define CMDBRK       1
#define ESCSEQ      5
#define UP_CASE     2

/*************************************************************
**
**     Protocol Stack ID
**
*************************************************************/

#define TCP_STACK    1
#define LAT_STACK    2
#define V2_STACK	 3

/**********************************************************
**
**    Maximum  Packet size for each 
**    protocol.
**
************************************************************/

#define   V2SIZE     64     /* maximum V2 packet size */

/***********************************************************
**
**    Session State 
**
***********************************************************/

#define   IDLE          0   /* no session */
#define   OPENING    1   /* session is connecting or listening */
#define   OPENED     2   /* session connected */
#define   CLOSING       3   /* session is closing */
#define   ABORTED       4   /* session aborted */
#define   LISTENING     5
#define   FCLOSE        6
#define   ASK_PWD       7   /* ask for password */
#define   LOGIN     8   /* ask for login name */
#define   ASK_RESP      9   /* ask for  PFX resp */
#define   FCLOSE_WAIT  10   /* fclose but output is not completed */

/*********************************************************
**
**    pcall command parameter value
**
*********************************************************/

#define    AUTO       2
#define    PRINTER    3

/**************************************************************
**
**    port mode
**
**************************************************************/

#define   CMDMODE         0        /* command mode   */
#define   DATAMODE        2        /* data mode      */
#define   ESCMODE         3        /* Esc sequence mode */
#define   LOGINMODE       4        /* Login mode       */
#define  CALLMODE         5        /* calling mode */
#define  LOOPMODE         6        /* loopback mode */
#define INPUTMODE         7        /* input mode */
#define  LOCKMODE         8        /* port lock mode */
#define  PASSWORDMODE     9        /* waiting for input password */
#define PFXMODE          10        /* waiting for input PFX response */

/********************************************************
**
**     Flow control type 
**
**********************************************************/
#define  XON    1
#define  EIA    2
#define NOTOUCH 3	/* no to do anthing in set_flowtype */

/***********************************************************
**
**     return code for cmd_match function 
**
***********************************************************/

#define     NO_CMD       -1     /* no cpooommand matched  */
#define     MORE_THAN_1  -2     /* more than 1 matched */
#define     NEED_COMP     -3    /* need to completed command */

/***********************************************************
**
**        Loopback mode
**
***********************************************************/
#define     LOOP_OFF      0     /* loopback off */
#define     LOOP_LOCAL    1		/* loopback local */
#define     LOOP_REMOTE   2     /* loopback remote */

/************************************************************
**
**        Echo mode type
**
*************************************************************/
#define      LOCAL       0       /* local echo */
#define      REMOTE      1       /* remote echo */

/************************************************************
**
**        EOM_FLAG type 
**
*************************************************************/
#define      EOM_CHAR        1
#define      EOM_NEWLINE     2

/************************************************************
**
**        PORT RESET TYPE
**
*************************************************************/
#define      CURRENT     0   /* initialize port to current configuration */
#define      PERMANENT   1   /* initialize port to configuration stored in NVRAM */
#define      FACTORY     2   /* initialize port to factory default configuration */

/************************************************************
**
**       Flush types 
**
*************************************************************/
#define       FLUSH_ARP    0      /* flush ARP cache */
#define       FLUSH_DNS    1      /* flush DNS cache */

/************************************************************
**
**     tnsend events
**
*************************************************************/
#define     CAYT        0    /* send ayt */
#define     CBREAK      1    /* send a break */
#define     CAO         2    /* abort output */
#define     CINTP       3    /* send a interrupt */

/**************************************************************
**
**      bit map for brkflg
**
**************************************************************/
#define     BRK_BRK      1      /* for break command */ 
#define     IP_BRK       2      /* for interrupt command */ 
#define     CMD_BRK      4      /* for command command */

/**************************************************************
**
**       return code for find_entry
**
**************************************************************/
#define      NO_ENTRY     0
#define      GOOD_ENTRY   1
#define      BAD_ENTRY    2


/******************************************************
**
**    command state which stored in the misc[0]
**
******************************************************/

#define   FIRST         0         /* first time in the command routine*/
#define   SECOND        1         /* second time in the command routine */
#define   THIRD         2
#define   FOURTH        3
#define   FIFTH         4
#define   SIXTH         5

/***************************************************
**
**   the flag set in the tflag of the RAMPIT
**
***************************************************/
#define  PORT_LOGOUT	0x01   	/* Port is in logout state */
#define	 XTIME_OUT	0x02   	/* xtimer of dtr drop	*/
#define	 BREAK_SIGNAL	0x08	/* Break seen */
#define  IDLE_TIMEOUT   0x10   	/* for DATAMODE or CALLMODE */
#define  DTR_CHANGE     0x20   	/* for DATAMODE or CALLMODE */
#define  PCALL_AUTO     0x40   	/* the call is pcall auto */
#define  TASK_WAKEUP    0x80	/* wakeup the task and do nothing */

/***********************************************
**
**   EIA signal in the eia of RAMPIT
**
***********************************************/

#define   DTR    0x80
#define   RTS    0x40
#define   AB     0x20
#define   RCV_BREAK 0x10   /* received a break */
#define   RI     0x8
#define   DSR    0x4
#define   CTS    0x2
#define   DCD    0x1


/**********************************************************
**
**
**     The following constant is defined and used on misc[1]
**     in RAM_PIT
************************************************************/

#define  QUIETON   1       /* the port is set to quiet ON */
#define  ABON      0x2      /* autobaud is in progress */
#define  DORI      0x4      /* do RI */
#define  DOAB      0x8
#define  DSR_TIMER 0x10     /* idle timeout for DSR timer */ 
#define  PAUTO     0x20     /* do pcall auto */
#define  SESTA     0x40     /* session established */
#define  SCLOSE    0x80     /* session closed flag */

#define	ADM_IDLE	30000
#define	MAXTRY		3


#define PINGED  1       /* result from the ping in flag */
#define RESOLVED 1      /* result from the resolve name in flag */

#define VAL_DTR	2	/* value for DTR selection in autobaud */

#define RMU_ALL		0
#define RMU_PSWD	1
#define RMU_PFX		2
#define RM_ALL		0
#define RM_ENT		1
#define RM_NODE		2


/* Reasons for closing a session in ITTASK*/
#define NOCHECKING	0 /* nothing to be done */
#define OK_CLOSE	1
#define OK_FCLOSE	2
#define ABT_TIMEOUT	3
#define ABT_NOACT	4
#define ABT_FAULT	5
/* code in ITTASK may be a error msg index or a value (sess #, T.O value)*/
/* bit map for spcchar */
#define SPC_AO 		1
#define SPC_INTP	2

#define ACC_SIZE (MAXPORT+1)/8 + 1
#define MAXPASSWD 8	/* passwd */
#define MAXSVCNAME 16	/* Maximum number of characters for Name */
#define MAXNODENAME 16	/* Maximum number of characters for Name */
#define MAXSVCDES 32	/* Maximum number of characters for Description */

typedef struct {
   byte rating;
   byte used;
   char service[MAXSVCNAME+1];
   char svc_des[MAXSVCDES+1];
   char password[MAXPASSWD+1];
   byte adjrating;	/* Value to increment/decrement rating */
   int  access; 	/* bit map of port which can be access by the svc */ 
   }SVCTBL;

extern SVCTBL *SERVICE_ROOT;

