
/**			       
*	Product Name:	Multi-Port Bridge
*
*	Program Name:	eebridge
*
*	Filename:	bitmask.h
*
*	$Log:   /b/gregs/bridge/declike/inc/bitmask.h_v  $
 * 
 *    Rev 1.0   06 May 1993 09:13:02   franks
 * Initial revision.
 * 
 *    Rev 1.0   09 Apr 1992 17:10:18   pvcs
 * Initial revision.
*
*	Creation Date:	3/30/92
*
*	Programmers:
*
*	Copyright (c) 1991 by Hughes LAN Systems
*
**/

#ifndef __BITMASK_H
#define __BITMASK_H v100


/*
 * BRIDGE PAKCET PROCESSOR BIT MAP FILTER TABLE
 */

/*
 * filter information for each port
 */
#define BMFOLEN 	16	/* up to 32 phrases per bit map sentence */
#define BMFO_EOL	0	/* the End Of Calc flag */
#define BMFO_AND	64	/* the AND operator */
#define BMFO_OR 	65	/* the OR operator */
#define BMFO_NOT	66	/* the NOT operator */
#define BMFO_EOL	0	/* the End Of Calc flag */


/*	Alphabetic Define Correspond Directly to Element in the Array  */
#define	A		'a' 	/*	Correspond to Arrary Element 0  */
#define	B		'b'		/*	Correspond to Arrary Element 1  */
#define	C		'c'		/*	Correspond to Arrary Element 2  */
#define	D		'd'		/*	Correspond to Arrary Element 3  */
#define	E		'e'		/*	Correspond to Arrary Element 4  */
#define	F		'f'		/*	Correspond to Arrary Element 5  */
#define	G		'g'		/*	Correspond to Arrary Element 6  */
#define	H		'h'		/*	Correspond to Arrary Element 7  */
#define	I		'i'		/*	Correspond to Arrary Element 8  */
#define	J		'j'		/*	Correspond to Arrary Element 9  */

/*	Bit Mask Format  */
#define	HEXADECIMAL		"HEXADECIMAL"
#define	BINARY			"BINARY"

/*	Table of Bit Mask Defining Elements  */

typedef struct bmfe
{
	unsigned long	bm_mask;	/*	Bit mask value  */
	unsigned long	bm_mtch;	/*	Bit mask match value  */
	unsigned int	bm_ofst;	/*  Bit mask offset  */
	unsigned int	bm_count;	/*	Number of time the bit mask elemene is in used  */
}BMFE;

typedef struct bmdefine
{
	BMFE			BitMask;			/*	Parse the string and create the bit mask element  */
	unsigned char	ValueString[36];	/*	Preserve the original character string  */
}BMDEFINE;


typedef struct bmexpression
{
	unsigned int	BMMode;					/*	None, Permit, or Block  */
	unsigned char	BMExpString[BMFOLEN];		/*	Expression string  */
	unsigned char	BMExpRevPolish[BMFOLEN];		/*	Reserve polish representation of bit mask expression  */
}BMEXPRESSION;

typedef struct binarymask
{
	unsigned long	BinMask;	/*	Binary mask value  */
	unsigned long	BinValue;	/*	Binary match value  */
}BINARYMASK;

#endif
