/*****************************************************************************
*       Program Name:  nim960 bridge
*
*       Filename:      834ping.c
*
*       $Log:   /b/gregs/bridge/declike/cmd/834ping.c_v  $
 * 
 *    Rev 1.5   20 Sep 1993 15:09:08   gregs
 * lsh 9/20/93 fixed ping command line accepting garbage.
 * 
 *    Rev 1.4   13 Sep 1993 18:56:34   gregs
 * lsh 9/13/93 Replaced scanf with pick_a_kw and atod to fix SIT bugs 20,21,23.
 * 
 *    Rev 1.3   03 Sep 1993 10:20:32   vinay
 * changed the ping size to 1470 from 1472
 * 
 *    Rev 1.2   22 Aug 1993 15:34:32   vinay
 * changed the kw len for timout to 5
 * 
 *    Rev 1.1   29 Jul 1993 16:37:02   vinay
 * fixed the ping problem
 * 
 *    Rev 1.0   04 May 1993 16:03:52   franks
 * Initial revision.
 * 
 *    Rev 1.5   13 May 1992 14:37:16   franks
 * 1). Fixed the default timeout feature of the ping command so that is 
 *     defaults to 5 seconds instead of 5 milli-seconds.
 * 
 *    Rev 1.4   04 May 1992 12:16:14   franks
 * No change.
 * 
 *    Rev 1.3   17 Apr 1992 16:17:28   franks
 * No change.
 * 
 *    Rev 1.2   16 Apr 1992 14:46:42   franks
 * No change.
 * 
 *    Rev 1.1   14 Apr 1992 13:05:56   franks
 * No change.
 * 
 *    Rev 1.0   30 Mar 1992 17:48:08   pvcs
 * Initial revision.
*
*       Comments:      Developed for i960 platform.
*
*       (C) Copyright 1991 Hughes LAN Systems
*       
*	Listing of routines in this file:
*
*		
******************************************************************************/

#include <types.h>
#include <target.h>
#include <krnl.h>
#include <bridges.h>
#include <utility.h>
#include <prcadr.h>
#include <prcctl.h>
#include <krnl.h>
#include <sncvar.h>
#include <eeprecs.h>
#include <nvrecs.h>
#include <stp.h>
#include <tcpip.h>
#include <error.h>
#include <cpb.h>

IP  PingIPDevice;
int PingStatus = 0;

icmp_pinged(tag, status)
long tag;
int status;
{
    PingStatus = status;
}


StartPing(PacketSize, PingInterval)
int PacketSize;
int PingInterval;
{
    int PingRetCode;

	PingStatus = -1;

    if((PingRetCode=icmp_ping(PingIPDevice.IPAddress, 
                          PacketSize, (int)PingInterval, (long)0)) != 0)
        PingStatus = PingRetCode;

    while(PingStatus == -1)
        ReSchedule();

    switch(PingStatus)
    {
        case 0:
            printf("Device %d.%d.%d.%d is alive\n",
                    PingIPDevice.IP[0], PingIPDevice.IP[1],
                    PingIPDevice.IP[2], PingIPDevice.IP[3]);
            break;

        case ERR_NORSRC:
            printf("Error no resource\n");
            break;

        case ERR_NET_UNREACHABLE:
            printf("Device %d.%d.%d.%d is unreachable\n",
                    PingIPDevice.IP[0], PingIPDevice.IP[1],
                        PingIPDevice.IP[2], PingIPDevice.IP[3]);
            break;

        case ERR_NOTNEGOT:
            printf("Device %d.%d.%d.%d is not answering\n",
                    PingIPDevice.IP[0], PingIPDevice.IP[1],
                        PingIPDevice.IP[2], PingIPDevice.IP[3]);
            break;


default:
            printf("Device is unreachable\n");
    }
}  /* end of StartPing() */


Ping( CPB_P pcpb )
{
    uint Count, i;
    uint length;
    uint Interval   = 500; 
    uint PacketSize = 64;
    uint RetCode    = 0;
    uint RepCnt     = 1;
    uint ForEver    = FALSE;
    char *kw;
    char Buffer[17];

    
    length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

    if(RetCode = GetIPAddress( &PingIPDevice.IP, kw, Buffer))
        return( RetCode );

    pcpb->cl_idx += length;

	/* As long as there are cmdline options get them */
    while( pcpb->cl_idx < pcpb->cmdlen )  {
    
		length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
        pcpb->cl_idx += length;

		if( strcmp(kw, "SIZE") == 0 ) {
            
		    length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

		    if(!atod(kw,&PacketSize))
				return KW_UN_AMB;

            pcpb->cl_idx += length;
            RetCode = VerifyPacSize( PacketSize );
            if( RetCode ) 
                return(OUT_OF_RANGE);
		}
		else
		if( strcmp(kw, "COUNT") == 0 ) {

		    length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);


            if( *kw == '*' && length == 2  )
        	    ForEver = TRUE;
            else {
		    		if(!atod(kw,&RepCnt))
						return KW_UN_AMB;
        	    	if( RepCnt > 10000 || RepCnt < 1 ) {
        	        	return(OUT_OF_RANGE);
                	}
            }
            pcpb->cl_idx += length;
		}
		else
		if( strlen(kw) >= 5 && strncmp(kw, "TIMEOUT",strlen(kw)) == 0 )
		{

		    length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
            
		    		if(!atod(kw,&Interval))
						return KW_UN_AMB;
            		if( Interval < 5 || Interval > 100 )
              			return(OUT_OF_RANGE);
            		pcpb->cl_idx += length;
            		Interval *= 100;
		}
		else {
            pcpb->cl_idx -= length;

			/* syntax error */
			return( CMD_SYNTAX_ERR );
		}
	}

    if( (RepCnt > 1) || (ForEver == TRUE) )
        MultiplePing( PacketSize, RepCnt, Interval, ForEver );
    else
        StartPing( PacketSize, Interval );

    return(RetCode);
}

/******************************************************************************/

VerifyPacSize( uint PacketSize ) {

    uint MinPingSize = 64;
    uint MaxPingSize = 1470;

    if(PacketSize < MinPingSize || PacketSize > MaxPingSize) {
        return( ERR_INV_PACKETSIZE );
    }
    return( 0 );
}

MultiplePing( PacketSize1, Count1, Interval1, ForEver)
uint  PacketSize1, Count1, Interval1, ForEver;
{
    uint RetCode, i;
    ulong XmtCnt = 0;
    ulong RcvCnt = 0;
    ulong TimeOutCnt = 0;
    ulong HostErrCnt = 0;
    char inchar;


    for(i=0; (i < Count1) || (ForEver == TRUE); i++)
    {
        PingStatus = -1;
	XmtCnt++;
        if((RetCode = icmp_ping(PingIPDevice.IPAddress,
                                PacketSize1,
                                (int)Interval1,
                                (long)0)) != 0)
            PingStatus = RetCode;

        if((inchar = getch()) == 3) {
            icmp_ping_abort((long)0);
	    ForEver = FALSE;
            break;
	}

        while(PingStatus == -1)
        {
            if((inchar = getch()) == 3)
            {
                icmp_ping_abort((long)0);
		ForEver = FALSE;
                break;
            }
            ReSchedule();
        }

        if(inchar == 3)
            break;

        switch(PingStatus)
        {
            case 0:
                printf(".");
		RcvCnt++;
                break;

            case ERR_TIMEOUT:
                printf("T");
		TimeOutCnt++;
                break;

            case ERR_UNKNOWN:
            case ERR_NORSRC:
            case ERR_NET_UNREACHABLE:
            case ERR_NOTNEGOT:
                printf("?");
		HostErrCnt++;
                break;

            default:
                printf("#");
        }
    }
    Scroll(2);
    printf("\t\t\t\tPing Statistics Summary:\n");
    printf("-------------------------------------------------------------");
    printf("\n\nPackets Transmitted: %ld\n", XmtCnt);
    printf("Packets Received:    %ld\n", RcvCnt);
    printf("TimeOuts:            %ld\n", TimeOutCnt);
    printf("HostErr:             %ld\n", HostErrCnt);
    putchar('\n');
}

