/*****************************************************************************
*       Program Name:  nim960 bridge
*
*       Filename:      834cmd4.c
*
*       $Log:   /b/gregs/bridge/declike/cmd/834cmd4.c_v  $
 * 
 *    Rev 1.16   12 Nov 1993 11:38:24   vinay
 * returning out_of_range if reset level not in valid range
 * 
 *    Rev 1.15   08 Nov 1993 15:28:04   vinay
 * 
 *    Rev 1.14   26 Oct 1993 17:08:56   vinay
 * fixed clear data command
 * 
 *    Rev 1.13   12 Oct 1993 10:36:36   vinay
 * added help for show memory
 * 
 *    Rev 1.12   05 Oct 1993 17:20:54   vinay
 * moved udpdir[index-1] down.(above strcpy(&udpdir[index-1].UProtStr, kw );
 * 
 *    Rev 1.11   05 Oct 1993 15:29:16   vinay
 * setting the fddi to default values for level 3 and 4 reset.
 * 
 *    Rev 1.10   15 Sep 1993 12:46:52   vinay
 * 
 *    Rev 1.9   15 Sep 1993 10:30:48   vinay
 * fixed clear data command
 * 
 *    Rev 1.8   14 Sep 1993 09:34:26   vinay
 * fixed bugs in clear database, def mod usp
 * 
 *    Rev 1.7   13 Sep 1993 11:52:24   gregs
 * lsh 9/13/93 changed default request file name from febridge h836.
 * 
 *    Rev 1.6   03 Sep 1993 11:41:10   vinay
 * fixed the init mod command
 * 
 *    Rev 1.5   31 Aug 1993 17:49:02   gregs
 * lsh Aug/31/93 Changed year to yr.
 * 
 *    Rev 1.4   31 Aug 1993 17:43:38   gregs
 * lsh Aug/31/93 Added check for leap year in SetDate.
 * 
 *    Rev 1.3   19 Aug 1993 17:04:10   vinay
 * writing the hubid and slotid to eeprom. got rid of some debug messages
 * 
 *    Rev 1.2   29 Jul 1993 16:34:22   vinay
 * 
 *    Rev 1.1   24 Jun 1993 09:07:56   franks
 * 
 *    Rev 1.0   04 May 1993 16:03:50   franks
 * Initial revision.
 * 
 *    Rev 1.6   14 May 1992 08:29:36   franks
 * 1). Modified the gokrnl routine so that it cannot be invoked via telnet.
 * 
 *    Rev 1.5   13 May 1992 14:26:48   franks
 * 1). Fixed problem with the command line options for the cl db command
 *     being sensitive to spaces between the options.
 * 
 *    Rev 1.4   04 May 1992 12:15:48   franks
 * 1). Support for windows console
 * 
 *    Rev 1.3   17 Apr 1992 16:17:22   franks
 * No change.
 * 
 *    Rev 1.2   16 Apr 1992 14:46:38   franks
 * No change.
 * 
 *    Rev 1.1   14 Apr 1992 13:00:00   franks
 * 1). Added 3 hidden commands to support the windows console. 
 * 2). Changed the init brg level 4 command so that the AUI port state is 
 *     saved prior to a reset, and then set back to that value once the reset
 *     has been accomplished.
 * 3). Fixed a bug in the date command. Now handles leap year correctly.
 * 4). Added a new hidden command to display hidden command help text.
 * 5). Modified the init bridge command so that a parameter value of 0 is 
 *     no longer valid. Added a new hidden command called hls gokrnl which
 *     will jump to the kernel menu.
 * 
 *    Rev 1.0   30 Mar 1992 17:48:04   pvcs
 * Initial revision.
*
*       Comments:      Developed for i960 platform.
*
*       (C) Copyright 1991 Hughes LAN Systems
*       
*	Listing of routines in this file:
*
*		
******************************************************************************/


#include <types.h>
#include <target.h>
#include <bridges.h>
#include <filter.h>
#include <utility.h>
#include <prcadr.h> 
#include <krnl.h>
#include <prcctl.h> 
#include <sncvar.h>
#include <eeprecs.h>
#include <nvram.h>
#include <nvrecs.h>
#include <stp.h>
#include <tcpip.h>
#include <time.h>
#include <sys.h>
#include <cpb.h>
#include <834error.h>
#include <log.h>
#include <rlog.h>

/* EXTERNAL VARIABLE DEFINITIONS */
extern char *APPLSOFTVERSION;
extern IP IPDevice[];
extern PRCCTL prc;
extern NVR_BSTATUS *BridgeStatus;
extern ERRORLOG ErrorLogTable[];
extern Port_data port_info[];
extern Bridge_data bridge_info;
extern void BitmaskStatusScreen();
extern TIMER IntervalTimer;
extern tcpip *_initp;
extern unsigned long InitTimeSeconds;
extern unsigned long InitDateSeconds;
extern long GmtOffset;
extern UDPDIR *udpdir;
extern uint Ports;
extern NVR_SYS nvr_sys;

extern char HDEBUG[];
extern char HSHARP[];
extern char HFLARP[];
extern char HGOKRNL[];
extern char HHELP[];
extern char HSHMEM[];

/******************************************************************************/
/* Start ClearBrgBMask() */
ClearBrgBMask( CPB_P pcpb ) {

	unsigned char *Number;
	uint Index = 1;
	uint length;

	/* Get the first argument and */
	/* check value range          */
	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&Number,CASE_INSENSITIVE);
	if (*Number < MINNUMBER || *Number > MAXNUMBER)
		return (ERR_BITMASK_NUMBER);

	ChangeToIndex(*Number, &Index);		/* Convert the num into an index */
	if (BridgeStatus->BMElement[Index].BitMask.bm_count == 0)
		memset(&BridgeStatus->BMElement[Index], NULL, sizeof(BMDEFINE));
	else
		return (ERR_DEF_EXP);

	SaveBStatus();
	pcpb->cl_idx += length;
	return(0);
}

/******************************************************************************/
/* Start ClearBrgContact() */
ClearBrgContact( CPB_P pcpb ) {

	strcpy(&BridgeStatus->Contact, "NONE");

	SaveBStatus();            /* Record change in NVRAM */
	pcpb->cl_idx = pcpb->cmdlen;
	return (0);
}
/* End ClearBrgContact() */

/******************************************************************************/
							/* Start ClearBrgIPAddr() */
ClearBrgIPAddr( CPB_P pcpb ) {

	uint retcode;
	EEP_BOOT *eep;
	unsigned long address;

	address = 0L;

	if( IsTelnetActive() ) {
		printf("\nCannot clear IP Address while telnet session is active\n");
	    pcpb->cl_idx = pcpb->cmdlen;
		return(0);
	}

	/* Get the EEPROM boot record */
	eep = &eep_boot_rec;

	/* Modify the ip address in the boot record */
	eep->eep_IP = address;

	/* Modify the working copy of the address */
	_initp->in_me = address;	

	/* Replace the EEPROM boot record */
	SaveEepBoot();

	/*	K Kong	3.4.92
	 *	Set the IP in the adminbus 
	 */
	AdmSetIP(address);
	pcpb->cl_idx = pcpb->cmdlen;
	return (0);
}
/* End ClearBrgIPAddr() */

/******************************************************************************/
							/* Start ClearBrgLog() */
ClearBrgLog( CPB_P pcpb ) {

	memset(&RstLog->nvr_resetlog, NULL, sizeof(RstLog->nvr_resetlog));

ReSchedule();
	SaveRstLog();
	pcpb->cl_idx = pcpb->cmdlen;
	return(0);
}
/* End ClearBrgLog() */


/******************************************************************************/
							/* Start ClearBrgNetmask() */
ClearBrgNetmask( CPB_P pcpb ) {

	uint retcode;
	EEP_BOOT *eep;
	unsigned long address;

	address = 0L;

	/* Get the EEPROM boot record */
	eep = &eep_boot_rec;

	/* Modify the ip address in the boot record */
	eep->eep_NetMask = address;

	/* Modify the working copy of the address */
	_initp->net_mask = address;	

	/* Replace the EEPROM boot record */
	SaveEepBoot();

	/*	K Kong	3.4.92
	 *	Set the netmask in the adminbus 
	 */
	AdmSetNetMask(address);
	pcpb->cl_idx = pcpb->cmdlen;
	return (0);
}
/* End ClearBrgNetmask() */

/******************************************************************************/
							/* Start ClearBrgRLog() */
ClearBrgRLog( CPB_P pcpb ) {

	StopLearning();
	memset(&relearnlog, NULL, sizeof(relearnlog));
	StartLearning();
	pcpb->cl_idx = pcpb->cmdlen;
	return(0);
}


/******************************************************************************/
							/* Start ClearBrgServer() */
ClearBrgServer( CPB_P pcpb ) {

	uint retcode;
	EEP_BOOT *eep;
	unsigned long address;

	address = 0L;

	/* Get the EEPROM boot record */
	eep = &eep_boot_rec;

	/* Modify the ip address in the boot record */
	eep->eep_ServerIP = address;

	/* Replace the EEPROM boot record */
	SaveEepBoot();

	pcpb->cl_idx = pcpb->cmdlen;
	return (0);
}
/* End ClearBrgServer() */


/******************************************************************************/
							/* Start ClearBrgTFTPFile() */
ClearBrgTFTPFile( CPB_P pcpb ) {

	uint retcode;
	EEP_BOOT *eep;

	/* Get the EEPROM boot record */
	eep = &eep_boot_rec;

	/* Modify the TFTP file in the boot record */

	memset(eep->eep_image_file, NULL, 128);
	strcpy(eep->eep_image_file, "none");

	/* Replace the EEPROM boot record */
	SaveEepBoot();

	pcpb->cl_idx = pcpb->cmdlen;
	return (0);
}
/* End ClearBrgTFTPFile() */



/******************************************************************************/
						/* Start ClearBrgLocation() */
ClearBrgLocation( CPB_P pcpb ) {

	strcpy(&BridgeStatus->Location, "NONE");

	SaveBStatus();            /* Record change in NVRAM */
	pcpb->cl_idx = pcpb->cmdlen;
	return (0);
}
/* End ClearBrgLocation() */

/******************************************************************************/
						/* Start ClearBrgName() */
ClearBrgName( CPB_P pcpb ) {

	strcpy(&BridgeStatus->Name, "NONE");

	SaveBStatus();            /* Record change in NVRAM */
	pcpb->cl_idx = pcpb->cmdlen;
	return (0);
}
/* End ClearBrgName() */


/******************************************************************************/
						/* Start ClearBrgTraffic() */
ClearBrgTraffic( CPB_P pcpb ) {

	ClearMainTrScrn();
	return(0);
}

/******************************************************************************/
						/* Start ClearBrgUDP() */
ClearBrgUDP( CPB_P pcpb ) {

	UDPDIR *udp;
	uint length;
	uint index;
	char *kw;

	sscanf(&pcpb->cmd[pcpb->cl_idx],"%d", &index);
	if( index < 1 || index > MAXUSRTYPE )
		return( CMD_SYNTAX_ERR );
	
	index--;
 	udp = (udpdir+index);

	/* Make sure the UDP is not being used */
	if( udp->PrtSet != 0 )
		return( ERR_DEF_EXP );

	/* clear the UDP entry */
 	udp->UProtTyp = 0;
 	udp->PrtSet   = 0;
	memset((udp->UProtStr), NULL, 9);

	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	pcpb->cl_idx += length;
	SaveProtocolTbl();
	return(0);
}

/******************************************************************************/
						/* Start ClearDataBase() */

ClearDataBase( CPB_P pcpb ) {

	uint retcode;
	uint MatchCnt;
	uint length;
	uint PortMask;
	RECORDMASK ValueMask;
    	ADR  AdrNode, *ap;
	char *First;
	char *str;
	char *kw;
	char *Arg;
	char Buffer[STRLN];
	char ALLNIDS[] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

	memset(Buffer, NULL, sizeof(Buffer));
	memset(&ValueMask, NULL, sizeof(RECORDMASK));

        /* copy the first token */
	while (pcpb->cmd[pcpb->cl_idx] == SPACE)
        	pcpb->cl_idx++;
	GetWord(Buffer, &pcpb->cmd[pcpb->cl_idx]);
	
	/*
	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	*/

	if (strlen(Buffer) == 12)       /* first argument is mac address */
	{
        	/*
        	* Check to see if there are any problems
        	* in the address convertion
        	*/
        	if (HexToNid(Buffer, &AdrNode, 6))
                	return (ERR_HEX12_ADR);
	
        	if (FindNid(&AdrNode, &ap))
                	return(ADR_NOT_FOUND);  /* no entry found */

        	/* check for any tailing junk */
        	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],
                	&kw,CASE_INSENSITIVE);
        	pcpb->cl_idx += length;
        	if(pcpb->cl_idx < pcpb->cmdlen)
                	return (ERR_INV_ARG);
	
        	if (ap->adr_hom == 0)
        	/* Don't delete local address */
                	return 0;
	
	
        	if (DeleteNid( ap, &MatchCnt))
                	return (ADR_NOT_FOUND);
	}
	else if ((*Buffer == CHARACTER_ONE) ||
        	(*Buffer == CHARACTER_TWO) ||
        	(*Buffer == CHARACTER_THREE) ||
        	(*Buffer == CHARACTER_FOUR) ||
        	(*Buffer == CHARACTER_ALL))
	{
        	PortMask = 0;
        	if (retcode = PortArgument(Buffer, &PortMask, &length))
                	return (retcode);
        	ValueMask.PortMask = (unsigned char)PortMask;
	
        	pcpb->cl_idx += length;
        	/* parse the flag list */
        	if (SetAttribute(&pcpb->cmd[pcpb->cl_idx],&ValueMask,&length))
                	return (CMD_SYNTAX_ERR);
	
        	DelMultiNids( &ValueMask, &MatchCnt );
	}
	else
	{
        	memcpy(&ValueMask.AddressValue, ALLNIDS, sizeof(ALLNIDS));
        	memcpy(&ValueMask.AddressMask, ALLNIDS, sizeof(ALLNIDS));
        	ValueMask.PortMask = (unsigned char)ALLPORT;
	
        	/*pcpb->cl_idx += length;*/
        	/* parse flag list */
        	if (SetAttribute(&pcpb->cmd[pcpb->cl_idx],&ValueMask,&length))
                	return (CMD_SYNTAX_ERR);
	
        	DelMultiNids( &ValueMask, &MatchCnt );
	}
	
#ifdef DISCARD
    	/* Skip leading white spaces */
    while( pcpb->cmd[pcpb->cl_idx] == SPACE )
        	pcpb->cl_idx++;

	First = &pcpb->cmd[pcpb->cl_idx];

	GetWord(Buffer, First);	/*	Get the first argument  */

	/* Adjust the cmdline index */
	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
    	pcpb->cl_idx += length;

	/*	Only the address argument is entered  */

	if ((strlen(Buffer) == 12) && (pcpb->cl_idx >= pcpb->cmdlen))  {
		
	/*	Check to see if there are any problems */
	/*  in the address convertion              */

		if (HexToNid(First, &AdrNode, 6))
			return (ERR_HEX12_ADR);
		else  {
              /* FIND THE ADDRESS IN THE ADDR LIST */

               if( FindNid( &AdrNode, &ap ) )  {
                   return( ADR_NOT_FOUND );
			}
			if( ap->adr_hom == 0 )   /* Don't delete local address */
				return( 0 );
			if( DeleteNid( ap, &MatchCnt ) )
				return( ADR_NOT_FOUND );
		}
	}
    /* TO BE USED WITH ADDRESS SPECIFICATION        */
    	else if( (strlen(Buffer) == 12) && (pcpb->cl_idx < pcpb->cmdlen) )
           return( ERR_INV_ARG );

            /* NO ADDRESS INFO */
	else if ( (*First == CHARACTER_ONE)   ||
		 (*First == CHARACTER_TWO)   ||
		 (*First == CHARACTER_THREE) ||
		 (*First == CHARACTER_FOUR)  ||
		 (*First == CHARACTER_ALL))
	{
		PortMask = 0;
		strcpy(Buffer,First);
		FunctReturnCode = PortArgument(First, &PortMask, &length);
		if (FunctReturnCode)
			return (FunctReturnCode);

		ValueMask.PortMask = (unsigned char)PortMask;

		if(pcpb->cmdlen > pcpb->cl_idx)
		{
        	/* Skip leading white spaces */
        	while( pcpb->cmd[pcpb->cl_idx] == SPACE )
            	pcpb->cl_idx++;

		Arg = &pcpb->cmd[pcpb->cl_idx];
	
		length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
    		pcpb->cl_idx += length;

		strupr(Arg);
/***
		if ((strcmpi(kw, "RO") != 0))
		{
			if(pcpb->cl_idx < pcpb->cmdlen)
				return CMD_SYNTAX_ERR;	
***/

			/* Check to see if there are problems while */
			/* scanning the attributes  */
			
			if (SetAttribute(Arg, &ValueMask, &length))
				return ( CMD_SYNTAX_ERR );
		    	DelMultiNids( &ValueMask, &MatchCnt );
/******
		}
		else if(strcmpi(kw,"RO") == 0)
		{
			strcpy(Buffer,kw);
	
			length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
    			pcpb->cl_idx += length;

			if(CheckPortList(kw))
				return KW_UN_AMB;
			if(pcpb->cl_idx < pcpb->cmdlen)
				return CMD_SYNTAX_ERR;
			strcat(Buffer,kw);

			if (SetAttribute(Buffer, &ValueMask, &length))
				return ( CMD_SYNTAX_ERR );
			
			DelMultiNids( &ValueMask, &MatchCnt );
		}

		else
			return CMD_SYNTAX_ERR;
***********/
		}
		else
		{
			memcpy(&ValueMask.AddressValue, ALLNIDS, sizeof(ALLNIDS));
			memcpy(&ValueMask.AddressMask, ALLNIDS, sizeof(ALLNIDS));
        		ValueMask.PortMask = (unsigned char)ALLPORT;

		/*  Check to see if there are any problems while */
		/*  scanning the attributes  */

			strupr(First);
			if (SetAttribute(First, &ValueMask, &length))
				return ( CMD_SYNTAX_ERR );
		    	DelMultiNids( &ValueMask, &MatchCnt );
		}
	}
	else
#ifdef vinay
	if ((*First == 'S') ||
		(*First == 'R')
	   )
	{
		memcpy(&ValueMask.AddressValue, ALLNIDS, sizeof(ALLNIDS));
		memcpy(&ValueMask.AddressMask, ALLNIDS, sizeof(ALLNIDS));
        	ValueMask.PortMask = (unsigned char)ALLPORT;

		/*  Check to see if there are any problems while */
		/*  scanning the attributes  */

		strupr(First);
		if (SetAttribute(First, &ValueMask, &length))
			return ( CMD_SYNTAX_ERR );

		DelMultiNids( &ValueMask, &MatchCnt );
	}
	else
		return ( CMD_SYNTAX_ERR );
#endif
#endif
	printf("\nTotal number of records deleted = %d\n", MatchCnt);
	pcpb->cl_idx = pcpb->cmdlen;
	return (0);
}
/******************************************************************************/
CheckPortList(lst)
char *lst;
{
	int i;
	
	i = strlen(lst);

	while(i > 0)
	{
		if(*lst != CHARACTER_ONE && 
		*lst != CHARACTER_TWO && 
		*lst != CHARACTER_THREE && 
		*lst != CHARACTER_FOUR &&
		*lst != CHARACTER_ALL)
			return 1;
		lst++;
		i--;
	}
	return 0;
}
/******************************************************************************/
						/* Start ClearPortProtocol() */
ClearPortProtocol( CPB_P pcpb ) {

	int  retval;
	uint i;
	uint PortMask = Ports;  /* Global Variable */
	uint cnt;
	uint Index;
	char *Vector2 = &pcpb->cmd[pcpb->cl_idx];


	/* Check protocol type args */

	if (retval = isValidArg(pcpb, ADD, PortMask))
		return( retval );

	/* Set protocol blocking/permit bits... */
	retval = Minus(pcpb, PortMask); 
	SaveBStatus();
	SaveProtocolTbl();
	return( retval );
}

/* End ClearPortProtocol() */


/******************************************************************************/
						/* Start ClearPortBMExpr() */
ClearPortBMExpr( CPB_P pcpb ) {

	PRCCTL *prcctl = &prc;
	uint i;
	uint PortMask = Ports;  /* Global Variable */

	for (i = 1; i <= MAXPORTBIT; i <<= 1) {

		if (i & PortMask)  {

			switch (i)  {
			
				case PORT1:
					prcctl->Prc_BitMskFlt &= (byte)MASKPORT1; /* Turn it off */

					DecrementDefinition(
					  &BridgeStatus->BMExpression[0].BMExpRevPolish);
					memset(&BridgeStatus->BMExpression[0], NULL, 
												  sizeof(BMEXPRESSION));
					break;

				case PORT2:
					prcctl->Prc_BitMskFlt &= (byte)MASKPORT2; /* Turn it off */

					DecrementDefinition(
						  &BridgeStatus->BMExpression[1].BMExpRevPolish);
					memset(&BridgeStatus->BMExpression[1], NULL, 
												  sizeof(BMEXPRESSION));
					break;

				case PORT3:
					prcctl->Prc_BitMskFlt &= (byte)MASKPORT3; /* Turn it off */

					DecrementDefinition(
						  &BridgeStatus->BMExpression[2].BMExpRevPolish);
					memset(&BridgeStatus->BMExpression[2], NULL, 
												  sizeof(BMEXPRESSION));
					break;

				case PORT4:
					prcctl->Prc_BitMskFlt &= (byte)MASKPORT4; /* Turn it off */

					DecrementDefinition(
						  &BridgeStatus->BMExpression[3].BMExpRevPolish);
					memset(&BridgeStatus->BMExpression[3], NULL, 
												  sizeof(BMEXPRESSION));
					break;

				case PORT5:
					prcctl->Prc_BitMskFlt &= (byte)MASKPORT5; /* Turn it off */

					DecrementDefinition(
						  &BridgeStatus->BMExpression[4].BMExpRevPolish);
					memset(&BridgeStatus->BMExpression[4], NULL, 
												  sizeof(BMEXPRESSION));
					break;
			}
		}
	}
	SaveBStatus();            /* Record change in NVRAM */
	return (0);
}
/* End ClearPortBMExpr() */


/******************************************************************************/
						/*	Start DefineDB()  */
DefineDB( CPB_P pcpb )  {

    uint FunctReturnCode, NextArgument;
	uint PortMask;
	uint length;
	uint hash;
	char *First;
	char GetsTrashed[13];
	char *Sec;
	char *str;
    ADR  AdrNode;  
	ADR *NewAdrNode;         /* need to get this from free list */

 	
	/* Get the 1st argument, should be an address */
	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&First,CASE_INSENSITIVE);

    /*	Check for problems in the address conversion  */
	if ( (strlen(First) == 12) )  {
		strcpy(GetsTrashed, First);
		if (HexToNid(GetsTrashed, &AdrNode, 6))
			return (ERR_HEX12_ADR);
	}
	else
		return( CMD_SYNTAX_ERR );

	
    /* Does the address already exist? */
	if( FindNid( &AdrNode, &NewAdrNode ) == NULL ) {
		return( ERR_REC_EXISTS );
	}

    pcpb->cl_idx += length;

	/* Get a new address node from the free list */
	StopLearning();
	NewAdrNode = prc_get_addr();
	if( NewAdrNode == (ADR *)NULL ) {
        StartLearning();
		return( ADR_TBL_FULL );
	}
	StartLearning();

    /* Get port location */

	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&Sec,CASE_INSENSITIVE);
    pcpb->cl_idx += length;

    if( (strlen( Sec ) != 1) ) {  /* only one port allowed! */
		StopLearning();
		prc_put_addr( NewAdrNode );  /* return the addr record */
		StartLearning();
        return( CMD_SYNTAX_ERR );
	}
	else {

		switch(*Sec)  {          /* set port bit */

			case CHARACTER_ONE:
								NewAdrNode->adr_hom |= PORT1; 
								break;

			case CHARACTER_TWO:
								NewAdrNode->adr_hom |= PORT2; 
								break;

			case CHARACTER_THREE:
								NewAdrNode->adr_hom |= PORT3; 
								break;

			case CHARACTER_FOUR:
								NewAdrNode->adr_hom |= PORT4;
								/* Add Address to FDDI CAM */
								CamAdd((ushort *)&NewAdrNode->adr_low);
								break;

			/* 5PORT -- Uncomment when using 5 ports
               case CHARACTER_FIVE:
                                  NewAdrNode->adr_hom |= PORT5; 
                                  break;
			*/

			default:  {
								StopLearning();
								prc_put_addr( NewAdrNode );
								StartLearning();
								return( CMD_SYNTAX_ERR );
			}
		}
		SetInUse( NewAdrNode );
		memcpy(&NewAdrNode->adr_low, &AdrNode.adr_low, 6);
	}
   
	if( SetNidAttribute( &pcpb->cmd[pcpb->cl_idx], NewAdrNode ) == FAIL ) {
		StopLearning();
		prc_put_addr( NewAdrNode );
		StartLearning();
		return( CMD_SYNTAX_ERR );
	}
	StopLearning();

    /* Get the hash value */
	hash = HashNid( &AdrNode.adr_low );

	AddToHashTbl( hash, NewAdrNode );
	StartLearning();

	/* All is ok... */
	pcpb->cl_idx = pcpb->cmdlen;
	return( 0 );
}
/*	End DefineDB()  */


/******************************************************************************/
						/*	Start DefineBrgUDPFilter()  */
DefineBrgUDPFilter( CPB_P pcpb )  {

	char *kw;
	char *cmdline = &pcpb->cmd[pcpb->cl_idx];
	char name[9];
	uint index;
	uint value;
	uint length;
	int 	i;

	length = pick_a_kw(cmdline,&kw,CASE_INSENSITIVE);
/*
	sscanf(cmdline, "%d", &index);
*/
	if(!atod(kw,&index))
		return CMD_SYNTAX_ERR;

    pcpb->cl_idx += length;
	if( index < 1 || index > MAXUSRTYPE )
		return( CMD_SYNTAX_ERR );
	 
	/* Move pointer to the value */
	if( pcpb->cl_idx >= pcpb->cmdlen )
		return( CMD_SYNTAX_ERR );
	else
		cmdline = &pcpb->cmd[pcpb->cl_idx];

	sscanf(cmdline, "%x", &value);

	if( value < 0x05EF ) 
		return( ERR_TYPE_LESS );
    else
	if( value > 0xFFFF )
		return( CMD_SYNTAX_ERR );

	bswap(&value);
	if ( isPreDef(value))
		return (29);

	for( i = 0; i < MAXUSRTYPE; i++)
		if(udpdir[i].UProtTyp == value)
			return ERR_REC_EXISTS;


	/* move cmd line pointer to the name */
	length = pick_a_kw(cmdline,&kw,CASE_INSENSITIVE);
    pcpb->cl_idx += length;
	if( pcpb->cl_idx >= pcpb->cmdlen )
		return( CMD_SYNTAX_ERR );
	cmdline = &pcpb->cmd[pcpb->cl_idx];

	length = pick_a_kw(cmdline,&kw,CASE_INSENSITIVE);
	if( strlen(kw) > 8 )
		return( ERR_STR_TOO_LONG );
	else
	{
		for( i = 0; i < MAXUSRTYPE; i++)
			if(strcmp(udpdir[i].UProtStr,kw) == 0)
				return ERR_REC_EXISTS;
		
		udpdir[index-1].UProtTyp = value;
		strcpy( &udpdir[index-1].UProtStr, kw );
	}

	SaveProtocolTbl();
    pcpb->cl_idx += length;
	return(0);
}

/******************************************************************************/
/*  Start SetDate() */
SetDate( CPB_P pcpb )  {

	uint day, mon, yr;
	char *kw;
	char *cmdline = &pcpb->cmd[pcpb->cl_idx];
	uint num;
	uint length;


	/* Get argument and check length */
	num = sscanf(cmdline,"%d-%d-%d", &mon, &day, &yr);
    if( num != 3 )  {
		return( CMD_SYNTAX_ERR );
	}

	if( day > 31 || day < 1 ) {
		printf("Incorrect - Day must be between 1 and 31.\n");
		return(0);
	}

	if ( (yr % 4) == 0)
	{
		if(mon == 2 && day > 29)
		{
			printf("Incorrect day for this month %d\n",mon);
			return 0;
		}
	}
	else
	{
		if (mon == 2 && day > 28)
		{
			printf("Incorrect day for this month %d\n",mon);
			return 0;
		}
	}

	if( mon > 12 || mon < 1 ) {
		printf("Incorrect - Month must be between 1 and 12.\n");
		return(0);
	}
	/* Adjust month */
	mon --;

	if( yr < 1990 ) {
		printf("Incorrect - Year must be after 1990.\n");
		return(0);
	}
	/* Adjust year 
    if( yr < 1900 )
	    yr+=1900;
    */

	InitDateSeconds = DateToSeconds( day, mon, yr);
	if(GetDate(&day, &mon, &yr)) {
		printf("\nDate Entered Incorrect!");
		return(0);
	}
	printf("\nNew Date: %02d-%02d-%02d\n", mon, day, yr);
    pcpb->cl_idx = pcpb->cmdlen;
	return( 0 );
}

/******************************************************************************/
/*  Start SetTime() */
SetTime( CPB_P pcpb ) {

	uint TimeTicks;
	uint hour, min, sec;
	char *kw;
	char *cmdline = &pcpb->cmd[pcpb->cl_idx];
	uint num;
	uint length;


	/* Get argument and check length */
	num = sscanf(cmdline,"%d:%d:%d", &hour, &min, &sec);
    if( num != 3 )  {
		return( CMD_SYNTAX_ERR );
	}

	if( hour > 24 || hour < 0 ) {
		printf("Incorrect - Hours must be between 0 and 24.\n");
		return(0);
	}
	if( min > 60 || min < 0 ) {
		printf("Incorrect - Minutes must be between 0 and 60.\n");
		return(0);
	}
	if( sec > 60 || sec < 0 ) {
		printf("Incorrect - Seconds must be between 0 and 60.\n");
		return(0);
	}
	InitTimeSeconds = (hour*3600) + (min*60) + sec;
	InitTimeSeconds -= RealTimeTicks()/100;
	if(GetTime(&hour, &min, &sec)) {
		printf("\nTime Entered Incorrect!");
		return(0);
	}
	printf("\nNew Time is: %02d:%02d:%02d\n", hour, min, sec);
    pcpb->cl_idx = pcpb->cmdlen;
	return( 0 );
}

/*****************************************************************************/
/* Start InitBrg() */
InitBrg( CPB_P pcpb ) {

	int  RetCode;
	uint RstLvl;
	uint length;
	char *kw;

	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);

	if( (strncmp(kw, "BRIDGE", strlen(kw) ) != 0) && 
	    (strncmp(kw, "MODULE", strlen(kw) ) != 0) )
		return(CMD_SYNTAX_ERR);

	if(strcmpi(kw,"BRIDGE") == 0 && strlen(kw) < 2)
			return CMD_SYNTAX_ERR;

	if(strcmpi(kw,"MODULE") == 0 && strlen(kw) < 3)
			return CMD_SYNTAX_ERR;

	pcpb->cl_idx += length;

	length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
	pcpb->cl_idx += length;
	if(!atod(kw,&RstLvl)) 
		return KW_UN_AMB;
	if( RstLvl < 1 || RstLvl > 4)
		return OUT_OF_RANGE;
	if(pcpb->cl_idx < pcpb->cmdlen)
	{
		length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
		pcpb->cl_idx += length;
		if(strcmpi(kw,"DOWNLOAD") == 0) 
		{
			eep_boot_rec.eep_ThinNet = 0x0000;
			if(pcpb->cl_idx < pcpb->cmdlen)
			{

				length = pick_a_kw(&pcpb->cmd[pcpb->cl_idx],&kw,CASE_INSENSITIVE);
				pcpb->cl_idx += length;
				if(strcmpi(kw,"SAVE") == 0)
					eep_boot_rec.eep_ThinNet = UPDATE_FLASH;
			}

			if(PutEeprom(EEP_BOOT_ADDR,&eep_boot_rec,EEP_BOOT_SIZE) != EEPROM_AOK)
			printf("Error writing to EEPROM.\n");
		}	
		else if(strcmpi(kw,"SAVE") == 0) 
		{
			eep_boot_rec.eep_ThinNet = UPDATE_FLASH;
			if(PutEeprom(EEP_BOOT_ADDR,&eep_boot_rec,EEP_BOOT_SIZE) != EEPROM_AOK)
				printf("Error writing to EEPROM.\n");
		}
		else
			return KW_UN_AMB;
	}		
	return UpdateSoftwareReset(RstLvl);
}


UpdateSoftwareReset(int RstLvl)
{
	int	RetCode;

	/* Flag this as a software reset */
	nvr_sys.nvr_reset = 0xff;
	if (RetCode =  Nvram_Updt( NVR_SYS_ADDR, &nvr_sys, NVR_SYS_SIZE ))
		printf("Error: (%d) Cannot save SYS REC to NVRAM..\n", RetCode);

	switch( RstLvl )  {
		
		case 1:         
				RecordRst(RSTMSG6);
            			break;

		case 2:         
				RecordRst(RSTMSG6);
            			break;

		case 3:

				memset( &Nvram_header, NULL, NVRAM_HDR_SIZE );
	            Nvram_Updt( NVRAM_HDR_ADDR, &Nvram_header, NVRAM_HDR_SIZE );
				InitNvram(NVRAM, eep_mfg_rec.eep_nvram_size);
				STP_dft_rst();

				/************************
				 Moved this to SetBridgeDefault() 

				setNVRAM_FDDIDefaults(&nvr_fddi_rec);
				PutFDDIRec(&nvr_fddi_rec);
				*************************/
				SetBridgeDefault();
				SaveBStatus();
				UserProtsToDefault();
				RecordRst(RSTMSG7);
	         /* Flag this as a software reset */
            nvr_sys.nvr_reset = 0xff;
            if (RetCode = Nvram_Updt(NVR_SYS_ADDR,&nvr_sys,NVR_SYS_SIZE ))
                printf("Error: (%d) Cannot save SYS REC to NVRAM..\n"
				           ,RetCode);
            			break;

		case 4:
				memset( &Nvram_header, NULL, NVRAM_HDR_SIZE );
	            Nvram_Updt( NVRAM_HDR_ADDR, &Nvram_header, NVRAM_HDR_SIZE );
				InitNvram(NVRAM, eep_mfg_rec.eep_nvram_size);
				STP_dft_rst();
			

				/**************************
				 Moved this to SetBridgeDefault() 

				setNVRAM_FDDIDefaults(&nvr_fddi_rec);
				PutFDDIRec(&nvr_fddi_rec);
				*****************************/
				SetBridgeDefault();
				UserProtsToDefault();
				ClearBootRecord();
				RecordRst(RSTMSG8);
	            /* Flag this as a software reset */
                nvr_sys.nvr_reset = 0xff;
                if (RetCode = Nvram_Updt(NVR_SYS_ADDR,&nvr_sys,NVR_SYS_SIZE ))
                    printf("Error: (%d) Cannot save SYS REC to NVRAM..\n"
						  ,RetCode);
            			break;


		default: 
				return( CMD_SYNTAX_ERR );
		}
	reset_brg();
}

ClearBootRecord()

	{
	/*
	 *	We want to remember the burn cycless.
	 */
	int	BurnCycles = eep_boot_rec.eep_BurnCycles;
    int savecfg;

	savecfg = eep_boot_rec.eep_ThinNet;
	memset(&eep_boot_rec, 0, sizeof(EEP_BOOT));
	/*
	 *	Set up the default request file name, which
	 *	is febridge for FDDI-Ethernet bridge, and restore the 
	 *	brun cycles.
	 */
	strcpy(eep_boot_rec.eep_request_file, "h836"); 
	eep_boot_rec.eep_ThinNet = savecfg;
	eep_boot_rec.eep_BurnCycles = BurnCycles;
	eep_boot_rec.eep_hubid = GetHubID();
	eep_boot_rec.eep_slotid = GetSlotID();
	SaveEepBoot();
	}

FlushArp( CPB_P pcpb ) {

	fls_arp_cache();
	pcpb->cl_idx = pcpb->cmdlen;
	return 0;
}

GoDebug(CPB_P pcpb ) {

	enter_debug();
	pcpb->cl_idx = pcpb->cmdlen;
	return 0;
}

ShowArp(CPB_P pcpb ) {

	ShowArpTable();
	pcpb->cl_idx = pcpb->cmdlen;
	return 0;
}

GoKernel(CPB_P pcpb) {

    if(IsAdmConOpened(0) || IsTelnetActive() ) {
        printf("\nCan only be invoked directly from the console.\n");
	    pcpb->cl_idx = pcpb->cmdlen;
        return(0);   
    }
	return NOT_IMPLEMENTED;
/***
	RecordRst(RSTMSG5);
	pcpb->cl_idx = pcpb->cmdlen;
	return( KERNEL_PROG );
***/
}

HiddenHlp(CPB_P pcpb) {

    printf("\n%-10s    %s\n","Command","Description");

    printf("\n%-10s :  Enter the debugger." , HDEBUG);
    printf("\n%-10s :  Show the arp table." , HSHARP);
    printf("\n%-10s :  Flush the arp table.", HFLARP);
    printf("\n%-10s :  Jump to the kernel menu.", HGOKRNL);
    printf("\n%-10s :  Show memory address [int|short|byte count]", HSHMEM);
    printf("\n%-10s :  This command.", HHELP);

    Scroll(2);
	pcpb->cl_idx = pcpb->cmdlen;
	return 0;
}

WinPortStatusScrn(CPB_P pcpb) {

    printf("PORTSTATE %x;", BridgeStatus->PortState);
    printf("LEARN %x;", BridgeStatus->Learning);
    printf("PACKETSZ %x;", BridgeStatus->PacketSize);
    printf("ROUT %x;", BridgeStatus->RestrictOutbound);
    printf("RINU %x;", BridgeStatus->RestrictInUCast);
    printf("RINM %x;", BridgeStatus->RestrictInMCast);
    printf("RUNKU %x;", BridgeStatus->UnkUCast);
    printf("RUNKM %x;\n", BridgeStatus->UnkMCast);
    pcpb->cl_idx = pcpb->cmdlen;
    return 0;
}

WinUserProtocols(CPB_P pcpb) {

    int portNum, portMask;
	UDPDIR *udp = udpdir;
	uint length;
	uint idx;
    uint val;

    putchar('\n');
    for(idx=0; idx < MAXUSRTYPE; idx++, udp++) {

        val=udp->UProtTyp;
        bswap(&val);
        printf("USP%d %x %x ", idx+1,
                               udp->PrtSet,
                               val);
        
        if( udp->UProtStr[0] == '\0' )
            printf("%s ", "NULL");   /* Required as a place holder */
        else
            printf("%s ", udp->UProtStr);
    }

    for(portNum=1,portMask=1; portNum<=ACTUALMAXPORT; portNum++,portMask<<=1){

        /* If protocol filtering is enabled */
        if(BridgeStatus->ProtFilter & portMask) {

           /* Get the filtering mode */
           if( BridgeStatus->FilterMode & portMask )
	       printf("MODE%d %d;", portNum, 2); /* Permit Mode */
           else
	       printf("MODE%d %d;", portNum, 1); /* Block Mode */
        }
        else
	       printf("MODE%d %d;", portNum, 0); /* Invalid Mode */
    }

    putchar('#');
    putchar('#');
    putchar('#');
    Scroll(1);
    pcpb->cl_idx = pcpb->cmdlen;
    return 0;
}

WinVendorProtocols(CPB_P pcpb) {

    int portNum, portMask;

    printf("IP %x;",     BridgeStatus->PFilterList[IP_P]     ); 
    printf("ARP %x;",    BridgeStatus->PFilterList[ARP_P]    ); 
    printf("REVARP %x;", BridgeStatus->PFilterList[REVARP_P] ); 
    printf("TOP %x;",    BridgeStatus->PFilterList[TOP_P]    ); 
    printf("V2 %x;",     BridgeStatus->PFilterList[V2_P]     ); 
    printf("NOVELL %x;", BridgeStatus->PFilterList[NOVELL_P] ); 
    printf("LAT %x;",    BridgeStatus->PFilterList[LAT_P]    ); 
    printf("BRIDGE %x;", BridgeStatus->PFilterList[BRIDGE_P] ); 
    printf("XNS %x;",    BridgeStatus->PFilterList[XNS_P]    ); 
    printf("DEC %x;",    BridgeStatus->PFilterList[DEC_P]    ); 
    printf("APPLE %x;",  BridgeStatus->PFilterList[APPLE_P]  ); 

    for(portNum=1,portMask=1; portNum<=ACTUALMAXPORT; portNum++,portMask<<=1){

        /* If protocol filtering is enabled */
        if(BridgeStatus->ProtFilter & portMask) {

           /* Get the filtering mode */
           if( BridgeStatus->FilterMode & portMask )
	       printf("MODE%d %d;", portNum, 2); /* Permit Mode */
           else
	       printf("MODE%d %d;", portNum, 1); /* Block Mode */
        }
        else
	       printf("MODE%d %d;", portNum, 0); /* Invalid Mode */
    }

    Scroll(1);
	
    pcpb->cl_idx = pcpb->cmdlen;
    return 0;
}

WinPortTraffic(CPB_P pcpb) {

    int cnt;
    extern SDV *sv_sdvs;
    SDV *TrafficCounters = sv_sdvs;

    for(cnt=0; cnt<4; cnt++) {
    
        printf("TRP%d %d %d  ", cnt+1, TrafficCounters[cnt].sv_txcnt,
                                       TrafficCounters[cnt].sv_rxcnt);

    }
    printf("###");
    Scroll(1);
	
    pcpb->cl_idx = pcpb->cmdlen;
    return 0;
}
